/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.advancements;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementTabType;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancementsScreen
extends Screen
implements ClientAdvancements.Listener {
    private static final ResourceLocation f_97329_ = new ResourceLocation("textures/gui/advancements/window.png");
    public static final int f_169556_ = 252;
    public static final int f_169557_ = 140;
    private static final int f_169564_ = 9;
    private static final int f_169565_ = 18;
    public static final int f_169558_ = 234;
    public static final int f_169559_ = 113;
    private static final int f_169566_ = 8;
    private static final int f_169567_ = 6;
    public static final int f_169560_ = 16;
    public static final int f_169561_ = 16;
    public static final int f_169562_ = 14;
    public static final int f_169563_ = 7;
    private static final double f_291493_ = 16.0;
    private static final Component f_97331_ = Component.m_237115_("advancements.sad_label");
    private static final Component f_97332_ = Component.m_237115_("advancements.empty");
    private static final Component f_97333_ = Component.m_237115_("gui.advancements");
    private final ClientAdvancements f_97334_;
    private final Map<AdvancementHolder, AdvancementTab> f_97335_ = Maps.newLinkedHashMap();
    @Nullable
    private AdvancementTab f_97336_;
    private boolean f_97337_;
    private static int tabPage;
    private static int maxPages;

    public AdvancementsScreen(ClientAdvancements p_97340_) {
        super(GameNarrator.f_93310_);
        this.f_97334_ = p_97340_;
    }

    @Override
    protected void m_7856_() {
        this.f_97335_.clear();
        this.f_97336_ = null;
        this.f_97334_.m_104397_((ClientAdvancements.Listener)this);
        if (this.f_97336_ == null && !this.f_97335_.isEmpty()) {
            AdvancementTab advancementtab = this.f_97335_.values().iterator().next();
            this.f_97334_.m_104401_(advancementtab.m_293004_().m_295246_(), true);
        } else {
            this.f_97334_.m_104401_(this.f_97336_ == null ? null : this.f_97336_.m_293004_().m_295246_(), true);
        }
        if (this.f_97335_.size() > AdvancementTabType.MAX_TABS) {
            int guiLeft = (this.f_96543_ - 252) / 2;
            int guiTop = (this.f_96544_ - 140) / 2;
            this.m_142416_(Button.m_253074_(Component.m_237113_("<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }).m_252794_(guiLeft, guiTop - 50).m_253046_(20, 20).m_253136_());
            this.m_142416_(Button.m_253074_(Component.m_237113_(">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }).m_252794_(guiLeft + 252 - 20, guiTop - 50).m_253046_(20, 20).m_253136_());
            maxPages = this.f_97335_.size() / AdvancementTabType.MAX_TABS;
        }
    }

    @Override
    public void m_7861_() {
        this.f_97334_.m_104397_((ClientAdvancements.Listener)null);
        ClientPacketListener clientpacketlistener = this.f_96541_.m_91403_();
        if (clientpacketlistener != null) {
            clientpacketlistener.m_295327_(ServerboundSeenAdvancementsPacket.m_134444_());
        }
    }

    public boolean m_6375_(double p_97343_, double p_97344_, int p_97345_) {
        if (p_97345_ == 0) {
            int i = (this.f_96543_ - 252) / 2;
            int j = (this.f_96544_ - 140) / 2;
            for (AdvancementTab advancementtab : this.f_97335_.values()) {
                if (advancementtab.getPage() != tabPage || !advancementtab.m_97154_(i, j, p_97343_, p_97344_)) continue;
                this.f_97334_.m_104401_(advancementtab.m_293004_().m_295246_(), true);
                break;
            }
        }
        return super.m_6375_(p_97343_, p_97344_, p_97345_);
    }

    @Override
    public boolean m_7933_(int p_97353_, int p_97354_, int p_97355_) {
        if (this.f_96541_.f_91066_.f_92055_.m_90832_(p_97353_, p_97354_)) {
            this.f_96541_.m_91152_(null);
            this.f_96541_.f_91067_.m_91601_();
            return true;
        }
        return super.m_7933_(p_97353_, p_97354_, p_97355_);
    }

    @Override
    public void m_88315_(GuiGraphics p_282589_, int p_282255_, int p_283354_, float p_283123_) {
        int i = (this.f_96543_ - 252) / 2;
        int j = (this.f_96544_ - 140) / 2;
        this.m_280273_(p_282589_, p_282255_, p_283354_, p_283123_);
        if (maxPages != 0) {
            MutableComponent page = Component.m_237113_(String.format("%d / %d", tabPage + 1, maxPages + 1));
            int width = this.f_96547_.m_92852_(page);
            p_282589_.m_280648_(this.f_96547_, page.m_7532_(), i + 126 - width / 2, j - 44, -1);
        }
        this.m_97373_(p_282589_, p_282255_, p_283354_, i, j);
        this.m_280088_(p_282589_, i, j);
        this.m_280355_(p_282589_, p_282255_, p_283354_, i, j);
        this.f_169369_.forEach(r -> r.m_88315_(p_282589_, p_282255_, p_283354_, p_283123_));
    }

    public boolean m_7979_(double p_97347_, double p_97348_, int p_97349_, double p_97350_, double p_97351_) {
        if (p_97349_ != 0) {
            this.f_97337_ = false;
            return false;
        }
        if (!this.f_97337_) {
            this.f_97337_ = true;
        } else if (this.f_97336_ != null) {
            this.f_97336_.m_97151_(p_97350_, p_97351_);
        }
        return true;
    }

    public boolean m_6050_(double p_300678_, double p_297858_, double p_301134_, double p_300488_) {
        if (this.f_97336_ != null) {
            this.f_97336_.m_97151_(p_301134_ * 16.0, p_300488_ * 16.0);
            return true;
        }
        return false;
    }

    private void m_97373_(GuiGraphics p_282012_, int p_97375_, int p_97376_, int p_97377_, int p_97378_) {
        AdvancementTab advancementtab = this.f_97336_;
        if (advancementtab == null) {
            p_282012_.m_280509_(p_97377_ + 9, p_97378_ + 18, p_97377_ + 9 + 234, p_97378_ + 18 + 113, -16777216);
            int i = p_97377_ + 9 + 117;
            p_282012_.m_280653_(this.f_96547_, f_97332_, i, p_97378_ + 18 + 56 - 4, -1);
            p_282012_.m_280653_(this.f_96547_, f_97331_, i, p_97378_ + 18 + 113 - 9, -1);
        } else {
            advancementtab.m_280047_(p_282012_, p_97377_ + 9, p_97378_ + 18);
        }
    }

    public void m_280088_(GuiGraphics p_283395_, int p_281890_, int p_282532_) {
        RenderSystem.enableBlend();
        p_283395_.m_280218_(f_97329_, p_281890_, p_282532_, 0, 0, 252, 140);
        if (this.f_97335_.size() > 1) {
            for (AdvancementTab advancementtab : this.f_97335_.values()) {
                if (advancementtab.getPage() != tabPage) continue;
                advancementtab.m_280105_(p_283395_, p_281890_, p_282532_, advancementtab == this.f_97336_);
            }
            for (AdvancementTab advancementtab1 : this.f_97335_.values()) {
                if (advancementtab1.getPage() != tabPage) continue;
                advancementtab1.m_280485_(p_283395_, p_281890_, p_282532_);
            }
        }
        p_283395_.m_280614_(this.f_96547_, f_97333_, p_281890_ + 8, p_282532_ + 6, 0x404040, false);
    }

    private void m_280355_(GuiGraphics p_282784_, int p_283556_, int p_282458_, int p_281519_, int p_283371_) {
        if (this.f_97336_ != null) {
            p_282784_.m_280168_().m_85836_();
            p_282784_.m_280168_().m_252880_(p_281519_ + 9, p_283371_ + 18, 400.0f);
            RenderSystem.enableDepthTest();
            this.f_97336_.m_280571_(p_282784_, p_283556_ - p_281519_ - 9, p_282458_ - p_283371_ - 18, p_281519_, p_283371_);
            RenderSystem.disableDepthTest();
            p_282784_.m_280168_().m_85849_();
        }
        if (this.f_97335_.size() > 1) {
            for (AdvancementTab advancementtab : this.f_97335_.values()) {
                if (advancementtab.getPage() != tabPage || !advancementtab.m_97154_(p_281519_, p_283371_, p_283556_, p_282458_)) continue;
                p_282784_.m_280557_(this.f_96547_, advancementtab.m_97189_(), p_283556_, p_282458_);
            }
        }
    }

    public void m_97365_(AdvancementNode p_300702_) {
        AdvancementTab advancementtab = AdvancementTab.m_97170_(this.f_96541_, this, this.f_97335_.size(), p_300702_);
        if (advancementtab != null) {
            this.f_97335_.put(p_300702_.m_295246_(), advancementtab);
        }
    }

    public void m_97371_(AdvancementNode p_298890_) {
    }

    public void m_97379_(AdvancementNode p_297934_) {
        AdvancementTab advancementtab = this.m_97394_(p_297934_);
        if (advancementtab != null) {
            advancementtab.m_97178_(p_297934_);
        }
    }

    public void m_97387_(AdvancementNode p_301169_) {
    }

    public void m_7922_(AdvancementNode p_300708_, AdvancementProgress p_97369_) {
        AdvancementWidget advancementwidget = this.m_97392_(p_300708_);
        if (advancementwidget != null) {
            advancementwidget.m_97264_(p_97369_);
        }
    }

    public void m_6896_(@Nullable AdvancementHolder p_297665_) {
        this.f_97336_ = this.f_97335_.get(p_297665_);
    }

    public void m_97341_() {
        this.f_97335_.clear();
        this.f_97336_ = null;
    }

    @Nullable
    public AdvancementWidget m_97392_(AdvancementNode p_298026_) {
        AdvancementTab advancementtab = this.m_97394_(p_298026_);
        return advancementtab == null ? null : advancementtab.m_97180_(p_298026_.m_295246_());
    }

    @Nullable
    private AdvancementTab m_97394_(AdvancementNode p_300894_) {
        AdvancementNode advancementnode = p_300894_.m_295389_();
        return this.f_97335_.get(advancementnode.m_295246_());
    }
}

