/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ServerSelectionList
extends ObjectSelectionList<Entry> {
    static final ResourceLocation f_291621_ = new ResourceLocation("server_list/incompatible");
    static final ResourceLocation f_291095_ = new ResourceLocation("server_list/unreachable");
    static final ResourceLocation f_291481_ = new ResourceLocation("server_list/ping_1");
    static final ResourceLocation f_291352_ = new ResourceLocation("server_list/ping_2");
    static final ResourceLocation f_290600_ = new ResourceLocation("server_list/ping_3");
    static final ResourceLocation f_291043_ = new ResourceLocation("server_list/ping_4");
    static final ResourceLocation f_290749_ = new ResourceLocation("server_list/ping_5");
    static final ResourceLocation f_290586_ = new ResourceLocation("server_list/pinging_1");
    static final ResourceLocation f_291800_ = new ResourceLocation("server_list/pinging_2");
    static final ResourceLocation f_290953_ = new ResourceLocation("server_list/pinging_3");
    static final ResourceLocation f_291670_ = new ResourceLocation("server_list/pinging_4");
    static final ResourceLocation f_291720_ = new ResourceLocation("server_list/pinging_5");
    static final ResourceLocation f_290768_ = new ResourceLocation("server_list/join_highlighted");
    static final ResourceLocation f_290763_ = new ResourceLocation("server_list/join");
    static final ResourceLocation f_291174_ = new ResourceLocation("server_list/move_up_highlighted");
    static final ResourceLocation f_290378_ = new ResourceLocation("server_list/move_up");
    static final ResourceLocation f_291824_ = new ResourceLocation("server_list/move_down_highlighted");
    static final ResourceLocation f_290758_ = new ResourceLocation("server_list/move_down");
    static final Logger f_99756_ = LogUtils.getLogger();
    static final ThreadPoolExecutor f_99757_ = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_99756_)).build());
    private static final ResourceLocation f_99758_ = new ResourceLocation("textures/misc/unknown_server.png");
    static final Component f_99760_ = Component.m_237115_("lanServer.scanning");
    static final Component f_99761_ = Component.m_237115_("multiplayer.status.cannot_resolve").m_306658_(-65536);
    static final Component f_99762_ = Component.m_237115_("multiplayer.status.cannot_connect").m_306658_(-65536);
    static final Component f_263833_ = Component.m_237115_("multiplayer.status.incompatible");
    static final Component f_263836_ = Component.m_237115_("multiplayer.status.no_connection");
    static final Component f_263746_ = Component.m_237115_("multiplayer.status.pinging");
    static final Component f_263785_ = Component.m_237115_("multiplayer.status.online");
    private final JoinMultiplayerScreen f_99766_;
    private final List<OnlineServerEntry> f_99767_ = Lists.newArrayList();
    private final Entry f_99768_ = new LANHeader();
    private final List<NetworkServerEntry> f_99755_ = Lists.newArrayList();

    public ServerSelectionList(JoinMultiplayerScreen p_99771_, Minecraft p_99772_, int p_99773_, int p_99774_, int p_99775_, int p_99776_) {
        super(p_99772_, p_99773_, p_99774_, p_99775_, p_99776_);
        this.f_99766_ = p_99771_;
    }

    private void m_99780_() {
        this.m_93516_();
        this.f_99767_.forEach(p_169979_ -> this.m_7085_((AbstractSelectionList.Entry)p_169979_));
        this.m_7085_((AbstractSelectionList.Entry)this.f_99768_);
        this.f_99755_.forEach(p_169976_ -> this.m_7085_((AbstractSelectionList.Entry)p_169976_));
    }

    public void m_6987_(@Nullable Entry p_99790_) {
        super.m_6987_((AbstractSelectionList.Entry)p_99790_);
        this.f_99766_.m_99730_();
    }

    public boolean m_7933_(int p_99782_, int p_99783_, int p_99784_) {
        Entry serverselectionlist$entry = (Entry)this.m_93511_();
        return serverselectionlist$entry != null && serverselectionlist$entry.m_7933_(p_99782_, p_99783_, p_99784_) || super.m_7933_(p_99782_, p_99783_, p_99784_);
    }

    public void m_99797_(ServerList p_99798_) {
        this.f_99767_.clear();
        for (int i = 0; i < p_99798_.m_105445_(); ++i) {
            this.f_99767_.add(new OnlineServerEntry(this.f_99766_, p_99798_.m_105432_(i)));
        }
        this.m_99780_();
    }

    public void m_99799_(List<LanServer> p_99800_) {
        int i = p_99800_.size() - this.f_99755_.size();
        this.f_99755_.clear();
        for (LanServer lanserver : p_99800_) {
            this.f_99755_.add(new NetworkServerEntry(this.f_99766_, lanserver));
        }
        this.m_99780_();
        for (int i1 = this.f_99755_.size() - i; i1 < this.f_99755_.size(); ++i1) {
            NetworkServerEntry serverselectionlist$networkserverentry = this.f_99755_.get(i1);
            int j = i1 - this.f_99755_.size() + this.m_6702_().size();
            int k = this.m_7610_(j);
            int l = this.m_93485_(j);
            if (l < this.m_252907_() || k > this.m_306468_()) continue;
            this.f_93386_.m_240477_().m_263195_((Component)Component.m_237110_("multiplayer.lan.server_found", serverselectionlist$networkserverentry.m_264484_()));
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 30;
    }

    public int m_5759_() {
        return super.m_5759_() + 85;
    }

    public void m_289224_() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LANHeader
    extends Entry {
        private final Minecraft f_99815_ = Minecraft.m_91087_();

        public void m_6311_(GuiGraphics p_281475_, int p_282477_, int p_282819_, int p_282001_, int p_281911_, int p_283126_, int p_282303_, int p_281998_, boolean p_282625_, float p_281811_) {
            int i = p_282819_ + p_283126_ / 2 - 4;
            p_281475_.m_280614_(this.f_99815_.f_91062_, f_99760_, this.f_99815_.f_91080_.f_96543_ / 2 - this.f_99815_.f_91062_.m_92852_(f_99760_) / 2, i, 0xFFFFFF, false);
            String s = LoadingDotsText.m_232744_((long)Util.m_137550_());
            p_281475_.m_280056_(this.f_99815_.f_91062_, s, this.f_99815_.f_91080_.f_96543_ / 2 - this.f_99815_.f_91062_.m_92895_(s) / 2, i + 9, -8355712, false);
        }

        public Component m_142172_() {
            return f_99760_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class OnlineServerEntry
    extends Entry {
        private static final int f_169983_ = 32;
        private static final int f_169984_ = 32;
        private static final int f_169986_ = 32;
        private final JoinMultiplayerScreen f_99855_;
        private final Minecraft f_99856_;
        private final ServerData f_99857_;
        private final FaviconTexture f_99860_;
        @Nullable
        private byte[] f_271423_;
        private long f_99861_;

        protected OnlineServerEntry(JoinMultiplayerScreen p_99864_, ServerData p_99865_) {
            this.f_99855_ = p_99864_;
            this.f_99857_ = p_99865_;
            this.f_99856_ = Minecraft.m_91087_();
            this.f_99860_ = FaviconTexture.m_289187_((TextureManager)this.f_99856_.m_91097_(), (String)p_99865_.f_105363_);
        }

        public void m_6311_(GuiGraphics p_281406_, int p_281506_, int p_282921_, int p_281363_, int p_283596_, int p_281630_, int p_283567_, int p_282864_, boolean p_282999_, float p_281423_) {
            List<Component> list1;
            Component component;
            ResourceLocation resourcelocation;
            if (!this.f_99857_.f_105369_) {
                this.f_99857_.f_105369_ = true;
                this.f_99857_.f_105366_ = -2L;
                this.f_99857_.f_105365_ = CommonComponents.f_237098_;
                this.f_99857_.f_105364_ = CommonComponents.f_237098_;
                f_99757_.submit(() -> {
                    try {
                        this.f_99855_.m_99731_().m_105459_(this.f_99857_, () -> this.f_99856_.execute(this::m_99866_));
                    }
                    catch (UnknownHostException unknownhostexception) {
                        this.f_99857_.f_105366_ = -1L;
                        this.f_99857_.f_105365_ = f_99761_;
                    }
                    catch (Exception exception) {
                        this.f_99857_.f_105366_ = -1L;
                        this.f_99857_.f_105365_ = f_99762_;
                    }
                });
            }
            boolean flag = !this.m_264399_();
            p_281406_.m_280056_(this.f_99856_.f_91062_, this.f_99857_.f_105362_, p_281363_ + 32 + 3, p_282921_ + 1, 0xFFFFFF, false);
            List<FormattedCharSequence> list = this.f_99856_.f_91062_.m_92923_(this.f_99857_.f_105365_, p_283596_ - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                p_281406_.m_280649_(this.f_99856_.f_91062_, list.get(i), p_281363_ + 32 + 3, p_282921_ + 12 + 9 * i, -8355712, false);
            }
            Component component1 = flag ? this.f_99857_.f_105368_.m_6881_().m_130940_(ChatFormatting.RED) : this.f_99857_.f_105364_;
            int j = this.f_99856_.f_91062_.m_92852_(component1);
            p_281406_.m_280614_(this.f_99856_.f_91062_, component1, p_281363_ + p_283596_ - j - 15 - 2, p_282921_ + 1, -8355712, false);
            if (flag) {
                resourcelocation = f_291621_;
                component = f_263833_;
                list1 = this.f_99857_.f_105370_;
            } else if (this.m_264063_()) {
                resourcelocation = this.f_99857_.f_105366_ < 0L ? f_291095_ : (this.f_99857_.f_105366_ < 150L ? f_290749_ : (this.f_99857_.f_105366_ < 300L ? f_291043_ : (this.f_99857_.f_105366_ < 600L ? f_290600_ : (this.f_99857_.f_105366_ < 1000L ? f_291352_ : f_291481_))));
                if (this.f_99857_.f_105366_ < 0L) {
                    component = f_263836_;
                    list1 = Collections.emptyList();
                } else {
                    component = Component.m_237110_("multiplayer.status.ping", this.f_99857_.f_105366_);
                    list1 = this.f_99857_.f_105370_;
                }
            } else {
                int k = (int)(Util.m_137550_() / 100L + (long)(p_281506_ * 2) & 7L);
                if (k > 4) {
                    k = 8 - k;
                }
                resourcelocation = switch (k) {
                    case 1 -> f_291800_;
                    case 2 -> f_290953_;
                    case 3 -> f_291670_;
                    case 4 -> f_291720_;
                    default -> f_290586_;
                };
                component = f_263746_;
                list1 = Collections.emptyList();
            }
            p_281406_.m_292816_(resourcelocation, p_281363_ + p_283596_ - 15, p_282921_, 10, 8);
            byte[] abyte = this.f_99857_.m_271916_();
            if (!Arrays.equals(abyte, this.f_271423_)) {
                if (this.m_99896_(abyte)) {
                    this.f_271423_ = abyte;
                } else {
                    this.f_99857_.m_271813_(null);
                    this.m_99866_();
                }
            }
            this.m_280396_(p_281406_, p_281363_, p_282921_, this.f_99860_.m_289196_());
            int l = p_283567_ - p_281363_;
            int i1 = p_282864_ - p_282921_;
            if (l >= p_283596_ - 15 && l <= p_283596_ - 5 && i1 >= 0 && i1 <= 8) {
                this.f_99855_.m_99707_(Collections.singletonList(component));
            } else if (l >= p_283596_ - j - 15 - 2 && l <= p_283596_ - 15 - 2 && i1 >= 0 && i1 <= 8) {
                this.f_99855_.m_99707_(list1);
            }
            ForgeHooksClient.drawForgePingInfo((JoinMultiplayerScreen)this.f_99855_, (ServerData)this.f_99857_, (GuiGraphics)p_281406_, (int)p_281363_, (int)p_282921_, (int)p_283596_, (int)l, (int)i1);
            if (((Boolean)this.f_99856_.f_91066_.m_231828_().m_231551_()).booleanValue() || p_282999_) {
                p_281406_.m_280509_(p_281363_, p_282921_, p_281363_ + 32, p_282921_ + 32, -1601138544);
                int j1 = p_283567_ - p_281363_;
                int k1 = p_282864_ - p_282921_;
                if (this.m_99899_()) {
                    if (j1 < 32 && j1 > 16) {
                        p_281406_.m_292816_(f_290768_, p_281363_, p_282921_, 32, 32);
                    } else {
                        p_281406_.m_292816_(f_290763_, p_281363_, p_282921_, 32, 32);
                    }
                }
                if (p_281506_ > 0) {
                    if (j1 < 16 && k1 < 16) {
                        p_281406_.m_292816_(f_291174_, p_281363_, p_282921_, 32, 32);
                    } else {
                        p_281406_.m_292816_(f_290378_, p_281363_, p_282921_, 32, 32);
                    }
                }
                if (p_281506_ < this.f_99855_.m_99732_().m_105445_() - 1) {
                    if (j1 < 16 && k1 > 16) {
                        p_281406_.m_292816_(f_291824_, p_281363_, p_282921_, 32, 32);
                    } else {
                        p_281406_.m_292816_(f_290758_, p_281363_, p_282921_, 32, 32);
                    }
                }
            }
        }

        private boolean m_264063_() {
            return this.f_99857_.f_105369_ && this.f_99857_.f_105366_ != -2L;
        }

        private boolean m_264399_() {
            return this.f_99857_.f_105367_ == SharedConstants.m_183709_().m_132495_();
        }

        public void m_99866_() {
            this.f_99855_.m_99732_().m_105442_();
        }

        protected void m_280396_(GuiGraphics p_281338_, int p_283001_, int p_282834_, ResourceLocation p_282534_) {
            RenderSystem.enableBlend();
            p_281338_.m_280163_(p_282534_, p_283001_, p_282834_, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        private boolean m_99899_() {
            return true;
        }

        private boolean m_99896_(@Nullable byte[] p_273176_) {
            if (p_273176_ == null) {
                this.f_99860_.m_289218_();
            } else {
                try {
                    this.f_99860_.m_289201_(NativeImage.m_271751_((byte[])p_273176_));
                }
                catch (Throwable throwable) {
                    f_99756_.error("Invalid icon for server {} ({})", new Object[]{this.f_99857_.f_105362_, this.f_99857_.f_105363_, throwable});
                    return false;
                }
            }
            return true;
        }

        public boolean m_7933_(int p_99875_, int p_99876_, int p_99877_) {
            if (Screen.m_96638_()) {
                ServerSelectionList serverselectionlist = this.f_99855_.f_99673_;
                int i = serverselectionlist.m_6702_().indexOf(this);
                if (i == -1) {
                    return true;
                }
                if (p_99875_ == 264 && i < this.f_99855_.m_99732_().m_105445_() - 1 || p_99875_ == 265 && i > 0) {
                    this.m_99871_(i, p_99875_ == 264 ? i + 1 : i - 1);
                    return true;
                }
            }
            return super.m_7933_(p_99875_, p_99876_, p_99877_);
        }

        private void m_99871_(int p_99872_, int p_99873_) {
            this.f_99855_.m_99732_().m_105434_(p_99872_, p_99873_);
            this.f_99855_.f_99673_.m_99797_(this.f_99855_.m_99732_());
            Entry serverselectionlist$entry = (Entry)this.f_99855_.f_99673_.m_6702_().get(p_99873_);
            this.f_99855_.f_99673_.m_6987_(serverselectionlist$entry);
            ServerSelectionList.this.m_93498_((AbstractSelectionList.Entry)serverselectionlist$entry);
        }

        public boolean m_6375_(double p_99868_, double p_99869_, int p_99870_) {
            double d0 = p_99868_ - (double)ServerSelectionList.this.m_5747_();
            double d1 = p_99869_ - (double)ServerSelectionList.this.m_7610_(ServerSelectionList.this.m_6702_().indexOf(this));
            if (d0 <= 32.0) {
                if (d0 < 32.0 && d0 > 16.0 && this.m_99899_()) {
                    this.f_99855_.m_99700_(this);
                    this.f_99855_.m_99729_();
                    return true;
                }
                int i = this.f_99855_.f_99673_.m_6702_().indexOf(this);
                if (d0 < 16.0 && d1 < 16.0 && i > 0) {
                    this.m_99871_(i, i - 1);
                    return true;
                }
                if (d0 < 16.0 && d1 > 16.0 && i < this.f_99855_.m_99732_().m_105445_() - 1) {
                    this.m_99871_(i, i + 1);
                    return true;
                }
            }
            this.f_99855_.m_99700_(this);
            if (Util.m_137550_() - this.f_99861_ < 250L) {
                this.f_99855_.m_99729_();
            }
            this.f_99861_ = Util.m_137550_();
            return true;
        }

        public ServerData m_99898_() {
            return this.f_99857_;
        }

        public Component m_142172_() {
            MutableComponent mutablecomponent = Component.m_237119_();
            mutablecomponent.m_7220_(Component.m_237110_("narrator.select", this.f_99857_.f_105362_));
            mutablecomponent.m_7220_(CommonComponents.f_178389_);
            if (!this.m_264399_()) {
                mutablecomponent.m_7220_(f_263833_);
                mutablecomponent.m_7220_(CommonComponents.f_178389_);
                mutablecomponent.m_7220_(Component.m_237110_("multiplayer.status.version.narration", this.f_99857_.f_105368_));
                mutablecomponent.m_7220_(CommonComponents.f_178389_);
                mutablecomponent.m_7220_(Component.m_237110_("multiplayer.status.motd.narration", this.f_99857_.f_105365_));
            } else if (this.f_99857_.f_105366_ < 0L) {
                mutablecomponent.m_7220_(f_263836_);
            } else if (!this.m_264063_()) {
                mutablecomponent.m_7220_(f_263746_);
            } else {
                mutablecomponent.m_7220_(f_263785_);
                mutablecomponent.m_7220_(CommonComponents.f_178389_);
                mutablecomponent.m_7220_(Component.m_237110_("multiplayer.status.ping.narration", this.f_99857_.f_105366_));
                mutablecomponent.m_7220_(CommonComponents.f_178389_);
                mutablecomponent.m_7220_(Component.m_237110_("multiplayer.status.motd.narration", this.f_99857_.f_105365_));
                if (this.f_99857_.f_263840_ != null) {
                    mutablecomponent.m_7220_(CommonComponents.f_178389_);
                    mutablecomponent.m_7220_(Component.m_237110_("multiplayer.status.player_count.narration", this.f_99857_.f_263840_.f_271178_(), this.f_99857_.f_263840_.f_271503_()));
                    mutablecomponent.m_7220_(CommonComponents.f_178389_);
                    mutablecomponent.m_7220_(ComponentUtils.m_178433_(this.f_99857_.f_105370_, Component.m_237113_(", ")));
                }
            }
            return mutablecomponent;
        }

        @Override
        public void close() {
            this.f_99860_.close();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NetworkServerEntry
    extends Entry {
        private static final int f_169981_ = 32;
        private static final Component f_99830_ = Component.m_237115_("lanServer.title");
        private static final Component f_99831_ = Component.m_237115_("selectServer.hiddenAddress");
        private final JoinMultiplayerScreen f_99832_;
        protected final Minecraft f_99828_;
        protected final LanServer f_99829_;
        private long f_99833_;

        protected NetworkServerEntry(JoinMultiplayerScreen p_99836_, LanServer p_99837_) {
            this.f_99832_ = p_99836_;
            this.f_99829_ = p_99837_;
            this.f_99828_ = Minecraft.m_91087_();
        }

        public void m_6311_(GuiGraphics p_282600_, int p_282649_, int p_283641_, int p_282277_, int p_283034_, int p_281533_, int p_282746_, int p_281454_, boolean p_283673_, float p_282694_) {
            p_282600_.m_280614_(this.f_99828_.f_91062_, f_99830_, p_282277_ + 32 + 3, p_283641_ + 1, 0xFFFFFF, false);
            p_282600_.m_280056_(this.f_99828_.f_91062_, this.f_99829_.m_120078_(), p_282277_ + 32 + 3, p_283641_ + 12, -8355712, false);
            if (this.f_99828_.f_91066_.f_92124_) {
                p_282600_.m_280614_(this.f_99828_.f_91062_, f_99831_, p_282277_ + 32 + 3, p_283641_ + 12 + 11, 0x303030, false);
            } else {
                p_282600_.m_280056_(this.f_99828_.f_91062_, this.f_99829_.m_120079_(), p_282277_ + 32 + 3, p_283641_ + 12 + 11, 0x303030, false);
            }
        }

        public boolean m_6375_(double p_99840_, double p_99841_, int p_99842_) {
            this.f_99832_.m_99700_(this);
            if (Util.m_137550_() - this.f_99833_ < 250L) {
                this.f_99832_.m_99729_();
            }
            this.f_99833_ = Util.m_137550_();
            return false;
        }

        public LanServer m_99838_() {
            return this.f_99829_;
        }

        public Component m_142172_() {
            return Component.m_237110_("narrator.select", this.m_264484_());
        }

        public Component m_264484_() {
            return Component.m_237119_().m_7220_(f_99830_).m_7220_(CommonComponents.f_263701_).m_130946_(this.f_99829_.m_120078_());
        }
    }
}

