/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.DatapackLoadFailureScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.RecoverWorldDataScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.resources.server.DownloadedPackSource;
import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.util.MemoryReserve;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WorldOpenFlows {
    private static final Logger f_233088_ = LogUtils.getLogger();
    private static final UUID f_303497_ = UUID.fromString("640a6a92-b6cb-48a0-b391-831586500359");
    private final Minecraft f_233089_;
    private final LevelStorageSource f_233090_;

    public WorldOpenFlows(Minecraft p_233093_, LevelStorageSource p_233094_) {
        this.f_233089_ = p_233093_;
        this.f_233090_ = p_233094_;
    }

    public void m_233157_(String p_233158_, LevelSettings p_233159_, WorldOptions p_249243_, Function<RegistryAccess, WorldDimensions> p_249252_, Screen p_310233_) {
        this.f_233089_.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_("selectWorld.data_read")));
        LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.m_233155_(p_233158_);
        if (levelstoragesource$levelstorageaccess != null) {
            PackRepository packrepository = ServerPacksSource.m_247728_(levelstoragesource$levelstorageaccess);
            WorldDataConfiguration worlddataconfiguration = p_233159_.m_246291_();
            try {
                WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(packrepository, worlddataconfiguration, false, false);
                WorldStem worldstem = this.m_246486_(worldloader$packconfig, p_258145_ -> {
                    WorldDimensions.Complete worlddimensions$complete = ((WorldDimensions)p_249252_.apply(p_258145_.f_244104_())).m_245300_(p_258145_.f_243759_().m_175515_(Registries.f_256862_));
                    return new WorldLoader.DataLoadOutput<PrimaryLevelData>(new PrimaryLevelData(p_233159_, p_249243_, worlddimensions$complete.f_244634_(), worlddimensions$complete.m_245945_()), worlddimensions$complete.m_245593_());
                }, WorldStem::new);
                this.f_233089_.m_261031_(levelstoragesource$levelstorageaccess, packrepository, worldstem, true);
            }
            catch (Exception exception) {
                f_233088_.warn("Failed to load datapacks, can't proceed with server load", (Throwable)exception);
                levelstoragesource$levelstorageaccess.m_306156_();
                this.f_233089_.m_91152_(p_310233_);
            }
        }
    }

    @Nullable
    private LevelStorageSource.LevelStorageAccess m_233155_(String p_233156_) {
        try {
            return this.f_233090_.m_289864_(p_233156_);
        }
        catch (IOException ioexception) {
            f_233088_.warn("Failed to read level {} data", (Object)p_233156_, (Object)ioexception);
            SystemToast.m_94852_((Minecraft)this.f_233089_, (String)p_233156_);
            this.f_233089_.m_91152_(null);
            return null;
        }
        catch (ContentValidationException contentvalidationexception) {
            f_233088_.warn("{}", (Object)contentvalidationexception.getMessage());
            this.f_233089_.m_91152_(NoticeWithLinkScreen.m_293051_(() -> this.f_233089_.m_91152_(null)));
            return null;
        }
    }

    public void m_245064_(LevelStorageSource.LevelStorageAccess p_250919_, ReloadableServerResources p_248897_, LayeredRegistryAccess<RegistryLayer> p_250801_, WorldData p_251654_) {
        PackRepository packrepository = ServerPacksSource.m_247728_(p_250919_);
        CloseableResourceManager closeableresourcemanager = (CloseableResourceManager)new WorldLoader.PackConfig(packrepository, p_251654_.m_6645_(), false, false).m_214399_().getSecond();
        this.f_233089_.m_261031_(p_250919_, packrepository, new WorldStem(closeableresourcemanager, p_248897_, p_250801_, p_251654_), true);
    }

    public WorldStem m_233122_(Dynamic<?> p_312184_, boolean p_233124_, PackRepository p_233125_) throws Exception {
        WorldLoader.PackConfig worldloader$packconfig = LevelStorageSource.m_305246_(p_312184_, p_233125_, p_233124_);
        return this.m_246486_(worldloader$packconfig, p_308270_ -> {
            Registry<LevelStem> registry = p_308270_.f_243759_().m_175515_(Registries.f_256862_);
            LevelDataAndDimensions leveldataanddimensions = LevelStorageSource.m_306102_(p_312184_, p_308270_.f_244127_(), registry, p_308270_.f_244104_());
            return new WorldLoader.DataLoadOutput<WorldData>(leveldataanddimensions.f_303671_(), leveldataanddimensions.f_303409_().m_245593_());
        }, WorldStem::new);
    }

    public Pair<LevelSettings, WorldCreationContext> m_246225_(LevelStorageSource.LevelStorageAccess p_249540_) throws Exception {
        @OnlyIn(value=Dist.CLIENT)
        record Data(LevelSettings f_244166_, WorldOptions f_244534_, Registry<LevelStem> f_244151_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Data.class, "levelSettings;options;existingDimensions", "f_244166_", "f_244534_", "f_244151_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Data.class, "levelSettings;options;existingDimensions", "f_244166_", "f_244534_", "f_244151_"}, this);
            }

            @Override
            public final boolean equals(Object p_249359_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Data.class, "levelSettings;options;existingDimensions", "f_244166_", "f_244534_", "f_244151_"}, this, p_249359_);
            }
        }
        PackRepository packrepository = ServerPacksSource.m_247728_(p_249540_);
        Dynamic<?> dynamic = p_249540_.m_307464_();
        WorldLoader.PackConfig worldloader$packconfig = LevelStorageSource.m_305246_(dynamic, packrepository, false);
        return this.m_246486_(worldloader$packconfig, p_308268_ -> {
            Registry<LevelStem> registry = new MappedRegistry<LevelStem>(Registries.f_256862_, Lifecycle.stable()).m_203521_();
            LevelDataAndDimensions leveldataanddimensions = LevelStorageSource.m_306102_(dynamic, p_308268_.f_244127_(), registry, p_308268_.f_244104_());
            return new WorldLoader.DataLoadOutput<Data>(new Data(leveldataanddimensions.f_303671_().m_5926_(), leveldataanddimensions.f_303671_().m_246337_(), leveldataanddimensions.f_303409_().f_244049_()), p_308268_.f_243759_());
        }, (p_247840_, p_247841_, p_247842_, p_247843_) -> {
            p_247840_.close();
            return Pair.of((Object)p_247843_.f_244166_, (Object)new WorldCreationContext(p_247843_.f_244534_, new WorldDimensions(p_247843_.f_244151_), p_247842_, p_247841_, p_247843_.f_244166_.m_246291_()));
        });
    }

    private <D, R> R m_246486_(WorldLoader.PackConfig p_250997_, WorldLoader.WorldDataSupplier<D> p_251759_, WorldLoader.ResultFactory<D, R> p_249635_) throws Exception {
        WorldLoader.InitConfig worldloader$initconfig = new WorldLoader.InitConfig(p_250997_, Commands.CommandSelection.INTEGRATED, 2);
        CompletableFuture<R> completablefuture = WorldLoader.m_214362_(worldloader$initconfig, p_251759_, p_249635_, Util.m_183991_(), this.f_233089_);
        this.f_233089_.m_18701_(completablefuture::isDone);
        return completablefuture.get();
    }

    private void m_233140_(LevelStorageSource.LevelStorageAccess p_312560_, boolean p_233143_, Runnable p_233144_, Runnable p_312163_) {
        MutableComponent component1;
        MutableComponent component;
        if (p_233143_) {
            component = Component.m_237115_("selectWorld.backupQuestion.customized");
            component1 = Component.m_237115_("selectWorld.backupWarning.customized");
        } else {
            component = Component.m_237115_("selectWorld.backupQuestion.experimental");
            component1 = Component.m_237115_("selectWorld.backupWarning.experimental");
        }
        this.f_233089_.m_91152_((Screen)new BackupConfirmScreen(p_312163_, (p_308273_, p_308274_) -> {
            if (p_308273_) {
                EditWorldScreen.m_101258_((LevelStorageSource.LevelStorageAccess)p_312560_);
            }
            p_233144_.run();
        }, (Component)component, (Component)component1, false));
    }

    public static void m_269260_(Minecraft p_270593_, CreateWorldScreen p_270733_, Lifecycle p_270539_, Runnable p_270158_, boolean p_270709_) {
        BooleanConsumer booleanconsumer = p_233154_ -> {
            if (p_233154_) {
                p_270158_.run();
            } else {
                p_270593_.m_91152_(p_270733_);
            }
        };
        if (!p_270709_ && p_270539_ != Lifecycle.stable()) {
            if (p_270539_ == Lifecycle.experimental()) {
                p_270593_.m_91152_((Screen)new ConfirmScreen(booleanconsumer, (Component)Component.m_237115_("selectWorld.warning.experimental.title"), (Component)Component.m_237115_("selectWorld.warning.experimental.question")));
            } else {
                p_270593_.m_91152_((Screen)new ConfirmScreen(booleanconsumer, (Component)Component.m_237115_("selectWorld.warning.deprecated.title"), (Component)Component.m_237115_("selectWorld.warning.deprecated.question")));
            }
        } else {
            p_270158_.run();
        }
    }

    public void m_306404_(String p_310959_, Runnable p_309850_) {
        this.f_233089_.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_("selectWorld.data_read")));
        LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.m_233155_(p_310959_);
        if (levelstoragesource$levelstorageaccess != null) {
            this.m_305776_(levelstoragesource$levelstorageaccess, p_309850_);
        }
    }

    private void m_305776_(LevelStorageSource.LevelStorageAccess p_310121_, Runnable p_309476_) {
        LevelSummary levelsummary;
        Dynamic<?> dynamic;
        this.f_233089_.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_("selectWorld.data_read")));
        try {
            dynamic = p_310121_.m_307464_();
            levelsummary = p_310121_.m_78308_(dynamic);
        }
        catch (IOException | NbtException | ReportedNbtException ioexception) {
            this.f_233089_.m_91152_((Screen)new RecoverWorldDataScreen(this.f_233089_, p_308264_ -> {
                if (p_308264_) {
                    this.m_305776_(p_310121_, p_309476_);
                } else {
                    p_310121_.m_306156_();
                    p_309476_.run();
                }
            }, p_310121_));
            return;
        }
        catch (OutOfMemoryError outofmemoryerror1) {
            MemoryReserve.m_182328_();
            System.gc();
            String s = "Ran out of memory trying to read level data of world folder \"" + p_310121_.m_78277_() + "\"";
            f_233088_.error(LogUtils.FATAL_MARKER, s);
            OutOfMemoryError outofmemoryerror = new OutOfMemoryError("Ran out of memory reading level data");
            outofmemoryerror.initCause(outofmemoryerror1);
            CrashReport crashreport = CrashReport.m_127521_(outofmemoryerror, s);
            CrashReportCategory crashreportcategory = crashreport.m_127514_("World details");
            crashreportcategory.m_128159_("World folder", p_310121_.m_78277_());
            throw new ReportedException(crashreport);
        }
        if (!levelsummary.m_193021_()) {
            p_310121_.m_306156_();
            this.f_233089_.m_91152_((Screen)new AlertScreen(p_309476_, (Component)Component.m_237115_("selectWorld.incompatible.title").m_306658_(-65536), (Component)Component.m_237110_("selectWorld.incompatible.description", levelsummary.m_78370_())));
        } else {
            LevelSummary.BackupStatus levelsummary$backupstatus = levelsummary.m_164914_();
            if (levelsummary$backupstatus.m_164931_()) {
                String s1 = "selectWorld.backupQuestion." + levelsummary$backupstatus.m_164933_();
                String s2 = "selectWorld.backupWarning." + levelsummary$backupstatus.m_164933_();
                MutableComponent mutablecomponent = Component.m_237115_(s1);
                if (levelsummary$backupstatus.m_164932_()) {
                    mutablecomponent.m_306658_(-2142128);
                }
                MutableComponent component = Component.m_237110_(s2, levelsummary.m_78370_(), SharedConstants.m_183709_().m_132493_());
                this.f_233089_.m_91152_((Screen)new BackupConfirmScreen(() -> {
                    p_310121_.m_306156_();
                    p_309476_.run();
                }, (p_308256_, p_308257_) -> {
                    if (p_308256_) {
                        EditWorldScreen.m_101258_((LevelStorageSource.LevelStorageAccess)p_310121_);
                    }
                    this.m_233133_(p_310121_, dynamic, false, true, p_309476_);
                }, (Component)mutablecomponent, (Component)component, false));
            } else {
                this.m_233133_(p_310121_, dynamic, false, true, p_309476_);
            }
        }
    }

    public CompletableFuture<Void> m_306257_(DownloadedPackSource p_312230_, LevelStorageSource.LevelStorageAccess p_310544_) {
        Path path = p_310544_.m_78283_(LevelResource.f_78181_);
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            p_312230_.m_306738_();
            CompletableFuture completablefuture = p_312230_.m_305490_(f_303497_);
            p_312230_.m_306353_(f_303497_, path);
            return completablefuture;
        }
        return CompletableFuture.completedFuture(null);
    }

    private void m_233133_(LevelStorageSource.LevelStorageAccess p_309733_, Dynamic<?> p_312455_, boolean p_310657_, boolean p_309504_, Runnable p_309915_) {
        this.loadLevel(p_309733_, p_312455_, p_310657_, p_309504_, p_309915_, false);
    }

    private void loadLevel(LevelStorageSource.LevelStorageAccess p_309733_, Dynamic<?> p_312455_, boolean p_310657_, boolean p_309504_, Runnable p_309915_, boolean confirmExperimentalWarning) {
        boolean flag1;
        PrimaryLevelData pld;
        WorldStem worldstem;
        this.f_233089_.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_("selectWorld.resource_load")));
        PackRepository packrepository = ServerPacksSource.m_247728_(p_309733_);
        ForgeHooks.readAdditionalLevelSaveData((LevelStorageSource.LevelStorageAccess)p_309733_, (LevelStorageSource.LevelDirectory)p_309733_.m_306248_());
        try {
            WorldData worldData;
            worldstem = this.m_233122_(p_312455_, p_310657_, packrepository);
            if (confirmExperimentalWarning && (worldData = worldstem.f_206895_()) instanceof PrimaryLevelData) {
                PrimaryLevelData pld2 = (PrimaryLevelData)worldData;
                pld2.withConfirmedWarning(true);
            }
        }
        catch (Exception exception) {
            f_233088_.warn("Failed to load level data or datapacks, can't proceed with server load", (Throwable)exception);
            if (!p_310657_) {
                this.f_233089_.m_91152_((Screen)new DatapackLoadFailureScreen(() -> {
                    p_309733_.m_306156_();
                    p_309915_.run();
                }, () -> this.m_233133_(p_309733_, p_312455_, true, p_309504_, p_309915_)));
            } else {
                p_309733_.m_306156_();
                this.f_233089_.m_91152_((Screen)new AlertScreen(p_309915_, (Component)Component.m_237115_("datapackFailure.safeMode.failed.title"), (Component)Component.m_237115_("datapackFailure.safeMode.failed.description"), CommonComponents.f_130660_, true));
            }
            return;
        }
        WorldData worlddata = worldstem.f_206895_();
        boolean flag = worlddata.m_246337_().m_247070_();
        boolean skipConfirmation = worlddata instanceof PrimaryLevelData && (pld = (PrimaryLevelData)worlddata).hasConfirmedExperimentalWarning();
        boolean bl = flag1 = worlddata.m_5754_() != Lifecycle.stable() && !skipConfirmation;
        if (!p_309504_ || !flag && !flag1) {
            DownloadedPackSource downloadedpacksource = this.f_233089_.m_247489_();
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.m_306257_(downloadedpacksource, p_309733_).thenApply(p_233177_ -> true)).exceptionallyComposeAsync(p_233183_ -> {
                f_233088_.warn("Failed to load pack: ", p_233183_);
                return this.m_233095_();
            }, (Executor)this.f_233089_)).thenAcceptAsync(p_308248_ -> {
                if (p_308248_.booleanValue()) {
                    this.f_233089_.m_261031_(p_309733_, packrepository, worldstem, false);
                } else {
                    worldstem.close();
                    p_309733_.m_306156_();
                    downloadedpacksource.m_304654_();
                    p_309915_.run();
                }
            }, (Executor)this.f_233089_)).exceptionally(p_233175_ -> {
                this.f_233089_.m_231412_(CrashReport.m_127521_(p_233175_, "Load world"));
                return null;
            });
        } else {
            if (flag) {
                this.m_233140_(p_309733_, flag, () -> this.m_233133_(p_309733_, p_312455_, p_310657_, false, p_309915_), () -> {
                    p_309733_.m_306156_();
                    p_309915_.run();
                });
            } else {
                ForgeHooksClient.createWorldConfirmationScreen(() -> this.loadLevel(p_309733_, p_312455_, p_310657_, false, p_309915_, true));
            }
            worldstem.close();
        }
    }

    private CompletableFuture<Boolean> m_233095_() {
        CompletableFuture<Boolean> completablefuture = new CompletableFuture<Boolean>();
        this.f_233089_.m_91152_((Screen)new ConfirmScreen(completablefuture::complete, (Component)Component.m_237115_("multiplayer.texturePrompt.failure.line1"), (Component)Component.m_237115_("multiplayer.texturePrompt.failure.line2"), CommonComponents.f_130659_, CommonComponents.f_130656_));
        return completablefuture;
    }
}

