/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReportCategory;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.resources.server.DownloadedPackSource;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ClientboundPingPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.ICustomPacket;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class ClientCommonPacketListenerImpl
implements ClientCommonPacketListener {
    private static final Component f_291297_ = Component.m_237115_("disconnect.lost");
    private static final Logger f_290426_ = LogUtils.getLogger();
    protected final Minecraft f_291812_;
    protected final Connection f_290549_;
    @Nullable
    protected final ServerData f_291024_;
    @Nullable
    protected String f_291180_;
    protected final WorldSessionTelemetryManager f_291019_;
    @Nullable
    protected final Screen f_291028_;
    private final List<DeferredPacket> f_291530_ = new ArrayList<DeferredPacket>();

    protected ClientCommonPacketListenerImpl(Minecraft p_300051_, Connection p_300688_, CommonListenerCookie p_300429_) {
        this.f_291812_ = p_300051_;
        this.f_290549_ = p_300688_;
        this.f_291024_ = p_300429_.f_290465_();
        this.f_291180_ = p_300429_.f_291604_();
        this.f_291019_ = p_300429_.f_290317_();
        this.f_291028_ = p_300429_.f_291050_();
    }

    @Override
    public void m_292764_(ClientboundKeepAlivePacket p_301155_) {
        this.m_292916_(new ServerboundKeepAlivePacket(p_301155_.m_295012_()), () -> !RenderSystem.isFrozenAtPollEvents(), Duration.ofMinutes(1L));
    }

    @Override
    public void m_293992_(ClientboundPingPacket p_300922_) {
        PacketUtils.m_131363_(p_300922_, this, this.f_291812_);
        this.m_295327_(new ServerboundPongPacket(p_300922_.m_293261_()));
    }

    @Override
    public void m_293213_(ClientboundCustomPayloadPacket p_298103_) {
        if (ForgeHooks.onCustomPayload((ICustomPacket)p_298103_, (Connection)this.f_290549_)) {
            return;
        }
        CustomPacketPayload custompacketpayload = p_298103_.f_291001_();
        if (!(custompacketpayload instanceof DiscardedPayload)) {
            PacketUtils.m_131363_(p_298103_, this, this.f_291812_);
            if (custompacketpayload instanceof BrandPayload) {
                BrandPayload brandpayload = (BrandPayload)custompacketpayload;
                this.f_291180_ = brandpayload.f_291526_();
                this.f_291019_.m_260918_(brandpayload.f_291526_());
            } else {
                this.m_105003_(custompacketpayload);
            }
        }
    }

    protected abstract void m_105003_(CustomPacketPayload var1);

    protected abstract RegistryAccess.Frozen m_105152_();

    @Override
    public void m_305543_(ClientboundResourcePackPushPacket p_310071_) {
        PacketUtils.m_131363_(p_310071_, this, this.f_291812_);
        UUID uuid = p_310071_.f_303323_();
        URL url = ClientCommonPacketListenerImpl.m_295112_(p_310071_.f_302762_());
        if (url == null) {
            this.f_290549_.m_129512_(new ServerboundResourcePackPacket(uuid, ServerboundResourcePackPacket.Action.INVALID_URL));
        } else {
            ServerData.ServerPackStatus serverdata$serverpackstatus;
            String s = p_310071_.f_302355_();
            boolean flag = p_310071_.f_302925_();
            ServerData.ServerPackStatus serverPackStatus = serverdata$serverpackstatus = this.f_291024_ != null ? this.f_291024_.m_105387_() : ServerData.ServerPackStatus.PROMPT;
            if (!(serverdata$serverpackstatus == ServerData.ServerPackStatus.PROMPT || flag && serverdata$serverpackstatus == ServerData.ServerPackStatus.DISABLED)) {
                this.f_291812_.m_247489_().m_304637_(uuid, url, s);
            } else {
                this.f_291812_.m_91152_(this.m_306760_(uuid, url, s, flag, p_310071_.f_303164_()));
            }
        }
    }

    @Override
    public void m_292941_(ClientboundResourcePackPopPacket p_311803_) {
        PacketUtils.m_131363_(p_311803_, this, this.f_291812_);
        p_311803_.f_302279_().ifPresentOrElse(p_308277_ -> this.f_291812_.m_247489_().m_306043_(p_308277_), () -> this.f_291812_.m_247489_().m_304654_());
    }

    static Component m_294992_(Component p_299226_, @Nullable Component p_298885_) {
        return p_298885_ == null ? p_299226_ : Component.m_237110_("multiplayer.texturePrompt.serverPrompt", p_299226_, p_298885_);
    }

    @Nullable
    private static URL m_295112_(String p_298850_) {
        try {
            URL url = new URL(p_298850_);
            String s = url.getProtocol();
            return !"http".equals(s) && !"https".equals(s) ? null : url;
        }
        catch (MalformedURLException malformedurlexception) {
            return null;
        }
    }

    @Override
    public void m_105133_(ClientboundUpdateTagsPacket p_299537_) {
        PacketUtils.m_131363_(p_299537_, this, this.f_291812_);
        p_299537_.m_294928_().forEach(this::m_294832_);
    }

    private <T> void m_294832_(ResourceKey<? extends Registry<? extends T>> p_301094_, TagNetworkSerialization.NetworkPayload p_297701_) {
        if (!p_297701_.m_203966_()) {
            Registry registry = this.m_105152_().m_6632_(p_301094_).orElseThrow(() -> new IllegalStateException("Unknown registry " + p_301094_));
            HashMap map = new HashMap();
            TagNetworkSerialization.m_203952_(p_301094_, registry, p_297701_, map::put);
            registry.m_203652_(map);
        }
    }

    @Override
    public void m_293975_(ClientboundDisconnectPacket p_298016_) {
        this.f_290549_.m_129507_(p_298016_.m_295854_());
    }

    protected void m_295826_() {
        Iterator<DeferredPacket> iterator = this.f_291530_.iterator();
        while (iterator.hasNext()) {
            DeferredPacket clientcommonpacketlistenerimpl$deferredpacket = iterator.next();
            if (clientcommonpacketlistenerimpl$deferredpacket.f_291727_().getAsBoolean()) {
                this.m_295327_(clientcommonpacketlistenerimpl$deferredpacket.f_291164_);
                iterator.remove();
                continue;
            }
            if (clientcommonpacketlistenerimpl$deferredpacket.f_291012_() > Util.m_137550_()) continue;
            iterator.remove();
        }
    }

    public void m_295327_(Packet<?> p_300175_) {
        this.f_290549_.m_129512_(p_300175_);
    }

    @Override
    public void m_7026_(Component p_298766_) {
        this.f_291019_.m_261027_();
        this.f_291812_.m_91320_(this.m_295606_(p_298766_));
        f_290426_.warn("Client disconnected with reason: {}", (Object)p_298766_.getString());
    }

    @Override
    public void m_306579_(CrashReportCategory p_309761_) {
        p_309761_.m_128165_("Server type", () -> this.f_291024_ != null ? this.f_291024_.m_306276_().toString() : "<none>");
        p_309761_.m_128165_("Server brand", () -> this.f_291180_);
    }

    protected Screen m_295606_(Component p_299787_) {
        Screen screen = Objects.requireNonNullElseGet(this.f_291028_, () -> new JoinMultiplayerScreen(new TitleScreen()));
        return this.f_291024_ != null && this.f_291024_.m_295074_() ? new DisconnectedRealmsScreen(screen, f_291297_, p_299787_) : new DisconnectedScreen(screen, f_291297_, p_299787_);
    }

    @Nullable
    public String m_295034_() {
        return this.f_291180_;
    }

    private void m_292916_(Packet<? extends ServerboundPacketListener> p_300852_, BooleanSupplier p_299754_, Duration p_299011_) {
        if (p_299754_.getAsBoolean()) {
            this.m_295327_(p_300852_);
        } else {
            this.f_291530_.add(new DeferredPacket(p_300852_, p_299754_, Util.m_137550_() + p_299011_.toMillis()));
        }
    }

    private Screen m_306760_(UUID p_313077_, URL p_312880_, String p_309420_, boolean p_312218_, @Nullable Component p_309535_) {
        Screen screen = this.f_291812_.f_91080_;
        if (screen instanceof PackConfirmScreen) {
            PackConfirmScreen clientcommonpacketlistenerimpl$packconfirmscreen = (PackConfirmScreen)((Object)screen);
            return clientcommonpacketlistenerimpl$packconfirmscreen.m_307179_(this.f_291812_, p_313077_, p_312880_, p_309420_, p_312218_, p_309535_);
        }
        return new PackConfirmScreen(this.f_291812_, screen, List.of(new PackConfirmScreen.PendingRequest(p_313077_, p_312880_, p_309420_)), p_312218_, p_309535_);
    }

    @OnlyIn(value=Dist.CLIENT)
    record DeferredPacket(Packet<? extends ServerboundPacketListener> f_291164_, BooleanSupplier f_291727_, long f_291012_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DeferredPacket.class, "packet;sendCondition;expirationTime", "f_291164_", "f_291727_", "f_291012_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DeferredPacket.class, "packet;sendCondition;expirationTime", "f_291164_", "f_291727_", "f_291012_"}, this);
        }

        @Override
        public final boolean equals(Object p_297419_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DeferredPacket.class, "packet;sendCondition;expirationTime", "f_291164_", "f_291727_", "f_291012_"}, this, p_297419_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class PackConfirmScreen
    extends ConfirmScreen {
        private final List<PendingRequest> f_303444_;
        @Nullable
        private final Screen f_302369_;

        PackConfirmScreen(@Nullable Minecraft p_309743_, Screen p_312679_, List<PendingRequest> p_312458_, @Nullable boolean p_313140_, Component p_312901_) {
            super(p_309396_ -> {
                p_309743_.m_91152_(p_312679_);
                DownloadedPackSource downloadedpacksource = p_309743_.m_247489_();
                if (p_309396_) {
                    if (p_311280_.f_291024_ != null) {
                        p_311280_.f_291024_.m_105379_(ServerData.ServerPackStatus.ENABLED);
                    }
                    downloadedpacksource.m_307345_();
                } else {
                    downloadedpacksource.m_306322_();
                    if (p_313140_) {
                        p_311280_.f_290549_.m_129507_(Component.m_237115_("multiplayer.requiredTexturePrompt.disconnect"));
                    } else if (p_311280_.f_291024_ != null) {
                        p_311280_.f_291024_.m_105379_(ServerData.ServerPackStatus.DISABLED);
                    }
                }
                for (PendingRequest clientcommonpacketlistenerimpl$packconfirmscreen$pendingrequest : p_312458_) {
                    downloadedpacksource.m_304637_(clientcommonpacketlistenerimpl$packconfirmscreen$pendingrequest.f_303468_, clientcommonpacketlistenerimpl$packconfirmscreen$pendingrequest.f_303036_, clientcommonpacketlistenerimpl$packconfirmscreen$pendingrequest.f_303850_);
                }
                if (p_311280_.f_291024_ != null) {
                    ServerList.m_105446_((ServerData)p_311280_.f_291024_);
                }
            }, (Component)(p_313140_ ? Component.m_237115_("multiplayer.requiredTexturePrompt.line1") : Component.m_237115_("multiplayer.texturePrompt.line1")), ClientCommonPacketListenerImpl.m_294992_(p_313140_ ? Component.m_237115_("multiplayer.requiredTexturePrompt.line2").m_130944_(ChatFormatting.YELLOW, ChatFormatting.BOLD) : Component.m_237115_("multiplayer.texturePrompt.line2"), p_312901_), p_313140_ ? CommonComponents.f_130659_ : CommonComponents.f_130657_, p_313140_ ? CommonComponents.f_290546_ : CommonComponents.f_130658_);
            this.f_303444_ = p_312458_;
            this.f_302369_ = p_312679_;
        }

        public PackConfirmScreen m_307179_(Minecraft p_312486_, UUID p_311436_, URL p_309404_, String p_312909_, boolean p_312985_, @Nullable Component p_309496_) {
            ImmutableList list = ImmutableList.builderWithExpectedSize((int)(this.f_303444_.size() + 1)).addAll(this.f_303444_).add((Object)new PendingRequest(p_311436_, p_309404_, p_312909_)).build();
            ClientCommonPacketListenerImpl clientCommonPacketListenerImpl = ClientCommonPacketListenerImpl.this;
            Objects.requireNonNull(clientCommonPacketListenerImpl);
            return clientCommonPacketListenerImpl.new PackConfirmScreen(p_312486_, this.f_302369_, (List<PendingRequest>)list, p_312985_, p_309496_);
        }

        @OnlyIn(value=Dist.CLIENT)
        record PendingRequest(UUID f_303468_, URL f_303036_, String f_303850_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{PendingRequest.class, "id;url;hash", "f_303468_", "f_303036_", "f_303850_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PendingRequest.class, "id;url;hash", "f_303468_", "f_303036_", "f_303850_"}, this);
            }

            @Override
            public final boolean equals(Object p_309838_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PendingRequest.class, "id;url;hash", "f_303468_", "f_303036_", "f_303850_"}, this, p_309838_);
            }
        }
    }
}

