/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<RegistryStub<?>> f_254732_ = new ArrayList();

    static <T> HolderGetter<T> m_254882_(final HolderLookup.RegistryLookup<T> p_255625_) {
        return new EmptyTagLookup<T>(p_255625_){

            @Override
            public Optional<Holder.Reference<T>> m_254902_(ResourceKey<T> p_255765_) {
                return p_255625_.m_254902_(p_255765_);
            }
        };
    }

    static <T> HolderLookup.RegistryLookup<T> m_305117_(final ResourceKey<? extends Registry<? extends T>> p_311196_, final Lifecycle p_311352_, final Map<ResourceKey<T>, Holder.Reference<T>> p_311458_) {
        return new HolderLookup.RegistryLookup<T>(){

            @Override
            public ResourceKey<? extends Registry<? extends T>> m_254879_() {
                return p_311196_;
            }

            @Override
            public Lifecycle m_255098_() {
                return p_311352_;
            }

            @Override
            public Optional<Holder.Reference<T>> m_254902_(ResourceKey<T> p_310975_) {
                return Optional.ofNullable((Holder.Reference)p_311458_.get(p_310975_));
            }

            @Override
            public Stream<Holder.Reference<T>> m_214062_() {
                return p_311458_.values().stream();
            }

            @Override
            public Optional<HolderSet.Named<T>> m_255050_(TagKey<T> p_311223_) {
                return Optional.empty();
            }

            @Override
            public Stream<HolderSet.Named<T>> m_214063_() {
                return Stream.empty();
            }
        };
    }

    public <T> RegistrySetBuilder m_255162_(ResourceKey<? extends Registry<T>> p_256446_, Lifecycle p_256394_, RegistryBootstrap<T> p_256638_) {
        this.f_254732_.add(new RegistryStub<T>(p_256446_, p_256394_, p_256638_));
        return this;
    }

    public <T> RegistrySetBuilder m_254916_(ResourceKey<? extends Registry<T>> p_256261_, RegistryBootstrap<T> p_256010_) {
        return this.m_255162_(p_256261_, Lifecycle.stable(), p_256010_);
    }

    public List<? extends ResourceKey<? extends Registry<?>>> getEntryKeys() {
        return this.f_254732_.stream().map(RegistryStub::f_254738_).toList();
    }

    private BuildState m_254900_(RegistryAccess p_256400_) {
        BuildState registrysetbuilder$buildstate = BuildState.m_255369_(p_256400_, this.f_254732_.stream().map(RegistryStub::f_254738_));
        this.f_254732_.forEach(p_255629_ -> p_255629_.m_254946_(registrysetbuilder$buildstate));
        return registrysetbuilder$buildstate;
    }

    private static HolderLookup.Provider m_307871_(RegistryAccess p_311176_, Stream<HolderLookup.RegistryLookup<?>> p_311668_) {
        Stream<HolderLookup.RegistryLookup> stream = p_311176_.m_206193_().map(p_258195_ -> p_258195_.f_206234_().m_255303_());
        return HolderLookup.Provider.m_254973_(Stream.concat(stream, p_311668_));
    }

    public HolderLookup.Provider m_255144_(RegistryAccess p_256112_) {
        BuildState registrysetbuilder$buildstate = this.m_254900_(p_256112_);
        Stream<HolderLookup.RegistryLookup<?>> stream = this.f_254732_.stream().map(p_308461_ -> p_308461_.m_254914_(registrysetbuilder$buildstate).m_254889_(p_308460_.f_254680_));
        HolderLookup.Provider holderlookup$provider = RegistrySetBuilder.m_307871_(p_256112_, stream);
        registrysetbuilder$buildstate.m_307079_();
        registrysetbuilder$buildstate.m_306434_();
        registrysetbuilder$buildstate.m_255178_();
        return holderlookup$provider;
    }

    private HolderLookup.Provider m_305743_(RegistryAccess p_312999_, HolderLookup.Provider p_309815_, Cloner.Factory p_311992_, Map<ResourceKey<? extends Registry<?>>, RegistryContents<?>> p_309672_, HolderLookup.Provider p_312434_) {
        CompositeOwner registrysetbuilder$compositeowner = new CompositeOwner();
        MutableObject mutableobject = new MutableObject();
        List list = p_309672_.keySet().stream().map(p_308443_ -> this.m_306817_(registrysetbuilder$compositeowner, p_311992_, (ResourceKey)p_308443_, p_312434_, p_309815_, (MutableObject<HolderLookup.Provider>)mutableobject)).peek(registrysetbuilder$compositeowner::m_255436_).collect(Collectors.toUnmodifiableList());
        HolderLookup.Provider holderlookup$provider = RegistrySetBuilder.m_307871_(p_312999_, list.stream());
        mutableobject.setValue((Object)holderlookup$provider);
        return holderlookup$provider;
    }

    private <T> HolderLookup.RegistryLookup<T> m_306817_(HolderOwner<T> p_312548_, Cloner.Factory p_312934_, ResourceKey<? extends Registry<? extends T>> p_313093_, HolderLookup.Provider p_311682_, HolderLookup.Provider p_313198_, MutableObject<HolderLookup.Provider> p_311605_) {
        Cloner cloner = p_312934_.m_305497_(p_313093_);
        if (cloner == null) {
            throw new NullPointerException("No cloner for " + p_313093_.m_135782_());
        }
        HashMap map = new HashMap();
        HolderLookup.RegistryLookup registrylookup = p_311682_.m_255025_(p_313093_);
        registrylookup.m_214062_().forEach(p_308453_ -> {
            ResourceKey resourcekey = p_308453_.m_205785_();
            LazyHolder lazyholder = new LazyHolder(p_312548_, resourcekey);
            lazyholder.f_303404_ = () -> cloner.m_306098_(p_308453_.m_203334_(), p_311682_, (HolderLookup.Provider)p_311605_.getValue());
            map.put(resourcekey, lazyholder);
        });
        HolderLookup.RegistryLookup registrylookup1 = p_313198_.m_254861_(p_313093_).orElse(null);
        Lifecycle lifecycle = registrylookup.m_255098_();
        if (registrylookup1 != null) {
            registrylookup1.m_214062_().forEach(p_308430_ -> {
                ResourceKey resourcekey = p_308430_.m_205785_();
                map.computeIfAbsent(resourcekey, p_308437_ -> {
                    LazyHolder lazyholder = new LazyHolder(p_312548_, resourcekey);
                    lazyholder.f_303404_ = () -> cloner.m_306098_(p_308430_.m_203334_(), p_313198_, (HolderLookup.Provider)p_311605_.getValue());
                    return lazyholder;
                });
            });
            lifecycle = registrylookup.m_255098_().add(registrylookup1.m_255098_());
        }
        return RegistrySetBuilder.m_305117_(p_313093_, lifecycle, map);
    }

    public PatchedRegistries m_254929_(RegistryAccess p_255676_, HolderLookup.Provider p_255900_, Cloner.Factory p_310265_) {
        BuildState registrysetbuilder$buildstate = this.m_254900_(p_255676_);
        HashMap map = new HashMap();
        this.f_254732_.stream().map(p_308447_ -> p_308447_.m_254914_(registrysetbuilder$buildstate)).forEach(p_272339_ -> map.put((ResourceKey<Registry<?>>)p_272339_.f_271195_, (RegistryContents<?>)p_272339_));
        Set set = p_255676_.m_305097_().collect(Collectors.toUnmodifiableSet());
        p_255900_.m_305097_().filter(p_308455_ -> !set.contains(p_308455_)).forEach(p_308463_ -> map.putIfAbsent((ResourceKey<Registry<?>>)p_308463_, new RegistryContents(p_308463_, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.RegistryLookup<?>> stream = map.values().stream().map(p_308445_ -> p_308445_.m_254889_(p_308444_.f_254680_));
        HolderLookup.Provider holderlookup$provider = RegistrySetBuilder.m_307871_(p_255676_, stream);
        registrysetbuilder$buildstate.m_306434_();
        registrysetbuilder$buildstate.m_255178_();
        HolderLookup.Provider holderlookup$provider1 = this.m_305743_(p_255676_, p_255900_, p_310265_, map, holderlookup$provider);
        return new PatchedRegistries(holderlookup$provider1, holderlookup$provider);
    }

    record RegistryStub<T>(ResourceKey<? extends Registry<T>> f_254738_, Lifecycle f_254728_, RegistryBootstrap<T> f_254689_) {
        void m_254946_(BuildState p_256272_) {
            this.f_254689_.m_254966_(p_256272_.m_255274_());
        }

        public RegistryContents<T> m_254914_(BuildState p_256416_) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, RegisteredValue<?>>> iterator = p_256416_.f_254644_.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, RegisteredValue<?>> entry = iterator.next();
                ResourceKey<?> resourcekey = entry.getKey();
                if (!resourcekey.m_135783_(this.f_254738_)) continue;
                RegisteredValue<?> registeredvalue = entry.getValue();
                Holder.Reference<Object> reference = p_256416_.f_254749_.f_254730_.remove(resourcekey);
                map.put(resourcekey, new ValueAndHolder(registeredvalue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new RegistryContents(this.f_254738_, this.f_254728_, map);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryStub.class, "key;lifecycle;bootstrap", "f_254738_", "f_254728_", "f_254689_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryStub.class, "key;lifecycle;bootstrap", "f_254738_", "f_254728_", "f_254689_"}, this);
        }

        @Override
        public final boolean equals(Object p_256621_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryStub.class, "key;lifecycle;bootstrap", "f_254738_", "f_254728_", "f_254689_"}, this, p_256621_);
        }
    }

    @FunctionalInterface
    public static interface RegistryBootstrap<T> {
        public void m_254966_(BootstapContext<T> var1);
    }

    record BuildState(CompositeOwner f_254680_, UniversalLookup f_254749_, Map<ResourceLocation, HolderGetter<?>> f_254690_, Map<ResourceKey<?>, RegisteredValue<?>> f_254644_, List<RuntimeException> f_254627_) {
        public static BuildState m_255369_(RegistryAccess p_255995_, Stream<ResourceKey<? extends Registry<?>>> p_256495_) {
            CompositeOwner registrysetbuilder$compositeowner = new CompositeOwner();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            UniversalLookup registrysetbuilder$universallookup = new UniversalLookup(registrysetbuilder$compositeowner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            p_255995_.m_206193_().forEach(p_258197_ -> builder.put((Object)p_258197_.f_206233_().m_135782_(), (Object)ForgeHooks.wrapRegistryLookup(p_258197_.f_206234_().m_255303_())));
            p_256495_.forEach(p_256603_ -> builder.put((Object)p_256603_.m_135782_(), (Object)registrysetbuilder$universallookup));
            return new BuildState(registrysetbuilder$compositeowner, registrysetbuilder$universallookup, (Map<ResourceLocation, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstapContext<T> m_255274_() {
            return new BootstapContext<T>(){

                @Override
                public Holder.Reference<T> m_255042_(ResourceKey<T> p_256176_, T p_256422_, Lifecycle p_255924_) {
                    RegisteredValue registeredvalue = f_254644_.put(p_256176_, new RegisteredValue(p_256422_, p_255924_));
                    if (registeredvalue != null) {
                        f_254627_.add(new IllegalStateException("Duplicate registration for " + p_256176_ + ", new=" + p_256422_ + ", old=" + registeredvalue.f_254685_));
                    }
                    return f_254749_.m_255345_(p_256176_);
                }

                @Override
                public <S> HolderGetter<S> m_255420_(ResourceKey<? extends Registry<? extends S>> p_255961_) {
                    return f_254690_.getOrDefault(p_255961_.m_135782_(), f_254749_);
                }

                @Override
                public <S> Optional<HolderLookup.RegistryLookup<S>> registryLookup(ResourceKey<? extends Registry<? extends S>> registry) {
                    return Optional.ofNullable((HolderLookup.RegistryLookup)f_254690_.get(registry.m_135782_()));
                }
            };
        }

        public void m_306434_() {
            this.f_254644_.forEach((p_256143_, p_256662_) -> this.f_254627_.add(new IllegalStateException("Orpaned value " + p_256662_.f_254685_ + " for key " + p_256143_)));
        }

        public void m_307079_() {
            for (ResourceKey<Object> resourcekey : this.f_254749_.f_254730_.keySet()) {
                this.f_254627_.add(new IllegalStateException("Unreferenced key: " + resourcekey));
            }
        }

        public void m_255178_() {
            if (!this.f_254627_.isEmpty()) {
                IllegalStateException illegalstateexception = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeexception : this.f_254627_) {
                    illegalstateexception.addSuppressed(runtimeexception);
                }
                throw illegalstateexception;
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BuildState.class, "owner;lookup;registries;registeredValues;errors", "f_254680_", "f_254749_", "f_254690_", "f_254644_", "f_254627_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BuildState.class, "owner;lookup;registries;registeredValues;errors", "f_254680_", "f_254749_", "f_254690_", "f_254644_", "f_254627_"}, this);
        }

        @Override
        public final boolean equals(Object p_256666_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BuildState.class, "owner;lookup;registries;registeredValues;errors", "f_254680_", "f_254749_", "f_254690_", "f_254644_", "f_254627_"}, this, p_256666_);
        }
    }

    static class CompositeOwner
    implements HolderOwner<Object> {
        private final Set<HolderOwner<?>> f_254663_ = Sets.newIdentityHashSet();

        CompositeOwner() {
        }

        @Override
        public boolean m_254921_(HolderOwner<Object> p_256333_) {
            return this.f_254663_.contains(p_256333_);
        }

        public void m_255436_(HolderOwner<?> p_256361_) {
            this.f_254663_.add(p_256361_);
        }

        public <T> HolderOwner<T> m_305995_() {
            return this;
        }
    }

    public record PatchedRegistries(HolderLookup.Provider f_303626_, HolderLookup.Provider f_302264_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PatchedRegistries.class, "full;patches", "f_303626_", "f_302264_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PatchedRegistries.class, "full;patches", "f_303626_", "f_302264_"}, this);
        }

        @Override
        public final boolean equals(Object p_311690_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PatchedRegistries.class, "full;patches", "f_303626_", "f_302264_"}, this, p_311690_);
        }
    }

    record RegistryContents<T>(ResourceKey<? extends Registry<? extends T>> f_271195_, Lifecycle f_271144_, Map<ResourceKey<T>, ValueAndHolder<T>> f_254715_) {
        public HolderLookup.RegistryLookup<T> m_254889_(CompositeOwner p_311874_) {
            Map map = this.f_254715_.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, p_311794_ -> {
                ValueAndHolder valueandholder = (ValueAndHolder)p_311794_.getValue();
                Holder.Reference reference = valueandholder.f_254632_().orElseGet(() -> Holder.Reference.m_254896_(p_311874_.m_305995_(), (ResourceKey)p_311794_.getKey()));
                reference.m_247654_(valueandholder.f_254683_().f_254685_());
                return reference;
            }));
            HolderLookup.RegistryLookup registrylookup = RegistrySetBuilder.m_305117_(this.f_271195_, this.f_271144_, map);
            p_311874_.m_255436_(registrylookup);
            return registrylookup;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryContents.class, "key;lifecycle;values", "f_271195_", "f_271144_", "f_254715_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryContents.class, "key;lifecycle;values", "f_271195_", "f_271144_", "f_254715_"}, this);
        }

        @Override
        public final boolean equals(Object p_255967_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryContents.class, "key;lifecycle;values", "f_271195_", "f_271144_", "f_254715_"}, this, p_255967_);
        }
    }

    static class LazyHolder<T>
    extends Holder.Reference<T> {
        @Nullable
        Supplier<T> f_303404_;

        protected LazyHolder(HolderOwner<T> p_311720_, @Nullable ResourceKey<T> p_312254_) {
            super(Holder.Reference.Type.STAND_ALONE, p_311720_, p_312254_, null);
        }

        @Override
        public void m_247654_(T p_309503_) {
            super.m_247654_(p_309503_);
            this.f_303404_ = null;
        }

        @Override
        public T m_203334_() {
            if (this.f_303404_ != null) {
                this.m_247654_(this.f_303404_.get());
            }
            return super.m_203334_();
        }
    }

    record ValueAndHolder<T>(RegisteredValue<T> f_254683_, Optional<Holder.Reference<T>> f_254632_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ValueAndHolder.class, "value;holder", "f_254683_", "f_254632_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ValueAndHolder.class, "value;holder", "f_254683_", "f_254632_"}, this);
        }

        @Override
        public final boolean equals(Object p_256656_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ValueAndHolder.class, "value;holder", "f_254683_", "f_254632_"}, this, p_256656_);
        }
    }

    static class UniversalLookup
    extends EmptyTagLookup<Object> {
        final Map<ResourceKey<Object>, Holder.Reference<Object>> f_254730_ = new HashMap<ResourceKey<Object>, Holder.Reference<Object>>();

        public UniversalLookup(HolderOwner<Object> p_256629_) {
            super(p_256629_);
        }

        @Override
        public Optional<Holder.Reference<Object>> m_254902_(ResourceKey<Object> p_256303_) {
            return Optional.of(this.m_255345_(p_256303_));
        }

        <T> Holder.Reference<T> m_255345_(ResourceKey<T> p_256298_) {
            return this.f_254730_.computeIfAbsent(p_256298_, p_256154_ -> Holder.Reference.m_254896_(this.f_254742_, p_256154_));
        }
    }

    record RegisteredValue<T>(T f_254685_, Lifecycle f_254641_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegisteredValue.class, "value;lifecycle", "f_254685_", "f_254641_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegisteredValue.class, "value;lifecycle", "f_254685_", "f_254641_"}, this);
        }

        @Override
        public final boolean equals(Object p_255671_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegisteredValue.class, "value;lifecycle", "f_254685_", "f_254641_"}, this, p_255671_);
        }
    }

    static abstract class EmptyTagLookup<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> f_254742_;

        protected EmptyTagLookup(HolderOwner<T> p_256166_) {
            this.f_254742_ = p_256166_;
        }

        @Override
        public Optional<HolderSet.Named<T>> m_255050_(TagKey<T> p_256664_) {
            return Optional.of(HolderSet.m_255229_(this.f_254742_, p_256664_));
        }
    }
}

