/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.PackOutput;
import net.minecraft.server.Bootstrap;
import net.minecraftforge.fml.StartupMessageManager;
import org.slf4j.Logger;

public class DataGenerator {
    private static final Logger f_123905_ = LogUtils.getLogger();
    private final Path f_243753_;
    private final PackOutput f_244116_;
    final Set<String> f_252429_ = new HashSet<String>();
    final Map<String, DataProvider> f_236026_ = new LinkedHashMap<String, DataProvider>();
    private final WorldVersion f_236027_;
    private final boolean f_236028_;
    private final Map<String, DataProvider> providersView = Collections.unmodifiableMap(this.f_236026_);

    public DataGenerator(Path p_251724_, WorldVersion p_250554_, boolean p_251323_) {
        this.f_243753_ = p_251724_;
        this.f_244116_ = new PackOutput(this.f_243753_);
        this.f_236027_ = p_250554_;
        this.f_236028_ = p_251323_;
    }

    public void m_123917_() throws IOException {
        HashCache hashcache = new HashCache(this.f_243753_, this.f_252429_, this.f_236027_);
        Stopwatch stopwatch = Stopwatch.createStarted();
        Stopwatch stopwatch1 = Stopwatch.createUnstarted();
        this.f_236026_.forEach((p_254418_, p_253750_) -> {
            if (!this.f_236028_ && !hashcache.m_253256_((String)p_254418_)) {
                f_123905_.debug("Generator {} already run for version {}", p_254418_, (Object)this.f_236027_.m_132493_());
            } else {
                f_123905_.info("Starting provider: {}", p_254418_);
                StartupMessageManager.addModMessage((String)("Generating: " + p_254418_));
                stopwatch1.start();
                hashcache.m_253116_(hashcache.m_253234_((String)p_254418_, p_253750_::m_213708_).join());
                stopwatch1.stop();
                f_123905_.info("{} finished after {} ms", p_254418_, (Object)stopwatch1.elapsed(TimeUnit.MILLISECONDS));
                stopwatch1.reset();
            }
        });
        f_123905_.info("All providers took: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        hashcache.m_123937_();
    }

    public PackGenerator m_253147_(boolean p_254422_) {
        return new PackGenerator(p_254422_, "vanilla", this.f_244116_);
    }

    public PackGenerator m_253030_(boolean p_253826_, String p_254134_) {
        Path path = this.f_244116_.m_247566_(PackOutput.Target.DATA_PACK).resolve("minecraft").resolve("datapacks").resolve(p_254134_);
        return new PackGenerator(p_253826_, p_254134_, new PackOutput(path));
    }

    public Map<String, DataProvider> getProvidersView() {
        return this.providersView;
    }

    public PackOutput getPackOutput() {
        return this.f_244116_;
    }

    public PackOutput getPackOutput(String path) {
        return new PackOutput(this.f_243753_.resolve(path));
    }

    public <T extends DataProvider> T addProvider(boolean run, DataProvider.Factory<T> factory) {
        return this.addProvider(run, factory.m_253034_(this.f_244116_));
    }

    public <T extends DataProvider> T addProvider(boolean run, T provider) {
        String id = provider.m_6055_();
        if (!this.f_252429_.add(id)) {
            throw new IllegalStateException("Duplicate provider: " + id);
        }
        if (run) {
            this.f_236026_.put(id, provider);
        }
        return provider;
    }

    static {
        Bootstrap.m_135870_();
    }

    public class PackGenerator {
        private final boolean f_252435_;
        private final String f_252464_;
        private final PackOutput f_252503_;

        PackGenerator(boolean p_253884_, String p_254544_, PackOutput p_254363_) {
            this.f_252435_ = p_253884_;
            this.f_252464_ = p_254544_;
            this.f_252503_ = p_254363_;
        }

        public <T extends DataProvider> T m_253108_(DataProvider.Factory<T> p_254382_) {
            T t = p_254382_.m_253034_(this.f_252503_);
            String s = this.f_252464_ + "/" + t.m_6055_();
            if (!DataGenerator.this.f_252429_.add(s)) {
                throw new IllegalStateException("Duplicate provider: " + s);
            }
            if (this.f_252435_) {
                DataGenerator.this.f_236026_.put(s, (DataProvider)t);
            }
            return t;
        }
    }
}

