/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public abstract class RecipeProvider
implements DataProvider {
    protected final PackOutput.PathProvider f_236355_;
    protected final PackOutput.PathProvider f_236356_;
    private static final Map<BlockFamily.Variant, BiFunction<ItemLike, ItemLike, RecipeBuilder>> f_244077_ = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, (p_176733_, p_176734_) -> RecipeProvider.m_176658_(p_176733_, Ingredient.m_43929_(p_176734_))).put((Object)BlockFamily.Variant.CHISELED, (p_248037_, p_248038_) -> RecipeProvider.m_246451_(RecipeCategory.BUILDING_BLOCKS, p_248037_, Ingredient.m_43929_(p_248038_))).put((Object)BlockFamily.Variant.CUT, (p_248026_, p_248027_) -> RecipeProvider.m_245792_(RecipeCategory.BUILDING_BLOCKS, p_248026_, Ingredient.m_43929_(p_248027_))).put((Object)BlockFamily.Variant.DOOR, (p_176714_, p_176715_) -> RecipeProvider.m_176670_(p_176714_, Ingredient.m_43929_(p_176715_))).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (p_176708_, p_176709_) -> RecipeProvider.m_176678_(p_176708_, Ingredient.m_43929_(p_176709_))).put((Object)BlockFamily.Variant.FENCE, (p_248031_, p_248032_) -> RecipeProvider.m_176678_(p_248031_, Ingredient.m_43929_(p_248032_))).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, (p_176698_, p_176699_) -> RecipeProvider.m_176684_(p_176698_, Ingredient.m_43929_(p_176699_))).put((Object)BlockFamily.Variant.FENCE_GATE, (p_176733_, p_176734_) -> RecipeProvider.m_176684_(p_176733_, Ingredient.m_43929_(p_176734_))).put((Object)BlockFamily.Variant.SIGN, (p_248037_, p_248038_) -> RecipeProvider.m_176726_(p_248037_, Ingredient.m_43929_(p_248038_))).put((Object)BlockFamily.Variant.SLAB, (p_248026_, p_248027_) -> RecipeProvider.m_247552_(RecipeCategory.BUILDING_BLOCKS, p_248026_, Ingredient.m_43929_(p_248027_))).put((Object)BlockFamily.Variant.STAIRS, (p_176714_, p_176715_) -> RecipeProvider.m_176710_(p_176714_, Ingredient.m_43929_(p_176715_))).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (p_176708_, p_176709_) -> RecipeProvider.m_247347_(RecipeCategory.REDSTONE, p_176708_, Ingredient.m_43929_(p_176709_))).put((Object)BlockFamily.Variant.POLISHED, (p_248031_, p_248032_) -> RecipeProvider.m_247174_(RecipeCategory.BUILDING_BLOCKS, p_248031_, Ingredient.m_43929_(p_248032_))).put((Object)BlockFamily.Variant.TRAPDOOR, (p_176698_, p_176699_) -> RecipeProvider.m_176720_(p_176698_, Ingredient.m_43929_(p_176699_))).put((Object)BlockFamily.Variant.WALL, (p_248035_, p_248036_) -> RecipeProvider.m_245864_(RecipeCategory.DECORATIONS, p_248035_, Ingredient.m_43929_(p_248036_))).build();

    public RecipeProvider(PackOutput p_248933_) {
        this.f_236355_ = p_248933_.m_245269_(PackOutput.Target.DATA_PACK, "recipes");
        this.f_236356_ = p_248933_.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
    }

    @Override
    public CompletableFuture<?> m_213708_(final CachedOutput p_254020_) {
        final HashSet set = Sets.newHashSet();
        final ArrayList list = new ArrayList();
        this.m_245200_(new RecipeOutput(){

            @Override
            public void accept(ResourceLocation p_312383_, Recipe<?> p_312007_, @Nullable ResourceLocation advancementId, @Nullable JsonElement advancement) {
                CompletableFuture<?> saveAdvancementFuture;
                if (!set.add(p_312383_)) {
                    throw new IllegalStateException("Duplicate recipe " + p_312383_);
                }
                list.add(DataProvider.m_293028_(p_254020_, Recipe.f_302387_, p_312007_, RecipeProvider.this.f_236355_.m_245731_(p_312383_)));
                if (advancement != null && (saveAdvancementFuture = RecipeProvider.this.saveAdvancement(p_254020_, advancementId, advancement)) != null) {
                    list.add(saveAdvancementFuture);
                }
            }

            @Override
            public Advancement.Builder m_293552_() {
                return Advancement.Builder.m_285878_().m_138396_(RecipeBuilder.f_236353_);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    @Nullable
    protected CompletableFuture<?> saveAdvancement(CachedOutput output, ResourceLocation advancementId, JsonElement advancement) {
        return DataProvider.m_253162_(output, advancement, this.f_236356_.m_245731_(advancementId));
    }

    protected CompletableFuture<?> m_253240_(CachedOutput p_253674_, AdvancementHolder p_297687_) {
        return DataProvider.m_293028_(p_253674_, Advancement.f_303179_, p_297687_.f_290952_(), this.f_236356_.m_245731_(p_297687_.f_291758_()));
    }

    protected abstract void m_245200_(RecipeOutput var1);

    protected static void m_247051_(RecipeOutput p_300618_, FeatureFlagSet p_251836_) {
        BlockFamilies.m_175934_().filter(BlockFamily::m_245288_).forEach(p_308528_ -> RecipeProvider.m_176580_(p_300618_, p_308528_, p_251836_));
    }

    protected static void m_176551_(RecipeOutput p_299023_, ItemLike p_176553_, ItemLike p_176554_, @Nullable String p_176555_) {
        RecipeProvider.m_176556_(p_299023_, p_176553_, p_176554_, p_176555_, 1);
    }

    protected static void m_176556_(RecipeOutput p_301230_, ItemLike p_176558_, ItemLike p_176559_, @Nullable String p_176560_, int p_176561_) {
        ShapelessRecipeBuilder.m_246517_(RecipeCategory.MISC, p_176558_, p_176561_).m_126209_(p_176559_).m_126145_(p_176560_).m_126132_(RecipeProvider.m_176602_(p_176559_), (Criterion)RecipeProvider.m_206406_(p_176559_)).m_176500_(p_301230_, RecipeProvider.m_176517_(p_176558_, p_176559_));
    }

    protected static void m_246272_(RecipeOutput p_300202_, List<ItemLike> p_250172_, RecipeCategory p_250588_, ItemLike p_251868_, float p_250789_, int p_252144_, String p_251687_) {
        RecipeProvider.m_245809_(p_300202_, RecipeSerializer.f_44091_, SmeltingRecipe::new, p_250172_, p_250588_, p_251868_, p_250789_, p_252144_, p_251687_, "_from_smelting");
    }

    protected static void m_245412_(RecipeOutput p_298528_, List<ItemLike> p_251504_, RecipeCategory p_248846_, ItemLike p_249735_, float p_248783_, int p_250303_, String p_251984_) {
        RecipeProvider.m_245809_(p_298528_, RecipeSerializer.f_44092_, BlastingRecipe::new, p_251504_, p_248846_, p_249735_, p_248783_, p_250303_, p_251984_, "_from_blasting");
    }

    private static <T extends AbstractCookingRecipe> void m_245809_(RecipeOutput p_297621_, RecipeSerializer<T> p_251817_, AbstractCookingRecipe.Factory<T> p_312098_, List<ItemLike> p_249619_, RecipeCategory p_251154_, ItemLike p_250066_, float p_251871_, int p_251316_, String p_251450_, String p_249236_) {
        for (ItemLike itemlike : p_249619_) {
            SimpleCookingRecipeBuilder.m_247607_(Ingredient.m_43929_(itemlike), p_251154_, p_250066_, p_251871_, p_251316_, p_251817_, p_312098_).m_126145_(p_251450_).m_126132_(RecipeProvider.m_176602_(itemlike), (Criterion)RecipeProvider.m_206406_(itemlike)).m_176500_(p_297621_, RecipeProvider.m_176632_(p_250066_) + p_249236_ + "_" + RecipeProvider.m_176632_(itemlike));
        }
    }

    protected static void m_246630_(RecipeOutput p_298409_, Item p_250046_, RecipeCategory p_248986_, Item p_250389_) {
        SmithingTransformRecipeBuilder.m_266555_(Ingredient.m_43929_(Items.f_265918_), Ingredient.m_43929_(p_250046_), Ingredient.m_43929_(Items.f_42418_), p_248986_, p_250389_).m_266439_("has_netherite_ingot", RecipeProvider.m_206406_(Items.f_42418_)).m_266260_(p_298409_, RecipeProvider.m_176632_(p_250389_) + "_smithing");
    }

    protected static void m_284421_(RecipeOutput p_297574_, Item p_285461_, ResourceLocation p_285044_) {
        SmithingTrimRecipeBuilder.m_266182_(Ingredient.m_43929_(p_285461_), Ingredient.m_204132_(ItemTags.f_265942_), Ingredient.m_204132_(ItemTags.f_265843_), RecipeCategory.MISC).m_266331_("has_smithing_trim_template", RecipeProvider.m_206406_(p_285461_)).m_266403_(p_297574_, p_285044_);
    }

    protected static void m_247540_(RecipeOutput p_297675_, RecipeCategory p_250881_, ItemLike p_252184_, ItemLike p_249710_) {
        ShapedRecipeBuilder.m_246608_(p_250881_, p_252184_, 1).m_126127_(Character.valueOf('#'), p_249710_).m_126130_("##").m_126130_("##").m_126132_(RecipeProvider.m_176602_(p_249710_), (Criterion)RecipeProvider.m_206406_(p_249710_)).m_176498_(p_297675_);
    }

    protected static void m_257994_(RecipeOutput p_298075_, RecipeCategory p_259247_, ItemLike p_259376_, ItemLike p_259717_, String p_260308_) {
        ShapelessRecipeBuilder.m_245498_(p_259247_, p_259376_).m_126211_(p_259717_, 9).m_126132_(p_260308_, (Criterion)RecipeProvider.m_206406_(p_259717_)).m_176498_(p_298075_);
    }

    protected static void m_258049_(RecipeOutput p_299853_, RecipeCategory p_259186_, ItemLike p_259360_, ItemLike p_259263_) {
        RecipeProvider.m_257994_(p_299853_, p_259186_, p_259360_, p_259263_, RecipeProvider.m_176602_(p_259263_));
    }

    protected static void m_257929_(RecipeOutput p_298877_, ItemLike p_259052_, TagKey<Item> p_259045_, int p_259471_) {
        ShapelessRecipeBuilder.m_246517_(RecipeCategory.BUILDING_BLOCKS, p_259052_, p_259471_).m_206419_(p_259045_).m_126145_("planks").m_126132_("has_log", (Criterion)RecipeProvider.m_125977_(p_259045_)).m_176498_(p_298877_);
    }

    protected static void m_257424_(RecipeOutput p_298139_, ItemLike p_259193_, TagKey<Item> p_259818_, int p_259807_) {
        ShapelessRecipeBuilder.m_246517_(RecipeCategory.BUILDING_BLOCKS, p_259193_, p_259807_).m_206419_(p_259818_).m_126145_("planks").m_126132_("has_logs", (Criterion)RecipeProvider.m_125977_(p_259818_)).m_176498_(p_298139_);
    }

    protected static void m_126002_(RecipeOutput p_298359_, ItemLike p_126004_, ItemLike p_126005_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.BUILDING_BLOCKS, p_126004_, 3).m_126127_(Character.valueOf('#'), p_126005_).m_126130_("##").m_126130_("##").m_126145_("bark").m_126132_("has_log", (Criterion)RecipeProvider.m_206406_(p_126005_)).m_176498_(p_298359_);
    }

    protected static void m_126021_(RecipeOutput p_300366_, ItemLike p_126023_, ItemLike p_126024_) {
        ShapedRecipeBuilder.m_245327_(RecipeCategory.TRANSPORTATION, p_126023_).m_126127_(Character.valueOf('#'), p_126024_).m_126130_("# #").m_126130_("###").m_126145_("boat").m_126132_("in_water", (Criterion)RecipeProvider.m_125979_(Blocks.f_49990_)).m_176498_(p_300366_);
    }

    protected static void m_236371_(RecipeOutput p_300411_, ItemLike p_236373_, ItemLike p_236374_) {
        ShapelessRecipeBuilder.m_245498_(RecipeCategory.TRANSPORTATION, p_236373_).m_126209_(Blocks.f_50087_).m_126209_(p_236374_).m_126145_("chest_boat").m_126132_("has_boat", (Criterion)RecipeProvider.m_125977_(ItemTags.f_13155_)).m_176498_(p_300411_);
    }

    protected static RecipeBuilder m_176658_(ItemLike p_176659_, Ingredient p_176660_) {
        return ShapelessRecipeBuilder.m_245498_(RecipeCategory.REDSTONE, p_176659_).m_126184_(p_176660_);
    }

    protected static RecipeBuilder m_176670_(ItemLike p_176671_, Ingredient p_176672_) {
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.REDSTONE, p_176671_, 3).m_126124_(Character.valueOf('#'), p_176672_).m_126130_("##").m_126130_("##").m_126130_("##");
    }

    protected static RecipeBuilder m_176678_(ItemLike p_176679_, Ingredient p_176680_) {
        int i = p_176679_ == Blocks.f_50198_ ? 6 : 3;
        Item item = p_176679_ == Blocks.f_50198_ ? Items.f_42691_ : Items.f_42398_;
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_176679_, i).m_126124_(Character.valueOf('W'), p_176680_).m_126127_(Character.valueOf('#'), item).m_126130_("W#W").m_126130_("W#W");
    }

    protected static RecipeBuilder m_176684_(ItemLike p_176685_, Ingredient p_176686_) {
        return ShapedRecipeBuilder.m_245327_(RecipeCategory.REDSTONE, p_176685_).m_126127_(Character.valueOf('#'), Items.f_42398_).m_126124_(Character.valueOf('W'), p_176686_).m_126130_("#W#").m_126130_("#W#");
    }

    protected static void m_176690_(RecipeOutput p_299733_, ItemLike p_176692_, ItemLike p_176693_) {
        RecipeProvider.m_247347_(RecipeCategory.REDSTONE, p_176692_, Ingredient.m_43929_(p_176693_)).m_126132_(RecipeProvider.m_176602_(p_176693_), RecipeProvider.m_206406_(p_176693_)).m_176498_(p_299733_);
    }

    protected static RecipeBuilder m_247347_(RecipeCategory p_251447_, ItemLike p_251989_, Ingredient p_249211_) {
        return ShapedRecipeBuilder.m_245327_(p_251447_, p_251989_).m_126124_(Character.valueOf('#'), p_249211_).m_126130_("##");
    }

    protected static void m_246658_(RecipeOutput p_300089_, RecipeCategory p_251848_, ItemLike p_249368_, ItemLike p_252133_) {
        RecipeProvider.m_247552_(p_251848_, p_249368_, Ingredient.m_43929_(p_252133_)).m_126132_(RecipeProvider.m_176602_(p_252133_), RecipeProvider.m_206406_(p_252133_)).m_176498_(p_300089_);
    }

    protected static RecipeBuilder m_247552_(RecipeCategory p_251707_, ItemLike p_251284_, Ingredient p_248824_) {
        return ShapedRecipeBuilder.m_246608_(p_251707_, p_251284_, 6).m_126124_(Character.valueOf('#'), p_248824_).m_126130_("###");
    }

    protected static RecipeBuilder m_176710_(ItemLike p_176711_, Ingredient p_176712_) {
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.BUILDING_BLOCKS, p_176711_, 4).m_126124_(Character.valueOf('#'), p_176712_).m_126130_("#  ").m_126130_("## ").m_126130_("###");
    }

    protected static RecipeBuilder m_176720_(ItemLike p_176721_, Ingredient p_176722_) {
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.REDSTONE, p_176721_, 2).m_126124_(Character.valueOf('#'), p_176722_).m_126130_("###").m_126130_("###");
    }

    protected static RecipeBuilder m_176726_(ItemLike p_176727_, Ingredient p_176728_) {
        return ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_176727_, 3).m_126145_("sign").m_126124_(Character.valueOf('#'), p_176728_).m_126127_(Character.valueOf('X'), Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" X ");
    }

    protected static void m_246977_(RecipeOutput p_300811_, ItemLike p_252355_, ItemLike p_250437_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_252355_, 6).m_126145_("hanging_sign").m_126127_(Character.valueOf('#'), p_250437_).m_126127_(Character.valueOf('X'), Items.f_42026_).m_126130_("X X").m_126130_("###").m_126130_("###").m_126132_("has_stripped_logs", (Criterion)RecipeProvider.m_206406_(p_250437_)).m_176498_(p_300811_);
    }

    protected static void m_289596_(RecipeOutput p_297350_, List<Item> p_289675_, List<Item> p_289672_, String p_289641_) {
        for (int i = 0; i < p_289675_.size(); ++i) {
            Item item = p_289675_.get(i);
            Item item1 = p_289672_.get(i);
            ShapelessRecipeBuilder.m_245498_(RecipeCategory.BUILDING_BLOCKS, item1).m_126209_(item).m_126184_(Ingredient.m_43921_(p_289672_.stream().filter(p_288265_ -> !p_288265_.equals(item1)).map(ItemStack::new))).m_126145_(p_289641_).m_126132_("has_needed_dye", (Criterion)RecipeProvider.m_206406_(item)).m_176500_(p_297350_, "dye_" + RecipeProvider.m_176632_(item1));
        }
    }

    protected static void m_176716_(RecipeOutput p_298709_, ItemLike p_176718_, ItemLike p_176719_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_176718_, 3).m_126127_(Character.valueOf('#'), p_176719_).m_126130_("##").m_126145_("carpet").m_126132_(RecipeProvider.m_176602_(p_176719_), (Criterion)RecipeProvider.m_206406_(p_176719_)).m_176498_(p_298709_);
    }

    protected static void m_126073_(RecipeOutput p_300515_, ItemLike p_126075_, ItemLike p_126076_) {
        ShapedRecipeBuilder.m_245327_(RecipeCategory.DECORATIONS, p_126075_).m_126127_(Character.valueOf('#'), p_126076_).m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126130_("###").m_126130_("XXX").m_126145_("bed").m_126132_(RecipeProvider.m_176602_(p_126076_), (Criterion)RecipeProvider.m_206406_(p_126076_)).m_176498_(p_300515_);
    }

    protected static void m_126081_(RecipeOutput p_300693_, ItemLike p_126083_, ItemLike p_126084_) {
        ShapedRecipeBuilder.m_245327_(RecipeCategory.DECORATIONS, p_126083_).m_126127_(Character.valueOf('#'), p_126084_).m_126127_(Character.valueOf('|'), Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" | ").m_126145_("banner").m_126132_(RecipeProvider.m_176602_(p_126084_), (Criterion)RecipeProvider.m_206406_(p_126084_)).m_176498_(p_300693_);
    }

    protected static void m_126085_(RecipeOutput p_297360_, ItemLike p_126087_, ItemLike p_126088_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.BUILDING_BLOCKS, p_126087_, 8).m_126127_(Character.valueOf('#'), Blocks.f_50058_).m_126127_(Character.valueOf('X'), p_126088_).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_("stained_glass").m_126132_("has_glass", (Criterion)RecipeProvider.m_206406_(Blocks.f_50058_)).m_176498_(p_297360_);
    }

    protected static void m_126089_(RecipeOutput p_300949_, ItemLike p_126091_, ItemLike p_126092_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_126091_, 16).m_126127_(Character.valueOf('#'), p_126092_).m_126130_("###").m_126130_("###").m_126145_("stained_glass_pane").m_126132_("has_glass", (Criterion)RecipeProvider.m_206406_(p_126092_)).m_176498_(p_300949_);
    }

    protected static void m_126093_(RecipeOutput p_298776_, ItemLike p_126095_, ItemLike p_126096_) {
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_246608_(RecipeCategory.DECORATIONS, p_126095_, 8).m_126127_(Character.valueOf('#'), Blocks.f_50185_).m_126127_(Character.valueOf('$'), p_126096_).m_126130_("###").m_126130_("#$#").m_126130_("###").m_126145_("stained_glass_pane").m_126132_("has_glass_pane", (Criterion)RecipeProvider.m_206406_(Blocks.f_50185_))).m_126132_(RecipeProvider.m_176602_(p_126096_), (Criterion)RecipeProvider.m_206406_(p_126096_)).m_176500_(p_298776_, RecipeProvider.m_176517_(p_126095_, Blocks.f_50185_));
    }

    protected static void m_126097_(RecipeOutput p_297522_, ItemLike p_126099_, ItemLike p_126100_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.BUILDING_BLOCKS, p_126099_, 8).m_126127_(Character.valueOf('#'), Blocks.f_50352_).m_126127_(Character.valueOf('X'), p_126100_).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_("stained_terracotta").m_126132_("has_terracotta", (Criterion)RecipeProvider.m_206406_(Blocks.f_50352_)).m_176498_(p_297522_);
    }

    protected static void m_126101_(RecipeOutput p_300890_, ItemLike p_126103_, ItemLike p_126104_) {
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_246517_(RecipeCategory.BUILDING_BLOCKS, p_126103_, 8).m_126209_(p_126104_).m_126211_(Blocks.f_49992_, 4).m_126211_(Blocks.f_49994_, 4).m_126145_("concrete_powder").m_126132_("has_sand", (Criterion)RecipeProvider.m_206406_(Blocks.f_49992_))).m_126132_("has_gravel", (Criterion)RecipeProvider.m_206406_(Blocks.f_49994_)).m_176498_(p_300890_);
    }

    protected static void m_176542_(RecipeOutput p_299296_, ItemLike p_176544_, ItemLike p_176545_) {
        ShapelessRecipeBuilder.m_245498_(RecipeCategory.DECORATIONS, p_176544_).m_126209_(Blocks.f_152482_).m_126209_(p_176545_).m_126145_("dyed_candle").m_126132_(RecipeProvider.m_176602_(p_176545_), (Criterion)RecipeProvider.m_206406_(p_176545_)).m_176498_(p_299296_);
    }

    protected static void m_246382_(RecipeOutput p_298550_, RecipeCategory p_251148_, ItemLike p_250499_, ItemLike p_249970_) {
        RecipeProvider.m_245864_(p_251148_, p_250499_, Ingredient.m_43929_(p_249970_)).m_126132_(RecipeProvider.m_176602_(p_249970_), RecipeProvider.m_206406_(p_249970_)).m_176498_(p_298550_);
    }

    protected static RecipeBuilder m_245864_(RecipeCategory p_249083_, ItemLike p_250754_, Ingredient p_250311_) {
        return ShapedRecipeBuilder.m_246608_(p_249083_, p_250754_, 6).m_126124_(Character.valueOf('#'), p_250311_).m_126130_("###").m_126130_("###");
    }

    protected static void m_245931_(RecipeOutput p_300055_, RecipeCategory p_248719_, ItemLike p_250032_, ItemLike p_250021_) {
        RecipeProvider.m_247174_(p_248719_, p_250032_, Ingredient.m_43929_(p_250021_)).m_126132_(RecipeProvider.m_176602_(p_250021_), RecipeProvider.m_206406_(p_250021_)).m_176498_(p_300055_);
    }

    protected static RecipeBuilder m_247174_(RecipeCategory p_249131_, ItemLike p_251242_, Ingredient p_251412_) {
        return ShapedRecipeBuilder.m_246608_(p_249131_, p_251242_, 4).m_126124_(Character.valueOf('S'), p_251412_).m_126130_("SS").m_126130_("SS");
    }

    protected static void m_247059_(RecipeOutput p_297773_, RecipeCategory p_252306_, ItemLike p_249686_, ItemLike p_251100_) {
        RecipeProvider.m_245792_(p_252306_, p_249686_, Ingredient.m_43929_(p_251100_)).m_126132_(RecipeProvider.m_176602_(p_251100_), (Criterion)RecipeProvider.m_206406_(p_251100_)).m_176498_(p_297773_);
    }

    protected static ShapedRecipeBuilder m_245792_(RecipeCategory p_250895_, ItemLike p_251147_, Ingredient p_251563_) {
        return ShapedRecipeBuilder.m_246608_(p_250895_, p_251147_, 4).m_126124_(Character.valueOf('#'), p_251563_).m_126130_("##").m_126130_("##");
    }

    protected static void m_246222_(RecipeOutput p_301222_, RecipeCategory p_251604_, ItemLike p_251049_, ItemLike p_252267_) {
        RecipeProvider.m_246451_(p_251604_, p_251049_, Ingredient.m_43929_(p_252267_)).m_126132_(RecipeProvider.m_176602_(p_252267_), (Criterion)RecipeProvider.m_206406_(p_252267_)).m_176498_(p_301222_);
    }

    protected static void m_247239_(RecipeOutput p_298750_, RecipeCategory p_248788_, ItemLike p_251925_, ItemLike p_252242_) {
        ShapedRecipeBuilder.m_245327_(p_248788_, p_251925_).m_126127_(Character.valueOf('#'), p_252242_).m_126130_("#").m_126130_("#").m_126132_(RecipeProvider.m_176602_(p_252242_), (Criterion)RecipeProvider.m_206406_(p_252242_)).m_176498_(p_298750_);
    }

    protected static ShapedRecipeBuilder m_246451_(RecipeCategory p_251755_, ItemLike p_249782_, Ingredient p_250087_) {
        return ShapedRecipeBuilder.m_245327_(p_251755_, p_249782_).m_126124_(Character.valueOf('#'), p_250087_).m_126130_("#").m_126130_("#");
    }

    protected static void m_247298_(RecipeOutput p_299266_, RecipeCategory p_250609_, ItemLike p_251254_, ItemLike p_249666_) {
        RecipeProvider.m_247600_(p_299266_, p_250609_, p_251254_, p_249666_, 1);
    }

    protected static void m_247600_(RecipeOutput p_300991_, RecipeCategory p_248911_, ItemLike p_251265_, ItemLike p_250033_, int p_301035_) {
        SingleItemRecipeBuilder.m_246944_(Ingredient.m_43929_(p_250033_), p_248911_, p_251265_, p_301035_).m_126132_(RecipeProvider.m_176602_(p_250033_), (Criterion)RecipeProvider.m_206406_(p_250033_)).m_176500_(p_300991_, RecipeProvider.m_176517_(p_251265_, p_250033_) + "_stonecutting");
    }

    private static void m_176739_(RecipeOutput p_298757_, ItemLike p_176741_, ItemLike p_176742_) {
        SimpleCookingRecipeBuilder.m_246179_(Ingredient.m_43929_(p_176742_), RecipeCategory.BUILDING_BLOCKS, p_176741_, 0.1f, 200).m_126132_(RecipeProvider.m_176602_(p_176742_), (Criterion)RecipeProvider.m_206406_(p_176742_)).m_176498_(p_298757_);
    }

    protected static void m_247655_(RecipeOutput p_298715_, RecipeCategory p_251203_, ItemLike p_251689_, RecipeCategory p_251376_, ItemLike p_248771_) {
        RecipeProvider.m_247368_(p_298715_, p_251203_, p_251689_, p_251376_, p_248771_, RecipeProvider.m_176644_(p_248771_), null, RecipeProvider.m_176644_(p_251689_), null);
    }

    protected static void m_246075_(RecipeOutput p_300453_, RecipeCategory p_250885_, ItemLike p_251651_, RecipeCategory p_250874_, ItemLike p_248576_, String p_250171_, String p_249386_) {
        RecipeProvider.m_247368_(p_300453_, p_250885_, p_251651_, p_250874_, p_248576_, p_250171_, p_249386_, RecipeProvider.m_176644_(p_251651_), null);
    }

    protected static void m_245261_(RecipeOutput p_298590_, RecipeCategory p_248979_, ItemLike p_249101_, RecipeCategory p_252036_, ItemLike p_250886_, String p_248768_, String p_250847_) {
        RecipeProvider.m_247368_(p_298590_, p_248979_, p_249101_, p_252036_, p_250886_, RecipeProvider.m_176644_(p_250886_), null, p_248768_, p_250847_);
    }

    private static void m_247368_(RecipeOutput p_298159_, RecipeCategory p_250083_, ItemLike p_250042_, RecipeCategory p_248977_, ItemLike p_251911_, String p_250475_, @Nullable String p_248641_, String p_252237_, @Nullable String p_250414_) {
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_246517_(p_250083_, p_250042_, 9).m_126209_(p_251911_).m_126145_(p_250414_).m_126132_(RecipeProvider.m_176602_(p_251911_), (Criterion)RecipeProvider.m_206406_(p_251911_))).m_126140_(p_298159_, new ResourceLocation(p_252237_));
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_245327_(p_248977_, p_251911_).m_126127_(Character.valueOf('#'), p_250042_).m_126130_("###").m_126130_("###").m_126130_("###").m_126145_(p_248641_).m_126132_(RecipeProvider.m_176602_(p_250042_), (Criterion)RecipeProvider.m_206406_(p_250042_))).m_126140_(p_298159_, new ResourceLocation(p_250475_));
    }

    protected static void m_266438_(RecipeOutput p_299385_, ItemLike p_267133_, TagKey<Item> p_298808_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.MISC, p_267133_, 2).m_126127_(Character.valueOf('#'), Items.f_42415_).m_206416_(Character.valueOf('C'), p_298808_).m_126127_(Character.valueOf('S'), p_267133_).m_126130_("#S#").m_126130_("#C#").m_126130_("###").m_126132_(RecipeProvider.m_176602_(p_267133_), (Criterion)RecipeProvider.m_206406_(p_267133_)).m_176498_(p_299385_);
    }

    protected static void m_266564_(RecipeOutput p_300831_, ItemLike p_266974_, ItemLike p_298586_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.MISC, p_266974_, 2).m_126127_(Character.valueOf('#'), Items.f_42415_).m_126127_(Character.valueOf('C'), p_298586_).m_126127_(Character.valueOf('S'), p_266974_).m_126130_("#S#").m_126130_("#C#").m_126130_("###").m_126132_(RecipeProvider.m_176602_(p_266974_), (Criterion)RecipeProvider.m_206406_(p_266974_)).m_176498_(p_300831_);
    }

    protected static <T extends AbstractCookingRecipe> void m_126006_(RecipeOutput p_298337_, String p_126008_, RecipeSerializer<T> p_250529_, AbstractCookingRecipe.Factory<T> p_312851_, int p_126010_) {
        RecipeProvider.m_247434_(p_298337_, p_126008_, p_250529_, p_312851_, p_126010_, Items.f_42579_, Items.f_42580_, 0.35f);
        RecipeProvider.m_247434_(p_298337_, p_126008_, p_250529_, p_312851_, p_126010_, Items.f_42581_, Items.f_42582_, 0.35f);
        RecipeProvider.m_247434_(p_298337_, p_126008_, p_250529_, p_312851_, p_126010_, Items.f_42526_, Items.f_42530_, 0.35f);
        RecipeProvider.m_247434_(p_298337_, p_126008_, p_250529_, p_312851_, p_126010_, Items.f_41910_, Items.f_42576_, 0.1f);
        RecipeProvider.m_247434_(p_298337_, p_126008_, p_250529_, p_312851_, p_126010_, Items.f_42527_, Items.f_42531_, 0.35f);
        RecipeProvider.m_247434_(p_298337_, p_126008_, p_250529_, p_312851_, p_126010_, Items.f_42658_, Items.f_42659_, 0.35f);
        RecipeProvider.m_247434_(p_298337_, p_126008_, p_250529_, p_312851_, p_126010_, Items.f_42485_, Items.f_42486_, 0.35f);
        RecipeProvider.m_247434_(p_298337_, p_126008_, p_250529_, p_312851_, p_126010_, Items.f_42620_, Items.f_42674_, 0.35f);
        RecipeProvider.m_247434_(p_298337_, p_126008_, p_250529_, p_312851_, p_126010_, Items.f_42697_, Items.f_42698_, 0.35f);
    }

    private static <T extends AbstractCookingRecipe> void m_247434_(RecipeOutput p_301359_, String p_249709_, RecipeSerializer<T> p_251876_, AbstractCookingRecipe.Factory<T> p_311509_, int p_249258_, ItemLike p_250669_, ItemLike p_250224_, float p_252138_) {
        SimpleCookingRecipeBuilder.m_247607_(Ingredient.m_43929_(p_250669_), RecipeCategory.FOOD, p_250224_, p_252138_, p_249258_, p_251876_, p_311509_).m_126132_(RecipeProvider.m_176602_(p_250669_), (Criterion)RecipeProvider.m_206406_(p_250669_)).m_176500_(p_301359_, RecipeProvider.m_176632_(p_250224_) + "_from_" + p_249709_);
    }

    protected static void m_176610_(RecipeOutput p_298400_, FeatureFlagSet p_312821_) {
        HoneycombItem.f_150863_.get().forEach((p_308519_, p_308520_) -> {
            if (p_308520_.m_245183_().m_247715_(p_312821_)) {
                ShapelessRecipeBuilder.m_245498_(RecipeCategory.BUILDING_BLOCKS, p_308520_).m_126209_((ItemLike)p_308519_).m_126209_(Items.f_42784_).m_126145_(RecipeProvider.m_176632_(p_308520_)).m_126132_(RecipeProvider.m_176602_(p_308519_), (Criterion)RecipeProvider.m_206406_(p_308519_)).m_176500_(p_298400_, RecipeProvider.m_176517_(p_308520_, Items.f_42784_));
            }
        });
    }

    protected static void m_306715_(RecipeOutput p_311070_, Block p_309854_, Block p_310802_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.BUILDING_BLOCKS, p_309854_, 4).m_126127_(Character.valueOf('M'), p_310802_).m_126130_(" M ").m_126130_("M M").m_126130_(" M ").m_126132_(RecipeProvider.m_176602_(p_310802_), (Criterion)RecipeProvider.m_206406_(p_310802_)).m_176498_(p_311070_);
    }

    protected static void m_306759_(RecipeOutput p_310731_, Block p_312293_, Block p_312258_) {
        ShapedRecipeBuilder.m_246608_(RecipeCategory.REDSTONE, p_312293_, 4).m_126127_(Character.valueOf('C'), p_312258_).m_126127_(Character.valueOf('R'), Items.f_42451_).m_126127_(Character.valueOf('B'), Items.f_42585_).m_126130_(" C ").m_126130_("CBC").m_126130_(" R ").m_126132_(RecipeProvider.m_176602_(p_312258_), (Criterion)RecipeProvider.m_206406_(p_312258_)).m_176498_(p_310731_);
    }

    protected static void m_176580_(RecipeOutput p_299904_, BlockFamily p_176582_, FeatureFlagSet p_312313_) {
        p_176582_.m_175954_().forEach((p_308524_, p_308525_) -> {
            if (p_308525_.m_245183_().m_247715_(p_312313_)) {
                BiFunction<ItemLike, ItemLike, RecipeBuilder> bifunction = f_244077_.get(p_308524_);
                Block itemlike = RecipeProvider.m_176523_(p_176582_, p_308524_);
                if (bifunction != null) {
                    RecipeBuilder recipebuilder = bifunction.apply((ItemLike)p_308525_, itemlike);
                    p_176582_.m_175957_().ifPresent(p_296361_ -> recipebuilder.m_126145_(p_296361_ + (String)(p_308524_ == BlockFamily.Variant.CUT ? "" : "_" + p_308524_.m_294338_())));
                    recipebuilder.m_126132_(p_176582_.m_175958_().orElseGet(() -> RecipeProvider.m_176602_(itemlike)), RecipeProvider.m_206406_(itemlike));
                    recipebuilder.m_176498_(p_299904_);
                }
                if (p_308524_ == BlockFamily.Variant.CRACKED) {
                    RecipeProvider.m_176739_(p_299904_, p_308525_, itemlike);
                }
            }
        });
    }

    protected static Block m_176523_(BlockFamily p_176524_, BlockFamily.Variant p_176525_) {
        if (p_176525_ == BlockFamily.Variant.CHISELED) {
            if (!p_176524_.m_175954_().containsKey((Object)BlockFamily.Variant.SLAB)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return p_176524_.m_175952_(BlockFamily.Variant.SLAB);
        }
        return p_176524_.m_175951_();
    }

    private static Criterion<EnterBlockTrigger.TriggerInstance> m_125979_(Block p_125980_) {
        return CriteriaTriggers.f_10570_.m_292665_(new EnterBlockTrigger.TriggerInstance(Optional.empty(), Optional.of(p_125980_.m_204297_()), Optional.empty()));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> m_176520_(MinMaxBounds.Ints p_176521_, ItemLike p_176522_) {
        return RecipeProvider.m_126011_(ItemPredicate.Builder.m_45068_().m_151445_(p_176522_).m_151443_(p_176521_));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> m_206406_(ItemLike p_298497_) {
        return RecipeProvider.m_126011_(ItemPredicate.Builder.m_45068_().m_151445_(p_298497_));
    }

    protected static Criterion<InventoryChangeTrigger.TriggerInstance> m_125977_(TagKey<Item> p_299059_) {
        return RecipeProvider.m_126011_(ItemPredicate.Builder.m_45068_().m_204145_(p_299059_));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> m_126011_(ItemPredicate.Builder ... p_299527_) {
        return RecipeProvider.m_293546_((ItemPredicate[])Arrays.stream(p_299527_).map(ItemPredicate.Builder::m_45077_).toArray(ItemPredicate[]::new));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> m_293546_(ItemPredicate ... p_297226_) {
        return CriteriaTriggers.f_10571_.m_292665_(new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.f_303621_, List.of(p_297226_)));
    }

    protected static String m_176602_(ItemLike p_176603_) {
        return "has_" + RecipeProvider.m_176632_(p_176603_);
    }

    protected static String m_176632_(ItemLike p_176633_) {
        return BuiltInRegistries.f_257033_.m_7981_(p_176633_.m_5456_()).m_135815_();
    }

    protected static String m_176644_(ItemLike p_176645_) {
        return RecipeProvider.m_176632_(p_176645_);
    }

    protected static String m_176517_(ItemLike p_176518_, ItemLike p_176519_) {
        return RecipeProvider.m_176632_(p_176518_) + "_from_" + RecipeProvider.m_176632_(p_176519_);
    }

    protected static String m_176656_(ItemLike p_176657_) {
        return RecipeProvider.m_176632_(p_176657_) + "_from_smelting";
    }

    protected static String m_176668_(ItemLike p_176669_) {
        return RecipeProvider.m_176632_(p_176669_) + "_from_blasting";
    }

    @Override
    public final String m_6055_() {
        return "Recipes";
    }
}

