/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.util.DelegateDataOutput;
import net.minecraft.util.FastBufferedInputStream;

public class NbtIo {
    private static final OpenOption[] f_302613_ = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static CompoundTag m_128939_(Path p_310303_, NbtAccounter p_311830_) throws IOException {
        try (InputStream inputstream = Files.newInputStream(p_310303_, new OpenOption[0]);){
            CompoundTag compoundTag = NbtIo.m_128937_(inputstream, p_311830_);
            return compoundTag;
        }
    }

    private static DataInputStream m_202493_(InputStream p_202494_) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(p_202494_)));
    }

    private static DataOutputStream m_306903_(OutputStream p_310411_) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(p_310411_)));
    }

    public static CompoundTag m_128937_(InputStream p_313037_, NbtAccounter p_312435_) throws IOException {
        try (DataInputStream datainputstream = NbtIo.m_202493_(p_313037_);){
            CompoundTag compoundTag = NbtIo.m_128934_(datainputstream, p_312435_);
            return compoundTag;
        }
    }

    public static void m_202487_(Path p_310443_, StreamTagVisitor p_202489_, NbtAccounter p_301727_) throws IOException {
        try (InputStream inputstream = Files.newInputStream(p_310443_, new OpenOption[0]);){
            NbtIo.m_202490_(inputstream, p_202489_, p_301727_);
        }
    }

    public static void m_202490_(InputStream p_202491_, StreamTagVisitor p_202492_, NbtAccounter p_301762_) throws IOException {
        try (DataInputStream datainputstream = NbtIo.m_202493_(p_202491_);){
            NbtIo.m_197509_(datainputstream, p_202492_, p_301762_);
        }
    }

    public static void m_128944_(CompoundTag p_128945_, Path p_310344_) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(p_310344_, f_302613_);
             BufferedOutputStream outputstream1 = new BufferedOutputStream(outputstream);){
            NbtIo.m_128947_(p_128945_, outputstream1);
        }
    }

    public static void m_128947_(CompoundTag p_128948_, OutputStream p_128949_) throws IOException {
        try (DataOutputStream dataoutputstream = NbtIo.m_306903_(p_128949_);){
            NbtIo.m_128941_(p_128948_, dataoutputstream);
        }
    }

    public static void m_128955_(CompoundTag p_128956_, Path p_311890_) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(p_311890_, f_302613_);
             BufferedOutputStream outputstream1 = new BufferedOutputStream(outputstream);
             DataOutputStream dataoutputstream = new DataOutputStream(outputstream1);){
            NbtIo.m_128941_(p_128956_, dataoutputstream);
        }
    }

    @Nullable
    public static CompoundTag m_128953_(Path p_310670_) throws IOException {
        if (!Files.exists(p_310670_, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputstream = Files.newInputStream(p_310670_, new OpenOption[0]);){
            CompoundTag compoundTag;
            try (DataInputStream datainputstream = new DataInputStream(inputstream);){
                compoundTag = NbtIo.m_128934_(datainputstream, NbtAccounter.m_301669_());
            }
            return compoundTag;
        }
    }

    public static CompoundTag m_128928_(DataInput p_128929_) throws IOException {
        return NbtIo.m_128934_(p_128929_, NbtAccounter.m_301669_());
    }

    public static CompoundTag m_128934_(DataInput p_128935_, NbtAccounter p_128936_) throws IOException {
        Tag tag = NbtIo.m_128930_(p_128935_, p_128936_);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void m_128941_(CompoundTag p_128942_, DataOutput p_128943_) throws IOException {
        NbtIo.m_306638_(p_128942_, p_128943_);
    }

    public static void m_197509_(DataInput p_197510_, StreamTagVisitor p_197511_, NbtAccounter p_301755_) throws IOException {
        TagType<?> tagtype = TagTypes.m_129397_(p_197510_.readByte());
        if (tagtype == EndTag.f_128533_) {
            if (p_197511_.m_196213_(EndTag.f_128533_) == StreamTagVisitor.ValueResult.CONTINUE) {
                p_197511_.m_196525_();
            }
        } else {
            switch (p_197511_.m_196213_(tagtype)) {
                default: {
                    break;
                }
                case BREAK: {
                    StringTag.m_197563_(p_197510_);
                    tagtype.m_196189_(p_197510_, p_301755_);
                    break;
                }
                case CONTINUE: {
                    StringTag.m_197563_(p_197510_);
                    tagtype.m_196511_(p_197510_, p_197511_, p_301755_);
                }
            }
        }
    }

    public static Tag m_295332_(DataInput p_301023_, NbtAccounter p_299704_) throws IOException {
        byte b0 = p_301023_.readByte();
        return b0 == 0 ? EndTag.f_128534_ : NbtIo.m_292742_(p_301023_, p_299704_, b0);
    }

    public static void m_292740_(Tag p_300328_, DataOutput p_297970_) throws IOException {
        p_297970_.writeByte(p_300328_.m_7060_());
        if (p_300328_.m_7060_() != 0) {
            p_300328_.m_6434_(p_297970_);
        }
    }

    public static void m_128950_(Tag p_128951_, DataOutput p_128952_) throws IOException {
        p_128952_.writeByte(p_128951_.m_7060_());
        if (p_128951_.m_7060_() != 0) {
            p_128952_.writeUTF("");
            p_128951_.m_6434_(p_128952_);
        }
    }

    public static void m_306638_(Tag p_310490_, DataOutput p_311501_) throws IOException {
        NbtIo.m_128950_(p_310490_, new StringFallbackDataOutput(p_311501_));
    }

    private static Tag m_128930_(DataInput p_128931_, NbtAccounter p_128933_) throws IOException {
        byte b0 = p_128931_.readByte();
        p_128933_.m_263468_(1L);
        if (b0 == 0) {
            return EndTag.f_128534_;
        }
        p_128933_.readUTF(p_128931_.readUTF());
        p_128933_.m_263468_(4L);
        return NbtIo.m_292742_(p_128931_, p_128933_, b0);
    }

    private static Tag m_292742_(DataInput p_299672_, NbtAccounter p_299171_, byte p_300451_) {
        try {
            return TagTypes.m_129397_(p_300451_).m_7300_(p_299672_, p_299171_);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.m_127521_(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("NBT Tag");
            crashreportcategory.m_128159_("Tag type", p_300451_);
            throw new ReportedNbtException(crashreport);
        }
    }

    public static class StringFallbackDataOutput
    extends DelegateDataOutput {
        public StringFallbackDataOutput(DataOutput p_311190_) {
            super(p_311190_);
        }

        @Override
        public void writeUTF(String p_311566_) throws IOException {
            try {
                super.writeUTF(p_311566_);
            }
            catch (UTFDataFormatException utfdataformatexception) {
                Util.m_200890_("Failed to write NBT String", utfdataformatexception);
                super.writeUTF("");
            }
        }
    }
}

