/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.Deflater;
import net.minecraft.network.VarInt;
import net.minecraftforge.common.util.HexDumper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompressionEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final byte[] f_129444_ = new byte[8192];
    private final Deflater f_129445_;
    private int f_129446_;
    private static final boolean DISABLE_PACKET_DEBUG = Boolean.parseBoolean(System.getProperty("forge.disablePacketCompressionDebug", "false"));
    private static final Logger LOGGER = LogManager.getLogger();

    public CompressionEncoder(int p_129448_) {
        this.f_129446_ = p_129448_;
        this.f_129445_ = new Deflater();
    }

    protected void encode(ChannelHandlerContext p_129452_, ByteBuf p_129453_, ByteBuf p_129454_) {
        int i = p_129453_.readableBytes();
        if (i < this.f_129446_) {
            VarInt.m_293803_(p_129454_, 0);
            p_129454_.writeBytes(p_129453_);
        } else {
            if (!DISABLE_PACKET_DEBUG && i > 0x800000) {
                p_129453_.markReaderIndex();
                LOGGER.error("Attempted to send packet over maximum protocol size: {} > {}\nData:\n{}", (Object)i, (Object)0x800000, (Object)HexDumper.dump((ByteBuf)p_129453_));
                p_129453_.resetReaderIndex();
            }
            byte[] abyte = new byte[i];
            p_129453_.readBytes(abyte);
            VarInt.m_293803_(p_129454_, abyte.length);
            this.f_129445_.setInput(abyte, 0, i);
            this.f_129445_.finish();
            while (!this.f_129445_.finished()) {
                int j = this.f_129445_.deflate(this.f_129444_);
                p_129454_.writeBytes(this.f_129444_, 0, j);
            }
            this.f_129445_.reset();
        }
    }

    public int m_178298_() {
        return this.f_129446_;
    }

    public void m_129449_(int p_129450_) {
        this.f_129446_ = p_129450_;
    }
}

