/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FriendlyByteBuf
extends ByteBuf
implements IForgeFriendlyByteBuf {
    public static final int f_178337_ = 0x200000;
    private final ByteBuf f_130049_;
    public static final short f_178333_ = Short.MAX_VALUE;
    public static final int f_178334_ = 262144;
    private static final int f_236798_ = 256;
    private static final int f_236799_ = 256;
    private static final int f_236800_ = 512;
    private static final Gson f_271126_ = new Gson();

    public FriendlyByteBuf(ByteBuf p_130051_) {
        this.f_130049_ = p_130051_;
    }

    @Deprecated
    public <T> T m_293826_(DynamicOps<Tag> p_300704_, Codec<T> p_298353_) {
        return this.m_266466_(p_300704_, p_298353_, NbtAccounter.m_301669_());
    }

    @Deprecated
    public <T> T m_266466_(DynamicOps<Tag> p_266903_, Codec<T> p_267107_, NbtAccounter p_300072_) {
        Tag tag = this.m_130081_(p_300072_);
        return Util.m_260975_(p_267107_.parse(p_266903_, (Object)tag), p_261423_ -> new DecoderException("Failed to decode: " + p_261423_ + " " + tag));
    }

    @Deprecated
    public <T> FriendlyByteBuf m_266332_(DynamicOps<Tag> p_266702_, Codec<T> p_267245_, T p_266783_) {
        Tag tag = (Tag)Util.m_260975_(p_267245_.encodeStart(p_266702_, p_266783_), p_272384_ -> new EncoderException("Failed to encode: " + p_272384_ + " " + p_266783_));
        this.m_130079_(tag);
        return this;
    }

    public <T> T m_271872_(Codec<T> p_273318_) {
        JsonElement jsonelement = GsonHelper.m_13794_(f_271126_, this.m_130277_(), JsonElement.class);
        DataResult dataresult = p_273318_.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
        return Util.m_260975_(dataresult, p_272382_ -> new DecoderException("Failed to decode json: " + p_272382_));
    }

    public <T> void m_272073_(Codec<T> p_273285_, T p_272770_) {
        DataResult dataresult = p_273285_.encodeStart((DynamicOps)JsonOps.INSTANCE, p_272770_);
        this.m_130070_(f_271126_.toJson((JsonElement)Util.m_260975_(dataresult, p_261421_ -> new EncoderException("Failed to encode: " + p_261421_ + " " + p_272770_))));
    }

    public <T> void m_236818_(IdMap<T> p_236819_, T p_236820_) {
        int i = p_236819_.m_7447_(p_236820_);
        if (i == -1) {
            throw new IllegalArgumentException("Can't find id for '" + p_236820_ + "' in map " + p_236819_);
        }
        this.m_130130_(i);
    }

    public <T> void m_263218_(IdMap<Holder<T>> p_263337_, Holder<T> p_263384_, Writer<T> p_263358_) {
        switch (p_263384_.m_203376_()) {
            case REFERENCE: {
                int i = p_263337_.m_7447_(p_263384_);
                if (i == -1) {
                    throw new IllegalArgumentException("Can't find id for '" + p_263384_.m_203334_() + "' in map " + p_263337_);
                }
                this.m_130130_(i + 1);
                break;
            }
            case DIRECT: {
                this.m_130130_(0);
                p_263358_.accept(this, p_263384_.m_203334_());
            }
        }
    }

    @Nullable
    public <T> T m_236816_(IdMap<T> p_236817_) {
        int i = this.m_130242_();
        return p_236817_.m_7942_(i);
    }

    public <T> Holder<T> m_263187_(IdMap<Holder<T>> p_263401_, Reader<T> p_263374_) {
        int i = this.m_130242_();
        if (i == 0) {
            return Holder.m_205709_(p_263374_.apply(this));
        }
        Holder<T> holder = p_263401_.m_7942_(i - 1);
        if (holder == null) {
            throw new IllegalArgumentException("Can't find element with id " + i);
        }
        return holder;
    }

    public static <T> IntFunction<T> m_182695_(IntFunction<T> p_182696_, int p_182697_) {
        return p_182686_ -> {
            if (p_182686_ > p_182697_) {
                throw new DecoderException("Value " + p_182686_ + " is larger than limit " + p_182697_);
            }
            return p_182696_.apply(p_182686_);
        };
    }

    public <T, C extends Collection<T>> C m_236838_(IntFunction<C> p_236839_, Reader<T> p_236840_) {
        int i = this.m_130242_();
        Collection c = (Collection)p_236839_.apply(i);
        for (int j = 0; j < i; ++j) {
            c.add(p_236840_.apply(this));
        }
        return (C)c;
    }

    public <T> void m_236828_(Collection<T> p_236829_, Writer<T> p_236830_) {
        this.m_130130_(p_236829_.size());
        for (T t : p_236829_) {
            p_236830_.accept(this, t);
        }
    }

    public <T> List<T> m_236845_(Reader<T> p_236846_) {
        return this.m_236838_(Lists::newArrayListWithCapacity, p_236846_);
    }

    public IntList m_178338_() {
        int i = this.m_130242_();
        IntArrayList intlist = new IntArrayList();
        for (int j = 0; j < i; ++j) {
            intlist.add(this.m_130242_());
        }
        return intlist;
    }

    public void m_178345_(IntList p_178346_) {
        this.m_130130_(p_178346_.size());
        p_178346_.forEach(this::m_130130_);
    }

    public <K, V, M extends Map<K, V>> M m_236841_(IntFunction<M> p_236842_, Reader<K> p_236843_, Reader<V> p_236844_) {
        int i = this.m_130242_();
        Map m = (Map)p_236842_.apply(i);
        for (int j = 0; j < i; ++j) {
            Object k = p_236843_.apply((K)((Object)this));
            Object v = p_236844_.apply((V)((Object)this));
            m.put(k, v);
        }
        return (M)m;
    }

    public <K, V> Map<K, V> m_236847_(Reader<K> p_236848_, Reader<V> p_236849_) {
        return this.m_236841_(Maps::newHashMapWithExpectedSize, p_236848_, p_236849_);
    }

    public <K, V> void m_236831_(Map<K, V> p_236832_, Writer<K> p_236833_, Writer<V> p_236834_) {
        this.m_130130_(p_236832_.size());
        p_236832_.forEach((p_236856_, p_236857_) -> {
            p_236833_.accept((Object)((Object)this), p_236856_);
            p_236834_.accept((Object)((Object)this), p_236857_);
        });
    }

    public void m_178364_(Consumer<FriendlyByteBuf> p_178365_) {
        int i = this.m_130242_();
        for (int j = 0; j < i; ++j) {
            p_178365_.accept(this);
        }
    }

    public <E extends Enum<E>> void m_245616_(EnumSet<E> p_250400_, Class<E> p_250673_) {
        Enum[] ae = (Enum[])p_250673_.getEnumConstants();
        BitSet bitset = new BitSet(ae.length);
        for (int i = 0; i < ae.length; ++i) {
            bitset.set(i, p_250400_.contains(ae[i]));
        }
        this.m_246901_(bitset, ae.length);
    }

    public <E extends Enum<E>> EnumSet<E> m_247336_(Class<E> p_251289_) {
        Enum[] ae = (Enum[])p_251289_.getEnumConstants();
        BitSet bitset = this.m_247358_(ae.length);
        EnumSet<Enum> enumset = EnumSet.noneOf(p_251289_);
        for (int i = 0; i < ae.length; ++i) {
            if (!bitset.get(i)) continue;
            enumset.add(ae[i]);
        }
        return enumset;
    }

    public <T> void m_236835_(Optional<T> p_236836_, Writer<T> p_236837_) {
        if (p_236836_.isPresent()) {
            this.writeBoolean(true);
            p_236837_.accept(this, p_236836_.get());
        } else {
            this.writeBoolean(false);
        }
    }

    public <T> Optional<T> m_236860_(Reader<T> p_236861_) {
        return this.readBoolean() ? Optional.of(p_236861_.apply(this)) : Optional.empty();
    }

    @Nullable
    public <T> T m_236868_(Reader<T> p_236869_) {
        return this.readBoolean() ? (T)p_236869_.apply(this) : null;
    }

    public <T> void m_236821_(@Nullable T p_236822_, Writer<T> p_236823_) {
        if (p_236822_ != null) {
            this.writeBoolean(true);
            p_236823_.accept(this, p_236822_);
        } else {
            this.writeBoolean(false);
        }
    }

    public <L, R> void m_236810_(Either<L, R> p_236811_, Writer<L> p_236812_, Writer<R> p_236813_) {
        p_236811_.ifLeft(p_296387_ -> {
            this.writeBoolean(true);
            p_236812_.accept((Object)((Object)this), p_296387_);
        }).ifRight(p_296383_ -> {
            this.writeBoolean(false);
            p_236813_.accept((Object)((Object)this), p_296383_);
        });
    }

    public <L, R> Either<L, R> m_236862_(Reader<L> p_236863_, Reader<R> p_236864_) {
        return this.readBoolean() ? Either.left(p_236863_.apply((L)((Object)this))) : Either.right(p_236864_.apply((R)((Object)this)));
    }

    public byte[] m_130052_() {
        return this.m_130101_(this.readableBytes());
    }

    public FriendlyByteBuf m_130087_(byte[] p_130088_) {
        this.m_130130_(p_130088_.length);
        this.writeBytes(p_130088_);
        return this;
    }

    public byte[] m_130101_(int p_130102_) {
        int i = this.m_130242_();
        if (i > p_130102_) {
            throw new DecoderException("ByteArray with size " + i + " is bigger than allowed " + p_130102_);
        }
        byte[] abyte = new byte[i];
        this.readBytes(abyte);
        return abyte;
    }

    public FriendlyByteBuf m_130089_(int[] p_130090_) {
        this.m_130130_(p_130090_.length);
        for (int i : p_130090_) {
            this.m_130130_(i);
        }
        return this;
    }

    public int[] m_130100_() {
        return this.m_130116_(this.readableBytes());
    }

    public int[] m_130116_(int p_130117_) {
        int i = this.m_130242_();
        if (i > p_130117_) {
            throw new DecoderException("VarIntArray with size " + i + " is bigger than allowed " + p_130117_);
        }
        int[] aint = new int[i];
        for (int j = 0; j < aint.length; ++j) {
            aint[j] = this.m_130242_();
        }
        return aint;
    }

    public FriendlyByteBuf m_130091_(long[] p_130092_) {
        this.m_130130_(p_130092_.length);
        for (long i : p_130092_) {
            this.writeLong(i);
        }
        return this;
    }

    public long[] m_178381_() {
        return this.m_130105_(null);
    }

    public long[] m_130105_(@Nullable long[] p_130106_) {
        return this.m_130093_(p_130106_, this.readableBytes() / 8);
    }

    public long[] m_130093_(@Nullable long[] p_130094_, int p_130095_) {
        int i = this.m_130242_();
        if (p_130094_ == null || p_130094_.length != i) {
            if (i > p_130095_) {
                throw new DecoderException("LongArray with size " + i + " is bigger than allowed " + p_130095_);
            }
            p_130094_ = new long[i];
        }
        for (int j = 0; j < p_130094_.length; ++j) {
            p_130094_[j] = this.readLong();
        }
        return p_130094_;
    }

    public BlockPos m_130135_() {
        return BlockPos.m_122022_(this.readLong());
    }

    public FriendlyByteBuf m_130064_(BlockPos p_130065_) {
        this.writeLong(p_130065_.m_121878_());
        return this;
    }

    public ChunkPos m_178383_() {
        return new ChunkPos(this.readLong());
    }

    public FriendlyByteBuf m_178341_(ChunkPos p_178342_) {
        this.writeLong(p_178342_.m_45588_());
        return this;
    }

    public SectionPos m_130157_() {
        return SectionPos.m_123184_(this.readLong());
    }

    public FriendlyByteBuf m_178343_(SectionPos p_178344_) {
        this.writeLong(p_178344_.m_123252_());
        return this;
    }

    public GlobalPos m_236872_() {
        ResourceKey<Level> resourcekey = this.m_236801_(Registries.f_256858_);
        BlockPos blockpos = this.m_130135_();
        return GlobalPos.m_122643_(resourcekey, blockpos);
    }

    public void m_236814_(GlobalPos p_236815_) {
        this.m_236858_(p_236815_.m_122640_());
        this.m_130064_(p_236815_.m_122646_());
    }

    public Vector3f m_269394_() {
        return new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
    }

    public void m_269582_(Vector3f p_270985_) {
        this.writeFloat(p_270985_.x());
        this.writeFloat(p_270985_.y());
        this.writeFloat(p_270985_.z());
    }

    public Quaternionf m_269131_() {
        return new Quaternionf(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat());
    }

    public void m_269101_(Quaternionf p_270141_) {
        this.writeFloat(p_270141_.x);
        this.writeFloat(p_270141_.y);
        this.writeFloat(p_270141_.z);
        this.writeFloat(p_270141_.w);
    }

    public Vec3 m_295597_() {
        return new Vec3(this.readDouble(), this.readDouble(), this.readDouble());
    }

    public void m_295412_(Vec3 p_300768_) {
        this.writeDouble(p_300768_.m_7096_());
        this.writeDouble(p_300768_.m_7098_());
        this.writeDouble(p_300768_.m_7094_());
    }

    public Component m_130238_() {
        return this.m_266466_(NbtOps.f_128958_, ComponentSerialization.f_303288_, NbtAccounter.m_301677_(0x200000L));
    }

    public Component m_305450_() {
        return this.m_293826_(NbtOps.f_128958_, ComponentSerialization.f_303288_);
    }

    public FriendlyByteBuf m_130083_(Component p_130084_) {
        return this.m_266332_(NbtOps.f_128958_, ComponentSerialization.f_303288_, p_130084_);
    }

    public <T extends Enum<T>> T m_130066_(Class<T> p_130067_) {
        return (T)((Enum[])p_130067_.getEnumConstants())[this.m_130242_()];
    }

    public FriendlyByteBuf m_130068_(Enum<?> p_130069_) {
        return this.m_130130_(p_130069_.ordinal());
    }

    public <T> T m_293355_(IntFunction<T> p_300981_) {
        int i = this.m_130242_();
        return p_300981_.apply(i);
    }

    public <T> FriendlyByteBuf m_293228_(ToIntFunction<T> p_297872_, T p_300123_) {
        int i = p_297872_.applyAsInt(p_300123_);
        return this.m_130130_(i);
    }

    public int m_130242_() {
        return VarInt.m_293637_(this.f_130049_);
    }

    public long m_130258_() {
        return VarLong.m_295135_(this.f_130049_);
    }

    public FriendlyByteBuf m_130077_(UUID p_130078_) {
        this.writeLong(p_130078_.getMostSignificantBits());
        this.writeLong(p_130078_.getLeastSignificantBits());
        return this;
    }

    public UUID m_130259_() {
        return new UUID(this.readLong(), this.readLong());
    }

    public FriendlyByteBuf m_130130_(int p_130131_) {
        VarInt.m_293803_(this.f_130049_, p_130131_);
        return this;
    }

    public FriendlyByteBuf m_130103_(long p_130104_) {
        VarLong.m_293521_(this.f_130049_, p_130104_);
        return this;
    }

    public FriendlyByteBuf m_130079_(@Nullable Tag p_300580_) {
        if (p_300580_ == null) {
            p_300580_ = EndTag.f_128534_;
        }
        try {
            NbtIo.m_292740_(p_300580_, (DataOutput)new ByteBufOutputStream((ByteBuf)this));
            return this;
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    @Nullable
    public CompoundTag m_130260_() {
        Tag tag = this.m_130081_(NbtAccounter.m_301677_(0x200000L));
        if (tag != null && !(tag instanceof CompoundTag)) {
            throw new DecoderException("Not a compound tag: " + tag);
        }
        return (CompoundTag)tag;
    }

    @Nullable
    public Tag m_130081_(NbtAccounter p_130082_) {
        try {
            Tag tag = NbtIo.m_295332_((DataInput)new ByteBufInputStream((ByteBuf)this), p_130082_);
            return tag.m_7060_() == 0 ? null : tag;
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public FriendlyByteBuf m_130055_(ItemStack p_130056_) {
        return this.writeItemStack(p_130056_, true);
    }

    public FriendlyByteBuf writeItemStack(ItemStack p_130056_, boolean limitedTag) {
        if (p_130056_.m_41619_()) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            Item item = p_130056_.m_41720_();
            this.m_236818_(BuiltInRegistries.f_257033_, item);
            this.writeByte(p_130056_.m_41613_());
            CompoundTag compoundtag = null;
            if (item.isDamageable(p_130056_) || item.m_41468_()) {
                compoundtag = limitedTag ? p_130056_.getShareTag() : p_130056_.m_41783_();
            }
            this.m_130079_(compoundtag);
        }
        return this;
    }

    public ItemStack m_130267_() {
        if (!this.readBoolean()) {
            return ItemStack.f_41583_;
        }
        Item item = this.m_236816_(BuiltInRegistries.f_257033_);
        byte i = this.readByte();
        ItemStack itemstack = new ItemStack(item, (int)i);
        itemstack.readShareTag(this.m_130260_());
        return itemstack;
    }

    public String m_130277_() {
        return this.m_130136_(Short.MAX_VALUE);
    }

    public String m_130136_(int p_130137_) {
        return Utf8String.m_294133_(this.f_130049_, p_130137_);
    }

    public FriendlyByteBuf m_130070_(String p_130071_) {
        return this.m_130072_(p_130071_, Short.MAX_VALUE);
    }

    public FriendlyByteBuf m_130072_(String p_130073_, int p_130074_) {
        Utf8String.m_295405_(this.f_130049_, p_130073_, p_130074_);
        return this;
    }

    public ResourceLocation m_130281_() {
        return new ResourceLocation(this.m_130136_(Short.MAX_VALUE));
    }

    public FriendlyByteBuf m_130085_(ResourceLocation p_130086_) {
        this.m_130070_(p_130086_.toString());
        return this;
    }

    public <T> ResourceKey<T> m_236801_(ResourceKey<? extends Registry<T>> p_236802_) {
        ResourceLocation resourcelocation = this.m_130281_();
        return ResourceKey.m_135785_(p_236802_, resourcelocation);
    }

    public void m_236858_(ResourceKey<?> p_236859_) {
        this.m_130085_(p_236859_.m_135782_());
    }

    public <T> ResourceKey<? extends Registry<T>> m_294064_() {
        ResourceLocation resourcelocation = this.m_130281_();
        return ResourceKey.m_135788_(resourcelocation);
    }

    public Date m_130282_() {
        return new Date(this.readLong());
    }

    public FriendlyByteBuf m_130075_(Date p_130076_) {
        this.writeLong(p_130076_.getTime());
        return this;
    }

    public Instant m_236873_() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void m_236826_(Instant p_236827_) {
        this.writeLong(p_236827_.toEpochMilli());
    }

    public PublicKey m_236874_() {
        try {
            return Crypt.m_13600_(this.m_130101_(512));
        }
        catch (CryptException cryptexception) {
            throw new DecoderException("Malformed public key bytes", (Throwable)cryptexception);
        }
    }

    public FriendlyByteBuf m_236824_(PublicKey p_236825_) {
        this.m_130087_(p_236825_.getEncoded());
        return this;
    }

    public BlockHitResult m_130283_() {
        BlockPos blockpos = this.m_130135_();
        Direction direction = this.m_130066_(Direction.class);
        float f = this.readFloat();
        float f1 = this.readFloat();
        float f2 = this.readFloat();
        boolean flag = this.readBoolean();
        return new BlockHitResult(new Vec3((double)blockpos.m_123341_() + (double)f, (double)blockpos.m_123342_() + (double)f1, (double)blockpos.m_123343_() + (double)f2), direction, blockpos, flag);
    }

    public void m_130062_(BlockHitResult p_130063_) {
        BlockPos blockpos = p_130063_.m_82425_();
        this.m_130064_(blockpos);
        this.m_130068_(p_130063_.m_82434_());
        Vec3 vec3 = p_130063_.m_82450_();
        this.writeFloat((float)(vec3.f_82479_ - (double)blockpos.m_123341_()));
        this.writeFloat((float)(vec3.f_82480_ - (double)blockpos.m_123342_()));
        this.writeFloat((float)(vec3.f_82481_ - (double)blockpos.m_123343_()));
        this.writeBoolean(p_130063_.m_82436_());
    }

    public BitSet m_178384_() {
        return BitSet.valueOf(this.m_178381_());
    }

    public void m_178350_(BitSet p_178351_) {
        this.m_130091_(p_178351_.toLongArray());
    }

    public BitSet m_247358_(int p_249113_) {
        byte[] abyte = new byte[Mth.m_184652_(p_249113_, 8)];
        this.readBytes(abyte);
        return BitSet.valueOf(abyte);
    }

    public void m_246901_(BitSet p_248698_, int p_248869_) {
        if (p_248698_.length() > p_248869_) {
            throw new EncoderException("BitSet is larger than expected size (" + p_248698_.length() + ">" + p_248869_ + ")");
        }
        byte[] abyte = p_248698_.toByteArray();
        this.writeBytes(Arrays.copyOf(abyte, Mth.m_184652_(p_248869_, 8)));
    }

    public GameProfile m_236875_() {
        UUID uuid = this.m_130259_();
        String s = this.m_130136_(16);
        GameProfile gameprofile = new GameProfile(uuid, s);
        gameprofile.getProperties().putAll((Multimap)this.m_246981_());
        return gameprofile;
    }

    public void m_236803_(GameProfile p_236804_) {
        this.m_130077_(p_236804_.getId());
        this.m_130070_(p_236804_.getName());
        this.m_246636_(p_236804_.getProperties());
    }

    public PropertyMap m_246981_() {
        PropertyMap propertymap = new PropertyMap();
        this.m_178364_(p_296385_ -> {
            Property property = this.m_236876_();
            propertymap.put((Object)property.name(), (Object)property);
        });
        return propertymap;
    }

    public void m_246636_(PropertyMap p_248638_) {
        this.m_236828_(p_248638_.values(), FriendlyByteBuf::m_236805_);
    }

    public Property m_236876_() {
        String s = this.m_130277_();
        String s1 = this.m_130277_();
        String s2 = (String)this.m_236868_(FriendlyByteBuf::m_130277_);
        return new Property(s, s1, s2);
    }

    public void m_236805_(Property p_236806_) {
        this.m_130070_(p_236806_.name());
        this.m_130070_(p_236806_.value());
        this.m_236821_(p_236806_.signature(), FriendlyByteBuf::m_130070_);
    }

    public boolean isContiguous() {
        return this.f_130049_.isContiguous();
    }

    public int maxFastWritableBytes() {
        return this.f_130049_.maxFastWritableBytes();
    }

    public int capacity() {
        return this.f_130049_.capacity();
    }

    public FriendlyByteBuf capacity(int p_300133_) {
        this.f_130049_.capacity(p_300133_);
        return this;
    }

    public int maxCapacity() {
        return this.f_130049_.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.f_130049_.alloc();
    }

    public ByteOrder order() {
        return this.f_130049_.order();
    }

    public ByteBuf order(ByteOrder p_130280_) {
        return this.f_130049_.order(p_130280_);
    }

    public ByteBuf unwrap() {
        return this.f_130049_;
    }

    public boolean isDirect() {
        return this.f_130049_.isDirect();
    }

    public boolean isReadOnly() {
        return this.f_130049_.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.f_130049_.asReadOnly();
    }

    public int readerIndex() {
        return this.f_130049_.readerIndex();
    }

    public FriendlyByteBuf readerIndex(int p_300300_) {
        this.f_130049_.readerIndex(p_300300_);
        return this;
    }

    public int writerIndex() {
        return this.f_130049_.writerIndex();
    }

    public FriendlyByteBuf writerIndex(int p_298940_) {
        this.f_130049_.writerIndex(p_298940_);
        return this;
    }

    public FriendlyByteBuf setIndex(int p_298280_, int p_301012_) {
        this.f_130049_.setIndex(p_298280_, p_301012_);
        return this;
    }

    public int readableBytes() {
        return this.f_130049_.readableBytes();
    }

    public int writableBytes() {
        return this.f_130049_.writableBytes();
    }

    public int maxWritableBytes() {
        return this.f_130049_.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.f_130049_.isReadable();
    }

    public boolean isReadable(int p_130254_) {
        return this.f_130049_.isReadable(p_130254_);
    }

    public boolean isWritable() {
        return this.f_130049_.isWritable();
    }

    public boolean isWritable(int p_130257_) {
        return this.f_130049_.isWritable(p_130257_);
    }

    public FriendlyByteBuf clear() {
        this.f_130049_.clear();
        return this;
    }

    public FriendlyByteBuf markReaderIndex() {
        this.f_130049_.markReaderIndex();
        return this;
    }

    public FriendlyByteBuf resetReaderIndex() {
        this.f_130049_.resetReaderIndex();
        return this;
    }

    public FriendlyByteBuf markWriterIndex() {
        this.f_130049_.markWriterIndex();
        return this;
    }

    public FriendlyByteBuf resetWriterIndex() {
        this.f_130049_.resetWriterIndex();
        return this;
    }

    public FriendlyByteBuf discardReadBytes() {
        this.f_130049_.discardReadBytes();
        return this;
    }

    public FriendlyByteBuf discardSomeReadBytes() {
        this.f_130049_.discardSomeReadBytes();
        return this;
    }

    public FriendlyByteBuf ensureWritable(int p_301044_) {
        this.f_130049_.ensureWritable(p_301044_);
        return this;
    }

    public int ensureWritable(int p_130141_, boolean p_130142_) {
        return this.f_130049_.ensureWritable(p_130141_, p_130142_);
    }

    public boolean getBoolean(int p_130159_) {
        return this.f_130049_.getBoolean(p_130159_);
    }

    public byte getByte(int p_130161_) {
        return this.f_130049_.getByte(p_130161_);
    }

    public short getUnsignedByte(int p_130225_) {
        return this.f_130049_.getUnsignedByte(p_130225_);
    }

    public short getShort(int p_130221_) {
        return this.f_130049_.getShort(p_130221_);
    }

    public short getShortLE(int p_130223_) {
        return this.f_130049_.getShortLE(p_130223_);
    }

    public int getUnsignedShort(int p_130235_) {
        return this.f_130049_.getUnsignedShort(p_130235_);
    }

    public int getUnsignedShortLE(int p_130237_) {
        return this.f_130049_.getUnsignedShortLE(p_130237_);
    }

    public int getMedium(int p_130217_) {
        return this.f_130049_.getMedium(p_130217_);
    }

    public int getMediumLE(int p_130219_) {
        return this.f_130049_.getMediumLE(p_130219_);
    }

    public int getUnsignedMedium(int p_130231_) {
        return this.f_130049_.getUnsignedMedium(p_130231_);
    }

    public int getUnsignedMediumLE(int p_130233_) {
        return this.f_130049_.getUnsignedMediumLE(p_130233_);
    }

    public int getInt(int p_130209_) {
        return this.f_130049_.getInt(p_130209_);
    }

    public int getIntLE(int p_130211_) {
        return this.f_130049_.getIntLE(p_130211_);
    }

    public long getUnsignedInt(int p_130227_) {
        return this.f_130049_.getUnsignedInt(p_130227_);
    }

    public long getUnsignedIntLE(int p_130229_) {
        return this.f_130049_.getUnsignedIntLE(p_130229_);
    }

    public long getLong(int p_130213_) {
        return this.f_130049_.getLong(p_130213_);
    }

    public long getLongLE(int p_130215_) {
        return this.f_130049_.getLongLE(p_130215_);
    }

    public char getChar(int p_130199_) {
        return this.f_130049_.getChar(p_130199_);
    }

    public float getFloat(int p_130207_) {
        return this.f_130049_.getFloat(p_130207_);
    }

    public double getDouble(int p_130205_) {
        return this.f_130049_.getDouble(p_130205_);
    }

    public FriendlyByteBuf getBytes(int p_299985_, ByteBuf p_298214_) {
        this.f_130049_.getBytes(p_299985_, p_298214_);
        return this;
    }

    public FriendlyByteBuf getBytes(int p_300246_, ByteBuf p_301111_, int p_300978_) {
        this.f_130049_.getBytes(p_300246_, p_301111_, p_300978_);
        return this;
    }

    public FriendlyByteBuf getBytes(int p_300430_, ByteBuf p_297846_, int p_300610_, int p_299363_) {
        this.f_130049_.getBytes(p_300430_, p_297846_, p_300610_, p_299363_);
        return this;
    }

    public FriendlyByteBuf getBytes(int p_300928_, byte[] p_297630_) {
        this.f_130049_.getBytes(p_300928_, p_297630_);
        return this;
    }

    public FriendlyByteBuf getBytes(int p_299455_, byte[] p_300069_, int p_300847_, int p_299513_) {
        this.f_130049_.getBytes(p_299455_, p_300069_, p_300847_, p_299513_);
        return this;
    }

    public FriendlyByteBuf getBytes(int p_299731_, ByteBuffer p_299164_) {
        this.f_130049_.getBytes(p_299731_, p_299164_);
        return this;
    }

    public FriendlyByteBuf getBytes(int p_298241_, OutputStream p_301151_, int p_299913_) throws IOException {
        this.f_130049_.getBytes(p_298241_, p_301151_, p_299913_);
        return this;
    }

    public int getBytes(int p_130187_, GatheringByteChannel p_130188_, int p_130189_) throws IOException {
        return this.f_130049_.getBytes(p_130187_, p_130188_, p_130189_);
    }

    public int getBytes(int p_130182_, FileChannel p_130183_, long p_130184_, int p_130185_) throws IOException {
        return this.f_130049_.getBytes(p_130182_, p_130183_, p_130184_, p_130185_);
    }

    public CharSequence getCharSequence(int p_130201_, int p_130202_, Charset p_130203_) {
        return this.f_130049_.getCharSequence(p_130201_, p_130202_, p_130203_);
    }

    public FriendlyByteBuf setBoolean(int p_299892_, boolean p_297333_) {
        this.f_130049_.setBoolean(p_299892_, p_297333_);
        return this;
    }

    public FriendlyByteBuf setByte(int p_297325_, int p_300406_) {
        this.f_130049_.setByte(p_297325_, p_300406_);
        return this;
    }

    public FriendlyByteBuf setShort(int p_297216_, int p_298749_) {
        this.f_130049_.setShort(p_297216_, p_298749_);
        return this;
    }

    public FriendlyByteBuf setShortLE(int p_299646_, int p_298038_) {
        this.f_130049_.setShortLE(p_299646_, p_298038_);
        return this;
    }

    public FriendlyByteBuf setMedium(int p_300490_, int p_299067_) {
        this.f_130049_.setMedium(p_300490_, p_299067_);
        return this;
    }

    public FriendlyByteBuf setMediumLE(int p_300630_, int p_299351_) {
        this.f_130049_.setMediumLE(p_300630_, p_299351_);
        return this;
    }

    public FriendlyByteBuf setInt(int p_299176_, int p_301413_) {
        this.f_130049_.setInt(p_299176_, p_301413_);
        return this;
    }

    public FriendlyByteBuf setIntLE(int p_300111_, int p_297978_) {
        this.f_130049_.setIntLE(p_300111_, p_297978_);
        return this;
    }

    public FriendlyByteBuf setLong(int p_298039_, long p_298360_) {
        this.f_130049_.setLong(p_298039_, p_298360_);
        return this;
    }

    public FriendlyByteBuf setLongLE(int p_300929_, long p_299282_) {
        this.f_130049_.setLongLE(p_300929_, p_299282_);
        return this;
    }

    public FriendlyByteBuf setChar(int p_297413_, int p_297953_) {
        this.f_130049_.setChar(p_297413_, p_297953_);
        return this;
    }

    public FriendlyByteBuf setFloat(int p_297779_, float p_297840_) {
        this.f_130049_.setFloat(p_297779_, p_297840_);
        return this;
    }

    public FriendlyByteBuf setDouble(int p_301027_, double p_299551_) {
        this.f_130049_.setDouble(p_301027_, p_299551_);
        return this;
    }

    public FriendlyByteBuf setBytes(int p_300769_, ByteBuf p_301342_) {
        this.f_130049_.setBytes(p_300769_, p_301342_);
        return this;
    }

    public FriendlyByteBuf setBytes(int p_300924_, ByteBuf p_301233_, int p_299359_) {
        this.f_130049_.setBytes(p_300924_, p_301233_, p_299359_);
        return this;
    }

    public FriendlyByteBuf setBytes(int p_299338_, ByteBuf p_299810_, int p_301059_, int p_297827_) {
        this.f_130049_.setBytes(p_299338_, p_299810_, p_301059_, p_297827_);
        return this;
    }

    public FriendlyByteBuf setBytes(int p_297553_, byte[] p_300329_) {
        this.f_130049_.setBytes(p_297553_, p_300329_);
        return this;
    }

    public FriendlyByteBuf setBytes(int p_297451_, byte[] p_300466_, int p_297825_, int p_299499_) {
        this.f_130049_.setBytes(p_297451_, p_300466_, p_297825_, p_299499_);
        return this;
    }

    public FriendlyByteBuf setBytes(int p_297596_, ByteBuffer p_299096_) {
        this.f_130049_.setBytes(p_297596_, p_299096_);
        return this;
    }

    public int setBytes(int p_130380_, InputStream p_130381_, int p_130382_) throws IOException {
        return this.f_130049_.setBytes(p_130380_, p_130381_, p_130382_);
    }

    public int setBytes(int p_130392_, ScatteringByteChannel p_130393_, int p_130394_) throws IOException {
        return this.f_130049_.setBytes(p_130392_, p_130393_, p_130394_);
    }

    public int setBytes(int p_130387_, FileChannel p_130388_, long p_130389_, int p_130390_) throws IOException {
        return this.f_130049_.setBytes(p_130387_, p_130388_, p_130389_, p_130390_);
    }

    public FriendlyByteBuf setZero(int p_297586_, int p_299960_) {
        this.f_130049_.setZero(p_297586_, p_299960_);
        return this;
    }

    public int setCharSequence(int p_130407_, CharSequence p_130408_, Charset p_130409_) {
        return this.f_130049_.setCharSequence(p_130407_, p_130408_, p_130409_);
    }

    public boolean readBoolean() {
        return this.f_130049_.readBoolean();
    }

    public byte readByte() {
        return this.f_130049_.readByte();
    }

    public short readUnsignedByte() {
        return this.f_130049_.readUnsignedByte();
    }

    public short readShort() {
        return this.f_130049_.readShort();
    }

    public short readShortLE() {
        return this.f_130049_.readShortLE();
    }

    public int readUnsignedShort() {
        return this.f_130049_.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.f_130049_.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.f_130049_.readMedium();
    }

    public int readMediumLE() {
        return this.f_130049_.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.f_130049_.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.f_130049_.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.f_130049_.readInt();
    }

    public int readIntLE() {
        return this.f_130049_.readIntLE();
    }

    public long readUnsignedInt() {
        return this.f_130049_.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.f_130049_.readUnsignedIntLE();
    }

    public long readLong() {
        return this.f_130049_.readLong();
    }

    public long readLongLE() {
        return this.f_130049_.readLongLE();
    }

    public char readChar() {
        return this.f_130049_.readChar();
    }

    public float readFloat() {
        return this.f_130049_.readFloat();
    }

    public double readDouble() {
        return this.f_130049_.readDouble();
    }

    public ByteBuf readBytes(int p_130287_) {
        return this.f_130049_.readBytes(p_130287_);
    }

    public ByteBuf readSlice(int p_130332_) {
        return this.f_130049_.readSlice(p_130332_);
    }

    public ByteBuf readRetainedSlice(int p_130328_) {
        return this.f_130049_.readRetainedSlice(p_130328_);
    }

    public FriendlyByteBuf readBytes(ByteBuf p_300560_) {
        this.f_130049_.readBytes(p_300560_);
        return this;
    }

    public FriendlyByteBuf readBytes(ByteBuf p_299224_, int p_300166_) {
        this.f_130049_.readBytes(p_299224_, p_300166_);
        return this;
    }

    public FriendlyByteBuf readBytes(ByteBuf p_301382_, int p_300030_, int p_300211_) {
        this.f_130049_.readBytes(p_301382_, p_300030_, p_300211_);
        return this;
    }

    public FriendlyByteBuf readBytes(byte[] p_299454_) {
        this.f_130049_.readBytes(p_299454_);
        return this;
    }

    public FriendlyByteBuf readBytes(byte[] p_299845_, int p_297363_, int p_299384_) {
        this.f_130049_.readBytes(p_299845_, p_297363_, p_299384_);
        return this;
    }

    public FriendlyByteBuf readBytes(ByteBuffer p_297688_) {
        this.f_130049_.readBytes(p_297688_);
        return this;
    }

    public FriendlyByteBuf readBytes(OutputStream p_300218_, int p_298001_) throws IOException {
        this.f_130049_.readBytes(p_300218_, p_298001_);
        return this;
    }

    public int readBytes(GatheringByteChannel p_130307_, int p_130308_) throws IOException {
        return this.f_130049_.readBytes(p_130307_, p_130308_);
    }

    public CharSequence readCharSequence(int p_130317_, Charset p_130318_) {
        return this.f_130049_.readCharSequence(p_130317_, p_130318_);
    }

    public int readBytes(FileChannel p_130303_, long p_130304_, int p_130305_) throws IOException {
        return this.f_130049_.readBytes(p_130303_, p_130304_, p_130305_);
    }

    public FriendlyByteBuf skipBytes(int p_300784_) {
        this.f_130049_.skipBytes(p_300784_);
        return this;
    }

    public FriendlyByteBuf writeBoolean(boolean p_300653_) {
        this.f_130049_.writeBoolean(p_300653_);
        return this;
    }

    public FriendlyByteBuf writeByte(int p_299498_) {
        this.f_130049_.writeByte(p_299498_);
        return this;
    }

    public FriendlyByteBuf writeShort(int p_299519_) {
        this.f_130049_.writeShort(p_299519_);
        return this;
    }

    public FriendlyByteBuf writeShortLE(int p_297214_) {
        this.f_130049_.writeShortLE(p_297214_);
        return this;
    }

    public FriendlyByteBuf writeMedium(int p_299802_) {
        this.f_130049_.writeMedium(p_299802_);
        return this;
    }

    public FriendlyByteBuf writeMediumLE(int p_301291_) {
        this.f_130049_.writeMediumLE(p_301291_);
        return this;
    }

    public FriendlyByteBuf writeInt(int p_301066_) {
        this.f_130049_.writeInt(p_301066_);
        return this;
    }

    public FriendlyByteBuf writeIntLE(int p_299068_) {
        this.f_130049_.writeIntLE(p_299068_);
        return this;
    }

    public FriendlyByteBuf writeLong(long p_300584_) {
        this.f_130049_.writeLong(p_300584_);
        return this;
    }

    public FriendlyByteBuf writeLongLE(long p_298747_) {
        this.f_130049_.writeLongLE(p_298747_);
        return this;
    }

    public FriendlyByteBuf writeChar(int p_300374_) {
        this.f_130049_.writeChar(p_300374_);
        return this;
    }

    public FriendlyByteBuf writeFloat(float p_299476_) {
        this.f_130049_.writeFloat(p_299476_);
        return this;
    }

    public FriendlyByteBuf writeDouble(double p_301246_) {
        this.f_130049_.writeDouble(p_301246_);
        return this;
    }

    public FriendlyByteBuf writeBytes(ByteBuf p_300943_) {
        this.f_130049_.writeBytes(p_300943_);
        return this;
    }

    public FriendlyByteBuf writeBytes(ByteBuf p_298105_, int p_299600_) {
        this.f_130049_.writeBytes(p_298105_, p_299600_);
        return this;
    }

    public FriendlyByteBuf writeBytes(ByteBuf p_299075_, int p_301207_, int p_299710_) {
        this.f_130049_.writeBytes(p_299075_, p_301207_, p_299710_);
        return this;
    }

    public FriendlyByteBuf writeBytes(byte[] p_299214_) {
        this.f_130049_.writeBytes(p_299214_);
        return this;
    }

    public FriendlyByteBuf writeBytes(byte[] p_298410_, int p_297608_, int p_300690_) {
        this.f_130049_.writeBytes(p_298410_, p_297608_, p_300690_);
        return this;
    }

    public FriendlyByteBuf writeBytes(ByteBuffer p_300889_) {
        this.f_130049_.writeBytes(p_300889_);
        return this;
    }

    public int writeBytes(InputStream p_130481_, int p_130482_) throws IOException {
        return this.f_130049_.writeBytes(p_130481_, p_130482_);
    }

    public int writeBytes(ScatteringByteChannel p_130490_, int p_130491_) throws IOException {
        return this.f_130049_.writeBytes(p_130490_, p_130491_);
    }

    public int writeBytes(FileChannel p_130486_, long p_130487_, int p_130488_) throws IOException {
        return this.f_130049_.writeBytes(p_130486_, p_130487_, p_130488_);
    }

    public FriendlyByteBuf writeZero(int p_298160_) {
        this.f_130049_.writeZero(p_298160_);
        return this;
    }

    public int writeCharSequence(CharSequence p_130501_, Charset p_130502_) {
        return this.f_130049_.writeCharSequence(p_130501_, p_130502_);
    }

    public int indexOf(int p_130244_, int p_130245_, byte p_130246_) {
        return this.f_130049_.indexOf(p_130244_, p_130245_, p_130246_);
    }

    public int bytesBefore(byte p_130108_) {
        return this.f_130049_.bytesBefore(p_130108_);
    }

    public int bytesBefore(int p_130110_, byte p_130111_) {
        return this.f_130049_.bytesBefore(p_130110_, p_130111_);
    }

    public int bytesBefore(int p_130113_, int p_130114_, byte p_130115_) {
        return this.f_130049_.bytesBefore(p_130113_, p_130114_, p_130115_);
    }

    public int forEachByte(ByteProcessor p_130150_) {
        return this.f_130049_.forEachByte(p_130150_);
    }

    public int forEachByte(int p_130146_, int p_130147_, ByteProcessor p_130148_) {
        return this.f_130049_.forEachByte(p_130146_, p_130147_, p_130148_);
    }

    public int forEachByteDesc(ByteProcessor p_130156_) {
        return this.f_130049_.forEachByteDesc(p_130156_);
    }

    public int forEachByteDesc(int p_130152_, int p_130153_, ByteProcessor p_130154_) {
        return this.f_130049_.forEachByteDesc(p_130152_, p_130153_, p_130154_);
    }

    public ByteBuf copy() {
        return this.f_130049_.copy();
    }

    public ByteBuf copy(int p_130128_, int p_130129_) {
        return this.f_130049_.copy(p_130128_, p_130129_);
    }

    public ByteBuf slice() {
        return this.f_130049_.slice();
    }

    public ByteBuf retainedSlice() {
        return this.f_130049_.retainedSlice();
    }

    public ByteBuf slice(int p_130450_, int p_130451_) {
        return this.f_130049_.slice(p_130450_, p_130451_);
    }

    public ByteBuf retainedSlice(int p_130359_, int p_130360_) {
        return this.f_130049_.retainedSlice(p_130359_, p_130360_);
    }

    public ByteBuf duplicate() {
        return this.f_130049_.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.f_130049_.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.f_130049_.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.f_130049_.nioBuffer();
    }

    public ByteBuffer nioBuffer(int p_130270_, int p_130271_) {
        return this.f_130049_.nioBuffer(p_130270_, p_130271_);
    }

    public ByteBuffer internalNioBuffer(int p_130248_, int p_130249_) {
        return this.f_130049_.internalNioBuffer(p_130248_, p_130249_);
    }

    public ByteBuffer[] nioBuffers() {
        return this.f_130049_.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int p_130275_, int p_130276_) {
        return this.f_130049_.nioBuffers(p_130275_, p_130276_);
    }

    public boolean hasArray() {
        return this.f_130049_.hasArray();
    }

    public byte[] array() {
        return this.f_130049_.array();
    }

    public int arrayOffset() {
        return this.f_130049_.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.f_130049_.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.f_130049_.memoryAddress();
    }

    public String toString(Charset p_130458_) {
        return this.f_130049_.toString(p_130458_);
    }

    public String toString(int p_130454_, int p_130455_, Charset p_130456_) {
        return this.f_130049_.toString(p_130454_, p_130455_, p_130456_);
    }

    public int hashCode() {
        return this.f_130049_.hashCode();
    }

    public boolean equals(Object p_130144_) {
        return this.f_130049_.equals(p_130144_);
    }

    public int compareTo(ByteBuf p_130123_) {
        return this.f_130049_.compareTo(p_130123_);
    }

    public String toString() {
        return this.f_130049_.toString();
    }

    public FriendlyByteBuf retain(int p_299349_) {
        this.f_130049_.retain(p_299349_);
        return this;
    }

    public FriendlyByteBuf retain() {
        this.f_130049_.retain();
        return this;
    }

    public FriendlyByteBuf touch() {
        this.f_130049_.touch();
        return this;
    }

    public FriendlyByteBuf touch(Object p_299243_) {
        this.f_130049_.touch(p_299243_);
        return this;
    }

    public int refCnt() {
        return this.f_130049_.refCnt();
    }

    public boolean release() {
        return this.f_130049_.release();
    }

    public boolean release(int p_130347_) {
        return this.f_130049_.release(p_130347_);
    }

    @FunctionalInterface
    public static interface Writer<T>
    extends BiConsumer<FriendlyByteBuf, T> {
        default public Writer<Optional<T>> m_236883_() {
            return (p_236881_, p_236882_) -> p_236881_.m_236835_(p_236882_, this);
        }
    }

    @FunctionalInterface
    public static interface Reader<T>
    extends Function<FriendlyByteBuf, T> {
        default public Reader<Optional<T>> m_236879_() {
            return p_236878_ -> p_236878_.m_236860_(this);
        }
    }
}

