/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HoverEvent {
    public static final Codec<HoverEvent> f_303270_ = Codec.either((Codec)TypedHoverEvent.f_303383_.codec(), (Codec)TypedHoverEvent.f_302885_.codec()).xmap(p_310363_ -> new HoverEvent((TypedHoverEvent)p_310363_.map(p_311007_ -> p_311007_, p_310641_ -> p_310641_)), p_311162_ -> Either.left(p_311162_.f_303629_));
    private final TypedHoverEvent<?> f_303629_;

    public <T> HoverEvent(Action<T> p_130818_, T p_130819_) {
        this(new TypedHoverEvent<T>(p_130818_, p_130819_));
    }

    private HoverEvent(TypedHoverEvent<?> p_313245_) {
        this.f_303629_ = p_313245_;
    }

    public Action<?> m_130820_() {
        return this.f_303629_.f_303739_;
    }

    @Nullable
    public <T> T m_130823_(Action<T> p_130824_) {
        if (this.f_303629_.f_303739_ == p_130824_) {
            return p_130824_.m_130864_(this.f_303629_.f_302951_);
        }
        return null;
    }

    public boolean equals(Object p_130828_) {
        if (this == p_130828_) {
            return true;
        }
        if (p_130828_ == null || this.getClass() != p_130828_.getClass()) {
            return false;
        }
        return ((HoverEvent)p_130828_).f_303629_.equals(this.f_303629_);
    }

    public String toString() {
        return this.f_303629_.toString();
    }

    public int hashCode() {
        return this.f_303629_.hashCode();
    }

    record TypedHoverEvent<T>(Action<T> f_303739_, T f_302951_) {
        public static final MapCodec<TypedHoverEvent<?>> f_303383_ = Action.f_302584_.dispatchMap("action", TypedHoverEvent::f_303739_, p_312897_ -> p_312897_.f_302304_);
        public static final MapCodec<TypedHoverEvent<?>> f_302885_ = Action.f_302584_.dispatchMap("action", TypedHoverEvent::f_303739_, p_310775_ -> p_310775_.f_303126_);

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TypedHoverEvent.class, "action;value", "f_303739_", "f_302951_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TypedHoverEvent.class, "action;value", "f_303739_", "f_302951_"}, this);
        }

        @Override
        public final boolean equals(Object p_311320_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TypedHoverEvent.class, "action;value", "f_303739_", "f_302951_"}, this, p_311320_);
        }
    }

    public static class Action<T>
    implements StringRepresentable {
        public static final Action<Component> f_130831_ = new Action<Component>("show_text", true, ComponentSerialization.f_303288_, DataResult::success);
        public static final Action<ItemStackInfo> f_130832_ = new Action<ItemStackInfo>("show_item", true, ItemStackInfo.f_303860_, ItemStackInfo::m_305901_);
        public static final Action<EntityTooltipInfo> f_130833_ = new Action<EntityTooltipInfo>("show_entity", true, EntityTooltipInfo.f_302309_, EntityTooltipInfo::m_307449_);
        public static final Codec<Action<?>> f_303568_ = StringRepresentable.m_306774_(() -> new Action[]{f_130831_, f_130832_, f_130833_});
        public static final Codec<Action<?>> f_302584_ = ExtraCodecs.m_264370_(f_303568_, Action::m_305202_);
        private final String f_130835_;
        private final boolean f_130836_;
        final Codec<TypedHoverEvent<T>> f_302304_;
        final Codec<TypedHoverEvent<T>> f_303126_;

        public Action(String p_130842_, boolean p_130843_, Codec<T> p_311195_, Function<Component, DataResult<T>> p_130844_) {
            this.f_130835_ = p_130842_;
            this.f_130836_ = p_130843_;
            this.f_302304_ = p_311195_.xmap(p_308563_ -> new TypedHoverEvent<Object>(this, p_308563_), p_308564_ -> p_308564_.f_302951_).fieldOf("contents").codec();
            this.f_303126_ = Codec.of((Encoder)Encoder.error((String)"Can't encode in legacy format"), (Decoder)ComponentSerialization.f_303288_.flatMap(p_130844_).map(p_308565_ -> new TypedHoverEvent<Object>(this, p_308565_)));
        }

        public boolean m_130847_() {
            return this.f_130836_;
        }

        @Override
        public String m_7912_() {
            return this.f_130835_;
        }

        T m_130864_(Object p_130865_) {
            return (T)p_130865_;
        }

        public String toString() {
            return "<action " + this.f_130835_ + ">";
        }

        private static DataResult<Action<?>> m_305202_(@Nullable Action<?> p_311888_) {
            if (p_311888_ == null) {
                return DataResult.error(() -> "Unknown action");
            }
            if (!p_311888_.m_130847_()) {
                return DataResult.error(() -> "Action not allowed: " + p_311888_);
            }
            return DataResult.success(p_311888_, (Lifecycle)Lifecycle.stable());
        }
    }

    public static class ItemStackInfo {
        public static final Codec<ItemStackInfo> f_303661_ = RecordCodecBuilder.create(p_309880_ -> p_309880_.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("id").forGetter(p_309680_ -> p_309680_.f_130888_), (App)ExtraCodecs.m_295827_(Codec.INT, "count", 1).forGetter(p_311217_ -> p_311217_.f_130889_), (App)ExtraCodecs.m_294263_(TagParser.f_290338_, "tag").forGetter(p_311651_ -> p_311651_.f_130890_)).apply((Applicative)p_309880_, ItemStackInfo::new));
        public static final Codec<ItemStackInfo> f_303860_ = Codec.either(BuiltInRegistries.f_257033_.m_194605_(), f_303661_).xmap(p_311541_ -> (ItemStackInfo)p_311541_.map(p_311266_ -> new ItemStackInfo((Item)p_311266_, 1, Optional.empty()), p_311381_ -> p_311381_), Either::right);
        private final Item f_130888_;
        private final int f_130889_;
        private final Optional<CompoundTag> f_130890_;
        @Nullable
        private ItemStack f_130891_;

        ItemStackInfo(Item p_130893_, int p_130894_, @Nullable CompoundTag p_130895_) {
            this(p_130893_, p_130894_, Optional.ofNullable(p_130895_));
        }

        ItemStackInfo(Item p_311378_, int p_311558_, Optional<CompoundTag> p_312925_) {
            this.f_130888_ = p_311378_;
            this.f_130889_ = p_311558_;
            this.f_130890_ = p_312925_;
        }

        public ItemStackInfo(ItemStack p_130897_) {
            this(p_130897_.m_41720_(), p_130897_.m_41613_(), p_130897_.m_41783_() != null ? Optional.of(p_130897_.m_41783_().m_6426_()) : Optional.empty());
        }

        public boolean equals(Object p_130911_) {
            if (this == p_130911_) {
                return true;
            }
            if (p_130911_ == null || this.getClass() != p_130911_.getClass()) {
                return false;
            }
            ItemStackInfo $$1 = (ItemStackInfo)p_130911_;
            return this.f_130889_ == $$1.f_130889_ && this.f_130888_.equals($$1.f_130888_) && this.f_130890_.equals($$1.f_130890_);
        }

        public int hashCode() {
            int $$0 = this.f_130888_.hashCode();
            $$0 = 31 * $$0 + this.f_130889_;
            $$0 = 31 * $$0 + this.f_130890_.hashCode();
            return $$0;
        }

        public ItemStack m_130898_() {
            if (this.f_130891_ == null) {
                this.f_130891_ = new ItemStack(this.f_130888_, this.f_130889_);
                this.f_130890_.ifPresent(this.f_130891_::m_41751_);
            }
            return this.f_130891_;
        }

        private static DataResult<ItemStackInfo> m_305901_(Component p_309792_) {
            try {
                CompoundTag $$1 = TagParser.m_129359_(p_309792_.getString());
                return DataResult.success((Object)new ItemStackInfo(ItemStack.m_41712_($$1)));
            }
            catch (CommandSyntaxException $$2) {
                return DataResult.error(() -> "Failed to parse item tag: " + $$2.getMessage());
            }
        }
    }

    public static class EntityTooltipInfo {
        public static final Codec<EntityTooltipInfo> f_302309_ = RecordCodecBuilder.create(p_310594_ -> p_310594_.group((App)BuiltInRegistries.f_256780_.m_194605_().fieldOf("type").forGetter(p_309982_ -> p_309982_.f_130871_), (App)UUIDUtil.f_302497_.fieldOf("id").forGetter(p_312795_ -> p_312795_.f_130872_), (App)ExtraCodecs.m_294263_(ComponentSerialization.f_303288_, "name").forGetter(p_310270_ -> p_310270_.f_130873_)).apply((Applicative)p_310594_, EntityTooltipInfo::new));
        public final EntityType<?> f_130871_;
        public final UUID f_130872_;
        public final Optional<Component> f_130873_;
        @Nullable
        private List<Component> f_130874_;

        public EntityTooltipInfo(EntityType<?> p_130876_, UUID p_130877_, @Nullable Component p_130878_) {
            this(p_130876_, p_130877_, Optional.ofNullable(p_130878_));
        }

        public EntityTooltipInfo(EntityType<?> p_312321_, UUID p_312750_, Optional<Component> p_312078_) {
            this.f_130871_ = p_312321_;
            this.f_130872_ = p_312750_;
            this.f_130873_ = p_312078_;
        }

        public static DataResult<EntityTooltipInfo> m_307449_(Component p_312203_) {
            try {
                CompoundTag $$1 = TagParser.m_129359_(p_312203_.getString());
                MutableComponent $$2 = Component.Serializer.m_130701_($$1.m_128461_("name"));
                EntityType<?> $$3 = BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation($$1.m_128461_("type")));
                UUID $$4 = UUID.fromString($$1.m_128461_("id"));
                return DataResult.success((Object)new EntityTooltipInfo($$3, $$4, $$2));
            }
            catch (Exception $$5) {
                return DataResult.error(() -> "Failed to parse tooltip: " + $$5.getMessage());
            }
        }

        public List<Component> m_130884_() {
            if (this.f_130874_ == null) {
                this.f_130874_ = new ArrayList<Component>();
                this.f_130873_.ifPresent(this.f_130874_::add);
                this.f_130874_.add(Component.m_237110_("gui.entity_tooltip.type", this.f_130871_.m_20676_()));
                this.f_130874_.add(Component.m_237113_(this.f_130872_.toString()));
            }
            return this.f_130874_;
        }

        public boolean equals(Object p_130886_) {
            if (this == p_130886_) {
                return true;
            }
            if (p_130886_ == null || this.getClass() != p_130886_.getClass()) {
                return false;
            }
            EntityTooltipInfo $$1 = (EntityTooltipInfo)p_130886_;
            return this.f_130871_.equals($$1.f_130871_) && this.f_130872_.equals($$1.f_130872_) && this.f_130873_.equals($$1.f_130873_);
        }

        public int hashCode() {
            int $$0 = this.f_130871_.hashCode();
            $$0 = 31 * $$0 + this.f_130872_.hashCode();
            $$0 = 31 * $$0 + this.f_130873_.hashCode();
            return $$0;
        }
    }
}

