/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.advancements.AdvancementVisibilityEvaluator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class PlayerAdvancements {
    private static final Logger f_135958_ = LogUtils.getLogger();
    private static final Gson f_135959_ = new GsonBuilder().setPrettyPrinting().create();
    private final PlayerList f_135962_;
    private final Path f_263766_;
    private AdvancementTree f_291661_;
    private final Map<AdvancementHolder, AdvancementProgress> f_263740_ = new LinkedHashMap<AdvancementHolder, AdvancementProgress>();
    private final Set<AdvancementHolder> f_135965_ = new HashSet<AdvancementHolder>();
    private final Set<AdvancementHolder> f_135967_ = new HashSet<AdvancementHolder>();
    private final Set<AdvancementNode> f_263821_ = new HashSet<AdvancementNode>();
    private ServerPlayer f_135968_;
    @Nullable
    private AdvancementHolder f_135969_;
    private boolean f_135970_ = true;
    private final Codec<Data> f_290992_;

    public PlayerAdvancements(DataFixer p_265655_, PlayerList p_265703_, ServerAdvancementManager p_265166_, Path p_265268_, ServerPlayer p_265673_) {
        this.f_135962_ = p_265703_;
        this.f_263766_ = p_265268_;
        this.f_135968_ = p_265673_;
        this.f_291661_ = p_265166_.m_294482_();
        int i = 1343;
        this.f_290992_ = DataFixTypes.ADVANCEMENTS.m_292606_(Data.f_291638_, p_265655_, 1343);
        this.m_136006_(p_265166_);
    }

    public void m_135979_(ServerPlayer p_135980_) {
        this.f_135968_ = p_135980_;
    }

    public void m_135978_() {
        for (CriterionTrigger criterionTrigger : BuiltInRegistries.f_302882_) {
            criterionTrigger.m_5656_(this);
        }
    }

    public void m_135981_(ServerAdvancementManager p_135982_) {
        this.m_135978_();
        this.f_263740_.clear();
        this.f_135965_.clear();
        this.f_263821_.clear();
        this.f_135967_.clear();
        this.f_135970_ = true;
        this.f_135969_ = null;
        this.f_291661_ = p_135982_.m_294482_();
        this.m_136006_(p_135982_);
    }

    private void m_135994_(ServerAdvancementManager p_135995_) {
        for (AdvancementHolder advancementholder : p_135995_.m_136028_()) {
            this.m_136004_(advancementholder);
        }
    }

    private void m_136002_(ServerAdvancementManager p_136003_) {
        for (AdvancementHolder advancementholder : p_136003_.m_136028_()) {
            Advancement advancement = advancementholder.f_290952_();
            if (!advancement.f_138302_().isEmpty()) continue;
            this.m_135988_(advancementholder, "");
            advancement.f_138300_().m_9989_(this.f_135968_);
        }
    }

    private void m_136006_(ServerAdvancementManager p_136007_) {
        if (Files.isRegularFile(this.f_263766_, new LinkOption[0])) {
            try (JsonReader jsonreader = new JsonReader((Reader)Files.newBufferedReader(this.f_263766_, StandardCharsets.UTF_8));){
                jsonreader.setLenient(false);
                JsonElement jsonelement = Streams.parse((JsonReader)jsonreader);
                Data playeradvancements$data = (Data)Util.m_260975_(this.f_290992_.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement), JsonParseException::new);
                this.m_294994_(p_136007_, playeradvancements$data);
            }
            catch (JsonParseException jsonparseexception) {
                f_135958_.error("Couldn't parse player advancements in {}", (Object)this.f_263766_, (Object)jsonparseexception);
            }
            catch (IOException ioexception) {
                f_135958_.error("Couldn't access player advancements in {}", (Object)this.f_263766_, (Object)ioexception);
            }
        }
        this.m_136002_(p_136007_);
        this.m_135994_(p_136007_);
    }

    public void m_135991_() {
        JsonElement jsonelement = (JsonElement)Util.m_260975_(this.f_290992_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.m_295536_()), IllegalStateException::new);
        try {
            FileUtil.m_257659_(this.f_263766_.getParent());
            try (BufferedWriter writer = Files.newBufferedWriter(this.f_263766_, StandardCharsets.UTF_8, new OpenOption[0]);){
                f_135959_.toJson(jsonelement, (Appendable)writer);
            }
        }
        catch (IOException ioexception) {
            f_135958_.error("Couldn't save player advancements to {}", (Object)this.f_263766_, (Object)ioexception);
        }
    }

    private void m_294994_(ServerAdvancementManager p_299201_, Data p_300341_) {
        p_300341_.m_293404_((p_296440_, p_296441_) -> {
            AdvancementHolder advancementholder = p_299201_.m_294099_((ResourceLocation)p_296440_);
            if (advancementholder == null) {
                f_135958_.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", p_296440_, (Object)this.f_263766_);
            } else {
                this.m_135985_(advancementholder, (AdvancementProgress)p_296441_);
                this.f_135967_.add(advancementholder);
                this.m_264423_(advancementholder);
            }
        });
    }

    private Data m_295536_() {
        LinkedHashMap<ResourceLocation, AdvancementProgress> map = new LinkedHashMap<ResourceLocation, AdvancementProgress>();
        this.f_263740_.forEach((p_296446_, p_296447_) -> {
            if (p_296447_.m_8206_()) {
                map.put(p_296446_.f_291758_(), (AdvancementProgress)p_296447_);
            }
        });
        return new Data(map);
    }

    public boolean m_135988_(AdvancementHolder p_298135_, String p_135990_) {
        boolean flag = false;
        AdvancementProgress advancementprogress = this.m_135996_(p_298135_);
        boolean flag1 = advancementprogress.m_8193_();
        if (advancementprogress.m_8196_(p_135990_)) {
            this.m_136008_(p_298135_);
            this.f_135967_.add(p_298135_);
            flag = true;
            ForgeEventFactory.onAdvancementGrant((Player)this.f_135968_, (AdvancementHolder)p_298135_, (AdvancementProgress)advancementprogress, (String)p_135990_);
            if (!flag1 && advancementprogress.m_8193_()) {
                p_298135_.f_290952_().f_138300_().m_9989_(this.f_135968_);
                p_298135_.f_290952_().f_138299_().ifPresent(p_308592_ -> {
                    if (p_308592_.m_14996_() && this.f_135968_.m_9236_().m_46469_().m_46207_(GameRules.f_46153_)) {
                        this.f_135962_.m_240416_(p_308592_.m_306629_().m_305571_(p_298135_, this.f_135968_), false);
                    }
                });
                ForgeEventFactory.onAdvancementEarned((Player)this.f_135968_, (AdvancementHolder)p_298135_);
            }
        }
        if (!flag1 && advancementprogress.m_8193_()) {
            this.m_264423_(p_298135_);
        }
        return flag;
    }

    public boolean m_135998_(AdvancementHolder p_297905_, String p_136000_) {
        boolean flag = false;
        AdvancementProgress advancementprogress = this.m_135996_(p_297905_);
        boolean flag1 = advancementprogress.m_8193_();
        if (advancementprogress.m_8209_(p_136000_)) {
            this.m_136004_(p_297905_);
            this.f_135967_.add(p_297905_);
            flag = true;
            ForgeEventFactory.onAdvancementRevoke((Player)this.f_135968_, (AdvancementHolder)p_297905_, (AdvancementProgress)advancementprogress, (String)p_136000_);
        }
        if (flag1 && !advancementprogress.m_8193_()) {
            this.m_264423_(p_297905_);
        }
        return flag;
    }

    private void m_264423_(AdvancementHolder p_298258_) {
        AdvancementNode advancementnode = this.f_291661_.m_292849_(p_298258_);
        if (advancementnode != null) {
            this.f_263821_.add(advancementnode.m_295389_());
        }
    }

    private void m_136004_(AdvancementHolder p_299071_) {
        AdvancementProgress advancementprogress = this.m_135996_(p_299071_);
        if (!advancementprogress.m_8193_()) {
            for (Map.Entry<String, Criterion<?>> entry : p_299071_.f_290952_().f_138302_().entrySet()) {
                CriterionProgress criterionprogress = advancementprogress.m_8214_(entry.getKey());
                if (criterionprogress == null || criterionprogress.m_12911_()) continue;
                this.m_293212_(p_299071_, entry.getKey(), entry.getValue());
            }
        }
    }

    private <T extends CriterionTriggerInstance> void m_293212_(AdvancementHolder p_297859_, String p_300029_, Criterion<T> p_298869_) {
        p_298869_.f_11412_().m_6467_(this, new CriterionTrigger.Listener<T>(p_298869_.f_290685_(), p_297859_, p_300029_));
    }

    private void m_136008_(AdvancementHolder p_298363_) {
        AdvancementProgress advancementprogress = this.m_135996_(p_298363_);
        for (Map.Entry<String, Criterion<?>> entry : p_298363_.f_290952_().f_138302_().entrySet()) {
            CriterionProgress criterionprogress = advancementprogress.m_8214_(entry.getKey());
            if (criterionprogress == null || !criterionprogress.m_12911_() && !advancementprogress.m_8193_()) continue;
            this.m_292677_(p_298363_, entry.getKey(), entry.getValue());
        }
    }

    private <T extends CriterionTriggerInstance> void m_292677_(AdvancementHolder p_301071_, String p_298445_, Criterion<T> p_297428_) {
        p_297428_.f_11412_().m_6468_(this, new CriterionTrigger.Listener<T>(p_297428_.f_290685_(), p_301071_, p_298445_));
    }

    public void m_135992_(ServerPlayer p_135993_) {
        if (this.f_135970_ || !this.f_263821_.isEmpty() || !this.f_135967_.isEmpty()) {
            HashMap<ResourceLocation, AdvancementProgress> map = new HashMap<ResourceLocation, AdvancementProgress>();
            HashSet<AdvancementHolder> set = new HashSet<AdvancementHolder>();
            HashSet<ResourceLocation> set1 = new HashSet<ResourceLocation>();
            for (AdvancementNode advancementnode : this.f_263821_) {
                this.m_264265_(advancementnode, set, set1);
            }
            this.f_263821_.clear();
            for (AdvancementHolder advancementholder : this.f_135967_) {
                if (!this.f_135965_.contains(advancementholder)) continue;
                map.put(advancementholder.f_291758_(), this.f_263740_.get(advancementholder));
            }
            this.f_135967_.clear();
            if (!(map.isEmpty() && set.isEmpty() && set1.isEmpty())) {
                p_135993_.f_8906_.m_141995_(new ClientboundUpdateAdvancementsPacket(this.f_135970_, set, set1, map));
            }
        }
        this.f_135970_ = false;
    }

    public void m_135983_(@Nullable AdvancementHolder p_300452_) {
        AdvancementHolder advancementholder = this.f_135969_;
        this.f_135969_ = p_300452_ != null && p_300452_.f_290952_().m_295578_() && p_300452_.f_290952_().f_138299_().isPresent() ? p_300452_ : null;
        if (advancementholder != this.f_135969_) {
            this.f_135968_.f_8906_.m_141995_(new ClientboundSelectAdvancementsTabPacket(this.f_135969_ == null ? null : this.f_135969_.f_291758_()));
        }
    }

    public AdvancementProgress m_135996_(AdvancementHolder p_299379_) {
        AdvancementProgress advancementprogress = this.f_263740_.get(p_299379_);
        if (advancementprogress == null) {
            advancementprogress = new AdvancementProgress();
            this.m_135985_(p_299379_, advancementprogress);
        }
        return advancementprogress;
    }

    private void m_135985_(AdvancementHolder p_299830_, AdvancementProgress p_135987_) {
        p_135987_.m_8198_(p_299830_.f_290952_().f_138303_());
        this.f_263740_.put(p_299830_, p_135987_);
    }

    private void m_264265_(AdvancementNode p_298387_, Set<AdvancementHolder> p_265206_, Set<ResourceLocation> p_265593_) {
        AdvancementVisibilityEvaluator.m_264402_(p_298387_, p_296442_ -> this.m_135996_(p_296442_.m_295246_()).m_8193_(), (p_296437_, p_296438_) -> {
            AdvancementHolder advancementholder = p_296437_.m_295246_();
            if (p_296438_) {
                if (this.f_135965_.add(advancementholder)) {
                    p_265206_.add(advancementholder);
                    if (this.f_263740_.containsKey(advancementholder)) {
                        this.f_135967_.add(advancementholder);
                    }
                }
            } else if (this.f_135965_.remove(advancementholder)) {
                p_265593_.add(advancementholder.f_291758_());
            }
        });
    }

    record Data(Map<ResourceLocation, AdvancementProgress> f_290510_) {
        public static final Codec<Data> f_291638_ = Codec.unboundedMap(ResourceLocation.f_135803_, AdvancementProgress.f_291693_).xmap(Data::new, Data::f_290510_);

        public void m_293404_(BiConsumer<ResourceLocation, AdvancementProgress> p_298170_) {
            this.f_290510_.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(p_300025_ -> p_298170_.accept((ResourceLocation)p_300025_.getKey(), (AdvancementProgress)p_300025_.getValue()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Data.class, "map", "f_290510_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Data.class, "map", "f_290510_"}, this);
        }

        @Override
        public final boolean equals(Object p_300592_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Data.class, "map", "f_290510_"}, this, p_300592_);
        }
    }
}

