/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener {
    private static final Logger f_136021_ = LogUtils.getLogger();
    private static final Gson f_136022_ = new GsonBuilder().create();
    private Map<ResourceLocation, AdvancementHolder> f_136023_ = Map.of();
    private AdvancementTree f_290842_ = new AdvancementTree();
    private final LootDataManager f_278379_;
    private final ICondition.IContext context;

    @Deprecated
    public ServerAdvancementManager(LootDataManager p_279237_) {
        this(p_279237_, ICondition.IContext.EMPTY);
    }

    public ServerAdvancementManager(LootDataManager p_279237_, ICondition.IContext context) {
        super(f_136022_, "advancements");
        this.f_278379_ = p_279237_;
        this.context = context;
    }

    @Override
    protected void m_5787_(Map<ResourceLocation, JsonElement> p_136034_, ResourceManager p_136035_, ProfilerFiller p_136036_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        p_136034_.forEach((p_308595_, p_308596_) -> {
            try {
                JsonObject json = ForgeHooks.readConditionalAdvancement(null, (JsonObject)((JsonObject)p_308596_));
                if (json == null) {
                    f_136021_.debug("Skipping loading advancement {} as its conditions were not met", p_308595_);
                    return;
                }
                Advancement advancement = (Advancement)Util.m_260975_(Advancement.f_303179_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json), JsonParseException::new);
                this.m_307654_((ResourceLocation)p_308595_, advancement);
                builder.put(p_308595_, (Object)new AdvancementHolder((ResourceLocation)p_308595_, advancement));
            }
            catch (Exception exception) {
                f_136021_.error("Parsing error loading custom advancement {}: {}", p_308595_, (Object)exception.getMessage());
            }
        });
        this.f_136023_ = builder.buildOrThrow();
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.m_293567_(this.f_136023_.values());
        for (AdvancementNode advancementnode : advancementtree.m_295865_()) {
            if (!advancementnode.m_295246_().f_290952_().f_138299_().isPresent()) continue;
            TreeNodePosition.m_16587_(advancementnode);
        }
        this.f_290842_ = advancementtree;
    }

    private void m_307654_(ResourceLocation p_309906_, Advancement p_310937_) {
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        p_310937_.m_306920_(problemreporter$collector, this.f_278379_);
        Multimap<String, String> multimap = problemreporter$collector.m_306090_();
        if (!multimap.isEmpty()) {
            String s = multimap.asMap().entrySet().stream().map(p_308593_ -> "  at " + (String)p_308593_.getKey() + ": " + String.join((CharSequence)"; ", (Iterable)p_308593_.getValue())).collect(Collectors.joining("\n"));
            f_136021_.warn("Found validation problems in advancement {}: \n{}", (Object)p_309906_, (Object)s);
        }
    }

    @Nullable
    public AdvancementHolder m_294099_(ResourceLocation p_299615_) {
        return this.f_136023_.get(p_299615_);
    }

    public AdvancementTree m_294482_() {
        return this.f_290842_;
    }

    public Collection<AdvancementHolder> m_136028_() {
        return this.f_136023_.values();
    }
}

