/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.client.server.LanServerPinger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.ConsoleInput;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.dedicated.ServerWatchdog;
import net.minecraft.server.gui.MinecraftServerGui;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.network.TextFilterClient;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.server.rcon.RconConsoleSource;
import net.minecraft.server.rcon.thread.QueryThreadGs4;
import net.minecraft.server.rcon.thread.RconThread;
import net.minecraft.util.Mth;
import net.minecraft.util.monitoring.jmx.MinecraftServerStatistics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.server.console.TerminalHandler;
import org.slf4j.Logger;

public class DedicatedServer
extends MinecraftServer
implements ServerInterface {
    static final Logger f_139598_ = LogUtils.getLogger();
    private static final int f_142864_ = 5000;
    private static final int f_142865_ = 2;
    public final List<ConsoleInput> f_139600_ = Collections.synchronizedList(Lists.newArrayList());
    @Nullable
    private QueryThreadGs4 f_139601_;
    private final RconConsoleSource f_139602_;
    @Nullable
    private RconThread f_139603_;
    private final DedicatedServerSettings f_139604_;
    @Nullable
    private MinecraftServerGui f_139605_;
    @Nullable
    private final TextFilterClient f_139606_;
    @Nullable
    private LanServerPinger dediLanPinger;

    public DedicatedServer(Thread p_214789_, LevelStorageSource.LevelStorageAccess p_214790_, PackRepository p_214791_, WorldStem p_214792_, DedicatedServerSettings p_214793_, DataFixer p_214794_, Services p_214795_, ChunkProgressListenerFactory p_214796_) {
        super(p_214789_, p_214790_, p_214791_, p_214792_, Proxy.NO_PROXY, p_214794_, p_214795_, p_214796_);
        this.f_139604_ = p_214793_;
        this.f_139602_ = new RconConsoleSource(this);
        this.f_139606_ = TextFilterClient.m_143736_(p_214793_.m_139777_().f_139724_);
    }

    @Override
    public boolean m_7038_() throws IOException {
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (TerminalHandler.handleCommands((DedicatedServer)DedicatedServer.this)) {
                    return;
                }
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                try {
                    String s1;
                    while (!DedicatedServer.this.m_129918_() && DedicatedServer.this.m_130010_() && (s1 = bufferedreader.readLine()) != null) {
                        DedicatedServer.this.m_139645_(s1, DedicatedServer.this.m_129893_());
                    }
                }
                catch (IOException ioexception1) {
                    f_139598_.error("Exception handling console input", (Throwable)ioexception1);
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_139598_));
        thread.start();
        f_139598_.info("Starting minecraft server version {}", (Object)SharedConstants.m_183709_().m_132493_());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            f_139598_.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        f_139598_.info("Loading properties");
        DedicatedServerProperties dedicatedserverproperties = this.f_139604_.m_139777_();
        if (this.m_129792_()) {
            this.m_129913_("127.0.0.1");
        } else {
            this.m_129985_(dedicatedserverproperties.f_139728_);
            this.m_129993_(dedicatedserverproperties.f_139729_);
            this.m_129913_(dedicatedserverproperties.f_139730_);
        }
        this.m_129997_(dedicatedserverproperties.f_139733_);
        this.m_129999_(dedicatedserverproperties.f_139734_);
        this.m_129989_(dedicatedserverproperties.f_139736_);
        super.m_7196_(dedicatedserverproperties.f_139725_.get());
        this.m_130004_(dedicatedserverproperties.f_139738_);
        this.f_129749_.m_5458_(dedicatedserverproperties.f_139740_);
        f_139598_.info("Default game type: {}", (Object)dedicatedserverproperties.f_139740_);
        InetAddress inetaddress = null;
        if (!this.m_130009_().isEmpty()) {
            inetaddress = InetAddress.getByName(this.m_130009_());
        }
        if (this.m_7010_() < 0) {
            this.m_129801_(dedicatedserverproperties.f_139742_);
        }
        this.m_129793_();
        f_139598_.info("Starting Minecraft server on {}:{}", (Object)(this.m_130009_().isEmpty() ? "*" : this.m_130009_()), (Object)this.m_7010_());
        try {
            this.m_129919_().m_9711_(inetaddress, this.m_7010_());
        }
        catch (IOException ioexception) {
            f_139598_.warn("**** FAILED TO BIND TO PORT!");
            f_139598_.warn("The exception was: {}", (Object)ioexception.toString());
            f_139598_.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.m_129797_()) {
            f_139598_.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            f_139598_.warn("The server will make no attempt to authenticate usernames. Beware.");
            f_139598_.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            f_139598_.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.m_139668_()) {
            this.m_129927_().m_11006_();
        }
        if (!OldUsersConverter.m_11106_(this)) {
            return false;
        }
        this.m_129823_(new DedicatedPlayerList(this, this.m_247573_(), this.f_129745_));
        long i = Util.m_137569_();
        SkullBlockEntity.m_222885_(this.f_236721_, this);
        GameProfileCache.m_11004_(this.m_129797_());
        if (!ServerLifecycleHooks.handleServerAboutToStart((MinecraftServer)this)) {
            return false;
        }
        f_139598_.info("Preparing level \"{}\"", (Object)this.m_7123_());
        this.m_130006_();
        long j = Util.m_137569_() - i;
        String s = String.format(Locale.ROOT, "%.3fs", (double)j / 1.0E9);
        f_139598_.info("Done ({})! For help, type \"help\"", (Object)s);
        this.f_302313_ = Util.m_137569_();
        if (dedicatedserverproperties.f_139744_ != null) {
            this.m_129900_().m_46170_(GameRules.f_46153_).m_46246_(dedicatedserverproperties.f_139744_, this);
        }
        if (dedicatedserverproperties.f_139745_) {
            f_139598_.info("Starting GS4 status listener");
            this.f_139601_ = QueryThreadGs4.m_11553_(this);
        }
        if (dedicatedserverproperties.f_139747_) {
            f_139598_.info("Starting remote control listener");
            this.f_139603_ = RconThread.m_11615_(this);
        }
        if (this.m_139669_() > 0L) {
            Thread thread1 = new Thread(new ServerWatchdog(this));
            thread1.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandlerWithName(f_139598_));
            thread1.setName("Server Watchdog");
            thread1.setDaemon(true);
            thread1.start();
        }
        if (dedicatedserverproperties.f_139721_) {
            MinecraftServerStatistics.m_18328_(this);
            f_139598_.info("JMX monitoring enabled");
        }
        if (((Boolean)ForgeConfig.SERVER.advertiseDedicatedServerToLan.get()).booleanValue()) {
            this.dediLanPinger = new LanServerPinger(this.m_129916_(), String.valueOf(this.m_7448_()));
            this.dediLanPinger.start();
        }
        return ServerLifecycleHooks.handleServerStarting((MinecraftServer)this);
    }

    @Override
    public boolean m_6998_() {
        return this.m_7913_().f_139731_ && super.m_6998_();
    }

    @Override
    public boolean m_7004_() {
        return this.f_139604_.m_139777_().f_139705_ && super.m_7004_();
    }

    @Override
    public boolean m_6997_() {
        return this.f_139604_.m_139777_().f_139732_ && super.m_6997_();
    }

    @Override
    public DedicatedServerProperties m_7913_() {
        return this.f_139604_.m_139777_();
    }

    @Override
    public void m_7044_() {
        this.m_129827_(this.m_7913_().f_139739_, true);
    }

    @Override
    public boolean m_7035_() {
        return this.m_7913_().f_139752_;
    }

    @Override
    public SystemReport m_142424_(SystemReport p_142870_) {
        p_142870_.m_143522_("Is Modded", () -> this.m_183471_().m_184605_());
        p_142870_.m_143522_("Type", () -> "Dedicated Server (map_server.txt)");
        return p_142870_;
    }

    @Override
    public void m_142116_(Path p_142872_) throws IOException {
        DedicatedServerProperties dedicatedserverproperties = this.m_7913_();
        try (BufferedWriter writer = Files.newBufferedWriter(p_142872_, new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", dedicatedserverproperties.f_139720_));
            writer.write(String.format(Locale.ROOT, "gamemode=%s%n", dedicatedserverproperties.f_139740_));
            writer.write(String.format(Locale.ROOT, "spawn-monsters=%s%n", dedicatedserverproperties.f_139705_));
            writer.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", dedicatedserverproperties.f_139723_));
            writer.write(String.format(Locale.ROOT, "max-world-size=%d%n", dedicatedserverproperties.f_139719_));
            writer.write(String.format(Locale.ROOT, "spawn-npcs=%s%n", dedicatedserverproperties.f_139732_));
            writer.write(String.format(Locale.ROOT, "view-distance=%d%n", dedicatedserverproperties.f_139714_));
            writer.write(String.format(Locale.ROOT, "simulation-distance=%d%n", dedicatedserverproperties.f_183715_));
            writer.write(String.format(Locale.ROOT, "spawn-animals=%s%n", dedicatedserverproperties.f_139731_));
            writer.write(String.format(Locale.ROOT, "generate-structures=%s%n", dedicatedserverproperties.f_243824_.m_247749_()));
            writer.write(String.format(Locale.ROOT, "use-native=%s%n", dedicatedserverproperties.f_139707_));
            writer.write(String.format(Locale.ROOT, "rate-limit=%d%n", dedicatedserverproperties.f_139713_));
        }
    }

    @Override
    public void m_6988_() {
        if (this.f_139606_ != null) {
            this.f_139606_.close();
        }
        if (this.f_139605_ != null) {
            this.f_139605_.m_139925_();
        }
        if (this.f_139603_ != null) {
            this.f_139603_.m_7530_();
        }
        if (this.f_139601_ != null) {
            this.f_139601_.m_7530_();
        }
        if (this.dediLanPinger != null) {
            this.dediLanPinger.interrupt();
            this.dediLanPinger = null;
        }
    }

    @Override
    public void m_5703_(BooleanSupplier p_139661_) {
        super.m_5703_(p_139661_);
        this.m_139665_();
    }

    @Override
    public boolean m_7079_() {
        return this.m_7913_().f_139753_;
    }

    public void m_139645_(String p_139646_, CommandSourceStack p_139647_) {
        this.f_139600_.add(new ConsoleInput(p_139646_, p_139647_));
    }

    public void m_139665_() {
        while (!this.f_139600_.isEmpty()) {
            ConsoleInput consoleinput = this.f_139600_.remove(0);
            this.m_129892_().m_230957_(consoleinput.f_135929_, consoleinput.f_135928_);
        }
    }

    @Override
    public boolean m_6982_() {
        return true;
    }

    @Override
    public int m_7032_() {
        return this.m_7913_().f_139713_;
    }

    @Override
    public boolean m_6994_() {
        return this.m_7913_().f_139707_;
    }

    @Override
    public DedicatedPlayerList m_6846_() {
        return (DedicatedPlayerList)super.m_6846_();
    }

    @Override
    public boolean m_6992_() {
        return true;
    }

    @Override
    public String m_6866_() {
        return this.m_130009_();
    }

    @Override
    public int m_7448_() {
        return this.m_7010_();
    }

    @Override
    public String m_6995_() {
        return this.m_129916_();
    }

    public void m_139667_() {
        if (this.f_139605_ == null) {
            this.f_139605_ = MinecraftServerGui.m_139921_(this);
        }
    }

    @Override
    public boolean m_6370_() {
        return this.f_139605_ != null;
    }

    @Override
    public boolean m_6993_() {
        return this.m_7913_().f_139708_;
    }

    @Override
    public int m_6396_() {
        return this.m_7913_().f_139709_;
    }

    @Override
    public boolean m_7762_(ServerLevel p_139630_, BlockPos p_139631_, Player p_139632_) {
        int j;
        if (p_139630_.m_46472_() != Level.f_46428_) {
            return false;
        }
        if (this.m_6846_().m_11307_().m_11390_()) {
            return false;
        }
        if (this.m_6846_().m_11303_(p_139632_.m_36316_())) {
            return false;
        }
        if (this.m_6396_() <= 0) {
            return false;
        }
        BlockPos blockpos = p_139630_.m_220360_();
        int i = Mth.m_14040_(p_139631_.m_123341_() - blockpos.m_123341_());
        int k = Math.max(i, j = Mth.m_14040_(p_139631_.m_123343_() - blockpos.m_123343_()));
        return k <= this.m_6396_();
    }

    @Override
    public boolean m_6373_() {
        return this.m_7913_().f_139722_;
    }

    @Override
    public boolean m_183306_() {
        return this.m_7913_().f_183716_;
    }

    @Override
    public int m_7022_() {
        return this.m_7913_().f_139710_;
    }

    @Override
    public int m_7034_() {
        return this.m_7913_().f_139711_;
    }

    @Override
    public void m_7196_(int p_139676_) {
        super.m_7196_(p_139676_);
        this.f_139604_.m_139778_(p_308934_ -> (DedicatedServerProperties)p_308934_.f_139725_.m_139895_(this.m_206579_(), p_139676_));
    }

    @Override
    public boolean m_6983_() {
        return this.m_7913_().f_139717_;
    }

    @Override
    public boolean m_6102_() {
        return this.m_7913_().f_139718_;
    }

    @Override
    public int m_6329_() {
        return this.m_7913_().f_139719_;
    }

    @Override
    public int m_6328_() {
        return this.m_7913_().f_139716_;
    }

    @Override
    public boolean m_214005_() {
        DedicatedServerProperties dedicatedserverproperties = this.m_7913_();
        return dedicatedserverproperties.f_214804_ && dedicatedserverproperties.f_139728_ && this.f_236721_.m_305993_();
    }

    @Override
    public boolean m_292975_() {
        return this.m_7913_().f_290960_;
    }

    protected boolean m_139668_() {
        boolean flag = false;
        for (int i = 0; !flag && i <= 2; ++i) {
            if (i > 0) {
                f_139598_.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.m_139671_();
            }
            flag = OldUsersConverter.m_11081_(this);
        }
        boolean flag1 = false;
        for (int j = 0; !flag1 && j <= 2; ++j) {
            if (j > 0) {
                f_139598_.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.m_139671_();
            }
            flag1 = OldUsersConverter.m_11098_(this);
        }
        boolean flag2 = false;
        for (int k = 0; !flag2 && k <= 2; ++k) {
            if (k > 0) {
                f_139598_.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.m_139671_();
            }
            flag2 = OldUsersConverter.m_11102_(this);
        }
        boolean flag3 = false;
        for (int l = 0; !flag3 && l <= 2; ++l) {
            if (l > 0) {
                f_139598_.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.m_139671_();
            }
            flag3 = OldUsersConverter.m_11104_(this);
        }
        boolean flag4 = false;
        for (int i1 = 0; !flag4 && i1 <= 2; ++i1) {
            if (i1 > 0) {
                f_139598_.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.m_139671_();
            }
            flag4 = OldUsersConverter.m_11090_(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void m_139671_() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long m_139669_() {
        return this.m_7913_().f_139712_;
    }

    @Override
    public int m_213994_() {
        return this.m_7913_().f_214801_;
    }

    @Override
    public String m_7138_() {
        return "";
    }

    @Override
    public String m_7261_(String p_139644_) {
        this.f_139602_.m_11512_();
        this.m_18709_(() -> this.m_129892_().m_230957_(this.f_139602_.m_11514_(), p_139644_));
        return this.f_139602_.m_11513_();
    }

    public void m_139688_(boolean p_139689_) {
        this.f_139604_.m_139778_(p_308931_ -> (DedicatedServerProperties)p_308931_.f_139726_.m_139895_(this.m_206579_(), p_139689_));
    }

    @Override
    public void m_7041_() {
        MinecraftForge.EVENT_BUS.post((Event)new GameShuttingDownEvent());
        super.m_7041_();
        if (this.dediLanPinger != null) {
            this.dediLanPinger.interrupt();
            this.dediLanPinger = null;
        }
        Util.m_137580_();
        SkullBlockEntity.m_196704_();
    }

    @Override
    public boolean m_7779_(GameProfile p_139642_) {
        return false;
    }

    @Override
    public int m_7186_(int p_139659_) {
        return this.m_7913_().f_139723_ * p_139659_ / 100;
    }

    @Override
    public String m_7123_() {
        return this.f_129744_.m_78277_();
    }

    @Override
    public boolean m_6365_() {
        return this.f_139604_.m_139777_().f_139720_;
    }

    @Override
    public TextFilter m_7950_(ServerPlayer p_139634_) {
        return this.f_139606_ != null ? this.f_139606_.m_10134_(p_139634_.m_36316_()) : TextFilter.f_143703_;
    }

    @Override
    @Nullable
    public GameType m_142359_() {
        return this.f_139604_.m_139777_().f_139737_ ? this.f_129749_.m_5464_() : null;
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> m_214042_() {
        return this.f_139604_.m_139777_().f_214802_;
    }
}

