/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.DebugBuffer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ChunkHolder {
    public static final Either<ChunkAccess, ChunkLoadingFailure> f_139995_ = Either.right((Object)ChunkLoadingFailure.f_140101_);
    public static final CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> f_139996_ = CompletableFuture.completedFuture(f_139995_);
    public static final Either<LevelChunk, ChunkLoadingFailure> f_139997_ = Either.right((Object)ChunkLoadingFailure.f_140101_);
    private static final Either<ChunkAccess, ChunkLoadingFailure> f_203750_ = Either.right((Object)ChunkLoadingFailure.f_140101_);
    private static final CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> f_139998_ = CompletableFuture.completedFuture(f_139997_);
    private static final List<ChunkStatus> f_139999_ = ChunkStatus.m_62349_();
    private final AtomicReferenceArray<CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>>> f_140001_ = new AtomicReferenceArray(f_139999_.size());
    private final LevelHeightAccessor f_142983_;
    private volatile CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> f_140002_ = f_139998_;
    private volatile CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> f_140003_ = f_139998_;
    private volatile CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> f_140004_ = f_139998_;
    private CompletableFuture<ChunkAccess> f_140005_ = CompletableFuture.completedFuture(null);
    @Nullable
    private final DebugBuffer<ChunkSaveDebug> f_142984_ = null;
    private int f_140006_;
    private int f_140007_;
    private int f_140008_;
    final ChunkPos f_140009_;
    private boolean f_140010_;
    private final ShortSet[] f_140011_;
    private final BitSet f_140012_ = new BitSet();
    private final BitSet f_140013_ = new BitSet();
    private final LevelLightEngine f_140014_;
    private final LevelChangeListener f_140015_;
    private final PlayerProvider f_140016_;
    private boolean f_140017_;
    LevelChunk currentlyLoading;
    private CompletableFuture<Void> f_142981_ = CompletableFuture.completedFuture(null);
    private CompletableFuture<?> f_290310_ = CompletableFuture.completedFuture(null);

    public ChunkHolder(ChunkPos p_142986_, int p_142987_, LevelHeightAccessor p_142988_, LevelLightEngine p_142989_, LevelChangeListener p_142990_, PlayerProvider p_142991_) {
        this.f_140009_ = p_142986_;
        this.f_142983_ = p_142988_;
        this.f_140014_ = p_142989_;
        this.f_140015_ = p_142990_;
        this.f_140016_ = p_142991_;
        this.f_140007_ = this.f_140006_ = ChunkLevel.f_286967_ + 1;
        this.f_140008_ = this.f_140006_;
        this.m_140027_(p_142987_);
        this.f_140011_ = new ShortSet[p_142988_.m_151559_()];
    }

    public CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> m_140047_(ChunkStatus p_140048_) {
        CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> completablefuture = this.f_140001_.get(p_140048_.m_62445_());
        return completablefuture == null ? f_139996_ : completablefuture;
    }

    public CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> m_140080_(ChunkStatus p_140081_) {
        return ChunkLevel.m_287158_(this.f_140007_).m_62427_(p_140081_) ? this.m_140047_(p_140081_) : f_139996_;
    }

    public CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> m_140026_() {
        return this.f_140003_;
    }

    public CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> m_140073_() {
        return this.f_140004_;
    }

    public CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> m_140082_() {
        return this.f_140002_;
    }

    @Nullable
    public LevelChunk m_140085_() {
        CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> completablefuture = this.m_140026_();
        Either<LevelChunk, ChunkLoadingFailure> either = completablefuture.getNow((Either<LevelChunk, ChunkLoadingFailure>)((Either)null));
        return either == null ? null : either.left().orElse(null);
    }

    public CompletableFuture<?> m_294134_() {
        return this.f_290310_;
    }

    @Nullable
    public LevelChunk m_295552_() {
        return !this.f_290310_.isDone() ? null : this.m_140085_();
    }

    @Nullable
    public LevelChunk m_212234_() {
        CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> completablefuture = this.m_140082_();
        Either<LevelChunk, ChunkLoadingFailure> either = completablefuture.getNow((Either<LevelChunk, ChunkLoadingFailure>)((Either)null));
        return either == null ? null : either.left().orElse(null);
    }

    @Nullable
    public ChunkStatus m_140088_() {
        for (int i = f_139999_.size() - 1; i >= 0; --i) {
            ChunkStatus chunkstatus = f_139999_.get(i);
            CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> completablefuture = this.m_140047_(chunkstatus);
            if (!completablefuture.getNow(f_139995_).left().isPresent()) continue;
            return chunkstatus;
        }
        return null;
    }

    @Nullable
    public ChunkAccess m_140089_() {
        for (int i = f_139999_.size() - 1; i >= 0; --i) {
            Optional optional;
            ChunkStatus chunkstatus = f_139999_.get(i);
            CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> completablefuture = this.m_140047_(chunkstatus);
            if (completablefuture.isCompletedExceptionally() || !(optional = completablefuture.getNow(f_139995_).left()).isPresent()) continue;
            return (ChunkAccess)optional.get();
        }
        return null;
    }

    public CompletableFuture<ChunkAccess> m_140090_() {
        return this.f_140005_;
    }

    public void m_140056_(BlockPos p_140057_) {
        LevelChunk levelchunk = this.m_140085_();
        if (levelchunk != null) {
            int i = this.f_142983_.m_151564_(p_140057_.m_123342_());
            if (this.f_140011_[i] == null) {
                this.f_140010_ = true;
                this.f_140011_[i] = new ShortOpenHashSet();
            }
            this.f_140011_[i].add(SectionPos.m_123218_(p_140057_));
        }
    }

    public void m_140036_(LightLayer p_140037_, int p_140038_) {
        ChunkAccess chunkaccess;
        Either<ChunkAccess, ChunkLoadingFailure> either = this.m_140080_(ChunkStatus.f_279614_).getNow((Either<ChunkAccess, ChunkLoadingFailure>)((Either)null));
        if (either != null && (chunkaccess = either.left().orElse(null)) != null) {
            chunkaccess.m_8092_(true);
            LevelChunk levelchunk = this.m_140085_();
            if (levelchunk != null) {
                int i = this.f_140014_.m_164447_();
                int j = this.f_140014_.m_164448_();
                if (p_140038_ >= i && p_140038_ <= j) {
                    int k = p_140038_ - i;
                    if (p_140037_ == LightLayer.SKY) {
                        this.f_140013_.set(k);
                    } else {
                        this.f_140012_.set(k);
                    }
                }
            }
        }
    }

    public void m_140054_(LevelChunk p_140055_) {
        if (this.f_140010_ || !this.f_140013_.isEmpty() || !this.f_140012_.isEmpty()) {
            Level level = p_140055_.m_62953_();
            if (!this.f_140013_.isEmpty() || !this.f_140012_.isEmpty()) {
                List<ServerPlayer> list = this.f_140016_.m_183262_(this.f_140009_, true);
                if (!list.isEmpty()) {
                    ClientboundLightUpdatePacket clientboundlightupdatepacket = new ClientboundLightUpdatePacket(p_140055_.m_7697_(), this.f_140014_, this.f_140013_, this.f_140012_);
                    this.m_288202_(list, clientboundlightupdatepacket);
                }
                this.f_140013_.clear();
                this.f_140012_.clear();
            }
            if (this.f_140010_) {
                List<ServerPlayer> list1 = this.f_140016_.m_183262_(this.f_140009_, false);
                for (int j = 0; j < this.f_140011_.length; ++j) {
                    ShortSet shortset = this.f_140011_[j];
                    if (shortset == null) continue;
                    this.f_140011_[j] = null;
                    if (list1.isEmpty()) continue;
                    int i = this.f_142983_.m_151568_(j);
                    SectionPos sectionpos = SectionPos.m_123196_(p_140055_.m_7697_(), i);
                    if (shortset.size() == 1) {
                        BlockPos blockpos = sectionpos.m_123245_(shortset.iterator().nextShort());
                        BlockState blockstate = level.m_8055_(blockpos);
                        this.m_288202_(list1, new ClientboundBlockUpdatePacket(blockpos, blockstate));
                        this.m_288224_(list1, level, blockpos, blockstate);
                        continue;
                    }
                    LevelChunkSection levelchunksection = p_140055_.m_183278_(j);
                    ClientboundSectionBlocksUpdatePacket clientboundsectionblocksupdatepacket = new ClientboundSectionBlocksUpdatePacket(sectionpos, shortset, levelchunksection);
                    this.m_288202_(list1, clientboundsectionblocksupdatepacket);
                    clientboundsectionblocksupdatepacket.m_132992_((p_288761_, p_288762_) -> this.m_288224_(list1, level, (BlockPos)p_288761_, (BlockState)p_288762_));
                }
                this.f_140010_ = false;
            }
        }
    }

    private void m_288224_(List<ServerPlayer> p_288982_, Level p_289011_, BlockPos p_288969_, BlockState p_288973_) {
        if (p_288973_.m_155947_()) {
            this.m_288223_(p_288982_, p_289011_, p_288969_);
        }
    }

    private void m_288223_(List<ServerPlayer> p_288988_, Level p_289005_, BlockPos p_288981_) {
        Packet<ClientGamePacketListener> packet;
        BlockEntity blockentity = p_289005_.m_7702_(p_288981_);
        if (blockentity != null && (packet = blockentity.m_58483_()) != null) {
            this.m_288202_(p_288988_, packet);
        }
    }

    private void m_288202_(List<ServerPlayer> p_288998_, Packet<?> p_289013_) {
        p_288998_.forEach(p_296560_ -> p_296560_.f_8906_.m_141995_(p_289013_));
    }

    public CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> m_140049_(ChunkStatus p_140050_, ChunkMap p_140051_) {
        int i = p_140050_.m_62445_();
        CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> completablefuture = this.f_140001_.get(i);
        if (completablefuture != null) {
            Either<ChunkAccess, ChunkLoadingFailure> either = completablefuture.getNow(f_203750_);
            if (either == null) {
                String s = "value in future for status: " + p_140050_ + " was incorrectly set to null at chunk: " + this.f_140009_;
                throw p_140051_.m_203751_(new IllegalStateException("null value previously set for chunk status"), s);
            }
            if (either == f_203750_ || either.right().isEmpty()) {
                return completablefuture;
            }
        }
        if (ChunkLevel.m_287158_(this.f_140007_).m_62427_(p_140050_)) {
            CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> completablefuture1 = p_140051_.m_140292_(this, p_140050_);
            this.m_143017_(completablefuture1, "schedule " + p_140050_);
            this.f_140001_.set(i, completablefuture1);
            return completablefuture1;
        }
        return completablefuture == null ? f_139996_ : completablefuture;
    }

    protected void m_200416_(String p_200417_, CompletableFuture<?> p_200418_) {
        if (this.f_142984_ != null) {
            this.f_142984_.m_144625_(new ChunkSaveDebug(Thread.currentThread(), p_200418_, p_200417_));
        }
        this.f_140005_ = this.f_140005_.thenCombine(p_200418_, (p_200414_, p_200415_) -> p_200414_);
    }

    private void m_143017_(CompletableFuture<? extends Either<? extends ChunkAccess, ChunkLoadingFailure>> p_143018_, String p_143019_) {
        if (this.f_142984_ != null) {
            this.f_142984_.m_144625_(new ChunkSaveDebug(Thread.currentThread(), p_143018_, p_143019_));
        }
        this.f_140005_ = this.f_140005_.thenCombine(p_143018_, (p_200411_, p_200412_) -> (ChunkAccess)p_200412_.map(p_200406_ -> p_200406_, p_200409_ -> p_200411_));
    }

    public void m_295085_(CompletableFuture<?> p_300440_) {
        this.f_290310_ = this.f_290310_.isDone() ? p_300440_ : this.f_290310_.thenCombine(p_300440_, (p_296561_, p_296562_) -> null);
    }

    public FullChunkStatus m_287213_() {
        return ChunkLevel.m_287264_(this.f_140007_);
    }

    public ChunkPos m_140092_() {
        return this.f_140009_;
    }

    public int m_140093_() {
        return this.f_140007_;
    }

    public int m_140094_() {
        return this.f_140008_;
    }

    private void m_140086_(int p_140087_) {
        this.f_140008_ = p_140087_;
    }

    public void m_140027_(int p_140028_) {
        this.f_140007_ = p_140028_;
    }

    private void m_142998_(ChunkMap p_142999_, CompletableFuture<Either<LevelChunk, ChunkLoadingFailure>> p_143000_, Executor p_143001_, FullChunkStatus p_287621_) {
        this.f_142981_.cancel(false);
        CompletableFuture completablefuture = new CompletableFuture();
        completablefuture.thenRunAsync(() -> p_142999_.m_287285_(this.f_140009_, p_287621_), p_143001_);
        this.f_142981_ = completablefuture;
        p_143000_.thenAccept(p_200421_ -> p_200421_.ifLeft(p_200424_ -> completablefuture.complete(null)));
    }

    private void m_287189_(ChunkMap p_287599_, FullChunkStatus p_287649_) {
        this.f_142981_.cancel(false);
        p_287599_.m_287285_(this.f_140009_, p_287649_);
    }

    protected void m_143003_(ChunkMap p_143004_, Executor p_143005_) {
        ChunkStatus chunkstatus = ChunkLevel.m_287158_(this.f_140006_);
        ChunkStatus chunkstatus1 = ChunkLevel.m_287158_(this.f_140007_);
        boolean flag = ChunkLevel.m_287217_(this.f_140006_);
        boolean flag1 = ChunkLevel.m_287217_(this.f_140007_);
        FullChunkStatus fullchunkstatus = ChunkLevel.m_287264_(this.f_140006_);
        FullChunkStatus fullchunkstatus1 = ChunkLevel.m_287264_(this.f_140007_);
        if (flag) {
            int i;
            Either either = Either.right((Object)new ChunkLoadingFailure(){

                public String toString() {
                    return "Unloaded ticket level " + ChunkHolder.this.f_140009_;
                }
            });
            int n = i = flag1 ? chunkstatus1.m_62445_() + 1 : 0;
            while (i <= chunkstatus.m_62445_()) {
                CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> completablefuture = this.f_140001_.get(i);
                if (completablefuture == null) {
                    this.f_140001_.set(i, CompletableFuture.completedFuture(either));
                }
                ++i;
            }
        }
        boolean flag5 = fullchunkstatus.m_287205_(FullChunkStatus.FULL);
        boolean flag6 = fullchunkstatus1.m_287205_(FullChunkStatus.FULL);
        this.f_140017_ |= flag6;
        if (!flag5 && flag6) {
            this.f_140002_ = p_143004_.m_143109_(this);
            this.m_142998_(p_143004_, this.f_140002_, p_143005_, FullChunkStatus.FULL);
            this.m_143017_(this.f_140002_, "full");
        }
        if (flag5 && !flag6) {
            this.f_140002_.complete(f_139997_);
            this.f_140002_ = f_139998_;
        }
        boolean flag7 = fullchunkstatus.m_287205_(FullChunkStatus.BLOCK_TICKING);
        boolean flag2 = fullchunkstatus1.m_287205_(FullChunkStatus.BLOCK_TICKING);
        if (!flag7 && flag2) {
            this.f_140003_ = p_143004_.m_143053_(this);
            this.m_142998_(p_143004_, this.f_140003_, p_143005_, FullChunkStatus.BLOCK_TICKING);
            this.m_143017_(this.f_140003_, "ticking");
        }
        if (flag7 && !flag2) {
            this.f_140003_.complete(f_139997_);
            this.f_140003_ = f_139998_;
        }
        boolean flag3 = fullchunkstatus.m_287205_(FullChunkStatus.ENTITY_TICKING);
        boolean flag4 = fullchunkstatus1.m_287205_(FullChunkStatus.ENTITY_TICKING);
        if (!flag3 && flag4) {
            if (this.f_140004_ != f_139998_) {
                throw Util.m_137570_(new IllegalStateException());
            }
            this.f_140004_ = p_143004_.m_280208_(this);
            this.m_142998_(p_143004_, this.f_140004_, p_143005_, FullChunkStatus.ENTITY_TICKING);
            this.m_143017_(this.f_140004_, "entity ticking");
        }
        if (flag3 && !flag4) {
            this.f_140004_.complete(f_139997_);
            this.f_140004_ = f_139998_;
        }
        if (!fullchunkstatus1.m_287205_(fullchunkstatus)) {
            this.m_287189_(p_143004_, fullchunkstatus1);
        }
        this.f_140015_.m_6250_(this.f_140009_, this::m_140094_, this.f_140007_, this::m_140086_);
        this.f_140006_ = this.f_140007_;
    }

    public boolean m_140095_() {
        return this.f_140017_;
    }

    public void m_140096_() {
        this.f_140017_ = ChunkLevel.m_287264_(this.f_140007_).m_287205_(FullChunkStatus.FULL);
    }

    public void m_140052_(ImposterProtoChunk p_140053_) {
        for (int i = 0; i < this.f_140001_.length(); ++i) {
            Optional optional;
            CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>> completablefuture = this.f_140001_.get(i);
            if (completablefuture == null || (optional = completablefuture.getNow(f_139995_).left()).isEmpty() || !(optional.get() instanceof ProtoChunk)) continue;
            this.f_140001_.set(i, CompletableFuture.completedFuture(Either.left((Object)p_140053_)));
        }
        this.m_143017_(CompletableFuture.completedFuture(Either.left((Object)p_140053_.m_62768_())), "replaceProto");
    }

    public List<Pair<ChunkStatus, CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>>>> m_202980_() {
        ArrayList<Pair<ChunkStatus, CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>>>> list = new ArrayList<Pair<ChunkStatus, CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>>>>();
        for (int i = 0; i < f_139999_.size(); ++i) {
            list.add((Pair<ChunkStatus, CompletableFuture<Either<ChunkAccess, ChunkLoadingFailure>>>)Pair.of((Object)f_139999_.get(i), this.f_140001_.get(i)));
        }
        return list;
    }

    @FunctionalInterface
    public static interface LevelChangeListener {
        public void m_6250_(ChunkPos var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface PlayerProvider {
        public List<ServerPlayer> m_183262_(ChunkPos var1, boolean var2);
    }

    static final class ChunkSaveDebug {
        private final Thread f_143023_;
        private final CompletableFuture<?> f_143024_;
        private final String f_143025_;

        ChunkSaveDebug(Thread p_143027_, CompletableFuture<?> p_143028_, String p_143029_) {
            this.f_143023_ = p_143027_;
            this.f_143024_ = p_143028_;
            this.f_143025_ = p_143029_;
        }
    }

    public static interface ChunkLoadingFailure {
        public static final ChunkLoadingFailure f_140101_ = new ChunkLoadingFailure(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }
}

