/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Comparators;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class PlayerChunkSender {
    private static final Logger f_291358_ = LogUtils.getLogger();
    public static final float f_291084_ = 0.01f;
    public static final float f_291160_ = 64.0f;
    private static final float f_291062_ = 9.0f;
    private static final int f_290748_ = 10;
    private final LongSet f_290689_ = new LongOpenHashSet();
    private final boolean f_291779_;
    private float f_290316_ = 9.0f;
    private float f_290940_;
    private int f_291052_;
    private int f_290413_ = 1;

    public PlayerChunkSender(boolean p_300389_) {
        this.f_291779_ = p_300389_;
    }

    public void m_293202_(LevelChunk p_298187_) {
        this.f_290689_.add(p_298187_.m_7697_().m_45588_());
    }

    public void m_293883_(ServerPlayer p_298166_, ChunkPos p_300687_) {
        if (!this.f_290689_.remove(p_300687_.m_45588_()) && p_298166_.m_6084_()) {
            p_298166_.f_8906_.m_141995_(new ClientboundForgetLevelChunkPacket(p_300687_));
            ForgeEventFactory.fireChunkUnWatch((ServerPlayer)p_298166_, (ChunkPos)p_300687_, (ServerLevel)((ServerLevel)p_298166_.m_9236_()));
        }
    }

    public void m_295003_(ServerPlayer p_297274_) {
        if (this.f_291052_ < this.f_290413_) {
            float f = Math.max(1.0f, this.f_290316_);
            this.f_290940_ = Math.min(this.f_290940_ + this.f_290316_, f);
            if (!(this.f_290940_ < 1.0f) && !this.f_290689_.isEmpty()) {
                ServerLevel serverlevel = p_297274_.m_284548_();
                ChunkMap chunkmap = serverlevel.m_7726_().f_8325_;
                List<LevelChunk> list = this.m_296019_(chunkmap, p_297274_.m_146902_());
                if (!list.isEmpty()) {
                    ServerGamePacketListenerImpl servergamepacketlistenerimpl = p_297274_.f_8906_;
                    ++this.f_291052_;
                    servergamepacketlistenerimpl.m_141995_(new ClientboundChunkBatchStartPacket());
                    for (LevelChunk levelchunk : list) {
                        PlayerChunkSender.m_293861_(servergamepacketlistenerimpl, serverlevel, levelchunk);
                    }
                    servergamepacketlistenerimpl.m_141995_(new ClientboundChunkBatchFinishedPacket(list.size()));
                    this.f_290940_ -= (float)list.size();
                }
            }
        }
    }

    private static void m_293861_(ServerGamePacketListenerImpl p_299748_, ServerLevel p_298120_, LevelChunk p_297712_) {
        p_299748_.m_141995_(new ClientboundLevelChunkWithLightPacket(p_297712_, p_298120_.m_5518_(), null, null));
        ChunkPos chunkpos = p_297712_.m_7697_();
        DebugPackets.m_133676_(p_298120_, chunkpos);
        ForgeEventFactory.fireChunkWatch((ServerPlayer)p_299748_.f_9743_, (LevelChunk)p_297712_, (ServerLevel)p_298120_);
    }

    private List<LevelChunk> m_296019_(ChunkMap p_298180_, ChunkPos p_298514_) {
        int i = Mth.m_14143_(this.f_290940_);
        List<LevelChunk> list = !this.f_291779_ && this.f_290689_.size() > i ? ((List)this.f_290689_.stream().collect(Comparators.least((int)i, Comparator.comparingInt(p_298514_::m_294557_)))).stream().mapToLong(Long::longValue).mapToObj(p_298180_::m_295187_).filter(Objects::nonNull).toList() : this.f_290689_.longStream().mapToObj(p_298180_::m_295187_).filter(Objects::nonNull).sorted(Comparator.comparingInt(p_299102_ -> p_298514_.m_293627_(p_299102_.m_7697_()))).toList();
        for (LevelChunk levelchunk : list) {
            this.f_290689_.remove(levelchunk.m_7697_().m_45588_());
        }
        return list;
    }

    public void m_293508_(float p_298238_) {
        --this.f_291052_;
        float f = this.f_290316_ = Double.isNaN(p_298238_) ? 0.01f : Mth.m_14036_(p_298238_, 0.01f, 64.0f);
        if (this.f_291052_ == 0) {
            this.f_290940_ = 1.0f;
        }
        this.f_290413_ = 10;
    }

    public boolean m_296008_(long p_299869_) {
        return this.f_290689_.contains(p_299869_);
    }
}

