/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class DownloadCacheCleaner {
    private static final Logger f_303196_ = LogUtils.getLogger();

    public static void m_307501_(Path p_311487_, int p_312653_) {
        try {
            List<PathAndTime> $$2 = DownloadCacheCleaner.m_305409_(p_311487_);
            int $$3 = $$2.size() - p_312653_;
            if ($$3 <= 0) {
                return;
            }
            $$2.sort(PathAndTime.f_302218_);
            List<PathAndPriority> $$4 = DownloadCacheCleaner.m_305891_($$2);
            Collections.reverse($$4);
            $$4.sort(PathAndPriority.f_302746_);
            HashSet<Path> $$5 = new HashSet<Path>();
            for (int $$6 = 0; $$6 < $$3; ++$$6) {
                PathAndPriority $$7 = $$4.get($$6);
                Path $$8 = $$7.f_302336_;
                try {
                    Files.delete($$8);
                    if ($$7.f_303116_ != 0) continue;
                    $$5.add($$8.getParent());
                    continue;
                }
                catch (IOException $$9) {
                    f_303196_.warn("Failed to delete cache file {}", (Object)$$8, (Object)$$9);
                }
            }
            $$5.remove(p_311487_);
            for (Path $$10 : $$5) {
                try {
                    Files.delete($$10);
                }
                catch (DirectoryNotEmptyException $$8) {
                }
                catch (IOException $$11) {
                    f_303196_.warn("Failed to delete empty(?) cache directory {}", (Object)$$10, (Object)$$11);
                }
            }
        }
        catch (IOException | UncheckedIOException $$12) {
            f_303196_.error("Failed to vacuum cache dir {}", (Object)p_311487_, (Object)$$12);
        }
    }

    private static List<PathAndTime> m_305409_(final Path p_311706_) throws IOException {
        try {
            final ArrayList<PathAndTime> $$1 = new ArrayList<PathAndTime>();
            Files.walkFileTree(p_311706_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p_312027_, BasicFileAttributes p_309596_) {
                    if (p_309596_.isRegularFile() && !p_312027_.getParent().equals(p_311706_)) {
                        FileTime $$2 = p_309596_.lastModifiedTime();
                        $$1.add(new PathAndTime(p_312027_, $$2));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.visitFile((Path)object, basicFileAttributes);
                }
            });
            return $$1;
        }
        catch (NoSuchFileException $$2) {
            return List.of();
        }
    }

    private static List<PathAndPriority> m_305891_(List<PathAndTime> p_312641_) {
        ArrayList<PathAndPriority> $$1 = new ArrayList<PathAndPriority>();
        Object2IntOpenHashMap $$2 = new Object2IntOpenHashMap();
        for (PathAndTime $$3 : p_312641_) {
            int $$4 = $$2.addTo((Object)$$3.f_303548_.getParent(), 1);
            $$1.add(new PathAndPriority($$3.f_303548_, $$4));
        }
        return $$1;
    }

    record PathAndTime(Path f_303548_, FileTime f_303326_) {
        public static final Comparator<PathAndTime> f_302218_ = Comparator.comparing(PathAndTime::f_303326_).reversed();

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PathAndTime.class, "path;modifiedTime", "f_303548_", "f_303326_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PathAndTime.class, "path;modifiedTime", "f_303548_", "f_303326_"}, this);
        }

        @Override
        public final boolean equals(Object p_312587_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PathAndTime.class, "path;modifiedTime", "f_303548_", "f_303326_"}, this, p_312587_);
        }
    }

    record PathAndPriority(Path f_302336_, int f_303116_) {
        public static final Comparator<PathAndPriority> f_302746_ = Comparator.comparing(PathAndPriority::f_303116_).reversed();

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PathAndPriority.class, "path;removalPriority", "f_302336_", "f_303116_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PathAndPriority.class, "path;removalPriority", "f_302336_", "f_303116_"}, this);
        }

        @Override
        public final boolean equals(Object p_312037_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PathAndPriority.class, "path;removalPriority", "f_302336_", "f_303116_"}, this, p_312037_);
        }
    }
}

