/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class RandomSequences
extends SavedData {
    private static final Logger f_286984_ = LogUtils.getLogger();
    private final long f_290669_;
    private int f_290528_;
    private boolean f_291706_ = true;
    private boolean f_291446_ = true;
    private final Map<ResourceLocation, RandomSequence> f_286954_ = new Object2ObjectOpenHashMap();

    public static SavedData.Factory<RandomSequences> m_295760_(long p_297402_) {
        return new SavedData.Factory<RandomSequences>(() -> new RandomSequences(p_297402_), p_296656_ -> RandomSequences.m_287187_(p_297402_, p_296656_), DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES);
    }

    public RandomSequences(long p_287622_) {
        this.f_290669_ = p_287622_;
    }

    public RandomSource m_287292_(ResourceLocation p_287751_) {
        RandomSource $$1 = this.f_286954_.computeIfAbsent(p_287751_, this::m_294862_).m_287244_();
        return new DirtyMarkingRandomSource($$1);
    }

    private RandomSequence m_294862_(ResourceLocation p_299723_) {
        return this.m_292708_(p_299723_, this.f_290528_, this.f_291706_, this.f_291446_);
    }

    private RandomSequence m_292708_(ResourceLocation p_299881_, int p_299267_, boolean p_300525_, boolean p_297272_) {
        long $$4 = (p_300525_ ? this.f_290669_ : 0L) ^ (long)p_299267_;
        return new RandomSequence($$4, p_297272_ ? Optional.of(p_299881_) : Optional.empty());
    }

    public void m_293664_(BiConsumer<ResourceLocation, RandomSequence> p_299883_) {
        this.f_286954_.forEach(p_299883_);
    }

    public void m_293057_(int p_299968_, boolean p_298395_, boolean p_298518_) {
        this.f_290528_ = p_299968_;
        this.f_291706_ = p_298395_;
        this.f_291446_ = p_298518_;
    }

    @Override
    public CompoundTag m_7176_(CompoundTag p_287658_) {
        p_287658_.m_128405_("salt", this.f_290528_);
        p_287658_.m_128379_("include_world_seed", this.f_291706_);
        p_287658_.m_128379_("include_sequence_id", this.f_291446_);
        CompoundTag $$1 = new CompoundTag();
        this.f_286954_.forEach((p_287627_, p_287578_) -> $$1.m_128365_(p_287627_.toString(), (Tag)RandomSequence.f_286999_.encodeStart((DynamicOps)NbtOps.f_128958_, p_287578_).result().orElseThrow()));
        p_287658_.m_128365_("sequences", $$1);
        return p_287658_;
    }

    private static boolean m_295631_(CompoundTag p_297418_, String p_298953_, boolean p_297237_) {
        if (p_297418_.m_128425_(p_298953_, 1)) {
            return p_297418_.m_128471_(p_298953_);
        }
        return p_297237_;
    }

    public static RandomSequences m_287187_(long p_287756_, CompoundTag p_287587_) {
        RandomSequences $$2 = new RandomSequences(p_287756_);
        $$2.m_293057_(p_287587_.m_128451_("salt"), RandomSequences.m_295631_(p_287587_, "include_world_seed", true), RandomSequences.m_295631_(p_287587_, "include_sequence_id", true));
        CompoundTag $$3 = p_287587_.m_128469_("sequences");
        Set<String> $$4 = $$3.m_128431_();
        for (String $$5 : $$4) {
            try {
                RandomSequence $$6 = (RandomSequence)((Pair)RandomSequence.f_286999_.decode((DynamicOps)NbtOps.f_128958_, (Object)$$3.m_128423_($$5)).result().get()).getFirst();
                $$2.f_286954_.put(new ResourceLocation($$5), $$6);
            }
            catch (Exception $$7) {
                f_286984_.error("Failed to load random sequence {}", (Object)$$5, (Object)$$7);
            }
        }
        return $$2;
    }

    public int m_292818_() {
        int $$0 = this.f_286954_.size();
        this.f_286954_.clear();
        return $$0;
    }

    public void m_294388_(ResourceLocation p_298741_) {
        this.f_286954_.put(p_298741_, this.m_294862_(p_298741_));
    }

    public void m_295700_(ResourceLocation p_301350_, int p_298554_, boolean p_298049_, boolean p_301283_) {
        this.f_286954_.put(p_301350_, this.m_292708_(p_301350_, p_298554_, p_298049_, p_301283_));
    }

    class DirtyMarkingRandomSource
    implements RandomSource {
        private final RandomSource f_290870_;

        DirtyMarkingRandomSource(RandomSource p_299209_) {
            this.f_290870_ = p_299209_;
        }

        @Override
        public RandomSource m_213769_() {
            RandomSequences.this.m_77762_();
            return this.f_290870_.m_213769_();
        }

        @Override
        public PositionalRandomFactory m_188582_() {
            RandomSequences.this.m_77762_();
            return this.f_290870_.m_188582_();
        }

        @Override
        public void m_188584_(long p_300098_) {
            RandomSequences.this.m_77762_();
            this.f_290870_.m_188584_(p_300098_);
        }

        @Override
        public int m_188502_() {
            RandomSequences.this.m_77762_();
            return this.f_290870_.m_188502_();
        }

        @Override
        public int m_188503_(int p_301106_) {
            RandomSequences.this.m_77762_();
            return this.f_290870_.m_188503_(p_301106_);
        }

        @Override
        public long m_188505_() {
            RandomSequences.this.m_77762_();
            return this.f_290870_.m_188505_();
        }

        @Override
        public boolean m_188499_() {
            RandomSequences.this.m_77762_();
            return this.f_290870_.m_188499_();
        }

        @Override
        public float m_188501_() {
            RandomSequences.this.m_77762_();
            return this.f_290870_.m_188501_();
        }

        @Override
        public double m_188500_() {
            RandomSequences.this.m_77762_();
            return this.f_290870_.m_188500_();
        }

        @Override
        public double m_188583_() {
            RandomSequences.this.m_77762_();
            return this.f_290870_.m_188583_();
        }

        public boolean equals(Object p_299603_) {
            if (this == p_299603_) {
                return true;
            }
            if (p_299603_ instanceof DirtyMarkingRandomSource) {
                DirtyMarkingRandomSource $$1 = (DirtyMarkingRandomSource)p_299603_;
                return this.f_290870_.equals($$1.f_290870_);
            }
            return false;
        }
    }
}

