/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger f_268644_ = LogUtils.getLogger();
    public static final int f_268638_ = -1;
    private static final EntityDataAccessor<Integer> f_291687_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> f_290650_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> f_291382_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Vector3f> f_268598_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> f_268489_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Quaternionf> f_268693_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_268624_);
    private static final EntityDataAccessor<Quaternionf> f_268713_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_268624_);
    private static final EntityDataAccessor<Byte> f_268593_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> f_268599_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> f_268421_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> f_268527_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> f_268708_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> f_268532_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> f_268639_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> f_268687_ = SynchedEntityData.m_135353_(Display.class, EntityDataSerializers.f_135028_);
    private static final IntSet f_276582_ = IntSet.of((int[])new int[]{f_268598_.m_135015_(), f_268489_.m_135015_(), f_268693_.m_135015_(), f_268713_.m_135015_(), f_268593_.m_135015_(), f_268599_.m_135015_(), f_268527_.m_135015_(), f_268708_.m_135015_()});
    private static final float f_268480_ = 0.0f;
    private static final float f_268460_ = 1.0f;
    private static final int f_268716_ = -1;
    public static final String f_290493_ = "teleport_duration";
    public static final String f_291794_ = "interpolation_duration";
    public static final String f_290397_ = "start_interpolation";
    public static final String f_268715_ = "transformation";
    public static final String f_268514_ = "billboard";
    public static final String f_268506_ = "brightness";
    public static final String f_268647_ = "view_range";
    public static final String f_268520_ = "shadow_radius";
    public static final String f_268507_ = "shadow_strength";
    public static final String f_268743_ = "width";
    public static final String f_268633_ = "height";
    public static final String f_268537_ = "glow_color_override";
    private long f_271381_ = Integer.MIN_VALUE;
    private int f_276631_;
    private float f_276153_;
    private AABB f_268702_;
    protected boolean f_276470_;
    private boolean f_276444_;
    private boolean f_276570_;
    @Nullable
    private RenderState f_276646_;
    @Nullable
    private PosRotInterpolationTarget f_291647_;

    public Display(EntityType<?> p_270360_, Level p_270280_) {
        super(p_270360_, p_270280_);
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.f_268702_ = this.m_20191_();
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> p_270275_) {
        super.m_7350_(p_270275_);
        if (f_268639_.equals(p_270275_) || f_268532_.equals(p_270275_)) {
            this.m_269361_();
        }
        if (f_291687_.equals(p_270275_)) {
            this.f_276444_ = true;
        }
        if (f_290650_.equals(p_270275_)) {
            this.f_276570_ = true;
        }
        if (f_276582_.contains(p_270275_.m_135015_())) {
            this.f_276470_ = true;
        }
    }

    private static Transformation m_269448_(SynchedEntityData p_270278_) {
        Vector3f $$1 = p_270278_.m_135370_(f_268598_);
        Quaternionf $$2 = p_270278_.m_135370_(f_268693_);
        Vector3f $$3 = p_270278_.m_135370_(f_268489_);
        Quaternionf $$4 = p_270278_.m_135370_(f_268713_);
        return new Transformation($$1, $$2, $$3, $$4);
    }

    @Override
    public void m_8119_() {
        Entity $$0 = this.m_20202_();
        if ($$0 != null && $$0.m_213877_()) {
            this.m_8127_();
        }
        if (this.m_9236_().f_46443_) {
            if (this.f_276444_) {
                this.f_276444_ = false;
                int $$1 = this.m_294688_();
                this.f_271381_ = this.f_19797_ + $$1;
            }
            if (this.f_276570_) {
                this.f_276570_ = false;
                this.f_276631_ = this.m_295061_();
            }
            if (this.f_276470_) {
                this.f_276470_ = false;
                boolean $$2 = this.f_276631_ != 0;
                this.f_276646_ = $$2 && this.f_276646_ != null ? this.m_277098_(this.f_276646_, this.f_276153_) : this.m_277152_();
                this.m_276825_($$2, this.f_276153_);
            }
            if (this.f_291647_ != null) {
                if (this.f_291647_.f_290672_ == 0) {
                    this.f_291647_.m_294804_(this);
                    this.m_146867_();
                    this.f_291647_ = null;
                } else {
                    this.f_291647_.m_293331_(this);
                    --this.f_291647_.f_290672_;
                    if (this.f_291647_.f_290672_ == 0) {
                        this.f_291647_ = null;
                    }
                }
            }
        }
    }

    protected abstract void m_276825_(boolean var1, float var2);

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(f_291382_, 0);
        this.f_19804_.m_135372_(f_291687_, 0);
        this.f_19804_.m_135372_(f_290650_, 0);
        this.f_19804_.m_135372_(f_268598_, new Vector3f());
        this.f_19804_.m_135372_(f_268489_, new Vector3f(1.0f, 1.0f, 1.0f));
        this.f_19804_.m_135372_(f_268713_, new Quaternionf());
        this.f_19804_.m_135372_(f_268693_, new Quaternionf());
        this.f_19804_.m_135372_(f_268593_, BillboardConstraints.FIXED.m_269016_());
        this.f_19804_.m_135372_(f_268599_, -1);
        this.f_19804_.m_135372_(f_268421_, Float.valueOf(1.0f));
        this.f_19804_.m_135372_(f_268527_, Float.valueOf(0.0f));
        this.f_19804_.m_135372_(f_268708_, Float.valueOf(1.0f));
        this.f_19804_.m_135372_(f_268532_, Float.valueOf(0.0f));
        this.f_19804_.m_135372_(f_268639_, Float.valueOf(0.0f));
        this.f_19804_.m_135372_(f_268687_, -1);
    }

    @Override
    protected void m_7378_(CompoundTag p_270854_) {
        if (p_270854_.m_128441_(f_268715_)) {
            Transformation.f_268620_.decode((DynamicOps)NbtOps.f_128958_, (Object)p_270854_.m_128423_(f_268715_)).resultOrPartial(Util.m_137489_("Display entity", arg_0 -> ((Logger)f_268644_).error(arg_0))).ifPresent(p_270952_ -> this.m_269214_((Transformation)p_270952_.getFirst()));
        }
        if (p_270854_.m_128425_(f_291794_, 99)) {
            int $$1 = p_270854_.m_128451_(f_291794_);
            this.m_294351_($$1);
        }
        if (p_270854_.m_128425_(f_290397_, 99)) {
            int $$2 = p_270854_.m_128451_(f_290397_);
            this.m_294622_($$2);
        }
        if (p_270854_.m_128425_(f_290493_, 99)) {
            int $$3 = p_270854_.m_128451_(f_290493_);
            this.m_292636_(Mth.m_14045_($$3, 0, 59));
        }
        if (p_270854_.m_128425_(f_268514_, 8)) {
            BillboardConstraints.f_268505_.decode((DynamicOps)NbtOps.f_128958_, (Object)p_270854_.m_128423_(f_268514_)).resultOrPartial(Util.m_137489_("Display entity", arg_0 -> ((Logger)f_268644_).error(arg_0))).ifPresent(p_270691_ -> this.m_269423_((BillboardConstraints)p_270691_.getFirst()));
        }
        if (p_270854_.m_128425_(f_268647_, 99)) {
            this.m_269215_(p_270854_.m_128457_(f_268647_));
        }
        if (p_270854_.m_128425_(f_268520_, 99)) {
            this.m_269526_(p_270854_.m_128457_(f_268520_));
        }
        if (p_270854_.m_128425_(f_268507_, 99)) {
            this.m_269228_(p_270854_.m_128457_(f_268507_));
        }
        if (p_270854_.m_128425_(f_268743_, 99)) {
            this.m_269441_(p_270854_.m_128457_(f_268743_));
        }
        if (p_270854_.m_128425_(f_268633_, 99)) {
            this.m_269087_(p_270854_.m_128457_(f_268633_));
        }
        if (p_270854_.m_128425_(f_268537_, 99)) {
            this.m_269026_(p_270854_.m_128451_(f_268537_));
        }
        if (p_270854_.m_128425_(f_268506_, 10)) {
            Brightness.f_268672_.decode((DynamicOps)NbtOps.f_128958_, (Object)p_270854_.m_128423_(f_268506_)).resultOrPartial(Util.m_137489_("Display entity", arg_0 -> ((Logger)f_268644_).error(arg_0))).ifPresent(p_270247_ -> this.m_269586_((Brightness)p_270247_.getFirst()));
        } else {
            this.m_269586_(null);
        }
    }

    private void m_269214_(Transformation p_270186_) {
        this.f_19804_.m_135381_(f_268598_, p_270186_.m_252829_());
        this.f_19804_.m_135381_(f_268693_, p_270186_.m_253244_());
        this.f_19804_.m_135381_(f_268489_, p_270186_.m_252900_());
        this.f_19804_.m_135381_(f_268713_, p_270186_.m_252848_());
    }

    @Override
    protected void m_7380_(CompoundTag p_270779_) {
        Transformation.f_268620_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)Display.m_269448_(this.f_19804_)).result().ifPresent(p_270528_ -> p_270779_.m_128365_(f_268715_, (Tag)p_270528_));
        BillboardConstraints.f_268505_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.m_269218_()).result().ifPresent(p_270227_ -> p_270779_.m_128365_(f_268514_, (Tag)p_270227_));
        p_270779_.m_128405_(f_291794_, this.m_295061_());
        p_270779_.m_128405_(f_290493_, this.m_295284_());
        p_270779_.m_128350_(f_268647_, this.m_269081_());
        p_270779_.m_128350_(f_268520_, this.m_269459_());
        p_270779_.m_128350_(f_268507_, this.m_269155_());
        p_270779_.m_128350_(f_268743_, this.m_269558_());
        p_270779_.m_128350_(f_268633_, this.m_269410_());
        p_270779_.m_128405_(f_268537_, this.m_269034_());
        Brightness $$1 = this.m_269102_();
        if ($$1 != null) {
            Brightness.f_268672_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)$$1).result().ifPresent(p_270121_ -> p_270779_.m_128365_(f_268506_, (Tag)p_270121_));
        }
    }

    @Override
    public void m_6453_(double p_297677_, double p_301293_, double p_301384_, float p_300635_, float p_299108_, int p_299659_) {
        int $$6 = this.m_295284_();
        this.f_291647_ = new PosRotInterpolationTarget($$6, p_297677_, p_301293_, p_301384_, p_300635_, p_299108_);
    }

    @Override
    public double m_293268_() {
        return this.f_291647_ != null ? this.f_291647_.f_290957_ : this.m_20185_();
    }

    @Override
    public double m_293950_() {
        return this.f_291647_ != null ? this.f_291647_.f_290716_ : this.m_20186_();
    }

    @Override
    public double m_292720_() {
        return this.f_291647_ != null ? this.f_291647_.f_291240_ : this.m_20189_();
    }

    @Override
    public float m_293123_() {
        return this.f_291647_ != null ? (float)this.f_291647_.f_290651_ : this.m_146909_();
    }

    @Override
    public float m_293582_() {
        return this.f_291647_ != null ? (float)this.f_291647_.f_291326_ : this.m_146908_();
    }

    @Override
    public AABB m_6921_() {
        return this.f_268702_;
    }

    @Override
    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean m_6090_() {
        return true;
    }

    @Nullable
    public RenderState m_276844_() {
        return this.f_276646_;
    }

    private void m_294351_(int p_297488_) {
        this.f_19804_.m_135381_(f_290650_, p_297488_);
    }

    private int m_295061_() {
        return this.f_19804_.m_135370_(f_290650_);
    }

    private void m_294622_(int p_300640_) {
        this.f_19804_.m_276349_(f_291687_, p_300640_, true);
    }

    private int m_294688_() {
        return this.f_19804_.m_135370_(f_291687_);
    }

    private void m_292636_(int p_300107_) {
        this.f_19804_.m_135381_(f_291382_, p_300107_);
    }

    private int m_295284_() {
        return this.f_19804_.m_135370_(f_291382_);
    }

    private void m_269423_(BillboardConstraints p_270345_) {
        this.f_19804_.m_135381_(f_268593_, p_270345_.m_269016_());
    }

    private BillboardConstraints m_269218_() {
        return BillboardConstraints.f_268544_.apply(this.f_19804_.m_135370_(f_268593_).byteValue());
    }

    private void m_269586_(@Nullable Brightness p_270461_) {
        this.f_19804_.m_135381_(f_268599_, p_270461_ != null ? p_270461_.m_269595_() : -1);
    }

    @Nullable
    private Brightness m_269102_() {
        int $$0 = this.f_19804_.m_135370_(f_268599_);
        return $$0 != -1 ? Brightness.m_269373_($$0) : null;
    }

    private int m_269041_() {
        return this.f_19804_.m_135370_(f_268599_);
    }

    private void m_269215_(float p_270907_) {
        this.f_19804_.m_135381_(f_268421_, Float.valueOf(p_270907_));
    }

    private float m_269081_() {
        return this.f_19804_.m_135370_(f_268421_).floatValue();
    }

    private void m_269526_(float p_270122_) {
        this.f_19804_.m_135381_(f_268527_, Float.valueOf(p_270122_));
    }

    private float m_269459_() {
        return this.f_19804_.m_135370_(f_268527_).floatValue();
    }

    private void m_269228_(float p_270866_) {
        this.f_19804_.m_135381_(f_268708_, Float.valueOf(p_270866_));
    }

    private float m_269155_() {
        return this.f_19804_.m_135370_(f_268708_).floatValue();
    }

    private void m_269441_(float p_270741_) {
        this.f_19804_.m_135381_(f_268532_, Float.valueOf(p_270741_));
    }

    private float m_269558_() {
        return this.f_19804_.m_135370_(f_268532_).floatValue();
    }

    private void m_269087_(float p_270716_) {
        this.f_19804_.m_135381_(f_268639_, Float.valueOf(p_270716_));
    }

    private int m_269034_() {
        return this.f_19804_.m_135370_(f_268687_);
    }

    private void m_269026_(int p_270784_) {
        this.f_19804_.m_135381_(f_268687_, p_270784_);
    }

    public float m_272147_(float p_272675_) {
        float $$4;
        int $$1 = this.f_276631_;
        if ($$1 <= 0) {
            return 1.0f;
        }
        float $$2 = (long)this.f_19797_ - this.f_271381_;
        float $$3 = $$2 + p_272675_;
        this.f_276153_ = $$4 = Mth.m_14036_(Mth.m_184655_($$3, 0.0f, $$1), 0.0f, 1.0f);
        return $$4;
    }

    private float m_269410_() {
        return this.f_19804_.m_135370_(f_268639_).floatValue();
    }

    @Override
    public void m_6034_(double p_270091_, double p_270983_, double p_270419_) {
        super.m_6034_(p_270091_, p_270983_, p_270419_);
        this.m_269361_();
    }

    private void m_269361_() {
        float $$0 = this.m_269558_();
        float $$1 = this.m_269410_();
        if ($$0 == 0.0f || $$1 == 0.0f) {
            this.f_19811_ = true;
        } else {
            this.f_19811_ = false;
            float $$2 = $$0 / 2.0f;
            double $$3 = this.m_20185_();
            double $$4 = this.m_20186_();
            double $$5 = this.m_20189_();
            this.f_268702_ = new AABB($$3 - (double)$$2, $$4, $$5 - (double)$$2, $$3 + (double)$$2, $$4 + (double)$$1, $$5 + (double)$$2);
        }
    }

    @Override
    public boolean m_6783_(double p_270991_) {
        return p_270991_ < Mth.m_144952_((double)this.m_269081_() * 64.0 * Display.m_20150_());
    }

    @Override
    public int m_19876_() {
        int $$0 = this.m_269034_();
        return $$0 != -1 ? $$0 : super.m_19876_();
    }

    private RenderState m_277152_() {
        return new RenderState(GenericInterpolator.m_277024_(Display.m_269448_(this.f_19804_)), this.m_269218_(), this.m_269041_(), FloatInterpolator.m_277016_(this.m_269459_()), FloatInterpolator.m_277016_(this.m_269155_()), this.m_269034_());
    }

    private RenderState m_277098_(RenderState p_277365_, float p_277948_) {
        Transformation $$2 = p_277365_.f_276585_.m_269136_(p_277948_);
        float $$3 = p_277365_.f_276607_.m_269229_(p_277948_);
        float $$4 = p_277365_.f_276693_.m_269229_(p_277948_);
        return new RenderState(new TransformationInterpolator($$2, Display.m_269448_(this.f_19804_)), this.m_269218_(), this.m_269041_(), new LinearFloatInterpolator($$3, this.m_269459_()), new LinearFloatInterpolator($$4, this.m_269155_()), this.m_269034_());
    }

    public record RenderState(GenericInterpolator<Transformation> f_276585_, BillboardConstraints f_276506_, int f_276438_, FloatInterpolator f_276607_, FloatInterpolator f_276693_, int f_276486_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RenderState.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "f_276585_", "f_276506_", "f_276438_", "f_276607_", "f_276693_", "f_276486_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RenderState.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "f_276585_", "f_276506_", "f_276438_", "f_276607_", "f_276693_", "f_276486_"}, this);
        }

        @Override
        public final boolean equals(Object p_277541_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RenderState.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "f_276585_", "f_276506_", "f_276438_", "f_276607_", "f_276693_", "f_276486_"}, this, p_277541_);
        }
    }

    static class PosRotInterpolationTarget {
        int f_290672_;
        final double f_290957_;
        final double f_290716_;
        final double f_291240_;
        final double f_291326_;
        final double f_290651_;

        PosRotInterpolationTarget(int p_297638_, double p_297433_, double p_297414_, double p_300814_, double p_297927_, double p_297784_) {
            this.f_290672_ = p_297638_;
            this.f_290957_ = p_297433_;
            this.f_290716_ = p_297414_;
            this.f_291240_ = p_300814_;
            this.f_291326_ = p_297927_;
            this.f_290651_ = p_297784_;
        }

        void m_294804_(Entity p_297540_) {
            p_297540_.m_6034_(this.f_290957_, this.f_290716_, this.f_291240_);
            p_297540_.m_19915_((float)this.f_291326_, (float)this.f_290651_);
        }

        void m_293331_(Entity p_300902_) {
            p_300902_.m_293725_(this.f_290672_, this.f_290957_, this.f_290716_, this.f_291240_, this.f_291326_, this.f_290651_);
        }
    }

    public static final class BillboardConstraints
    extends Enum<BillboardConstraints>
    implements StringRepresentable {
        public static final /* enum */ BillboardConstraints FIXED = new BillboardConstraints(0, "fixed");
        public static final /* enum */ BillboardConstraints VERTICAL = new BillboardConstraints(1, "vertical");
        public static final /* enum */ BillboardConstraints HORIZONTAL = new BillboardConstraints(2, "horizontal");
        public static final /* enum */ BillboardConstraints CENTER = new BillboardConstraints(3, "center");
        public static final Codec<BillboardConstraints> f_268505_;
        public static final IntFunction<BillboardConstraints> f_268544_;
        private final byte f_268470_;
        private final String f_268642_;
        private static final /* synthetic */ BillboardConstraints[] $VALUES;

        public static BillboardConstraints[] values() {
            return (BillboardConstraints[])$VALUES.clone();
        }

        public static BillboardConstraints valueOf(String p_270795_) {
            return Enum.valueOf(BillboardConstraints.class, p_270795_);
        }

        private BillboardConstraints(byte p_270785_, String p_270544_) {
            this.f_268642_ = p_270544_;
            this.f_268470_ = p_270785_;
        }

        @Override
        public String m_7912_() {
            return this.f_268642_;
        }

        byte m_269016_() {
            return this.f_268470_;
        }

        private static /* synthetic */ BillboardConstraints[] m_269521_() {
            return new BillboardConstraints[]{FIXED, VERTICAL, HORIZONTAL, CENTER};
        }

        static {
            $VALUES = BillboardConstraints.m_269521_();
            f_268505_ = StringRepresentable.m_216439_(BillboardConstraints::values);
            f_268544_ = ByIdMap.m_262839_(BillboardConstraints::m_269016_, BillboardConstraints.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> m_277024_(T p_277718_) {
            return p_277907_ -> p_277718_;
        }

        public T m_269136_(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator m_277016_(float p_277894_) {
            return p_278040_ -> p_277894_;
        }

        public float m_269229_(float var1);
    }

    record TransformationInterpolator(Transformation f_276675_, Transformation f_276610_) implements GenericInterpolator<Transformation>
    {
        @Override
        public Transformation m_269136_(float p_278027_) {
            if ((double)p_278027_ >= 1.0) {
                return this.f_276610_;
            }
            return this.f_276675_.m_175937_(this.f_276610_, p_278027_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TransformationInterpolator.class, "previous;current", "f_276675_", "f_276610_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TransformationInterpolator.class, "previous;current", "f_276675_", "f_276610_"}, this);
        }

        @Override
        public final boolean equals(Object p_277812_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TransformationInterpolator.class, "previous;current", "f_276675_", "f_276610_"}, this, p_277812_);
        }

        @Override
        public /* synthetic */ Object m_269136_(float f) {
            return this.m_269136_(f);
        }
    }

    record LinearFloatInterpolator(float f_276496_, float f_276689_) implements FloatInterpolator
    {
        @Override
        public float m_269229_(float p_277511_) {
            return Mth.m_14179_(p_277511_, this.f_276496_, this.f_276689_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LinearFloatInterpolator.class, "previous;current", "f_276496_", "f_276689_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LinearFloatInterpolator.class, "previous;current", "f_276496_", "f_276689_"}, this);
        }

        @Override
        public final boolean equals(Object p_277871_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LinearFloatInterpolator.class, "previous;current", "f_276496_", "f_276689_"}, this, p_277871_);
        }
    }

    record ColorInterpolator(int f_276650_, int f_276509_) implements IntInterpolator
    {
        @Override
        public int m_269120_(float p_278012_) {
            return FastColor.ARGB32.m_269105_(p_278012_, this.f_276650_, this.f_276509_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ColorInterpolator.class, "previous;current", "f_276650_", "f_276509_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ColorInterpolator.class, "previous;current", "f_276650_", "f_276509_"}, this);
        }

        @Override
        public final boolean equals(Object p_278002_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ColorInterpolator.class, "previous;current", "f_276650_", "f_276509_"}, this, p_278002_);
        }
    }

    record LinearIntInterpolator(int f_276498_, int f_276492_) implements IntInterpolator
    {
        @Override
        public int m_269120_(float p_277960_) {
            return Mth.m_269140_(p_277960_, this.f_276498_, this.f_276492_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LinearIntInterpolator.class, "previous;current", "f_276498_", "f_276492_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LinearIntInterpolator.class, "previous;current", "f_276498_", "f_276492_"}, this);
        }

        @Override
        public final boolean equals(Object p_277372_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LinearIntInterpolator.class, "previous;current", "f_276498_", "f_276492_"}, this, p_277372_);
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator m_276859_(int p_277348_) {
            return p_277356_ -> p_277348_;
        }

        public int m_269120_(float var1);
    }

    public static class TextDisplay
    extends Display {
        public static final String f_268588_ = "text";
        private static final String f_268529_ = "line_width";
        private static final String f_268552_ = "text_opacity";
        private static final String f_268596_ = "background";
        private static final String f_268662_ = "shadow";
        private static final String f_268692_ = "see_through";
        private static final String f_268694_ = "default_background";
        private static final String f_268486_ = "alignment";
        public static final byte f_268445_ = 1;
        public static final byte f_268740_ = 2;
        public static final byte f_268465_ = 4;
        public static final byte f_268562_ = 8;
        public static final byte f_268545_ = 16;
        private static final byte f_268541_ = -1;
        public static final int f_268744_ = 0x40000000;
        private static final EntityDataAccessor<Component> f_268542_ = SynchedEntityData.m_135353_(TextDisplay.class, EntityDataSerializers.f_135031_);
        private static final EntityDataAccessor<Integer> f_268476_ = SynchedEntityData.m_135353_(TextDisplay.class, EntityDataSerializers.f_135028_);
        private static final EntityDataAccessor<Integer> f_268494_ = SynchedEntityData.m_135353_(TextDisplay.class, EntityDataSerializers.f_135028_);
        private static final EntityDataAccessor<Byte> f_268481_ = SynchedEntityData.m_135353_(TextDisplay.class, EntityDataSerializers.f_135027_);
        private static final EntityDataAccessor<Byte> f_268636_ = SynchedEntityData.m_135353_(TextDisplay.class, EntityDataSerializers.f_135027_);
        private static final IntSet f_276462_ = IntSet.of((int[])new int[]{f_268542_.m_135015_(), f_268476_.m_135015_(), f_268494_.m_135015_(), f_268481_.m_135015_(), f_268636_.m_135015_()});
        @Nullable
        private CachedInfo f_268719_;
        @Nullable
        private TextRenderState f_276542_;

        public TextDisplay(EntityType<?> p_270708_, Level p_270736_) {
            super(p_270708_, p_270736_);
        }

        @Override
        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(f_268542_, Component.m_237119_());
            this.f_19804_.m_135372_(f_268476_, 200);
            this.f_19804_.m_135372_(f_268494_, 0x40000000);
            this.f_19804_.m_135372_(f_268481_, (byte)-1);
            this.f_19804_.m_135372_(f_268636_, (byte)0);
        }

        @Override
        public void m_7350_(EntityDataAccessor<?> p_270797_) {
            super.m_7350_(p_270797_);
            if (f_276462_.contains(p_270797_.m_135015_())) {
                this.f_276470_ = true;
            }
        }

        private Component m_269000_() {
            return this.f_19804_.m_135370_(f_268542_);
        }

        private void m_269037_(Component p_270902_) {
            this.f_19804_.m_135381_(f_268542_, p_270902_);
        }

        private int m_269517_() {
            return this.f_19804_.m_135370_(f_268476_);
        }

        private void m_269174_(int p_270545_) {
            this.f_19804_.m_135381_(f_268476_, p_270545_);
        }

        private byte m_269180_() {
            return this.f_19804_.m_135370_(f_268481_);
        }

        private void m_269007_(byte p_270583_) {
            this.f_19804_.m_135381_(f_268481_, p_270583_);
        }

        private int m_269375_() {
            return this.f_19804_.m_135370_(f_268494_);
        }

        private void m_269001_(int p_270241_) {
            this.f_19804_.m_135381_(f_268494_, p_270241_);
        }

        private byte m_269327_() {
            return this.f_19804_.m_135370_(f_268636_);
        }

        private void m_269559_(byte p_270855_) {
            this.f_19804_.m_135381_(f_268636_, p_270855_);
        }

        private static byte m_269024_(byte p_270219_, CompoundTag p_270994_, String p_270958_, byte p_270701_) {
            if (p_270994_.m_128471_(p_270958_)) {
                return (byte)(p_270219_ | p_270701_);
            }
            return p_270219_;
        }

        @Override
        protected void m_7378_(CompoundTag p_270714_) {
            super.m_7378_(p_270714_);
            if (p_270714_.m_128425_(f_268529_, 99)) {
                this.m_269174_(p_270714_.m_128451_(f_268529_));
            }
            if (p_270714_.m_128425_(f_268552_, 99)) {
                this.m_269007_(p_270714_.m_128445_(f_268552_));
            }
            if (p_270714_.m_128425_(f_268596_, 99)) {
                this.m_269001_(p_270714_.m_128451_(f_268596_));
            }
            byte $$1 = TextDisplay.m_269024_((byte)0, p_270714_, f_268662_, (byte)1);
            $$1 = TextDisplay.m_269024_($$1, p_270714_, f_268692_, (byte)2);
            $$1 = TextDisplay.m_269024_($$1, p_270714_, f_268694_, (byte)4);
            Optional<Align> $$2 = Align.f_268461_.decode((DynamicOps)NbtOps.f_128958_, (Object)p_270714_.m_128423_(f_268486_)).resultOrPartial(Util.m_137489_("Display entity", arg_0 -> ((Logger)f_268644_).error(arg_0))).map(Pair::getFirst);
            if ($$2.isPresent()) {
                $$1 = switch ($$2.get()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Align.CENTER -> $$1;
                    case Align.LEFT -> (byte)($$1 | 8);
                    case Align.RIGHT -> (byte)($$1 | 0x10);
                };
            }
            this.m_269559_($$1);
            if (p_270714_.m_128425_(f_268588_, 8)) {
                String $$3 = p_270714_.m_128461_(f_268588_);
                try {
                    MutableComponent $$4 = Component.Serializer.m_130701_($$3);
                    if ($$4 != null) {
                        CommandSourceStack $$5 = this.m_20203_().m_81325_(2);
                        MutableComponent $$6 = ComponentUtils.m_130731_($$5, $$4, this, 0);
                        this.m_269037_($$6);
                    } else {
                        this.m_269037_(Component.m_237119_());
                    }
                }
                catch (Exception $$7) {
                    f_268644_.warn("Failed to parse display entity text {}", (Object)$$3, (Object)$$7);
                }
            }
        }

        private static void m_269407_(byte p_270879_, CompoundTag p_270177_, String p_270294_, byte p_270853_) {
            p_270177_.m_128379_(p_270294_, (p_270879_ & p_270853_) != 0);
        }

        @Override
        protected void m_7380_(CompoundTag p_270268_) {
            super.m_7380_(p_270268_);
            p_270268_.m_128359_(f_268588_, Component.Serializer.m_130703_(this.m_269000_()));
            p_270268_.m_128405_(f_268529_, this.m_269517_());
            p_270268_.m_128405_(f_268596_, this.m_269375_());
            p_270268_.m_128344_(f_268552_, this.m_269180_());
            byte $$1 = this.m_269327_();
            TextDisplay.m_269407_($$1, p_270268_, f_268662_, (byte)1);
            TextDisplay.m_269407_($$1, p_270268_, f_268692_, (byte)2);
            TextDisplay.m_269407_($$1, p_270268_, f_268694_, (byte)4);
            Align.f_268461_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)TextDisplay.m_269384_($$1)).result().ifPresent(p_271001_ -> p_270268_.m_128365_(f_268486_, (Tag)p_271001_));
        }

        @Override
        protected void m_276825_(boolean p_277565_, float p_277967_) {
            this.f_276542_ = p_277565_ && this.f_276542_ != null ? this.m_276848_(this.f_276542_, p_277967_) : this.m_276914_();
            this.f_268719_ = null;
        }

        @Nullable
        public TextRenderState m_277174_() {
            return this.f_276542_;
        }

        private TextRenderState m_276914_() {
            return new TextRenderState(this.m_269000_(), this.m_269517_(), IntInterpolator.m_276859_(this.m_269180_()), IntInterpolator.m_276859_(this.m_269375_()), this.m_269327_());
        }

        private TextRenderState m_276848_(TextRenderState p_278000_, float p_277646_) {
            int $$2 = p_278000_.f_276562_.m_269120_(p_277646_);
            int $$3 = p_278000_.f_276579_.m_269120_(p_277646_);
            return new TextRenderState(this.m_269000_(), this.m_269517_(), new LinearIntInterpolator($$3, this.m_269180_()), new ColorInterpolator($$2, this.m_269375_()), this.m_269327_());
        }

        public CachedInfo m_269343_(LineSplitter p_270682_) {
            if (this.f_268719_ == null) {
                this.f_268719_ = this.f_276542_ != null ? p_270682_.m_269487_(this.f_276542_.f_276477_(), this.f_276542_.f_276622_()) : new CachedInfo(List.of(), 0);
            }
            return this.f_268719_;
        }

        public static Align m_269384_(byte p_270911_) {
            if ((p_270911_ & 8) != 0) {
                return Align.LEFT;
            }
            if ((p_270911_ & 0x10) != 0) {
                return Align.RIGHT;
            }
            return Align.CENTER;
        }

        public static final class Align
        extends Enum<Align>
        implements StringRepresentable {
            public static final /* enum */ Align CENTER = new Align("center");
            public static final /* enum */ Align LEFT = new Align("left");
            public static final /* enum */ Align RIGHT = new Align("right");
            public static final Codec<Align> f_268461_;
            private final String f_268523_;
            private static final /* synthetic */ Align[] $VALUES;

            public static Align[] values() {
                return (Align[])$VALUES.clone();
            }

            public static Align valueOf(String p_270912_) {
                return Enum.valueOf(Align.class, p_270912_);
            }

            private Align(String p_270554_) {
                this.f_268523_ = p_270554_;
            }

            @Override
            public String m_7912_() {
                return this.f_268523_;
            }

            private static /* synthetic */ Align[] m_269578_() {
                return new Align[]{CENTER, LEFT, RIGHT};
            }

            static {
                $VALUES = Align.m_269578_();
                f_268461_ = StringRepresentable.m_216439_(Align::values);
            }
        }

        public record TextRenderState(Component f_276477_, int f_276622_, IntInterpolator f_276579_, IntInterpolator f_276562_, byte f_276556_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{TextRenderState.class, "text;lineWidth;textOpacity;backgroundColor;flags", "f_276477_", "f_276622_", "f_276579_", "f_276562_", "f_276556_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TextRenderState.class, "text;lineWidth;textOpacity;backgroundColor;flags", "f_276477_", "f_276622_", "f_276579_", "f_276562_", "f_276556_"}, this);
            }

            @Override
            public final boolean equals(Object p_278077_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TextRenderState.class, "text;lineWidth;textOpacity;backgroundColor;flags", "f_276477_", "f_276622_", "f_276579_", "f_276562_", "f_276556_"}, this, p_278077_);
            }
        }

        public record CachedInfo(List<CachedLine> f_268675_, int f_268557_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedInfo.class, "lines;width", "f_268675_", "f_268557_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedInfo.class, "lines;width", "f_268675_", "f_268557_"}, this);
            }

            @Override
            public final boolean equals(Object p_270322_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedInfo.class, "lines;width", "f_268675_", "f_268557_"}, this, p_270322_);
            }
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo m_269487_(Component var1, int var2);
        }

        public record CachedLine(FormattedCharSequence f_268516_, int f_268443_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedLine.class, "contents;width", "f_268516_", "f_268443_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedLine.class, "contents;width", "f_268516_", "f_268443_"}, this);
            }

            @Override
            public final boolean equals(Object p_270160_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedLine.class, "contents;width", "f_268516_", "f_268443_"}, this, p_270160_);
            }
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String f_268661_ = "block_state";
        private static final EntityDataAccessor<BlockState> f_268543_ = SynchedEntityData.m_135353_(BlockDisplay.class, EntityDataSerializers.f_135034_);
        @Nullable
        private BlockRenderState f_276560_;

        public BlockDisplay(EntityType<?> p_271022_, Level p_270442_) {
            super(p_271022_, p_270442_);
        }

        @Override
        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(f_268543_, Blocks.f_50016_.m_49966_());
        }

        @Override
        public void m_7350_(EntityDataAccessor<?> p_277476_) {
            super.m_7350_(p_277476_);
            if (p_277476_.equals(f_268543_)) {
                this.f_276470_ = true;
            }
        }

        private BlockState m_269134_() {
            return this.f_19804_.m_135370_(f_268543_);
        }

        private void m_269329_(BlockState p_270267_) {
            this.f_19804_.m_135381_(f_268543_, p_270267_);
        }

        @Override
        protected void m_7378_(CompoundTag p_270139_) {
            super.m_7378_(p_270139_);
            this.m_269329_(NbtUtils.m_247651_(this.m_9236_().m_246945_(Registries.f_256747_), p_270139_.m_128469_(f_268661_)));
        }

        @Override
        protected void m_7380_(CompoundTag p_270469_) {
            super.m_7380_(p_270469_);
            p_270469_.m_128365_(f_268661_, NbtUtils.m_129202_(this.m_269134_()));
        }

        @Nullable
        public BlockRenderState m_276881_() {
            return this.f_276560_;
        }

        @Override
        protected void m_276825_(boolean p_277802_, float p_277688_) {
            this.f_276560_ = new BlockRenderState(this.m_269134_());
        }

        public record BlockRenderState(BlockState f_276526_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlockRenderState.class, "blockState", "f_276526_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockRenderState.class, "blockState", "f_276526_"}, this);
            }

            @Override
            public final boolean equals(Object p_277657_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockRenderState.class, "blockState", "f_276526_"}, this, p_277657_);
            }
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String f_268554_ = "item";
        private static final String f_268471_ = "item_display";
        private static final EntityDataAccessor<ItemStack> f_268455_ = SynchedEntityData.m_135353_(ItemDisplay.class, EntityDataSerializers.f_135033_);
        private static final EntityDataAccessor<Byte> f_268601_ = SynchedEntityData.m_135353_(ItemDisplay.class, EntityDataSerializers.f_135027_);
        private final SlotAccess f_268451_ = new SlotAccess(){

            @Override
            public ItemStack m_142196_() {
                return this.m_269568_();
            }

            @Override
            public boolean m_142104_(ItemStack p_270697_) {
                this.m_269362_(p_270697_);
                return true;
            }
        };
        @Nullable
        private ItemRenderState f_276545_;

        public ItemDisplay(EntityType<?> p_270104_, Level p_270735_) {
            super(p_270104_, p_270735_);
        }

        @Override
        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(f_268455_, ItemStack.f_41583_);
            this.f_19804_.m_135372_(f_268601_, ItemDisplayContext.NONE.m_269462_());
        }

        @Override
        public void m_7350_(EntityDataAccessor<?> p_277793_) {
            super.m_7350_(p_277793_);
            if (f_268455_.equals(p_277793_) || f_268601_.equals(p_277793_)) {
                this.f_276470_ = true;
            }
        }

        ItemStack m_269568_() {
            return this.f_19804_.m_135370_(f_268455_);
        }

        void m_269362_(ItemStack p_270310_) {
            this.f_19804_.m_135381_(f_268455_, p_270310_);
        }

        private void m_269028_(ItemDisplayContext p_270370_) {
            this.f_19804_.m_135381_(f_268601_, p_270370_.m_269462_());
        }

        private ItemDisplayContext m_269386_() {
            return ItemDisplayContext.f_268648_.apply(this.f_19804_.m_135370_(f_268601_).byteValue());
        }

        @Override
        protected void m_7378_(CompoundTag p_270713_) {
            super.m_7378_(p_270713_);
            this.m_269362_(ItemStack.m_41712_(p_270713_.m_128469_(f_268554_)));
            if (p_270713_.m_128425_(f_268471_, 8)) {
                ItemDisplayContext.f_268458_.decode((DynamicOps)NbtOps.f_128958_, (Object)p_270713_.m_128423_(f_268471_)).resultOrPartial(Util.m_137489_("Display entity", arg_0 -> ((Logger)f_268644_).error(arg_0))).ifPresent(p_270456_ -> this.m_269028_((ItemDisplayContext)p_270456_.getFirst()));
            }
        }

        @Override
        protected void m_7380_(CompoundTag p_270669_) {
            super.m_7380_(p_270669_);
            p_270669_.m_128365_(f_268554_, this.m_269568_().m_41739_(new CompoundTag()));
            ItemDisplayContext.f_268458_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.m_269386_()).result().ifPresent(p_270615_ -> p_270669_.m_128365_(f_268471_, (Tag)p_270615_));
        }

        @Override
        public SlotAccess m_141942_(int p_270599_) {
            if (p_270599_ == 0) {
                return this.f_268451_;
            }
            return SlotAccess.f_147290_;
        }

        @Nullable
        public ItemRenderState m_277122_() {
            return this.f_276545_;
        }

        @Override
        protected void m_276825_(boolean p_277976_, float p_277708_) {
            ItemStack $$2 = this.m_269568_();
            $$2.m_41636_(this);
            this.f_276545_ = new ItemRenderState($$2, this.m_269386_());
        }

        public record ItemRenderState(ItemStack f_276600_, ItemDisplayContext f_276629_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemRenderState.class, "itemStack;itemTransform", "f_276600_", "f_276629_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemRenderState.class, "itemStack;itemTransform", "f_276600_", "f_276629_"}, this);
            }

            @Override
            public final boolean equals(Object p_277711_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemRenderState.class, "itemStack;itemTransform", "f_276600_", "f_276629_"}, this, p_277711_);
            }
        }
    }
}

