/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MushroomCow
extends Cow
implements Shearable,
IForgeShearable {
    private static final EntityDataAccessor<String> f_28908_ = SynchedEntityData.m_135353_(MushroomCow.class, EntityDataSerializers.f_135030_);
    private static final int f_148934_ = 1024;
    private static final String f_291553_ = "stew_effects";
    @javax.annotation.Nullable
    private List<SuspiciousEffectHolder.EffectEntry> f_290954_;
    @javax.annotation.Nullable
    private UUID f_28911_;

    public MushroomCow(EntityType<? extends MushroomCow> p_28914_, Level p_28915_) {
        super((EntityType<? extends Cow>)p_28914_, p_28915_);
    }

    @Override
    public float m_5610_(BlockPos p_28933_, LevelReader p_28934_) {
        return p_28934_.m_8055_(p_28933_.m_7495_()).m_60713_(Blocks.f_50195_) ? 10.0f : p_28934_.m_220419_(p_28933_);
    }

    public static boolean m_218200_(EntityType<MushroomCow> p_218201_, LevelAccessor p_218202_, MobSpawnType p_218203_, BlockPos p_218204_, RandomSource p_218205_) {
        return p_218202_.m_8055_(p_218204_.m_7495_()).m_204336_(BlockTags.f_184231_) && MushroomCow.m_186209_(p_218202_, p_218204_);
    }

    @Override
    public void m_8038_(ServerLevel p_28921_, LightningBolt p_28922_) {
        UUID uuid = p_28922_.m_20148_();
        if (!uuid.equals(this.f_28911_)) {
            this.m_28464_(this.m_28554_() == MushroomType.RED ? MushroomType.BROWN : MushroomType.RED);
            this.f_28911_ = uuid;
            this.m_5496_(SoundEvents.f_12071_, 2.0f, 1.0f);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_28908_, MushroomType.RED.f_28960_);
    }

    @Override
    public InteractionResult m_6071_(Player p_28941_, InteractionHand p_28942_) {
        ItemStack itemstack = p_28941_.m_21120_(p_28942_);
        if (itemstack.m_150930_(Items.f_42399_) && !this.m_6162_()) {
            ItemStack itemstack2;
            boolean flag = false;
            if (this.f_290954_ != null) {
                flag = true;
                itemstack2 = new ItemStack(Items.f_42718_);
                SuspiciousStewItem.m_294406_(itemstack2, this.f_290954_);
                this.f_290954_ = null;
            } else {
                itemstack2 = new ItemStack(Items.f_42400_);
            }
            ItemStack itemstack1 = ItemUtils.m_41817_(itemstack, p_28941_, itemstack2, false);
            p_28941_.m_21008_(p_28942_, itemstack1);
            SoundEvent soundevent = flag ? SoundEvents.f_12074_ : SoundEvents.f_12073_;
            this.m_5496_(soundevent, 1.0f, 1.0f);
            return InteractionResult.m_19078_(this.m_9236_().f_46443_);
        }
        if (this.m_28554_() == MushroomType.BROWN && itemstack.m_204117_(ItemTags.f_13145_)) {
            if (this.f_290954_ != null) {
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_(ParticleTypes.f_123762_, this.m_20185_() + this.f_19796_.m_188500_() / 2.0, this.m_20227_(0.5), this.m_20189_() + this.f_19796_.m_188500_() / 2.0, 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                }
            } else {
                Optional<List<SuspiciousEffectHolder.EffectEntry>> optional = this.m_293901_(itemstack);
                if (optional.isEmpty()) {
                    return InteractionResult.PASS;
                }
                if (!p_28941_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                for (int j = 0; j < 4; ++j) {
                    this.m_9236_().m_7106_(ParticleTypes.f_123806_, this.m_20185_() + this.f_19796_.m_188500_() / 2.0, this.m_20227_(0.5), this.m_20189_() + this.f_19796_.m_188500_() / 2.0, 0.0, this.f_19796_.m_188500_() / 5.0, 0.0);
                }
                this.f_290954_ = optional.get();
                this.m_5496_(SoundEvents.f_12072_, 2.0f, 1.0f);
            }
            return InteractionResult.m_19078_(this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_28941_, p_28942_);
    }

    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level world, BlockPos pos, int fortune) {
        this.m_146852_(GameEvent.f_157781_, player);
        return this.shearInternal(player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS);
    }

    @Override
    public void m_5851_(SoundSource p_28924_) {
        this.shearInternal(p_28924_).forEach(s -> this.m_9236_().m_7967_(new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), (ItemStack)((Object)s))));
    }

    private List<ItemStack> shearInternal(SoundSource p_28924_) {
        this.m_9236_().m_6269_(null, this, SoundEvents.f_12075_, p_28924_, 1.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            if (!ForgeEventFactory.canLivingConvert((LivingEntity)this, EntityType.f_20557_, time -> {})) {
                return Collections.emptyList();
            }
            Cow cow = EntityType.f_20557_.m_20615_(this.m_9236_());
            if (cow != null) {
                ((ServerLevel)this.m_9236_()).m_8767_(ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                this.m_146870_();
                cow.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                cow.m_21153_(this.m_21223_());
                cow.f_20883_ = this.f_20883_;
                if (this.m_8077_()) {
                    cow.m_6593_(this.m_7770_());
                    cow.m_20340_(this.m_20151_());
                }
                if (this.m_21532_()) {
                    cow.m_21530_();
                }
                cow.m_20331_(this.m_20147_());
                this.m_9236_().m_7967_(cow);
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)cow);
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (int i = 0; i < 5; ++i) {
                    items.add(new ItemStack(this.m_28554_().f_28961_.m_60734_()));
                }
                return items;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean m_6220_() {
        return this.m_6084_() && !this.m_6162_();
    }

    @Override
    public void m_7380_(CompoundTag p_28944_) {
        super.m_7380_(p_28944_);
        p_28944_.m_128359_("Type", this.m_28554_().m_7912_());
        if (this.f_290954_ != null) {
            SuspiciousEffectHolder.EffectEntry.f_291114_.encodeStart((DynamicOps)NbtOps.f_128958_, this.f_290954_).result().ifPresent(p_296800_ -> p_28944_.m_128365_(f_291553_, (Tag)p_296800_));
        }
    }

    @Override
    public void m_7378_(CompoundTag p_28936_) {
        super.m_7378_(p_28936_);
        this.m_28464_(MushroomType.m_28976_(p_28936_.m_128461_("Type")));
        if (p_28936_.m_128425_(f_291553_, 9)) {
            SuspiciousEffectHolder.EffectEntry.f_291114_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_28936_.m_128423_(f_291553_)).result().ifPresent(p_296801_ -> {
                this.f_290954_ = p_296801_;
            });
        }
    }

    private Optional<List<SuspiciousEffectHolder.EffectEntry>> m_293901_(ItemStack p_298141_) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.m_257980_(p_298141_.m_41720_());
        return suspiciouseffectholder != null ? Optional.of(suspiciouseffectholder.m_294088_()) : Optional.empty();
    }

    public void m_28464_(MushroomType p_28929_) {
        this.f_19804_.m_135381_(f_28908_, p_28929_.f_28960_);
    }

    public MushroomType m_28554_() {
        return MushroomType.m_28976_(this.f_19804_.m_135370_(f_28908_));
    }

    @Override
    @javax.annotation.Nullable
    public MushroomCow m_142606_(ServerLevel p_148942_, AgeableMob p_148943_) {
        MushroomCow mushroomcow = EntityType.f_20504_.m_20615_(p_148942_);
        if (mushroomcow != null) {
            mushroomcow.m_28464_(this.m_28930_((MushroomCow)p_148943_));
        }
        return mushroomcow;
    }

    private MushroomType m_28930_(MushroomCow p_28931_) {
        MushroomType mushroomcow$mushroomtype1;
        MushroomType mushroomcow$mushroomtype = this.m_28554_();
        MushroomType mushroomcow$mushroomtype2 = mushroomcow$mushroomtype == (mushroomcow$mushroomtype1 = p_28931_.m_28554_()) && this.f_19796_.m_188503_(1024) == 0 ? (mushroomcow$mushroomtype == MushroomType.BROWN ? MushroomType.RED : MushroomType.BROWN) : (this.f_19796_.m_188499_() ? mushroomcow$mushroomtype : mushroomcow$mushroomtype1);
        return mushroomcow$mushroomtype2;
    }

    public boolean isShearable(ItemStack item, Level world, BlockPos pos) {
        return this.m_6220_();
    }

    private static /* synthetic */ void m_28925_(InteractionHand p_28926_, Player p_28927_) {
        p_28927_.m_21190_(p_28926_);
    }

    public static final class MushroomType
    extends Enum<MushroomType>
    implements StringRepresentable {
        public static final /* enum */ MushroomType RED = new MushroomType("red", Blocks.f_50073_.m_49966_());
        public static final /* enum */ MushroomType BROWN = new MushroomType("brown", Blocks.f_50072_.m_49966_());
        public static final StringRepresentable.EnumCodec<MushroomType> f_262198_;
        final String f_28960_;
        final BlockState f_28961_;
        private static final /* synthetic */ MushroomType[] $VALUES;

        public static MushroomType[] values() {
            return (MushroomType[])$VALUES.clone();
        }

        public static MushroomType valueOf(String p_28979_) {
            return Enum.valueOf(MushroomType.class, p_28979_);
        }

        private MushroomType(String p_28967_, BlockState p_28968_) {
            this.f_28960_ = p_28967_;
            this.f_28961_ = p_28968_;
        }

        public BlockState m_28969_() {
            return this.f_28961_;
        }

        @Override
        public String m_7912_() {
            return this.f_28960_;
        }

        static MushroomType m_28976_(String p_28977_) {
            return f_262198_.m_262792_(p_28977_, RED);
        }

        private static /* synthetic */ MushroomType[] m_148944_() {
            return new MushroomType[]{RED, BROWN};
        }

        static {
            $VALUES = MushroomType.m_148944_();
            f_262198_ = StringRepresentable.m_216439_(MushroomType::values);
        }
    }
}

