/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.joml.Vector3f;

public abstract class AbstractHorse
extends Animal
implements ContainerListener,
HasCustomInventoryScreen,
OwnableEntity,
PlayerRideableJumping,
Saddleable {
    public static final int f_149486_ = 400;
    public static final int f_149487_ = 499;
    public static final int f_149488_ = 500;
    public static final double f_271338_ = 0.15;
    private static final float f_271139_ = (float)AbstractHorse.m_271981_(() -> 0.0);
    private static final float f_271541_ = (float)AbstractHorse.m_271981_(() -> 1.0);
    private static final float f_271305_ = (float)AbstractHorse.m_272017_(() -> 0.0);
    private static final float f_271293_ = (float)AbstractHorse.m_272017_(() -> 1.0);
    private static final float f_271313_ = AbstractHorse.m_271722_(p_272505_ -> 0);
    private static final float f_271308_ = AbstractHorse.m_271722_(p_272504_ -> p_272504_ - 1);
    private static final float f_273870_ = 0.25f;
    private static final float f_273946_ = 0.5f;
    private static final Predicate<LivingEntity> f_30525_ = p_30636_ -> p_30636_ instanceof AbstractHorse && ((AbstractHorse)p_30636_).m_30623_();
    private static final TargetingConditions f_30526_ = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26888_(f_30525_);
    private static final Ingredient f_30527_ = Ingredient.m_43929_(Items.f_42405_, Items.f_42501_, Blocks.f_50335_.m_5456_(), Items.f_42410_, Items.f_42677_, Items.f_42436_, Items.f_42437_);
    private static final EntityDataAccessor<Byte> f_30528_ = SynchedEntityData.m_135353_(AbstractHorse.class, EntityDataSerializers.f_135027_);
    private static final int f_149492_ = 2;
    private static final int f_149493_ = 4;
    private static final int f_149494_ = 8;
    private static final int f_149495_ = 16;
    private static final int f_149496_ = 32;
    private static final int f_149497_ = 64;
    public static final int f_149489_ = 0;
    public static final int f_149490_ = 1;
    public static final int f_149491_ = 2;
    private int f_30507_;
    private int f_30508_;
    private int f_30509_;
    public int f_30517_;
    public int f_30518_;
    protected boolean f_30519_;
    protected SimpleContainer f_30520_;
    protected int f_30521_;
    protected float f_30522_;
    protected boolean f_30510_;
    private float f_30511_;
    private float f_30512_;
    private float f_30513_;
    private float f_30514_;
    private float f_30515_;
    private float f_30516_;
    protected boolean f_30523_ = true;
    protected int f_30524_;
    @Nullable
    private UUID f_268614_;
    private LazyOptional<?> itemHandler = null;

    protected AbstractHorse(EntityType<? extends AbstractHorse> p_30531_, Level p_30532_) {
        super((EntityType<? extends Animal>)p_30531_, p_30532_);
        this.m_274367_(1.0f);
        this.m_30625_();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, new PanicGoal(this, 1.2));
        this.f_21345_.m_25352_(1, new RunAroundLikeCrazyGoal(this, 1.2));
        this.f_21345_.m_25352_(2, new BreedGoal(this, 1.0, AbstractHorse.class));
        this.f_21345_.m_25352_(4, new FollowParentGoal(this, 1.0));
        this.f_21345_.m_25352_(6, new WaterAvoidingRandomStrollGoal(this, 0.7));
        this.f_21345_.m_25352_(7, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, new RandomLookAroundGoal(this));
        if (this.m_245259_()) {
            this.f_21345_.m_25352_(9, new RandomStandGoal(this));
        }
        this.m_7509_();
    }

    protected void m_7509_() {
        this.f_21345_.m_25352_(0, new FloatGoal(this));
        this.f_21345_.m_25352_(3, new TemptGoal(this, 1.25, Ingredient.m_43929_(Items.f_42677_, Items.f_42436_, Items.f_42437_), false));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_30528_, (byte)0);
    }

    protected boolean m_30647_(int p_30648_) {
        return (this.f_19804_.m_135370_(f_30528_) & p_30648_) != 0;
    }

    protected void m_30597_(int p_30598_, boolean p_30599_) {
        byte b0 = this.f_19804_.m_135370_(f_30528_);
        if (p_30599_) {
            this.f_19804_.m_135381_(f_30528_, (byte)(b0 | p_30598_));
        } else {
            this.f_19804_.m_135381_(f_30528_, (byte)(b0 & ~p_30598_));
        }
    }

    public boolean m_30614_() {
        return this.m_30647_(2);
    }

    @Override
    @Nullable
    public UUID m_21805_() {
        return this.f_268614_;
    }

    public void m_30586_(@Nullable UUID p_30587_) {
        this.f_268614_ = p_30587_;
    }

    public boolean m_30616_() {
        return this.f_30519_;
    }

    public void m_30651_(boolean p_30652_) {
        this.m_30597_(2, p_30652_);
    }

    public void m_30655_(boolean p_30656_) {
        this.f_30519_ = p_30656_;
    }

    @Override
    protected void m_7880_(float p_30660_) {
        if (p_30660_ > 6.0f && this.m_30617_()) {
            this.m_30661_(false);
        }
    }

    public boolean m_30617_() {
        return this.m_30647_(16);
    }

    public boolean m_30622_() {
        return this.m_30647_(32);
    }

    public boolean m_30623_() {
        return this.m_30647_(8);
    }

    public void m_30657_(boolean p_30658_) {
        this.m_30597_(8, p_30658_);
    }

    @Override
    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_30614_();
    }

    @Override
    public void m_5853_(@Nullable SoundSource p_30546_) {
        this.f_30520_.m_6836_(0, new ItemStack(Items.f_42450_));
    }

    public void m_246861_(Player p_251330_, ItemStack p_248855_) {
        if (this.m_6010_(p_248855_)) {
            this.f_30520_.m_6836_(1, p_248855_.m_255036_(1));
            if (!p_251330_.m_150110_().f_35937_) {
                p_248855_.m_41774_(1);
            }
        }
    }

    @Override
    public boolean m_6254_() {
        return this.m_30647_(4);
    }

    public int m_30624_() {
        return this.f_30521_;
    }

    public void m_30649_(int p_30650_) {
        this.f_30521_ = p_30650_;
    }

    public int m_30653_(int p_30654_) {
        int i = Mth.m_14045_(this.m_30624_() + p_30654_, 0, this.m_7555_());
        this.m_30649_(i);
        return i;
    }

    @Override
    public boolean m_6094_() {
        return !this.m_20160_();
    }

    private void m_30610_() {
        SoundEvent soundevent;
        this.m_30612_();
        if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
            ((Level)this.m_9236_()).m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
    }

    @Override
    public boolean m_142535_(float p_149499_, float p_149500_, DamageSource p_149501_) {
        int i;
        LivingFallEvent event = ForgeEventFactory.onLivingFall((LivingEntity)this, (float)p_149499_, (float)p_149500_);
        if (event.isCanceled()) {
            return false;
        }
        p_149499_ = event.getDistance();
        p_149500_ = event.getDamageMultiplier();
        if (p_149499_ > 1.0f) {
            this.m_5496_(SoundEvents.f_11980_, 0.4f, 1.0f);
        }
        if ((i = this.m_5639_(p_149499_, p_149500_)) <= 0) {
            return false;
        }
        this.m_6469_(p_149501_, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(p_149501_, i);
            }
        }
        this.m_21229_();
        return true;
    }

    @Override
    protected int m_5639_(float p_30606_, float p_30607_) {
        return Mth.m_14167_((p_30606_ * 0.5f - 3.0f) * p_30607_);
    }

    protected int m_7506_() {
        return 2;
    }

    protected void m_30625_() {
        SimpleContainer simplecontainer = this.f_30520_;
        this.f_30520_ = new SimpleContainer(this.m_7506_());
        if (simplecontainer != null) {
            simplecontainer.m_19181_(this);
            int i = Math.min(simplecontainer.m_6643_(), this.f_30520_.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.f_30520_.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.f_30520_.m_19164_(this);
        this.m_7493_();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.f_30520_));
    }

    protected void m_7493_() {
        if (!((Level)this.m_9236_()).f_46443_) {
            this.m_30597_(4, !this.f_30520_.m_8020_(0).m_41619_());
        }
    }

    @Override
    public void m_5757_(Container p_30548_) {
        boolean flag = this.m_6254_();
        this.m_7493_();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
    }

    public double m_30626_() {
        return this.m_21133_(Attributes.f_22288_);
    }

    @Override
    public boolean m_6469_(DamageSource p_252258_, float p_250984_) {
        boolean flag = super.m_6469_(p_252258_, p_250984_);
        if (flag && this.f_19796_.m_188503_(3) == 0) {
            this.m_247525_();
        }
        return flag;
    }

    protected boolean m_245259_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7871_() {
        return null;
    }

    @Override
    protected void m_7355_(BlockPos p_30584_, BlockState p_30585_) {
        if (!p_30585_.m_278721_()) {
            BlockState blockstate = ((Level)this.m_9236_()).m_8055_(p_30584_.m_7494_());
            SoundType soundtype = p_30585_.getSoundType((LevelReader)((Object)this.m_9236_()), p_30584_, this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)((Object)this.m_9236_()), p_30584_, this);
            }
            if (this.m_20160_() && this.f_30523_) {
                ++this.f_30524_;
                if (this.f_30524_ > 5 && this.f_30524_ % 3 == 0) {
                    this.m_5877_(soundtype);
                } else if (this.f_30524_ <= 5) {
                    this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (this.m_278175_(soundtype)) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    private boolean m_278175_(SoundType p_278280_) {
        return p_278280_ == SoundType.f_56736_ || p_278280_ == SoundType.f_244244_ || p_278280_ == SoundType.f_56763_ || p_278280_ == SoundType.f_271497_ || p_278280_ == SoundType.f_243772_;
    }

    protected void m_5877_(SoundType p_30560_) {
        this.m_5496_(SoundEvents.f_11977_, p_30560_.m_56773_() * 0.15f, p_30560_.m_56774_());
    }

    public static AttributeSupplier.Builder m_30627_() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_).m_22268_(Attributes.f_22276_, 53.0).m_22268_(Attributes.f_22279_, 0.225f);
    }

    @Override
    public int m_5792_() {
        return 6;
    }

    public int m_7555_() {
        return 100;
    }

    @Override
    protected float m_6121_() {
        return 0.8f;
    }

    @Override
    public int m_8100_() {
        return 400;
    }

    @Override
    public void m_213583_(Player p_218808_) {
        if (!((Level)this.m_9236_()).f_46443_ && (!this.m_20160_() || this.m_20363_(p_218808_)) && this.m_30614_()) {
            p_218808_.m_6658_(this, this.f_30520_);
        }
    }

    public InteractionResult m_30580_(Player p_30581_, ItemStack p_30582_) {
        boolean flag = this.m_5994_(p_30581_, p_30582_);
        if (flag & !p_30581_.m_150110_().f_35937_) {
            p_30582_.m_41774_(1);
        }
        if (((Level)this.m_9236_()).f_46443_) {
            return InteractionResult.CONSUME;
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected boolean m_5994_(Player p_30593_, ItemStack p_30594_) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        if (p_30594_.m_150930_(Items.f_42405_)) {
            f = 2.0f;
            i = 20;
            j = 3;
        } else if (p_30594_.m_150930_(Items.f_42501_)) {
            f = 1.0f;
            i = 30;
            j = 3;
        } else if (p_30594_.m_150930_(Blocks.f_50335_.m_5456_())) {
            f = 20.0f;
            i = 180;
        } else if (p_30594_.m_150930_(Items.f_42410_)) {
            f = 3.0f;
            i = 60;
            j = 3;
        } else if (p_30594_.m_150930_(Items.f_42677_)) {
            f = 4.0f;
            i = 60;
            j = 5;
            if (!((Level)this.m_9236_()).f_46443_ && this.m_30614_() && this.m_146764_() == 0 && !this.m_27593_()) {
                flag = true;
                this.m_27595_(p_30593_);
            }
        } else if (p_30594_.m_150930_(Items.f_42436_) || p_30594_.m_150930_(Items.f_42437_)) {
            f = 10.0f;
            i = 240;
            j = 10;
            if (!((Level)this.m_9236_()).f_46443_ && this.m_30614_() && this.m_146764_() == 0 && !this.m_27593_()) {
                flag = true;
                this.m_27595_(p_30593_);
            }
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
            flag = true;
        }
        if (this.m_6162_() && i > 0) {
            ((Level)this.m_9236_()).m_7106_(ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!((Level)this.m_9236_()).f_46443_) {
                this.m_146758_(i);
                flag = true;
            }
        }
        if (!(j <= 0 || !flag && this.m_30614_() || this.m_30624_() >= this.m_7555_() || ((Level)this.m_9236_()).f_46443_)) {
            this.m_30653_(j);
            flag = true;
        }
        if (flag) {
            this.m_30610_();
            this.m_146850_(GameEvent.f_157806_);
        }
        return flag;
    }

    protected void m_6835_(Player p_30634_) {
        this.m_30661_(false);
        this.m_30665_(false);
        if (!((Level)this.m_9236_()).f_46443_) {
            p_30634_.m_146922_(this.m_146908_());
            p_30634_.m_146926_(this.m_146909_());
            p_30634_.m_20329_(this);
        }
    }

    @Override
    public boolean m_6107_() {
        return super.m_6107_() && this.m_20160_() && this.m_6254_() || this.m_30617_() || this.m_30622_();
    }

    @Override
    public boolean m_6898_(ItemStack p_30644_) {
        return f_30527_.test(p_30644_);
    }

    private void m_30611_() {
        this.f_30517_ = 1;
    }

    @Override
    protected void m_5907_() {
        super.m_5907_();
        if (this.f_30520_ != null) {
            for (int i = 0; i < this.f_30520_.m_6643_(); ++i) {
                ItemStack itemstack = this.f_30520_.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_(itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    @Override
    public void m_8107_() {
        if (this.f_19796_.m_188503_(200) == 0) {
            this.m_30611_();
        }
        super.m_8107_();
        if (!((Level)this.m_9236_()).f_46443_ && this.m_6084_()) {
            if (this.f_19796_.m_188503_(900) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (this.m_7559_()) {
                if (!this.m_30617_() && !this.m_20160_() && this.f_19796_.m_188503_(300) == 0 && ((Level)this.m_9236_()).m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_)) {
                    this.m_30661_(true);
                }
                if (this.m_30617_() && ++this.f_30507_ > 50) {
                    this.f_30507_ = 0;
                    this.m_30661_(false);
                }
            }
            this.m_7567_();
        }
    }

    protected void m_7567_() {
        LivingEntity livingentity;
        if (this.m_30623_() && this.m_6162_() && !this.m_30617_() && (livingentity = this.m_9236_().m_45963_(AbstractHorse.class, f_30526_, this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(16.0))) != null && this.m_20280_(livingentity) > 4.0) {
            this.f_21344_.m_6570_(livingentity, 0);
        }
    }

    public boolean m_7559_() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_30508_ > 0 && ++this.f_30508_ > 30) {
            this.f_30508_ = 0;
            this.m_30597_(64, false);
        }
        if (this.m_21515_() && this.f_30509_ > 0 && ++this.f_30509_ > 20) {
            this.f_30509_ = 0;
            this.m_30665_(false);
        }
        if (this.f_30517_ > 0 && ++this.f_30517_ > 8) {
            this.f_30517_ = 0;
        }
        if (this.f_30518_ > 0) {
            ++this.f_30518_;
            if (this.f_30518_ > 300) {
                this.f_30518_ = 0;
            }
        }
        this.f_30512_ = this.f_30511_;
        if (this.m_30617_()) {
            this.f_30511_ += (1.0f - this.f_30511_) * 0.4f + 0.05f;
            if (this.f_30511_ > 1.0f) {
                this.f_30511_ = 1.0f;
            }
        } else {
            this.f_30511_ += (0.0f - this.f_30511_) * 0.4f - 0.05f;
            if (this.f_30511_ < 0.0f) {
                this.f_30511_ = 0.0f;
            }
        }
        this.f_30514_ = this.f_30513_;
        if (this.m_30622_()) {
            this.f_30512_ = this.f_30511_ = 0.0f;
            this.f_30513_ += (1.0f - this.f_30513_) * 0.4f + 0.05f;
            if (this.f_30513_ > 1.0f) {
                this.f_30513_ = 1.0f;
            }
        } else {
            this.f_30510_ = false;
            this.f_30513_ += (0.8f * this.f_30513_ * this.f_30513_ * this.f_30513_ - this.f_30513_) * 0.6f - 0.05f;
            if (this.f_30513_ < 0.0f) {
                this.f_30513_ = 0.0f;
            }
        }
        this.f_30516_ = this.f_30515_;
        if (this.m_30647_(64)) {
            this.f_30515_ += (1.0f - this.f_30515_) * 0.7f + 0.05f;
            if (this.f_30515_ > 1.0f) {
                this.f_30515_ = 1.0f;
            }
        } else {
            this.f_30515_ += (0.0f - this.f_30515_) * 0.7f - 0.05f;
            if (this.f_30515_ < 0.0f) {
                this.f_30515_ = 0.0f;
            }
        }
    }

    @Override
    public InteractionResult m_6071_(Player p_252289_, InteractionHand p_248927_) {
        if (!this.m_20160_() && !this.m_6162_()) {
            if (this.m_30614_() && p_252289_.m_36341_()) {
                this.m_213583_(p_252289_);
                return InteractionResult.m_19078_(((Level)this.m_9236_()).f_46443_);
            }
            ItemStack itemstack = p_252289_.m_21120_(p_248927_);
            if (!itemstack.m_41619_()) {
                InteractionResult interactionresult = itemstack.m_41647_(p_252289_, this, p_248927_);
                if (interactionresult.m_19077_()) {
                    return interactionresult;
                }
                if (this.m_7482_() && this.m_6010_(itemstack) && !this.m_7481_()) {
                    this.m_246861_(p_252289_, itemstack);
                    return InteractionResult.m_19078_(((Level)this.m_9236_()).f_46443_);
                }
            }
            this.m_6835_(p_252289_);
            return InteractionResult.m_19078_(((Level)this.m_9236_()).f_46443_);
        }
        return super.m_6071_(p_252289_, p_248927_);
    }

    private void m_30612_() {
        if (!((Level)this.m_9236_()).f_46443_) {
            this.f_30508_ = 1;
            this.m_30597_(64, true);
        }
    }

    public void m_30661_(boolean p_30662_) {
        this.m_30597_(16, p_30662_);
    }

    public void m_30665_(boolean p_30666_) {
        if (p_30666_) {
            this.m_30661_(false);
        }
        this.m_30597_(32, p_30666_);
    }

    @Nullable
    public SoundEvent m_247131_() {
        return this.m_7515_();
    }

    public void m_247525_() {
        if (this.m_245259_() && this.m_21515_()) {
            this.f_30509_ = 1;
            this.m_30665_(true);
        }
    }

    public void m_7564_() {
        if (!this.m_30622_()) {
            this.m_247525_();
            SoundEvent soundevent = this.m_7871_();
            if (soundevent != null) {
                this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
            }
        }
    }

    public boolean m_30637_(Player p_30638_) {
        this.m_30586_(p_30638_.m_20148_());
        this.m_30651_(true);
        if (p_30638_ instanceof ServerPlayer) {
            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)p_30638_, this);
        }
        ((Level)this.m_9236_()).m_7605_(this, (byte)7);
        return true;
    }

    @Override
    protected void m_274498_(Player p_278233_, Vec3 p_275693_) {
        super.m_274498_(p_278233_, p_275693_);
        Vec2 vec2 = this.m_274391_(p_278233_);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (this.m_6109_()) {
            if (p_275693_.f_82481_ <= 0.0) {
                this.f_30524_ = 0;
            }
            if (this.m_20096_()) {
                this.m_30655_(false);
                if (this.f_30522_ > 0.0f && !this.m_30616_()) {
                    this.m_245980_(this.f_30522_, p_275693_);
                }
                this.f_30522_ = 0.0f;
            }
        }
    }

    protected Vec2 m_274391_(LivingEntity p_275502_) {
        return new Vec2(p_275502_.m_146909_() * 0.5f, p_275502_.m_146908_());
    }

    @Override
    protected Vec3 m_274312_(Player p_278278_, Vec3 p_275506_) {
        if (this.m_20096_() && this.f_30522_ == 0.0f && this.m_30622_() && !this.f_30510_) {
            return Vec3.f_82478_;
        }
        float f = p_278278_.f_20900_ * 0.5f;
        float f1 = p_278278_.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3(f, 0.0, f1);
    }

    @Override
    protected float m_245547_(Player p_278336_) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    protected void m_245980_(float p_248808_, Vec3 p_275435_) {
        double d0 = this.m_30626_() * (double)p_248808_ * (double)this.m_20098_();
        double d1 = d0 + (double)this.m_285755_();
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
        this.m_30655_(true);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (p_275435_.f_82481_ > 0.0) {
            float f = Mth.m_14031_(this.m_146908_() * ((float)Math.PI / 180));
            float f1 = Mth.m_14089_(this.m_146908_() * ((float)Math.PI / 180));
            this.m_20256_(this.m_20184_().m_82520_(-0.4f * f * p_248808_, 0.0, 0.4f * f1 * p_248808_));
        }
    }

    protected void m_7486_() {
        this.m_5496_(SoundEvents.f_11979_, 0.4f, 1.0f);
    }

    @Override
    public void m_7380_(CompoundTag p_30589_) {
        super.m_7380_(p_30589_);
        p_30589_.m_128379_("EatingHaystack", this.m_30617_());
        p_30589_.m_128379_("Bred", this.m_30623_());
        p_30589_.m_128405_("Temper", this.m_30624_());
        p_30589_.m_128379_("Tame", this.m_30614_());
        if (this.m_21805_() != null) {
            p_30589_.m_128362_("Owner", this.m_21805_());
        }
        if (!this.f_30520_.m_8020_(0).m_41619_()) {
            p_30589_.m_128365_("SaddleItem", this.f_30520_.m_8020_(0).m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag p_30565_) {
        ItemStack itemstack;
        UUID uuid;
        super.m_7378_(p_30565_);
        this.m_30661_(p_30565_.m_128471_("EatingHaystack"));
        this.m_30657_(p_30565_.m_128471_("Bred"));
        this.m_30649_(p_30565_.m_128451_("Temper"));
        this.m_30651_(p_30565_.m_128471_("Tame"));
        if (p_30565_.m_128403_("Owner")) {
            uuid = p_30565_.m_128342_("Owner");
        } else {
            String s = p_30565_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_(this.m_20194_(), s);
        }
        if (uuid != null) {
            this.m_30586_(uuid);
        }
        if (p_30565_.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_(p_30565_.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.f_30520_.m_6836_(0, itemstack);
        }
        this.m_7493_();
    }

    @Override
    public boolean m_7848_(Animal p_30553_) {
        return false;
    }

    protected boolean m_30628_() {
        return !this.m_20160_() && !this.m_20159_() && this.m_30614_() && !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel p_149506_, AgeableMob p_149507_) {
        return null;
    }

    protected void m_149508_(AgeableMob p_149509_, AbstractHorse p_149510_) {
        this.m_272015_(p_149509_, p_149510_, Attributes.f_22276_, f_271313_, f_271308_);
        this.m_272015_(p_149509_, p_149510_, Attributes.f_22288_, f_271305_, f_271293_);
        this.m_272015_(p_149509_, p_149510_, Attributes.f_22279_, f_271139_, f_271541_);
    }

    private void m_272015_(AgeableMob p_273163_, AbstractHorse p_273784_, Attribute p_273681_, double p_272663_, double p_273405_) {
        double d0 = AbstractHorse.m_271715_(this.m_21172_(p_273681_), p_273163_.m_21172_(p_273681_), p_272663_, p_273405_, this.f_19796_);
        p_273784_.m_21051_(p_273681_).m_22100_(d0);
    }

    static double m_271715_(double p_272685_, double p_273709_, double p_273376_, double p_273030_, RandomSource p_272743_) {
        double d3;
        if (p_273030_ <= p_273376_) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        p_272685_ = Mth.m_14008_(p_272685_, p_273376_, p_273030_);
        p_273709_ = Mth.m_14008_(p_273709_, p_273376_, p_273030_);
        double d0 = 0.15 * (p_273030_ - p_273376_);
        double d2 = (p_272685_ + p_273709_) / 2.0;
        double d1 = Math.abs(p_272685_ - p_273709_) + d0 * 2.0;
        double d4 = d2 + d1 * (d3 = (p_272743_.m_188500_() + p_272743_.m_188500_() + p_272743_.m_188500_()) / 3.0 - 0.5);
        if (d4 > p_273030_) {
            double d6 = d4 - p_273030_;
            return p_273030_ - d6;
        }
        if (d4 < p_273376_) {
            double d5 = p_273376_ - d4;
            return p_273376_ + d5;
        }
        return d4;
    }

    public float m_30663_(float p_30664_) {
        return Mth.m_14179_(p_30664_, this.f_30512_, this.f_30511_);
    }

    public float m_30667_(float p_30668_) {
        return Mth.m_14179_(p_30668_, this.f_30514_, this.f_30513_);
    }

    public float m_30533_(float p_30534_) {
        return Mth.m_14179_(p_30534_, this.f_30516_, this.f_30515_);
    }

    @Override
    public void m_7888_(int p_30591_) {
        if (this.m_6254_()) {
            if (p_30591_ < 0) {
                p_30591_ = 0;
            } else {
                this.f_30510_ = true;
                this.m_247525_();
            }
            this.f_30522_ = p_30591_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_30591_ / 90.0f;
        }
    }

    @Override
    public boolean m_7132_() {
        return this.m_6254_();
    }

    @Override
    public void m_7199_(int p_30574_) {
        this.f_30510_ = true;
        this.m_247525_();
        this.m_7486_();
    }

    @Override
    public void m_8012_() {
    }

    protected void m_30669_(boolean p_30670_) {
        SimpleParticleType particleoptions = p_30670_ ? ParticleTypes.f_123750_ : ParticleTypes.f_123762_;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            ((Level)this.m_9236_()).m_7106_(particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    @Override
    public void m_7822_(byte p_30541_) {
        if (p_30541_ == 7) {
            this.m_30669_(true);
        } else if (p_30541_ == 6) {
            this.m_30669_(false);
        } else {
            super.m_7822_(p_30541_);
        }
    }

    @Override
    protected void m_19956_(Entity p_289569_, Entity.MoveFunction p_289558_) {
        super.m_19956_(p_289569_, p_289558_);
        if (p_289569_ instanceof LivingEntity) {
            ((LivingEntity)p_289569_).f_20883_ = this.f_20883_;
        }
    }

    protected static float m_271722_(IntUnaryOperator p_272695_) {
        return 15.0f + (float)p_272695_.applyAsInt(8) + (float)p_272695_.applyAsInt(9);
    }

    protected static double m_272017_(DoubleSupplier p_272718_) {
        return (double)0.4f + p_272718_.getAsDouble() * 0.2 + p_272718_.getAsDouble() * 0.2 + p_272718_.getAsDouble() * 0.2;
    }

    protected static double m_271981_(DoubleSupplier p_273691_) {
        return ((double)0.45f + p_273691_.getAsDouble() * 0.3 + p_273691_.getAsDouble() * 0.3 + p_273691_.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean m_6147_() {
        return false;
    }

    @Override
    protected float m_6431_(Pose p_30578_, EntityDimensions p_30579_) {
        return p_30579_.f_20378_ * 0.95f;
    }

    public boolean m_7482_() {
        return false;
    }

    public boolean m_7481_() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean m_6010_(ItemStack p_30645_) {
        return false;
    }

    private SlotAccess m_149502_(final int p_149503_, final Predicate<ItemStack> p_149504_) {
        return new SlotAccess(){

            @Override
            public ItemStack m_142196_() {
                return AbstractHorse.this.f_30520_.m_8020_(p_149503_);
            }

            @Override
            public boolean m_142104_(ItemStack p_149528_) {
                if (!p_149504_.test(p_149528_)) {
                    return false;
                }
                AbstractHorse.this.f_30520_.m_6836_(p_149503_, p_149528_);
                AbstractHorse.this.m_7493_();
                return true;
            }
        };
    }

    @Override
    public SlotAccess m_141942_(int p_149514_) {
        int j;
        int i = p_149514_ - 400;
        if (i >= 0 && i < 2 && i < this.f_30520_.m_6643_()) {
            if (i == 0) {
                return this.m_149502_(i, p_149516_ -> p_149516_.m_41619_() || p_149516_.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.m_7482_()) {
                    return SlotAccess.f_147290_;
                }
                return this.m_149502_(i, p_149516_ -> p_149516_.m_41619_() || this.m_6010_((ItemStack)((Object)p_149516_)));
            }
        }
        return (j = p_149514_ - 500 + 2) >= 2 && j < this.f_30520_.m_6643_() ? SlotAccess.m_147292_(this.f_30520_, j) : super.m_141942_(p_149514_);
    }

    @Override
    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (this.m_6254_() && (entity = this.m_146895_()) instanceof Player) {
            return (Player)entity;
        }
        return super.m_6688_();
    }

    @Nullable
    private Vec3 m_30561_(Vec3 p_30562_, LivingEntity p_30563_) {
        double d0 = this.m_20185_() + p_30562_.f_82479_;
        double d1 = this.m_20191_().f_82289_;
        double d2 = this.m_20189_() + p_30562_.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : p_30563_.m_7431_()) {
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            double d3 = this.m_20191_().f_82292_ + 0.75;
            do {
                double d4 = this.m_9236_().m_45573_(blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_(d4)) {
                    AABB aabb = p_30563_.m_21270_(pose);
                    Vec3 vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.m_123342_() + d4, d2);
                    if (DismountHelper.m_38456_((CollisionGetter)((Object)this.m_9236_()), p_30563_, aabb.m_82383_(vec3))) {
                        p_30563_.m_20124_(pose);
                        return vec3;
                    }
                }
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            } while ((double)blockpos$mutableblockpos.m_123342_() < d3);
        }
        return null;
    }

    @Override
    public Vec3 m_7688_(LivingEntity p_30576_) {
        Vec3 vec3 = AbstractHorse.m_19903_(this.m_20205_(), p_30576_.m_20205_(), this.m_146908_() + (p_30576_.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f));
        Vec3 vec31 = this.m_30561_(vec3, p_30576_);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = AbstractHorse.m_19903_(this.m_20205_(), p_30576_.m_20205_(), this.m_146908_() + (p_30576_.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f));
        Vec3 vec33 = this.m_30561_(vec32, p_30576_);
        return vec33 != null ? vec33 : this.m_20182_();
    }

    protected void m_214179_(RandomSource p_218804_) {
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_30555_, DifficultyInstance p_30556_, MobSpawnType p_30557_, @Nullable SpawnGroupData p_30558_, @Nullable CompoundTag p_30559_) {
        if (p_30558_ == null) {
            p_30558_ = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        this.m_214179_(p_30555_.m_213780_());
        return super.m_6518_(p_30555_, p_30556_, p_30557_, p_30558_, p_30559_);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_()) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean m_149511_(Container p_149512_) {
        return this.f_30520_ != p_149512_;
    }

    public int m_247558_() {
        return this.m_8100_();
    }

    @Override
    protected Vector3f m_292594_(Entity p_301103_, EntityDimensions p_298879_, float p_299886_) {
        return new Vector3f(0.0f, this.m_293694_(p_298879_, p_299886_) + 0.15f * this.f_30514_ * p_299886_, -0.7f * this.f_30514_ * p_299886_);
    }

    protected float m_293694_(EntityDimensions p_299002_, float p_297393_) {
        return p_299002_.f_20378_ + (this.m_6162_() ? 0.125f : -0.15625f) * p_297393_;
    }
}

