/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeBoat;
import org.joml.Vector3f;

public class Boat
extends VehicleEntity
implements IForgeBoat {
    private static final EntityDataAccessor<Integer> f_38285_ = SynchedEntityData.m_135353_(Boat.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> f_38286_ = SynchedEntityData.m_135353_(Boat.class, EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> f_38287_ = SynchedEntityData.m_135353_(Boat.class, EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> f_38262_ = SynchedEntityData.m_135353_(Boat.class, EntityDataSerializers.f_135028_);
    public static final int f_150268_ = 0;
    public static final int f_150269_ = 1;
    private static final int f_150266_ = 60;
    private static final float f_150267_ = 0.3926991f;
    public static final double f_150270_ = 0.7853981852531433;
    public static final int f_150271_ = 60;
    private final float[] f_38263_ = new float[2];
    private float f_38264_;
    private float f_38265_;
    private float f_38266_;
    private int f_38267_;
    private double f_38268_;
    private double f_38269_;
    private double f_38270_;
    private double f_38271_;
    private double f_38272_;
    private boolean f_38273_;
    private boolean f_38274_;
    private boolean f_38275_;
    private boolean f_38276_;
    private double f_38277_;
    private float f_38278_;
    private Status f_38279_;
    private Status f_38280_;
    private double f_38281_;
    private boolean f_38257_;
    private boolean f_38258_;
    private float f_38259_;
    private float f_38260_;
    private float f_38261_;

    public Boat(EntityType<? extends Boat> p_38290_, Level p_38291_) {
        super(p_38290_, p_38291_);
        this.f_19850_ = true;
    }

    public Boat(Level p_38293_, double p_38294_, double p_38295_, double p_38296_) {
        this((EntityType<? extends Boat>)EntityType.f_20552_, p_38293_);
        this.m_6034_(p_38294_, p_38295_, p_38296_);
        this.f_19854_ = p_38294_;
        this.f_19855_ = p_38295_;
        this.f_19856_ = p_38296_;
    }

    @Override
    protected float m_6380_(Pose p_38327_, EntityDimensions p_38328_) {
        return p_38328_.f_20378_;
    }

    @Override
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_38285_, Type.OAK.ordinal());
        this.f_19804_.m_135372_(f_38286_, false);
        this.f_19804_.m_135372_(f_38287_, false);
        this.f_19804_.m_135372_(f_38262_, 0);
    }

    @Override
    public boolean m_7337_(Entity p_38376_) {
        return Boat.m_38323_(this, p_38376_);
    }

    public static boolean m_38323_(Entity p_38324_, Entity p_38325_) {
        return (p_38325_.m_5829_() || p_38325_.m_6094_()) && !p_38324_.m_20365_(p_38325_);
    }

    @Override
    public boolean m_5829_() {
        return true;
    }

    @Override
    public boolean m_6094_() {
        return true;
    }

    @Override
    protected Vec3 m_7643_(Direction.Axis p_38335_, BlockUtil.FoundRectangle p_38336_) {
        return LivingEntity.m_21289_(super.m_7643_(p_38335_, p_38336_));
    }

    @Override
    protected Vector3f m_292594_(Entity p_299070_, EntityDimensions p_299244_, float p_298802_) {
        float f = this.m_213802_();
        if (this.m_20197_().size() > 1) {
            int i = this.m_20197_().indexOf(p_299070_);
            f = i == 0 ? 0.2f : -0.6f;
            if (p_299070_ instanceof Animal) {
                f += 0.2f;
            }
        }
        return new Vector3f(0.0f, this.m_28554_() == Type.BAMBOO ? p_299244_.f_20378_ * 0.8888889f : p_299244_.f_20378_ / 3.0f, f);
    }

    @Override
    public void m_6845_(boolean p_38381_) {
        if (!this.m_9236_().f_46443_) {
            this.f_38257_ = true;
            this.f_38258_ = p_38381_;
            if (this.m_38397_() == 0) {
                this.m_38366_(60);
            }
        }
        this.m_9236_().m_7106_(ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
        if (this.f_19796_.m_188503_(20) == 0) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5509_(), this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_(), false);
            this.m_146852_(GameEvent.f_157784_, this.m_6688_());
        }
    }

    @Override
    public void m_7334_(Entity p_38373_) {
        if (p_38373_ instanceof Boat) {
            if (p_38373_.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(p_38373_);
            }
        } else if (p_38373_.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(p_38373_);
        }
    }

    @Override
    public Item m_38369_() {
        return switch (this.m_28554_()) {
            case Type.SPRUCE -> Items.f_42742_;
            case Type.BIRCH -> Items.f_42743_;
            case Type.JUNGLE -> Items.f_42744_;
            case Type.ACACIA -> Items.f_42745_;
            case Type.CHERRY -> Items.f_271386_;
            case Type.DARK_OAK -> Items.f_42746_;
            case Type.MANGROVE -> Items.f_220204_;
            case Type.BAMBOO -> Items.f_244624_;
            default -> Items.f_42453_;
        };
    }

    @Override
    public void m_6053_(float p_265761_) {
        this.m_306256_(-this.m_305195_());
        this.m_307446_(10);
        this.m_305563_(this.m_304923_() * 11.0f);
    }

    @Override
    public boolean m_6087_() {
        return !this.m_213877_();
    }

    @Override
    public void m_6453_(double p_38299_, double p_38300_, double p_38301_, float p_38302_, float p_38303_, int p_38304_) {
        this.f_38268_ = p_38299_;
        this.f_38269_ = p_38300_;
        this.f_38270_ = p_38301_;
        this.f_38271_ = p_38302_;
        this.f_38272_ = p_38303_;
        this.f_38267_ = 10;
    }

    @Override
    public double m_293268_() {
        return this.f_38267_ > 0 ? this.f_38268_ : this.m_20185_();
    }

    @Override
    public double m_293950_() {
        return this.f_38267_ > 0 ? this.f_38269_ : this.m_20186_();
    }

    @Override
    public double m_292720_() {
        return this.f_38267_ > 0 ? this.f_38270_ : this.m_20189_();
    }

    @Override
    public float m_293123_() {
        return this.f_38267_ > 0 ? (float)this.f_38272_ : this.m_146909_();
    }

    @Override
    public float m_293582_() {
        return this.f_38267_ > 0 ? (float)this.f_38271_ : this.m_146908_();
    }

    @Override
    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    @Override
    public void m_8119_() {
        this.f_38280_ = this.f_38279_;
        this.f_38279_ = this.m_38392_();
        this.f_38265_ = this.f_38279_ != Status.UNDER_WATER && this.f_38279_ != Status.UNDER_FLOWING_WATER ? 0.0f : (this.f_38265_ += 1.0f);
        if (!this.m_9236_().f_46443_ && this.f_38265_ >= 60.0f) {
            this.m_20153_();
        }
        if (this.m_305464_() > 0) {
            this.m_307446_(this.m_305464_() - 1);
        }
        if (this.m_304923_() > 0.0f) {
            this.m_305563_(this.m_304923_() - 1.0f);
        }
        super.m_8119_();
        this.m_38391_();
        if (this.m_6109_()) {
            if (!(this.m_146895_() instanceof Player)) {
                this.m_38339_(false, false);
            }
            this.m_38395_();
            if (this.m_9236_().f_46443_) {
                this.m_38396_();
                this.m_9236_().m_5503_(new ServerboundPaddleBoatPacket(this.m_38313_(0), this.m_38313_(1)));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_38388_();
        for (int i = 0; i <= 1; ++i) {
            if (this.m_38313_(i)) {
                SoundEvent soundevent;
                if (!this.m_20067_() && (double)(this.f_38263_[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((this.f_38263_[i] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundevent = this.m_38370_()) != null) {
                    Vec3 vec3 = this.m_20252_(1.0f);
                    double d0 = i == 1 ? -vec3.f_82481_ : vec3.f_82481_;
                    double d1 = i == 1 ? vec3.f_82479_ : -vec3.f_82479_;
                    this.m_9236_().m_6263_(null, this.m_20185_() + d0, this.m_20186_(), this.m_20189_() + d1, soundevent, this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_());
                }
                int n = i;
                this.f_38263_[n] = this.f_38263_[n] + 0.3926991f;
                continue;
            }
            this.f_38263_[i] = 0.0f;
        }
        this.m_20101_();
        List<Entity> list = this.m_9236_().m_6249_(this, this.m_20191_().m_82377_(0.2f, -0.01f, 0.2f), EntitySelector.m_20421_(this));
        if (!list.isEmpty()) {
            boolean flag = !this.m_9236_().f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity : list) {
                if (entity.m_20363_(this)) continue;
                if (flag && this.m_20197_().size() < this.m_213801_() && !entity.m_20159_() && this.m_271938_(entity) && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_(this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
    }

    private void m_38388_() {
        if (this.m_9236_().f_46443_) {
            int i = this.m_38397_();
            this.f_38259_ = i > 0 ? (this.f_38259_ += 0.05f) : (this.f_38259_ -= 0.1f);
            this.f_38259_ = Mth.m_14036_(this.f_38259_, 0.0f, 1.0f);
            this.f_38261_ = this.f_38260_;
            this.f_38260_ = 10.0f * (float)Math.sin(0.5f * (float)this.m_9236_().m_46467_()) * this.f_38259_;
        } else {
            int k;
            if (!this.f_38257_) {
                this.m_38366_(0);
            }
            if ((k = this.m_38397_()) > 0) {
                this.m_38366_(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.m_38366_(0);
                    Vec3 vec3 = this.m_20184_();
                    if (this.f_38258_) {
                        this.m_20256_(vec3.m_82520_(0.0, -0.7, 0.0));
                        this.m_20153_();
                    } else {
                        this.m_20334_(vec3.f_82479_, this.m_146862_(p_150274_ -> p_150274_ instanceof Player) ? 2.7 : 0.6, vec3.f_82481_);
                    }
                }
                this.f_38257_ = false;
            }
        }
    }

    @Nullable
    protected SoundEvent m_38370_() {
        switch (this.m_38392_()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.f_11707_;
            }
            case ON_LAND: {
                return SoundEvents.f_11706_;
            }
        }
        return null;
    }

    private void m_38391_() {
        if (this.m_6109_()) {
            this.f_38267_ = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.f_38267_ > 0) {
            this.m_293725_(this.f_38267_, this.f_38268_, this.f_38269_, this.f_38270_, this.f_38271_, this.f_38272_);
            --this.f_38267_;
        }
    }

    public void m_38339_(boolean p_38340_, boolean p_38341_) {
        this.f_19804_.m_135381_(f_38286_, p_38340_);
        this.f_19804_.m_135381_(f_38287_, p_38341_);
    }

    public float m_38315_(int p_38316_, float p_38317_) {
        return this.m_38313_(p_38316_) ? Mth.m_144920_(this.f_38263_[p_38316_] - 0.3926991f, this.f_38263_[p_38316_], p_38317_) : 0.0f;
    }

    private Status m_38392_() {
        Status boat$status = this.m_38394_();
        if (boat$status != null) {
            this.f_38277_ = this.m_20191_().f_82292_;
            return boat$status;
        }
        if (this.m_38393_()) {
            return Status.IN_WATER;
        }
        float f = this.m_38377_();
        if (f > 0.0f) {
            this.f_38278_ = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float m_38371_() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_(aabb.f_82288_);
        int j = Mth.m_14165_(aabb.f_82291_);
        int k = Mth.m_14107_(aabb.f_82292_);
        int l = Mth.m_14165_(aabb.f_82292_ - this.f_38281_);
        int i1 = Mth.m_14107_(aabb.f_82290_);
        int j1 = Mth.m_14165_(aabb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_(blockpos$mutableblockpos);
                    if (this.canBoatInFluid(fluidstate)) {
                        f = Math.max(f, fluidstate.m_76155_(this.m_9236_(), blockpos$mutableblockpos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutableblockpos.m_123342_() + f;
        }
        return l + 1;
    }

    public float m_38377_() {
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_(aabb1.f_82288_) - 1;
        int j = Mth.m_14165_(aabb1.f_82291_) + 1;
        int k = Mth.m_14107_(aabb1.f_82289_) - 1;
        int l = Mth.m_14165_(aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_(aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_(aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_(aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_(blockstate.m_60812_(this.m_9236_(), blockpos$mutableblockpos).m_83216_(l1, k2, i2), voxelshape, BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction(this.m_9236_(), blockpos$mutableblockpos, this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean m_38393_() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_(aabb.f_82288_);
        int j = Mth.m_14165_(aabb.f_82291_);
        int k = Mth.m_14107_(aabb.f_82289_);
        int l = Mth.m_14165_(aabb.f_82289_ + 0.001);
        int i1 = Mth.m_14107_(aabb.f_82290_);
        int j1 = Mth.m_14165_(aabb.f_82293_);
        boolean flag = false;
        this.f_38277_ = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_(blockpos$mutableblockpos);
                    if (!this.canBoatInFluid(fluidstate)) continue;
                    float f = (float)l1 + fluidstate.m_76155_(this.m_9236_(), blockpos$mutableblockpos);
                    this.f_38277_ = Math.max((double)f, this.f_38277_);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status m_38394_() {
        AABB aabb = this.m_20191_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_(aabb.f_82288_);
        int j = Mth.m_14165_(aabb.f_82291_);
        int k = Mth.m_14107_(aabb.f_82292_);
        int l = Mth.m_14165_(d0);
        int i1 = Mth.m_14107_(aabb.f_82290_);
        int j1 = Mth.m_14165_(aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_(blockpos$mutableblockpos);
                    if (!this.canBoatInFluid(fluidstate) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_(this.m_9236_(), blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private void m_38395_() {
        double d0 = -0.04f;
        double d1 = this.m_20068_() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.f_38264_ = 0.05f;
        if (this.f_38280_ == Status.IN_AIR && this.f_38279_ != Status.IN_AIR && this.f_38279_ != Status.ON_LAND) {
            this.f_38277_ = this.m_20227_(1.0);
            this.m_6034_(this.m_20185_(), (double)(this.m_38371_() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.f_38281_ = 0.0;
            this.f_38279_ = Status.IN_WATER;
        } else {
            if (this.f_38279_ == Status.IN_WATER) {
                d2 = (this.f_38277_ - this.m_20186_()) / (double)this.m_20206_();
                this.f_38264_ = 0.9f;
            } else if (this.f_38279_ == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.f_38264_ = 0.9f;
            } else if (this.f_38279_ == Status.UNDER_WATER) {
                d2 = 0.01f;
                this.f_38264_ = 0.45f;
            } else if (this.f_38279_ == Status.IN_AIR) {
                this.f_38264_ = 0.9f;
            } else if (this.f_38279_ == Status.ON_LAND) {
                this.f_38264_ = this.f_38278_;
                if (this.m_6688_() instanceof Player) {
                    this.f_38278_ /= 2.0f;
                }
            }
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_ * (double)this.f_38264_, vec3.f_82480_ + d1, vec3.f_82481_ * (double)this.f_38264_);
            this.f_38266_ *= this.f_38264_;
            if (d2 > 0.0) {
                Vec3 vec31 = this.m_20184_();
                this.m_20334_(vec31.f_82479_, (vec31.f_82480_ + d2 * 0.06153846016296973) * 0.75, vec31.f_82481_);
            }
        }
    }

    private void m_38396_() {
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.f_38273_) {
                this.f_38266_ -= 1.0f;
            }
            if (this.f_38274_) {
                this.f_38266_ += 1.0f;
            }
            if (this.f_38274_ != this.f_38273_ && !this.f_38275_ && !this.f_38276_) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.f_38266_);
            if (this.f_38275_) {
                f += 0.04f;
            }
            if (this.f_38276_) {
                f -= 0.005f;
            }
            this.m_20256_(this.m_20184_().m_82520_(Mth.m_14031_(-this.m_146908_() * ((float)Math.PI / 180)) * f, 0.0, Mth.m_14089_(this.m_146908_() * ((float)Math.PI / 180)) * f));
            this.m_38339_(this.f_38274_ && !this.f_38273_ || this.f_38275_, this.f_38273_ && !this.f_38274_ || this.f_38275_);
        }
    }

    protected float m_213802_() {
        return 0.0f;
    }

    public boolean m_271938_(Entity p_273171_) {
        return p_273171_.m_20205_() < this.m_20205_();
    }

    @Override
    protected void m_19956_(Entity p_289552_, Entity.MoveFunction p_289571_) {
        super.m_19956_(p_289552_, p_289571_);
        if (!p_289552_.m_6095_().m_204039_(EntityTypeTags.f_302423_)) {
            p_289552_.m_146922_(p_289552_.m_146908_() + this.f_38266_);
            p_289552_.m_5616_(p_289552_.m_6080_() + this.f_38266_);
            this.m_38321_(p_289552_);
            if (p_289552_ instanceof Animal && this.m_20197_().size() == this.m_213801_()) {
                int i = p_289552_.m_19879_() % 2 == 0 ? 90 : 270;
                p_289552_.m_5618_(((Animal)p_289552_).f_20883_ + (float)i);
                p_289552_.m_5616_(p_289552_.m_6080_() + (float)i);
            }
        }
    }

    @Override
    public Vec3 m_7688_(LivingEntity p_38357_) {
        Vec3 vec3 = Boat.m_19903_(this.m_20205_() * Mth.f_13994_, p_38357_.m_20205_(), p_38357_.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        BlockPos blockpos = BlockPos.m_274561_(d0, this.m_20191_().f_82292_, d1);
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.m_9236_().m_46801_(blockpos1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.m_9236_().m_45573_(blockpos);
            if (DismountHelper.m_38439_(d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_(d3 = this.m_9236_().m_45573_(blockpos1))) {
                list.add(new Vec3(d0, (double)blockpos1.m_123342_() + d3, d1));
            }
            for (Pose pose : p_38357_.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_(this.m_9236_(), vec31, p_38357_, pose)) continue;
                    p_38357_.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return super.m_7688_(p_38357_);
    }

    protected void m_38321_(Entity p_38322_) {
        p_38322_.m_5618_(this.m_146908_());
        float f = Mth.m_14177_(p_38322_.m_146908_() - this.m_146908_());
        float f1 = Mth.m_14036_(f, -105.0f, 105.0f);
        p_38322_.f_19859_ += f1 - f;
        p_38322_.m_146922_(p_38322_.m_146908_() + f1 - f);
        p_38322_.m_5616_(p_38322_.m_146908_());
    }

    @Override
    public void m_7340_(Entity p_38383_) {
        this.m_38321_(p_38383_);
    }

    @Override
    protected void m_7380_(CompoundTag p_38359_) {
        p_38359_.m_128359_("Type", this.m_28554_().m_7912_());
    }

    @Override
    protected void m_7378_(CompoundTag p_38338_) {
        if (p_38338_.m_128425_("Type", 8)) {
            this.m_28464_(Type.m_38432_(p_38338_.m_128461_("Type")));
        }
    }

    @Override
    public InteractionResult m_6096_(Player p_38330_, InteractionHand p_38331_) {
        if (p_38330_.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (this.f_38265_ < 60.0f) {
            if (!this.m_9236_().f_46443_) {
                return p_38330_.m_20329_(this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7840_(double p_38307_, boolean p_38308_, BlockState p_38309_, BlockPos p_38310_) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (p_38308_) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_(this.m_28554_().m_38434_());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_(Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.canBoatInFluid(this.m_9236_().m_6425_(this.m_20183_().m_7495_())) && p_38307_ < 0.0) {
                this.f_19789_ -= (float)p_38307_;
            }
        }
    }

    public boolean m_38313_(int p_38314_) {
        return this.f_19804_.m_135370_(p_38314_ == 0 ? f_38286_ : f_38287_) != false && this.m_6688_() != null;
    }

    private void m_38366_(int p_38367_) {
        this.f_19804_.m_135381_(f_38262_, p_38367_);
    }

    private int m_38397_() {
        return this.f_19804_.m_135370_(f_38262_);
    }

    public float m_38352_(float p_38353_) {
        return Mth.m_14179_(p_38353_, this.f_38261_, this.f_38260_);
    }

    public void m_28464_(Type p_38333_) {
        this.f_19804_.m_135381_(f_38285_, p_38333_.ordinal());
    }

    public Type m_28554_() {
        return Type.m_38430_(this.f_19804_.m_135370_(f_38285_));
    }

    @Override
    protected boolean m_7310_(Entity p_38390_) {
        return this.m_20197_().size() < this.m_213801_() && !this.canBoatInFluid(this.getEyeInFluidType());
    }

    protected int m_213801_() {
        return 2;
    }

    @Override
    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingentity;
        Entity entity = this.m_146895_();
        LivingEntity livingentity1 = entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : super.m_6688_();
        return livingentity1;
    }

    public void m_38342_(boolean p_38343_, boolean p_38344_, boolean p_38345_, boolean p_38346_) {
        this.f_38273_ = p_38343_;
        this.f_38274_ = p_38344_;
        this.f_38275_ = p_38345_;
        this.f_38276_ = p_38346_;
    }

    @Override
    protected Component m_5677_() {
        return Component.m_237115_(this.m_38369_().m_5524_());
    }

    @Override
    public boolean m_5842_() {
        return this.f_38279_ == Status.UNDER_WATER || this.f_38279_ == Status.UNDER_FLOWING_WATER;
    }

    @Override
    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.f_38267_ > 0) {
            this.f_38267_ = 0;
            this.m_19890_(this.f_38268_, this.f_38269_, this.f_38270_, (float)this.f_38271_, (float)this.f_38272_);
        }
    }

    @Override
    public ItemStack m_142340_() {
        return new ItemStack(this.m_38369_());
    }

    public static final class Type
    extends Enum<Type>
    implements StringRepresentable {
        public static final /* enum */ Type OAK = new Type(Blocks.f_50705_, "oak");
        public static final /* enum */ Type SPRUCE = new Type(Blocks.f_50741_, "spruce");
        public static final /* enum */ Type BIRCH = new Type(Blocks.f_50742_, "birch");
        public static final /* enum */ Type JUNGLE = new Type(Blocks.f_50743_, "jungle");
        public static final /* enum */ Type ACACIA = new Type(Blocks.f_50744_, "acacia");
        public static final /* enum */ Type CHERRY = new Type(Blocks.f_271304_, "cherry");
        public static final /* enum */ Type DARK_OAK = new Type(Blocks.f_50745_, "dark_oak");
        public static final /* enum */ Type MANGROVE = new Type(Blocks.f_220865_, "mangrove");
        public static final /* enum */ Type BAMBOO = new Type(Blocks.f_244477_, "bamboo");
        private final String f_38420_;
        private final Block f_38421_;
        public static final StringRepresentable.EnumCodec<Type> f_262275_;
        private static final IntFunction<Type> f_262735_;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_38437_) {
            return Enum.valueOf(Type.class, p_38437_);
        }

        private Type(Block p_38427_, String p_38428_) {
            this.f_38420_ = p_38428_;
            this.f_38421_ = p_38427_;
        }

        @Override
        public String m_7912_() {
            return this.f_38420_;
        }

        public String m_38429_() {
            return this.f_38420_;
        }

        public Block m_38434_() {
            return this.f_38421_;
        }

        public String toString() {
            return this.f_38420_;
        }

        public static Type m_38430_(int p_38431_) {
            return f_262735_.apply(p_38431_);
        }

        public static Type m_38432_(String p_38433_) {
            return f_262275_.m_262792_(p_38433_, OAK);
        }

        private static /* synthetic */ Type[] m_150277_() {
            return new Type[]{OAK, SPRUCE, BIRCH, JUNGLE, ACACIA, CHERRY, DARK_OAK, MANGROVE, BAMBOO};
        }

        static {
            $VALUES = Type.m_150277_();
            f_262275_ = StringRepresentable.m_216439_(Type::values);
            f_262735_ = ByIdMap.m_262839_(Enum::ordinal, Type.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status IN_WATER = new Status();
        public static final /* enum */ Status UNDER_WATER = new Status();
        public static final /* enum */ Status UNDER_FLOWING_WATER = new Status();
        public static final /* enum */ Status ON_LAND = new Status();
        public static final /* enum */ Status IN_AIR = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String p_38412_) {
            return Enum.valueOf(Status.class, p_38412_);
        }

        private static /* synthetic */ Status[] m_150276_() {
            return new Status[]{IN_WATER, UNDER_WATER, UNDER_FLOWING_WATER, ON_LAND, IN_AIR};
        }

        static {
            $VALUES = Status.m_150276_();
        }
    }
}

