/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;

public class BoneMealItem
extends Item {
    public static final int f_150701_ = 3;
    public static final int f_150702_ = 1;
    public static final int f_150703_ = 3;

    public BoneMealItem(Item.Properties p_40626_) {
        super(p_40626_);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext p_40637_) {
        Level level = p_40637_.m_43725_();
        BlockPos blockpos = p_40637_.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(p_40637_.m_43719_());
        if (BoneMealItem.applyBonemeal(p_40637_.m_43722_(), level, blockpos, p_40637_.m_43723_())) {
            if (!level.f_46443_) {
                p_40637_.m_43723_().m_146850_(GameEvent.f_223697_);
                level.m_46796_(1505, blockpos, 0);
            }
            return InteractionResult.m_19078_(level.f_46443_);
        }
        BlockState blockstate = level.m_8055_(blockpos);
        boolean flag = blockstate.m_60783_(level, blockpos, p_40637_.m_43719_());
        if (flag && BoneMealItem.m_40631_(p_40637_.m_43722_(), level, blockpos1, p_40637_.m_43719_())) {
            if (!level.f_46443_) {
                p_40637_.m_43723_().m_146850_(GameEvent.f_223697_);
                level.m_46796_(1505, blockpos1, 0);
            }
            return InteractionResult.m_19078_(level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Deprecated
    public static boolean m_40627_(ItemStack p_40628_, Level p_40629_, BlockPos p_40630_) {
        if (p_40629_ instanceof ServerLevel) {
            return BoneMealItem.applyBonemeal(p_40628_, p_40629_, p_40630_, null);
        }
        return false;
    }

    public static boolean applyBonemeal(ItemStack p_40628_, Level p_40629_, BlockPos p_40630_, Player player) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = p_40629_.m_8055_(p_40630_);
        int hook = ForgeEventFactory.onApplyBonemeal((Player)player, (Level)p_40629_, (BlockPos)p_40630_, (BlockState)blockstate, (ItemStack)p_40628_);
        if (hook != 0) {
            return hook > 0;
        }
        Block block = blockstate.m_60734_();
        if (block instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)((Object)block)).m_7370_(p_40629_, p_40630_, blockstate)) {
            if (p_40629_ instanceof ServerLevel) {
                if (bonemealableblock.m_214167_(p_40629_, p_40629_.f_46441_, p_40630_, blockstate)) {
                    bonemealableblock.m_214148_((ServerLevel)p_40629_, p_40629_.f_46441_, p_40630_, blockstate);
                }
                p_40628_.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public static boolean m_40631_(ItemStack p_40632_, Level p_40633_, BlockPos p_40634_, @Nullable Direction p_40635_) {
        if (p_40633_.m_8055_(p_40634_).m_60713_(Blocks.f_49990_) && p_40633_.m_6425_(p_40634_).m_76186_() == 8) {
            if (!(p_40633_ instanceof ServerLevel)) {
                return true;
            }
            RandomSource randomsource = p_40633_.m_213780_();
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = p_40634_;
                BlockState blockstate = Blocks.f_50037_.m_49966_();
                for (int j = 0; j < i / 16; ++j) {
                    if (p_40633_.m_8055_(blockpos = blockpos.m_7918_(randomsource.m_188503_(3) - 1, (randomsource.m_188503_(3) - 1) * randomsource.m_188503_(3) / 2, randomsource.m_188503_(3) - 1)).m_60838_(p_40633_, blockpos)) continue block0;
                }
                Holder holder = p_40633_.m_204166_(blockpos);
                if (holder.m_203656_(BiomeTags.f_215804_)) {
                    if (i == 0 && p_40635_ != null && p_40635_.m_122434_().m_122479_()) {
                        blockstate = BuiltInRegistries.f_256975_.m_203431_(BlockTags.f_13052_).flatMap(p_204098_ -> p_204098_.m_213653_(p_204097_.f_46441_)).map(p_204100_ -> ((Block)p_204100_.m_203334_()).m_49966_()).orElse(blockstate);
                        if (blockstate.m_61138_(BaseCoralWallFanBlock.f_49192_)) {
                            blockstate = (BlockState)blockstate.m_61124_(BaseCoralWallFanBlock.f_49192_, p_40635_);
                        }
                    } else if (randomsource.m_188503_(4) == 0) {
                        blockstate = BuiltInRegistries.f_256975_.m_203431_(BlockTags.f_13050_).flatMap(p_204091_ -> p_204091_.m_213653_(p_204090_.f_46441_)).map(p_204095_ -> ((Block)p_204095_.m_203334_()).m_49966_()).orElse(blockstate);
                    }
                }
                if (blockstate.m_204338_(BlockTags.f_13052_, p_204093_ -> p_204093_.m_61138_(BaseCoralWallFanBlock.f_49192_))) {
                    for (int k = 0; !blockstate.m_60710_(p_40633_, blockpos) && k < 4; ++k) {
                        blockstate = (BlockState)blockstate.m_61124_(BaseCoralWallFanBlock.f_49192_, Direction.Plane.HORIZONTAL.m_235690_(randomsource));
                    }
                }
                if (!blockstate.m_60710_(p_40633_, blockpos)) continue;
                BlockState blockstate1 = p_40633_.m_8055_(blockpos);
                if (blockstate1.m_60713_(Blocks.f_49990_) && p_40633_.m_6425_(blockpos).m_76186_() == 8) {
                    p_40633_.m_7731_(blockpos, blockstate, 3);
                    continue;
                }
                if (!blockstate1.m_60713_(Blocks.f_50037_) || randomsource.m_188503_(10) != 0) continue;
                ((BonemealableBlock)((Object)Blocks.f_50037_)).m_214148_((ServerLevel)p_40633_, randomsource, blockpos, blockstate1);
            }
            p_40632_.m_41774_(1);
            return true;
        }
        return false;
    }

    public static void m_40638_(LevelAccessor p_40639_, BlockPos p_40640_, int p_40641_) {
        BlockState blockstate;
        if (p_40641_ == 0) {
            p_40641_ = 15;
        }
        if (!(blockstate = p_40639_.m_8055_(p_40640_)).m_60795_()) {
            double d1;
            double d0 = 0.5;
            if (blockstate.m_60713_(Blocks.f_49990_)) {
                p_40641_ *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.m_60804_(p_40639_, p_40640_)) {
                p_40640_ = p_40640_.m_7494_();
                p_40641_ *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.m_60808_(p_40639_, p_40640_).m_83297_(Direction.Axis.Y);
            }
            p_40639_.m_7106_(ParticleTypes.f_123748_, (double)p_40640_.m_123341_() + 0.5, (double)p_40640_.m_123342_() + 0.5, (double)p_40640_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            RandomSource randomsource = p_40639_.m_213780_();
            for (int i = 0; i < p_40641_; ++i) {
                double d8;
                double d7;
                double d2 = randomsource.m_188583_() * 0.02;
                double d3 = randomsource.m_188583_() * 0.02;
                double d4 = randomsource.m_188583_() * 0.02;
                double d5 = 0.5 - d0;
                double d6 = (double)p_40640_.m_123341_() + d5 + randomsource.m_188500_() * d0 * 2.0;
                if (p_40639_.m_8055_(BlockPos.m_274561_(d6, d7 = (double)p_40640_.m_123342_() + randomsource.m_188500_() * d1, d8 = (double)p_40640_.m_123343_() + d5 + randomsource.m_188500_() * d0 * 2.0).m_7495_()).m_60795_()) continue;
                p_40639_.m_7106_(ParticleTypes.f_123748_, d6, d7, d8, d2, d3, d4);
            }
        }
    }
}

