/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class BucketItem
extends Item
implements DispensibleContainerItem {
    private final Fluid f_40687_;
    private final Supplier<? extends Fluid> fluidSupplier;

    @Deprecated
    public BucketItem(Fluid p_40689_, Item.Properties p_40690_) {
        super(p_40690_);
        this.f_40687_ = p_40689_;
        this.fluidSupplier = ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)p_40689_);
    }

    public BucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(builder);
        this.f_40687_ = null;
        this.fluidSupplier = supplier;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_40703_, Player p_40704_, InteractionHand p_40705_) {
        BlockHitResult blockhitresult;
        ItemStack itemstack = p_40704_.m_21120_(p_40705_);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)p_40704_, (Level)p_40703_, (ItemStack)itemstack, (HitResult)(blockhitresult = BucketItem.m_41435_(p_40703_, p_40704_, this.f_40687_ == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_(itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_(itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (p_40703_.m_7966_(p_40704_, blockpos) && p_40704_.m_36204_(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (this.f_40687_ == Fluids.f_76191_) {
                BucketPickup bucketpickup;
                ItemStack itemstack2;
                BlockState blockstate1 = p_40703_.m_8055_(blockpos);
                Block $$10 = blockstate1.m_60734_();
                if ($$10 instanceof BucketPickup && !(itemstack2 = (bucketpickup = (BucketPickup)((Object)$$10)).m_142598_(p_40704_, p_40703_, blockpos, blockstate1)).m_41619_()) {
                    p_40704_.m_36246_(Stats.f_12982_.m_12902_(this));
                    bucketpickup.getPickupSound(blockstate1).ifPresent(p_150709_ -> p_40704_.m_5496_((SoundEvent)p_150709_, 1.0f, 1.0f));
                    p_40703_.m_142346_(p_40704_, GameEvent.f_157816_, blockpos);
                    ItemStack itemstack1 = ItemUtils.m_41813_(itemstack, p_40704_, itemstack2);
                    if (!p_40703_.f_46443_) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)p_40704_, itemstack2);
                    }
                    return InteractionResultHolder.m_19092_(itemstack1, p_40703_.m_5776_());
                }
                return InteractionResultHolder.m_19100_(itemstack);
            }
            BlockState blockstate = p_40703_.m_8055_(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(p_40703_, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.emptyContents(p_40704_, p_40703_, blockpos2, blockhitresult, itemstack)) {
                this.m_142131_(p_40704_, p_40703_, itemstack, blockpos2);
                if (p_40704_ instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)p_40704_, blockpos2, itemstack);
                }
                p_40704_.m_36246_(Stats.f_12982_.m_12902_(this));
                return InteractionResultHolder.m_19092_(BucketItem.m_40699_(itemstack, p_40704_), p_40703_.m_5776_());
            }
            return InteractionResultHolder.m_19100_(itemstack);
        }
        return InteractionResultHolder.m_19100_(itemstack);
    }

    public static ItemStack m_40699_(ItemStack p_40700_, Player p_40701_) {
        return !p_40701_.m_150110_().f_35937_ ? new ItemStack(Items.f_42446_) : p_40700_;
    }

    @Override
    public void m_142131_(@Nullable Player p_150711_, Level p_150712_, ItemStack p_150713_, BlockPos p_150714_) {
    }

    @Override
    @Deprecated
    public boolean m_142073_(@Nullable Player p_150716_, Level p_150717_, BlockPos p_150718_, @Nullable BlockHitResult p_150719_) {
        return this.emptyContents(p_150716_, p_150717_, p_150718_, p_150719_, null);
    }

    public boolean emptyContents(@Nullable Player p_150716_, Level p_150717_, BlockPos p_150718_, @Nullable BlockHitResult p_150719_, @Nullable ItemStack container) {
        Fluid $$6 = this.f_40687_;
        if ($$6 instanceof FlowingFluid) {
            LiquidBlockContainer liquid;
            LiquidBlockContainer liquidblockcontainer;
            FlowingFluid flowingfluid = (FlowingFluid)$$6;
            BlockState blockstate = p_150717_.m_8055_(p_150718_);
            Block $$7 = blockstate.m_60734_();
            boolean $$8 = blockstate.m_60722_(this.f_40687_);
            boolean flag2 = blockstate.m_60795_() || $$8 || $$7 instanceof LiquidBlockContainer && (liquidblockcontainer = (LiquidBlockContainer)((Object)$$7)).m_6044_(p_150716_, p_150717_, p_150718_, blockstate, this.f_40687_);
            boolean flag1 = flag2;
            Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
            if (!flag1) {
                return p_150719_ != null && this.emptyContents(p_150716_, p_150717_, p_150719_.m_82425_().m_121945_(p_150719_.m_82434_()), null, container);
            }
            if (containedFluidStack.isPresent() && this.f_40687_.getFluidType().isVaporizedOnPlacement(p_150717_, p_150718_, (FluidStack)containedFluidStack.get())) {
                this.f_40687_.getFluidType().onVaporize(p_150716_, p_150717_, p_150718_, (FluidStack)containedFluidStack.get());
                return true;
            }
            if (p_150717_.m_6042_().f_63857_() && this.f_40687_.m_205067_(FluidTags.f_13131_)) {
                int l = p_150718_.m_123341_();
                int i = p_150718_.m_123342_();
                int j = p_150718_.m_123343_();
                p_150717_.m_5594_(p_150716_, p_150718_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (p_150717_.f_46441_.m_188501_() - p_150717_.f_46441_.m_188501_()) * 0.8f);
                for (int k = 0; k < 8; ++k) {
                    p_150717_.m_7106_(ParticleTypes.f_123755_, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0);
                }
                return true;
            }
            if ($$7 instanceof LiquidBlockContainer && (liquid = (LiquidBlockContainer)((Object)$$7)).m_6044_(p_150716_, p_150717_, p_150718_, blockstate, this.f_40687_)) {
                LiquidBlockContainer liquidblockcontainer1 = (LiquidBlockContainer)((Object)$$7);
                if (this.f_40687_ == Fluids.f_76193_) {
                    liquidblockcontainer1.m_7361_(p_150717_, p_150718_, blockstate, flowingfluid.m_76068_(false));
                    this.m_7718_(p_150716_, p_150717_, p_150718_);
                    return true;
                }
            }
            if (!p_150717_.f_46443_ && $$8 && !blockstate.m_278721_()) {
                p_150717_.m_46961_(p_150718_, true);
            }
            if (!p_150717_.m_7731_(p_150718_, this.f_40687_.m_76145_().m_76188_(), 11) && !blockstate.m_60819_().m_76170_()) {
                return false;
            }
            this.m_7718_(p_150716_, p_150717_, p_150718_);
            return true;
        }
        return false;
    }

    protected void m_7718_(@Nullable Player p_40696_, LevelAccessor p_40697_, BlockPos p_40698_) {
        SoundEvent soundevent = this.f_40687_.getFluidType().getSound(p_40696_, (BlockGetter)p_40697_, p_40698_, SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = this.f_40687_.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        p_40697_.m_5594_(p_40696_, p_40698_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        p_40697_.m_142346_(p_40696_, GameEvent.f_157769_, p_40698_);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (this.getClass() == BucketItem.class) {
            return new FluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public Fluid getFluid() {
        return this.fluidSupplier.get();
    }

    protected boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        LiquidBlockContainer liquid;
        Block block = blockstate.m_60734_();
        return block instanceof LiquidBlockContainer && (liquid = (LiquidBlockContainer)((Object)block)).m_6044_(null, worldIn, posIn, blockstate, this.f_40687_);
    }
}

