/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class ShovelItem
extends DiggerItem {
    protected static final Map<Block, BlockState> f_43110_ = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)Blocks.f_50440_, (Object)Blocks.f_152481_.m_49966_()).put((Object)Blocks.f_50493_, (Object)Blocks.f_152481_.m_49966_()).put((Object)Blocks.f_50599_, (Object)Blocks.f_152481_.m_49966_()).put((Object)Blocks.f_50546_, (Object)Blocks.f_152481_.m_49966_()).put((Object)Blocks.f_50195_, (Object)Blocks.f_152481_.m_49966_()).put((Object)Blocks.f_152549_, (Object)Blocks.f_152481_.m_49966_()).build());

    public ShovelItem(Tier p_43114_, float p_43115_, float p_43116_, Item.Properties p_43117_) {
        super(p_43115_, p_43116_, p_43114_, BlockTags.f_144283_, p_43117_);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext p_43119_) {
        Level level = p_43119_.m_43725_();
        BlockPos blockpos = p_43119_.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (p_43119_.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = p_43119_.m_43723_();
        BlockState blockstate1 = blockstate.getToolModifiedState(p_43119_, ToolActions.SHOVEL_FLATTEN, false);
        BlockState blockstate2 = null;
        if (blockstate1 != null && level.m_46859_(blockpos.m_7494_())) {
            level.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.m_60734_() instanceof CampfireBlock && blockstate.m_61143_(CampfireBlock.f_51227_).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_5898_(null, 1009, blockpos, 0);
            }
            CampfireBlock.m_152749_(p_43119_.m_43723_(), level, blockpos, blockstate);
            blockstate2 = (BlockState)blockstate.m_61124_(CampfireBlock.f_51227_, false);
        }
        if (blockstate2 != null) {
            if (!level.f_46443_) {
                level.m_7731_(blockpos, blockstate2, 11);
                level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_(player, blockstate2));
                if (player != null) {
                    p_43119_.m_43722_().m_41622_(1, player, p_43122_ -> p_43122_.m_21190_(p_43119_.m_43724_()));
                }
            }
            return InteractionResult.m_19078_(level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static BlockState getShovelPathingState(BlockState originalState) {
        return f_43110_.get(originalState.m_60734_());
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction);
    }
}

