/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;

public class Ingredient
implements Predicate<ItemStack> {
    private static final AtomicInteger INVALIDATION_COUNTER = new AtomicInteger();
    public static final Ingredient f_43901_ = new Ingredient(Stream.empty());
    private final Value[] f_43902_;
    @Nullable
    private ItemStack[] f_43903_;
    @Nullable
    private IntList f_43904_;
    public static final Codec<Ingredient> VANILLA_CODEC = Ingredient.m_294319_(true);
    public static final Codec<Ingredient> f_291570_ = ForgeHooks.enhanceIngredientCodec(VANILLA_CODEC);
    private static final Codec<Ingredient> VANILLA_CODEC_NONEMPTY = Ingredient.m_294319_(false);
    public static final Codec<Ingredient> f_290991_ = ForgeHooks.enhanceIngredientCodec(VANILLA_CODEC_NONEMPTY);
    private int invalidationCounter;
    private final boolean isVanilla = this.getClass() == Ingredient.class;

    public static void invalidateAll() {
        INVALIDATION_COUNTER.incrementAndGet();
    }

    protected Ingredient(Stream<? extends Value> p_43907_) {
        this.f_43902_ = (Value[])p_43907_.toArray(Value[]::new);
    }

    private Ingredient(Value[] p_301101_) {
        this.f_43902_ = p_301101_;
    }

    public ItemStack[] m_43908_() {
        if (this.f_43903_ == null || this.checkInvalidation()) {
            this.f_43903_ = (ItemStack[])Arrays.stream(this.f_43902_).flatMap(p_43916_ -> p_43916_.m_6223_().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.f_43903_;
    }

    @Override
    public boolean test(@Nullable ItemStack p_43914_) {
        if (p_43914_ == null) {
            return false;
        }
        if (this.m_43947_()) {
            return p_43914_.m_41619_();
        }
        for (ItemStack itemstack : this.m_43908_()) {
            if (!itemstack.m_150930_(p_43914_.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public IntList m_43931_() {
        if (this.f_43904_ == null || this.checkInvalidation()) {
            this.markValid();
            ItemStack[] aitemstack = this.m_43908_();
            this.f_43904_ = new IntArrayList(aitemstack.length);
            for (ItemStack itemstack : aitemstack) {
                this.f_43904_.add(StackedContents.m_36496_(itemstack));
            }
            this.f_43904_.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.f_43904_;
    }

    public final void m_43923_(FriendlyByteBuf p_43924_) {
        if (ForgeHooks.ingredientToNetwork((FriendlyByteBuf)p_43924_, (Ingredient)this)) {
            p_43924_.m_236828_(Arrays.asList(this.m_43908_()), FriendlyByteBuf::m_130055_);
        }
    }

    public boolean m_43947_() {
        return this.f_43902_.length == 0;
    }

    public boolean equals(Object p_300457_) {
        if (p_300457_ instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)p_300457_;
            return Arrays.equals(this.f_43902_, ingredient.f_43902_);
        }
        return false;
    }

    public final boolean checkInvalidation() {
        int currentInvalidationCounter = INVALIDATION_COUNTER.get();
        if (this.invalidationCounter != currentInvalidationCounter) {
            this.invalidate();
            return true;
        }
        return false;
    }

    protected final void markValid() {
        this.invalidationCounter = INVALIDATION_COUNTER.get();
    }

    protected void invalidate() {
        this.f_43903_ = null;
        this.f_43904_ = null;
    }

    public boolean isSimple() {
        return true;
    }

    public final boolean isVanilla() {
        return this.isVanilla;
    }

    public IIngredientSerializer<? extends Ingredient> serializer() {
        if (!this.isVanilla()) {
            throw new IllegalStateException("Modders must implement Ingredient.codec in their custom Ingredients: " + this.getClass());
        }
        return IIngredientSerializer.VANILLA;
    }

    public static Ingredient m_43938_(Stream<? extends Value> p_43939_) {
        Ingredient ingredient = new Ingredient(p_43939_);
        return ingredient.m_43947_() ? f_43901_ : ingredient;
    }

    public static Ingredient m_151265_() {
        return f_43901_;
    }

    public static Ingredient m_43929_(ItemLike ... p_43930_) {
        return Ingredient.m_43921_(Arrays.stream(p_43930_).map(ItemStack::new));
    }

    public static Ingredient m_43927_(ItemStack ... p_43928_) {
        return Ingredient.m_43921_(Arrays.stream(p_43928_));
    }

    public static Ingredient m_43921_(Stream<ItemStack> p_43922_) {
        return Ingredient.m_43938_(p_43922_.filter(p_43944_ -> !p_43944_.m_41619_()).map(ItemValue::new));
    }

    public static Ingredient m_204132_(TagKey<Item> p_204133_) {
        return Ingredient.m_43938_(Stream.of(new TagValue(p_204133_)));
    }

    public static Ingredient m_43940_(FriendlyByteBuf p_43941_) {
        int size = p_43941_.m_130242_();
        if (size == -1) {
            return ForgeHooks.ingredientFromNetwork((FriendlyByteBuf)p_43941_);
        }
        return Ingredient.m_43938_(Stream.generate(() -> new ItemValue(p_43941_.m_130267_())).limit(size));
    }

    private static Codec<Ingredient> m_294319_(boolean p_298496_) {
        Codec codec = Codec.list(Value.f_290964_).comapFlatMap(p_296902_ -> !p_298496_ && p_296902_.size() < 1 ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)p_296902_.toArray(new Value[0])), List::of);
        return ExtraCodecs.m_294448_(codec, Value.f_290964_).flatComapMap(p_296900_ -> (Ingredient)p_296900_.map(Ingredient::new, p_296903_ -> new Ingredient(new Value[]{p_296903_})), p_296899_ -> {
            if (p_296899_.f_43902_.length == 1) {
                return DataResult.success((Object)Either.right((Object)p_296899_.f_43902_[0]));
            }
            return p_296899_.f_43902_.length == 0 && !p_298496_ ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)Either.left((Object)p_296899_.f_43902_));
        });
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Ingredient[");
        for (int x = 0; x < this.f_43902_.length; ++x) {
            Value value;
            if (x != 0) {
                buf.append(", ");
            }
            if ((value = this.f_43902_[x]) instanceof TagValue) {
                TagValue tag = (TagValue)value;
                buf.append('#').append(tag.f_43959_().f_203868_());
                continue;
            }
            value = this.f_43902_[x];
            if (value instanceof ItemValue) {
                ItemValue item = (ItemValue)value;
                buf.append((Object)item.f_43951_());
                continue;
            }
            buf.append(this.f_43902_[x]);
        }
        buf.append(']');
        return buf.toString();
    }

    public static interface Value {
        public static final Codec<Value> f_290964_ = ExtraCodecs.m_144639_(ItemValue.f_291350_, TagValue.f_291685_).xmap(p_300070_ -> (Value)p_300070_.map(p_301348_ -> p_301348_, p_298354_ -> p_298354_), p_299608_ -> {
            if (p_299608_ instanceof TagValue) {
                TagValue ingredient$tagvalue = (TagValue)p_299608_;
                return Either.right((Object)ingredient$tagvalue);
            }
            if (p_299608_ instanceof ItemValue) {
                ItemValue ingredient$itemvalue = (ItemValue)p_299608_;
                return Either.left((Object)ingredient$itemvalue);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> m_6223_();
    }

    public record TagValue(TagKey<Item> f_43959_) implements Value
    {
        static final Codec<TagValue> f_291685_ = RecordCodecBuilder.create(p_300241_ -> p_300241_.group((App)TagKey.m_203877_(Registries.f_256913_).fieldOf("tag").forGetter(p_301340_ -> p_301340_.f_43959_)).apply((Applicative)p_300241_, TagValue::new));

        @Override
        public boolean equals(Object p_298268_) {
            if (p_298268_ instanceof TagValue) {
                TagValue ingredient$tagvalue = (TagValue)p_298268_;
                return ingredient$tagvalue.f_43959_.f_203868_().equals(this.f_43959_.f_203868_());
            }
            return false;
        }

        @Override
        public Collection<ItemStack> m_6223_() {
            ArrayList list = Lists.newArrayList();
            for (Holder<Item> holder : BuiltInRegistries.f_257033_.m_206058_(this.f_43959_)) {
                list.add(new ItemStack(holder));
            }
            if (list.size() == 0) {
                list.add(new ItemStack(Blocks.f_50375_).m_41714_(Component.m_237113_("Empty Tag: " + this.f_43959_.f_203868_())));
            }
            return list;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TagValue.class, "tag", "f_43959_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TagValue.class, "tag", "f_43959_"}, this);
        }
    }

    public record ItemValue(ItemStack f_43951_) implements Value
    {
        static final Codec<ItemValue> f_291350_ = RecordCodecBuilder.create(p_309250_ -> p_309250_.group((App)ItemStack.f_302992_.fieldOf("item").forGetter(p_299657_ -> p_299657_.f_43951_)).apply((Applicative)p_309250_, ItemValue::new));

        @Override
        public boolean equals(Object p_300135_) {
            if (!(p_300135_ instanceof ItemValue)) {
                return false;
            }
            ItemValue ingredient$itemvalue = (ItemValue)p_300135_;
            return ingredient$itemvalue.f_43951_.m_41720_().equals(this.f_43951_.m_41720_()) && ingredient$itemvalue.f_43951_.m_41613_() == this.f_43951_.m_41613_();
        }

        @Override
        public Collection<ItemStack> m_6223_() {
            return Collections.singleton(this.f_43951_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemValue.class, "item", "f_43951_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemValue.class, "item", "f_43951_"}, this);
        }
    }
}

