/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ShapedRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    final ShapedRecipePattern f_302516_;
    final ItemStack f_44149_;
    final String f_44151_;
    final CraftingBookCategory f_244483_;
    final boolean f_271538_;

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public ShapedRecipe(String p_250221_, CraftingBookCategory p_250716_, ShapedRecipePattern p_312200_, ItemStack p_248581_, boolean p_310619_) {
        this.f_44151_ = p_250221_;
        this.f_244483_ = p_250716_;
        this.f_302516_ = p_312200_;
        this.f_44149_ = p_248581_;
        this.f_271538_ = p_310619_;
    }

    public ShapedRecipe(String p_272759_, CraftingBookCategory p_273506_, ShapedRecipePattern p_310709_, ItemStack p_272852_) {
        this(p_272759_, p_273506_, p_310709_, p_272852_, true);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44076_;
    }

    @Override
    public String m_6076_() {
        return this.f_44151_;
    }

    public int getRecipeWidth() {
        return this.m_44220_();
    }

    @Override
    public CraftingBookCategory m_245232_() {
        return this.f_244483_;
    }

    public int getRecipeHeight() {
        return this.m_44221_();
    }

    @Override
    public ItemStack m_8043_(RegistryAccess p_266881_) {
        return this.f_44149_;
    }

    @Override
    public NonNullList<Ingredient> m_7527_() {
        return this.f_302516_.f_303265_();
    }

    @Override
    public boolean m_271738_() {
        return this.f_271538_;
    }

    @Override
    public boolean m_8004_(int p_44161_, int p_44162_) {
        return p_44161_ >= this.f_302516_.f_303446_() && p_44162_ >= this.f_302516_.f_302375_();
    }

    @Override
    public boolean m_5818_(CraftingContainer p_44176_, Level p_44177_) {
        return this.f_302516_.m_304908_(p_44176_);
    }

    @Override
    public ItemStack m_5874_(CraftingContainer p_266686_, RegistryAccess p_266725_) {
        return this.m_8043_(p_266725_).m_41777_();
    }

    public int m_44220_() {
        return this.f_302516_.f_303446_();
    }

    public int m_44221_() {
        return this.f_302516_.f_302375_();
    }

    @Override
    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.m_43947_()).anyMatch(p_151273_ -> ForgeHooks.hasNoElements((Ingredient)p_151273_));
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipe> {
        public static final Codec<ShapedRecipe> f_291611_ = RecordCodecBuilder.create(p_309256_ -> p_309256_.group((App)ExtraCodecs.m_295827_(Codec.STRING, "group", "").forGetter(p_309251_ -> p_309251_.f_44151_), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_309253_ -> p_309253_.f_244483_), (App)ShapedRecipePattern.f_302908_.forGetter(p_309254_ -> p_309254_.f_302516_), (App)ItemStack.f_302323_.fieldOf("result").forGetter(p_309252_ -> p_309252_.f_44149_), (App)ExtraCodecs.m_295827_(Codec.BOOL, "show_notification", true).forGetter(p_309255_ -> p_309255_.f_271538_)).apply((Applicative)p_309256_, ShapedRecipe::new));

        @Override
        public Codec<ShapedRecipe> m_292673_() {
            return f_291611_;
        }

        @Override
        public ShapedRecipe m_8005_(FriendlyByteBuf p_44234_) {
            String s = p_44234_.m_130277_();
            CraftingBookCategory craftingbookcategory = p_44234_.m_130066_(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = ShapedRecipePattern.m_306640_(p_44234_);
            ItemStack itemstack = p_44234_.m_130267_();
            boolean flag = p_44234_.readBoolean();
            return new ShapedRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        @Override
        public void m_6178_(FriendlyByteBuf p_44227_, ShapedRecipe p_44228_) {
            p_44227_.m_130070_(p_44228_.f_44151_);
            p_44227_.m_130068_(p_44228_.f_244483_);
            p_44228_.f_302516_.m_307574_(p_44227_);
            p_44227_.m_130055_(p_44228_.f_44149_);
            p_44227_.writeBoolean(p_44228_.f_271538_);
        }
    }
}

