/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public record ShapedRecipePattern(int f_303446_, int f_302375_, NonNullList<Ingredient> f_303265_, Optional<Data> f_302791_) {
    private static final int f_302599_ = 3;
    public static final MapCodec<ShapedRecipePattern> f_302908_ = Data.f_303136_.flatXmap(ShapedRecipePattern::m_305688_, p_310854_ -> p_310854_.f_302791_().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));

    public static ShapedRecipePattern m_304825_(Map<Character, Ingredient> p_310983_, String ... p_310430_) {
        return ShapedRecipePattern.m_306906_(p_310983_, List.of(p_310430_));
    }

    public static ShapedRecipePattern m_306906_(Map<Character, Ingredient> p_313226_, List<String> p_310089_) {
        Data shapedrecipepattern$data = new Data(p_313226_, p_310089_);
        return Util.m_260975_(ShapedRecipePattern.m_305688_(shapedrecipepattern$data), IllegalArgumentException::new);
    }

    private static DataResult<ShapedRecipePattern> m_305688_(Data p_312333_) {
        String[] astring = ShapedRecipePattern.m_306947_(p_312333_.f_302897_);
        int i = astring[0].length();
        int j = astring.length;
        NonNullList<Ingredient> nonnulllist = NonNullList.m_122780_(i * j, Ingredient.f_43901_);
        CharArraySet charset = new CharArraySet(p_312333_.f_302495_.keySet());
        for (int k = 0; k < astring.length; ++k) {
            String s = astring[k];
            for (int l = 0; l < s.length(); ++l) {
                Ingredient ingredient;
                char c0 = s.charAt(l);
                Ingredient ingredient2 = ingredient = c0 == ' ' ? Ingredient.f_43901_ : p_312333_.f_302495_.get(Character.valueOf(c0));
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c0 + "' but it's not defined in the key");
                }
                charset.remove(c0);
                nonnulllist.set(l + i * k, ingredient);
            }
        }
        return !charset.isEmpty() ? DataResult.error(() -> ShapedRecipePattern.m_304879_((CharSet)charset)) : DataResult.success((Object)new ShapedRecipePattern(i, j, nonnulllist, Optional.of(p_312333_)));
    }

    @VisibleForTesting
    static String[] m_306947_(List<String> p_311492_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_311492_.size(); ++i1) {
            String s = p_311492_.get(i1);
            i = Math.min(i, ShapedRecipePattern.m_304979_(s));
            int j1 = ShapedRecipePattern.m_306007_(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_311492_.size() == l) {
            return new String[0];
        }
        String[] astring = new String[p_311492_.size() - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_311492_.get(k1 + k).substring(i, j + 1);
        }
        return astring;
    }

    private static int m_304979_(String p_309836_) {
        int i;
        for (i = 0; i < p_309836_.length() && p_309836_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int m_306007_(String p_312853_) {
        int i;
        for (i = p_312853_.length() - 1; i >= 0 && p_312853_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public boolean m_304908_(CraftingContainer p_310690_) {
        for (int i = 0; i <= p_310690_.m_39347_() - this.f_303446_; ++i) {
            for (int j = 0; j <= p_310690_.m_39346_() - this.f_302375_; ++j) {
                if (this.m_306368_(p_310690_, i, j, true)) {
                    return true;
                }
                if (!this.m_306368_(p_310690_, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean m_306368_(CraftingContainer p_313091_, int p_311269_, int p_310676_, boolean p_313153_) {
        for (int i = 0; i < p_313091_.m_39347_(); ++i) {
            for (int j = 0; j < p_313091_.m_39346_(); ++j) {
                int k = i - p_311269_;
                int l = j - p_310676_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.f_303446_ && l < this.f_302375_) {
                    ingredient = p_313153_ ? this.f_303265_.get(this.f_303446_ - k - 1 + l * this.f_303446_) : this.f_303265_.get(k + l * this.f_303446_);
                }
                if (ingredient.test(p_313091_.m_8020_(i + j * p_313091_.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public void m_307574_(FriendlyByteBuf p_312386_) {
        p_312386_.m_130130_(this.f_303446_);
        p_312386_.m_130130_(this.f_302375_);
        for (Ingredient ingredient : this.f_303265_) {
            ingredient.m_43923_(p_312386_);
        }
    }

    public static ShapedRecipePattern m_306640_(FriendlyByteBuf p_310753_) {
        int i = p_310753_.m_130242_();
        int j = p_310753_.m_130242_();
        NonNullList<Ingredient> nonnulllist = NonNullList.m_122780_(i * j, Ingredient.f_43901_);
        nonnulllist.replaceAll(p_309588_ -> Ingredient.m_43940_(p_310753_));
        return new ShapedRecipePattern(i, j, nonnulllist, Optional.empty());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShapedRecipePattern.class, "width;height;ingredients;data", "f_303446_", "f_302375_", "f_303265_", "f_302791_"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShapedRecipePattern.class, "width;height;ingredients;data", "f_303446_", "f_302375_", "f_303265_", "f_302791_"}, this);
    }

    @Override
    public final boolean equals(Object p_311235_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShapedRecipePattern.class, "width;height;ingredients;data", "f_303446_", "f_302375_", "f_303265_", "f_302791_"}, this, p_311235_);
    }

    private static /* synthetic */ String m_304879_(CharSet p_310764_) {
        return "Key defines symbols that aren't used in pattern: " + p_310764_;
    }

    public record Data(Map<Character, Ingredient> f_302495_, List<String> f_302897_) {
        private static final Codec<List<String>> f_302331_ = Codec.STRING.listOf().comapFlatMap(p_311191_ -> {
            if (p_311191_.size() > ShapedRecipe.MAX_HEIGHT) {
                return DataResult.error(() -> "Invalid pattern: too many rows, " + ShapedRecipe.MAX_HEIGHT + " is maximum");
            }
            if (p_311191_.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)p_311191_.get(0)).length();
            for (String s : p_311191_) {
                if (s.length() > ShapedRecipe.MAX_WIDTH) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, " + ShapedRecipe.MAX_WIDTH + " is maximum");
                }
                if (i == s.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)p_311191_);
        }, Function.identity());
        private static final Codec<Character> f_302820_ = Codec.STRING.comapFlatMap(p_313217_ -> {
            if (p_313217_.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + p_313217_ + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(p_313217_) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(p_313217_.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> f_303136_ = RecordCodecBuilder.mapCodec(p_310577_ -> p_310577_.group((App)ExtraCodecs.m_295464_(f_302820_, Ingredient.f_290991_).fieldOf("key").forGetter(p_311797_ -> p_311797_.f_302495_), (App)f_302331_.fieldOf("pattern").forGetter(p_309770_ -> p_309770_.f_302897_)).apply((Applicative)p_310577_, Data::new));

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Data.class, "key;pattern", "f_302495_", "f_302897_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Data.class, "key;pattern", "f_302495_", "f_302897_"}, this);
        }

        @Override
        public final boolean equals(Object p_311386_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Data.class, "key;pattern", "f_302495_", "f_302897_"}, this, p_311386_);
        }
    }
}

