/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;

public class ShapelessRecipe
implements CraftingRecipe {
    final String f_44242_;
    final CraftingBookCategory f_244076_;
    final ItemStack f_44243_;
    final NonNullList<Ingredient> f_44244_;
    private final boolean isSimple;

    public ShapelessRecipe(String p_249640_, CraftingBookCategory p_249390_, ItemStack p_252071_, NonNullList<Ingredient> p_250689_) {
        this.f_44242_ = p_249640_;
        this.f_244076_ = p_249390_;
        this.f_44243_ = p_252071_;
        this.f_44244_ = p_250689_;
        this.isSimple = p_250689_.stream().allMatch(Ingredient::isSimple);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44077_;
    }

    @Override
    public String m_6076_() {
        return this.f_44242_;
    }

    @Override
    public CraftingBookCategory m_245232_() {
        return this.f_244076_;
    }

    @Override
    public ItemStack m_8043_(RegistryAccess p_267111_) {
        return this.f_44243_;
    }

    @Override
    public NonNullList<Ingredient> m_7527_() {
        return this.f_44244_;
    }

    @Override
    public boolean m_5818_(CraftingContainer p_44262_, Level p_44263_) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < p_44262_.m_6643_(); ++j) {
            ItemStack itemstack = p_44262_.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.f_44244_.size() && (this.isSimple ? stackedcontents.m_36475_(this, null) : RecipeMatcher.findMatches(inputs, this.f_44244_) != null);
    }

    @Override
    public ItemStack m_5874_(CraftingContainer p_44260_, RegistryAccess p_266797_) {
        return this.f_44243_.m_41777_();
    }

    @Override
    public boolean m_8004_(int p_44252_, int p_44253_) {
        return p_44252_ * p_44253_ >= this.f_44244_.size();
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessRecipe> {
        private static final Codec<ShapelessRecipe> f_290581_ = RecordCodecBuilder.create(p_309257_ -> p_309257_.group((App)ExtraCodecs.m_295827_(Codec.STRING, "group", "").forGetter(p_299460_ -> p_299460_.f_44242_), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_297437_ -> p_297437_.f_244076_), (App)ItemStack.f_302323_.fieldOf("result").forGetter(p_300770_ -> p_300770_.f_44243_), (App)Ingredient.f_290991_.listOf().fieldOf("ingredients").flatXmap(p_297969_ -> {
            Ingredient[] aingredient = (Ingredient[])p_297969_.stream().filter(p_298915_ -> !p_298915_.m_43947_()).toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > ShapedRecipe.MAX_WIDTH * ShapedRecipe.MAX_HEIGHT ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success(NonNullList.m_122783_(Ingredient.f_43901_, aingredient));
        }, DataResult::success).forGetter(p_298509_ -> p_298509_.f_44244_)).apply((Applicative)p_309257_, ShapelessRecipe::new));

        @Override
        public Codec<ShapelessRecipe> m_292673_() {
            return f_290581_;
        }

        @Override
        public ShapelessRecipe m_8005_(FriendlyByteBuf p_44294_) {
            String s = p_44294_.m_130277_();
            CraftingBookCategory craftingbookcategory = p_44294_.m_130066_(CraftingBookCategory.class);
            int i = p_44294_.m_130242_();
            NonNullList<Ingredient> nonnulllist = NonNullList.m_122780_(i, Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, Ingredient.m_43940_(p_44294_));
            }
            ItemStack itemstack = p_44294_.m_130267_();
            return new ShapelessRecipe(s, craftingbookcategory, itemstack, nonnulllist);
        }

        @Override
        public void m_6178_(FriendlyByteBuf p_44281_, ShapelessRecipe p_44282_) {
            p_44281_.m_130070_(p_44282_.f_44242_);
            p_44281_.m_130068_(p_44282_.f_244076_);
            p_44281_.m_130130_(p_44282_.f_44244_.size());
            for (Ingredient ingredient : p_44282_.f_44244_) {
                ingredient.m_43923_(p_44281_);
            }
            p_44281_.m_130055_(p_44282_.f_44243_);
        }
    }
}

