/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Explosion {
    private static final ExplosionDamageCalculator f_46008_ = new ExplosionDamageCalculator();
    private static final int f_151469_ = 16;
    private final boolean f_46009_;
    private final BlockInteraction f_46010_;
    private final RandomSource f_46011_ = RandomSource.m_216327_();
    private final Level f_46012_;
    private final double f_46013_;
    private final double f_46014_;
    private final double f_46015_;
    @Nullable
    private final Entity f_46016_;
    private final float f_46017_;
    private final DamageSource f_46018_;
    private final ExplosionDamageCalculator f_46019_;
    private final ParticleOptions f_303246_;
    private final ParticleOptions f_302779_;
    private final SoundEvent f_302233_;
    private final ObjectArrayList<BlockPos> f_46020_ = new ObjectArrayList();
    private final Map<Player, Vec3> f_46021_ = Maps.newHashMap();

    public static DamageSource m_308019_(Level p_309890_, @Nullable Entity p_311046_) {
        return p_309890_.m_269111_().m_269036_(p_311046_, Explosion.m_306928_(p_311046_));
    }

    public Explosion(Level p_46024_, @Nullable Entity p_46025_, double p_46026_, double p_46027_, double p_46028_, float p_46029_, List<BlockPos> p_46030_, BlockInteraction p_312129_, ParticleOptions p_311112_, ParticleOptions p_311120_, SoundEvent p_311288_) {
        this(p_46024_, p_46025_, Explosion.m_308019_(p_46024_, p_46025_), null, p_46026_, p_46027_, p_46028_, p_46029_, false, p_312129_, p_311112_, p_311120_, p_311288_);
        this.f_46020_.addAll(p_46030_);
    }

    public Explosion(Level p_46041_, @Nullable Entity p_46042_, double p_46043_, double p_46044_, double p_46045_, float p_46046_, boolean p_46047_, BlockInteraction p_46048_, List<BlockPos> p_46049_) {
        this(p_46041_, p_46042_, p_46043_, p_46044_, p_46045_, p_46046_, p_46047_, p_46048_);
        this.f_46020_.addAll(p_46049_);
    }

    public Explosion(Level p_46032_, @Nullable Entity p_46033_, double p_46034_, double p_46035_, double p_46036_, float p_46037_, boolean p_46038_, BlockInteraction p_46039_) {
        this(p_46032_, p_46033_, Explosion.m_308019_(p_46032_, p_46033_), null, p_46034_, p_46035_, p_46036_, p_46037_, p_46038_, p_46039_, ParticleTypes.f_123813_, ParticleTypes.f_123812_, SoundEvents.f_11913_);
    }

    public Explosion(Level p_46051_, @Nullable Entity p_46052_, @Nullable DamageSource p_46053_, @Nullable ExplosionDamageCalculator p_46054_, double p_46055_, double p_46056_, double p_46057_, float p_46058_, boolean p_46059_, BlockInteraction p_46060_, ParticleOptions p_312175_, ParticleOptions p_310459_, SoundEvent p_311795_) {
        this.f_46012_ = p_46051_;
        this.f_46016_ = p_46052_;
        this.f_46017_ = p_46058_;
        this.f_46013_ = p_46055_;
        this.f_46014_ = p_46056_;
        this.f_46015_ = p_46057_;
        this.f_46009_ = p_46059_;
        this.f_46010_ = p_46060_;
        this.f_46018_ = p_46053_ == null ? p_46051_.m_269111_().m_269093_(this) : p_46053_;
        this.f_46019_ = p_46054_ == null ? this.m_46062_(p_46052_) : p_46054_;
        this.f_303246_ = p_312175_;
        this.f_302779_ = p_310459_;
        this.f_302233_ = p_311795_;
    }

    private ExplosionDamageCalculator m_46062_(@Nullable Entity p_46063_) {
        return p_46063_ == null ? f_46008_ : new EntityBasedExplosionDamageCalculator(p_46063_);
    }

    public static float m_46064_(Vec3 p_46065_, Entity p_46066_) {
        AABB aabb = p_46066_.m_20191_();
        double d0 = 1.0 / ((aabb.f_82291_ - aabb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.f_82292_ - aabb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.f_82293_ - aabb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = Mth.m_14139_(d5, aabb.f_82288_, aabb.f_82291_);
                        double d9 = Mth.m_14139_(d6, aabb.f_82289_, aabb.f_82292_);
                        double d10 = Mth.m_14139_(d7, aabb.f_82290_, aabb.f_82293_);
                        Vec3 vec3 = new Vec3(d8 + d3, d9, d10 + d4);
                        if (p_46066_.m_9236_().m_45547_(new ClipContext(vec3, p_46065_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_46066_)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public float m_305027_() {
        return this.f_46017_;
    }

    public Vec3 m_307721_() {
        return new Vec3(this.f_46013_, this.f_46014_, this.f_46015_);
    }

    public void m_46061_() {
        this.f_46012_.m_220400_(this.f_46016_, GameEvent.f_157812_, new Vec3(this.f_46013_, this.f_46014_, this.f_46015_));
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.f_46013_;
                    double d6 = this.f_46014_;
                    double d8 = this.f_46015_;
                    float f1 = 0.3f;
                    for (float f = this.f_46017_ * (0.7f + this.f_46012_.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.m_274561_(d4, d6, d8);
                        BlockState blockstate = this.f_46012_.m_8055_(blockpos);
                        FluidState fluidstate = this.f_46012_.m_6425_(blockpos);
                        if (!this.f_46012_.m_46739_(blockpos)) continue block2;
                        Optional<Float> optional = this.f_46019_.m_6617_(this, this.f_46012_, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (optional.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.f_46019_.m_6714_(this, this.f_46012_, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.f_46020_.addAll((Collection)set);
        float f2 = this.f_46017_ * 2.0f;
        int k1 = Mth.m_14107_(this.f_46013_ - (double)f2 - 1.0);
        int l1 = Mth.m_14107_(this.f_46013_ + (double)f2 + 1.0);
        int i2 = Mth.m_14107_(this.f_46014_ - (double)f2 - 1.0);
        int i1 = Mth.m_14107_(this.f_46014_ + (double)f2 + 1.0);
        int j2 = Mth.m_14107_(this.f_46015_ - (double)f2 - 1.0);
        int j1 = Mth.m_14107_(this.f_46015_ + (double)f2 + 1.0);
        List list = this.f_46012_.m_45933_(this.f_46016_, new AABB(k1, i2, j2, l1, i1, j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, (List)list, (double)f2);
        Vec3 vec3 = new Vec3(this.f_46013_, this.f_46014_, this.f_46015_);
        for (Entity entity : list) {
            Player player;
            double d10;
            double d9;
            double d7;
            double d5;
            double d12;
            double d11;
            if (entity.m_6128_(this) || !((d11 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2) <= 1.0) || (d12 = Math.sqrt((d5 = entity.m_20185_() - this.f_46013_) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.f_46014_) * d7 + (d9 = entity.m_20189_() - this.f_46015_) * d9)) == 0.0) continue;
            d5 /= d12;
            d7 /= d12;
            d9 /= d12;
            if (this.f_46019_.m_304921_(this, entity)) {
                entity.m_6469_(this.f_46018_, this.f_46019_.m_305869_(this, entity));
            }
            double d13 = (1.0 - d11) * (double)Explosion.m_46064_(vec3, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                d10 = ProtectionEnchantment.m_45135_(livingentity, d13);
            } else {
                d10 = d13;
            }
            Vec3 vec31 = new Vec3(d5 *= d10, d7 *= d10, d9 *= d10);
            entity.m_20256_(entity.m_20184_().m_82549_(vec31));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.f_46021_.put(player, vec31);
        }
    }

    public void m_46075_(boolean p_46076_) {
        if (this.f_46012_.f_46443_) {
            this.f_46012_.m_7785_(this.f_46013_, this.f_46014_, this.f_46015_, this.f_302233_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_46012_.f_46441_.m_188501_() - this.f_46012_.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        boolean flag = this.m_254884_();
        if (p_46076_) {
            ParticleOptions particleoptions = !(this.f_46017_ < 2.0f) && flag ? this.f_302779_ : this.f_303246_;
            this.f_46012_.m_7106_(particleoptions, this.f_46013_, this.f_46014_, this.f_46015_, 1.0, 0.0, 0.0);
        }
        if (flag) {
            this.f_46012_.m_46473_().m_6180_("explosion_blocks");
            ArrayList list = new ArrayList();
            Util.m_214673_(this.f_46020_, this.f_46012_.f_46441_);
            for (BlockPos blockpos : this.f_46020_) {
                this.f_46012_.m_8055_(blockpos).m_306874_(this.f_46012_, blockpos, this, (p_309264_, p_309265_) -> Explosion.m_306516_(list, p_309264_, p_309265_));
            }
            for (Pair pair : list) {
                Block.m_49840_(this.f_46012_, (BlockPos)pair.getSecond(), (ItemStack)((Object)pair.getFirst()));
            }
            this.f_46012_.m_46473_().m_7238_();
        }
        if (this.f_46009_) {
            for (BlockPos blockpos1 : this.f_46020_) {
                if (this.f_46011_.m_188503_(3) != 0 || !this.f_46012_.m_8055_(blockpos1).m_60795_() || !this.f_46012_.m_8055_(blockpos1.m_7495_()).m_60804_(this.f_46012_, blockpos1.m_7495_())) continue;
                this.f_46012_.m_46597_(blockpos1, BaseFireBlock.m_49245_(this.f_46012_, blockpos1));
            }
        }
    }

    private static void m_306516_(List<Pair<ItemStack, BlockPos>> p_311090_, ItemStack p_311817_, BlockPos p_309821_) {
        for (int i = 0; i < p_311090_.size(); ++i) {
            Pair<ItemStack, BlockPos> pair = p_311090_.get(i);
            ItemStack itemstack = (ItemStack)((Object)pair.getFirst());
            if (!ItemEntity.m_32026_(itemstack, p_311817_)) continue;
            p_311090_.set(i, (Pair<ItemStack, BlockPos>)Pair.of((Object)((Object)ItemEntity.m_32029_(itemstack, p_311817_, 16)), (Object)((BlockPos)pair.getSecond())));
            if (!p_311817_.m_41619_()) continue;
            return;
        }
        p_311090_.add((Pair<ItemStack, BlockPos>)Pair.of((Object)((Object)p_311817_), (Object)p_309821_));
    }

    public boolean m_254884_() {
        return this.f_46010_ != BlockInteraction.KEEP;
    }

    public Map<Player, Vec3> m_46078_() {
        return this.f_46021_;
    }

    @Nullable
    private static LivingEntity m_306928_(@Nullable Entity p_309719_) {
        Projectile projectile;
        Entity entity;
        if (p_309719_ == null) {
            return null;
        }
        if (p_309719_ instanceof PrimedTnt) {
            PrimedTnt primedtnt = (PrimedTnt)p_309719_;
            return primedtnt.m_19749_();
        }
        if (p_309719_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_309719_;
            return livingentity;
        }
        if (p_309719_ instanceof Projectile && (entity = (projectile = (Projectile)p_309719_).m_19749_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    @Nullable
    public LivingEntity m_252906_() {
        return Explosion.m_306928_(this.f_46016_);
    }

    @Nullable
    public Entity m_253049_() {
        return this.f_46016_;
    }

    public void m_46080_() {
        this.f_46020_.clear();
    }

    public List<BlockPos> m_46081_() {
        return this.f_46020_;
    }

    public BlockInteraction m_307824_() {
        return this.f_46010_;
    }

    public ParticleOptions m_307149_() {
        return this.f_303246_;
    }

    public ParticleOptions m_307299_() {
        return this.f_302779_;
    }

    public SoundEvent m_305033_() {
        return this.f_302233_;
    }

    public static final class BlockInteraction
    extends Enum<BlockInteraction> {
        public static final /* enum */ BlockInteraction KEEP = new BlockInteraction();
        public static final /* enum */ BlockInteraction DESTROY = new BlockInteraction();
        public static final /* enum */ BlockInteraction DESTROY_WITH_DECAY = new BlockInteraction();
        public static final /* enum */ BlockInteraction TRIGGER_BLOCK = new BlockInteraction();
        private static final /* synthetic */ BlockInteraction[] $VALUES;

        public static BlockInteraction[] values() {
            return (BlockInteraction[])$VALUES.clone();
        }

        public static BlockInteraction valueOf(String p_46091_) {
            return Enum.valueOf(BlockInteraction.class, p_46091_);
        }

        private static /* synthetic */ BlockInteraction[] m_151477_() {
            return new BlockInteraction[]{KEEP, DESTROY, DESTROY_WITH_DECAY, TRIGGER_BLOCK};
        }

        static {
            $VALUES = BlockInteraction.m_151477_();
        }
    }
}

