/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class ConcretePowderBlock
extends FallingBlock {
    public static final MapCodec<ConcretePowderBlock> f_303104_ = RecordCodecBuilder.mapCodec(p_312823_ -> p_312823_.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("concrete").forGetter(p_313163_ -> p_313163_.f_52058_), ConcretePowderBlock.m_305607_()).apply((Applicative)p_312823_, ConcretePowderBlock::new));
    private final Block f_52058_;

    public MapCodec<ConcretePowderBlock> m_304657_() {
        return f_303104_;
    }

    public ConcretePowderBlock(Block p_52060_, BlockBehaviour.Properties p_52061_) {
        super(p_52061_);
        this.f_52058_ = p_52060_;
    }

    @Override
    public void m_48792_(Level p_52068_, BlockPos p_52069_, BlockState p_52070_, BlockState p_52071_, FallingBlockEntity p_52072_) {
        if (ConcretePowderBlock.shouldSolidify(p_52068_, p_52069_, p_52070_, p_52071_.m_60819_())) {
            p_52068_.m_7731_(p_52069_, this.f_52058_.m_49966_(), 3);
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext p_52063_) {
        BlockState blockstate;
        BlockPos blockpos;
        Level blockgetter = p_52063_.m_43725_();
        return ConcretePowderBlock.m_52080_(blockgetter, blockpos = p_52063_.m_8083_(), blockstate = blockgetter.m_8055_(blockpos)) ? this.f_52058_.m_49966_() : super.m_5573_(p_52063_);
    }

    private static boolean shouldSolidify(BlockGetter p_52081_, BlockPos p_52082_, BlockState p_52083_, FluidState fluidState) {
        return p_52083_.canBeHydrated(p_52081_, p_52082_, fluidState, p_52082_) || ConcretePowderBlock.touchesLiquid(p_52081_, p_52082_, p_52083_);
    }

    private static boolean m_52080_(BlockGetter p_52081_, BlockPos p_52082_, BlockState p_52083_) {
        return ConcretePowderBlock.shouldSolidify(p_52081_, p_52082_, p_52083_, p_52081_.m_6425_(p_52082_));
    }

    private static boolean touchesLiquid(BlockGetter p_52065_, BlockPos p_52066_, BlockState state) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_52066_.m_122032_();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = p_52065_.m_8055_(blockpos$mutableblockpos);
            if (direction == Direction.DOWN && !state.canBeHydrated(p_52065_, p_52066_, blockstate.m_60819_(), blockpos$mutableblockpos)) continue;
            blockpos$mutableblockpos.m_122159_(p_52066_, direction);
            blockstate = p_52065_.m_8055_(blockpos$mutableblockpos);
            if (!state.canBeHydrated(p_52065_, p_52066_, blockstate.m_60819_(), blockpos$mutableblockpos) || blockstate.m_60783_(p_52065_, p_52066_, direction.m_122424_())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean m_52088_(BlockState p_52089_) {
        return p_52089_.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    @Override
    public BlockState m_7417_(BlockState p_52074_, Direction p_52075_, BlockState p_52076_, LevelAccessor p_52077_, BlockPos p_52078_, BlockPos p_52079_) {
        return ConcretePowderBlock.touchesLiquid(p_52077_, p_52078_, p_52074_) ? this.f_52058_.m_49966_() : super.m_7417_(p_52074_, p_52075_, p_52076_, p_52077_, p_52078_, p_52079_);
    }

    @Override
    public int m_6248_(BlockState p_52085_, BlockGetter p_52086_, BlockPos p_52087_) {
        return p_52085_.m_284242_((BlockGetter)p_52086_, (BlockPos)p_52087_).f_283871_;
    }
}

