/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class SpongeBlock
extends Block {
    public static final MapCodec<SpongeBlock> f_302671_ = SpongeBlock.m_306223_(SpongeBlock::new);
    public static final int f_154689_ = 6;
    public static final int f_154690_ = 64;
    private static final Direction[] f_276425_ = Direction.values();

    public MapCodec<SpongeBlock> m_304657_() {
        return f_302671_;
    }

    public SpongeBlock(BlockBehaviour.Properties p_56796_) {
        super(p_56796_);
    }

    @Override
    public void m_6807_(BlockState p_56811_, Level p_56812_, BlockPos p_56813_, BlockState p_56814_, boolean p_56815_) {
        if (!p_56814_.m_60713_(p_56811_.m_60734_())) {
            this.m_56797_(p_56812_, p_56813_);
        }
    }

    @Override
    public void m_6861_(BlockState p_56801_, Level p_56802_, BlockPos p_56803_, Block p_56804_, BlockPos p_56805_, boolean p_56806_) {
        this.m_56797_(p_56802_, p_56803_);
        super.m_6861_(p_56801_, p_56802_, p_56803_, p_56804_, p_56805_, p_56806_);
    }

    protected void m_56797_(Level p_56798_, BlockPos p_56799_) {
        if (this.m_56807_(p_56798_, p_56799_)) {
            p_56798_.m_7731_(p_56799_, Blocks.f_50057_.m_49966_(), 2);
            p_56798_.m_5594_(null, p_56799_, SoundEvents.f_290819_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean m_56807_(Level p_56808_, BlockPos p_56809_) {
        BlockState spongeState = p_56808_.m_8055_(p_56809_);
        return BlockPos.m_276833_(p_56809_, 6, 65, (p_277519_, p_277492_) -> {
            for (Direction direction : f_276425_) {
                p_277492_.accept(p_277519_.m_121945_(direction));
            }
        }, p_296944_ -> {
            BucketPickup bucketpickup;
            if (p_296944_.equals(p_56809_)) {
                return true;
            }
            BlockState blockstate = p_56808_.m_8055_((BlockPos)p_296944_);
            FluidState fluidstate = p_56808_.m_6425_((BlockPos)p_296944_);
            if (!spongeState.canBeHydrated(p_56808_, p_56809_, fluidstate, (BlockPos)p_296944_)) {
                return false;
            }
            Block block = blockstate.m_60734_();
            if (block instanceof BucketPickup && !(bucketpickup = (BucketPickup)((Object)block)).m_142598_(null, p_56808_, (BlockPos)p_296944_, blockstate).m_41619_()) {
                return true;
            }
            if (blockstate.m_60734_() instanceof LiquidBlock) {
                p_56808_.m_7731_((BlockPos)p_296944_, Blocks.f_50016_.m_49966_(), 3);
            } else {
                if (!(blockstate.m_60713_(Blocks.f_50575_) || blockstate.m_60713_(Blocks.f_50576_) || blockstate.m_60713_(Blocks.f_50037_) || blockstate.m_60713_(Blocks.f_50038_))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.m_155947_() ? p_56808_.m_7702_((BlockPos)p_296944_) : null;
                SpongeBlock.m_49892_(blockstate, p_56808_, p_296944_, blockentity);
                p_56808_.m_7731_((BlockPos)p_296944_, Blocks.f_50016_.m_49966_(), 3);
            }
            return true;
        }) > 1;
    }
}

