/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class StemBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<StemBlock> f_302223_ = RecordCodecBuilder.mapCodec(p_311216_ -> p_311216_.group((App)ResourceKey.m_195966_(Registries.f_256747_).fieldOf("fruit").forGetter(p_312514_ -> p_312514_.f_57015_), (App)ResourceKey.m_195966_(Registries.f_256747_).fieldOf("attached_stem").forGetter(p_309847_ -> p_309847_.f_302609_), (App)ResourceKey.m_195966_(Registries.f_256913_).fieldOf("seed").forGetter(p_311480_ -> p_311480_.f_302863_), StemBlock.m_305607_()).apply((Applicative)p_311216_, StemBlock::new));
    public static final int f_154724_ = 7;
    public static final IntegerProperty f_57013_ = BlockStateProperties.f_61409_;
    protected static final float f_154725_ = 1.0f;
    protected static final VoxelShape[] f_57014_ = new VoxelShape[]{Block.m_49796_(7.0, 0.0, 7.0, 9.0, 2.0, 9.0), Block.m_49796_(7.0, 0.0, 7.0, 9.0, 4.0, 9.0), Block.m_49796_(7.0, 0.0, 7.0, 9.0, 6.0, 9.0), Block.m_49796_(7.0, 0.0, 7.0, 9.0, 8.0, 9.0), Block.m_49796_(7.0, 0.0, 7.0, 9.0, 10.0, 9.0), Block.m_49796_(7.0, 0.0, 7.0, 9.0, 12.0, 9.0), Block.m_49796_(7.0, 0.0, 7.0, 9.0, 14.0, 9.0), Block.m_49796_(7.0, 0.0, 7.0, 9.0, 16.0, 9.0)};
    private final ResourceKey<Block> f_57015_;
    private final ResourceKey<Block> f_302609_;
    private final ResourceKey<Item> f_302863_;

    public MapCodec<StemBlock> m_304657_() {
        return f_302223_;
    }

    public StemBlock(ResourceKey<Block> p_310213_, ResourceKey<Block> p_312966_, ResourceKey<Item> p_312034_, BlockBehaviour.Properties p_154730_) {
        super(p_154730_);
        this.f_57015_ = p_310213_;
        this.f_302609_ = p_312966_;
        this.f_302863_ = p_312034_;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(f_57013_, 0));
    }

    @Override
    public VoxelShape m_5940_(BlockState p_57047_, BlockGetter p_57048_, BlockPos p_57049_, CollisionContext p_57050_) {
        return f_57014_[p_57047_.m_61143_(f_57013_)];
    }

    @Override
    protected boolean m_6266_(BlockState p_57053_, BlockGetter p_57054_, BlockPos p_57055_) {
        return p_57053_.m_60713_(Blocks.f_50093_);
    }

    @Override
    public void m_213898_(BlockState p_222538_, ServerLevel p_222539_, BlockPos p_222540_, RandomSource p_222541_) {
        float f;
        if (!p_222539_.isAreaLoaded(p_222540_, 1)) {
            return;
        }
        if (p_222539_.m_45524_(p_222540_, 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)p_222539_, (BlockPos)p_222540_, (BlockState)p_222538_, (p_222541_.m_188503_((int)(25.0f / (f = CropBlock.m_52272_(this, p_222539_, p_222540_))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = p_222538_.m_61143_(f_57013_);
            if (i < 7) {
                p_222539_.m_7731_(p_222540_, (BlockState)p_222538_.m_61124_(f_57013_, i + 1), 2);
            } else {
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(p_222541_);
                BlockPos blockpos = p_222540_.m_121945_(direction);
                BlockState blockstate = p_222539_.m_8055_(blockpos.m_7495_());
                if (p_222539_.m_8055_(blockpos).m_60795_() && (blockstate.m_60713_(Blocks.f_50093_) || blockstate.m_204336_(BlockTags.f_144274_))) {
                    Registry<Block> registry = p_222539_.m_9598_().m_175515_(Registries.f_256747_);
                    Optional<Block> optional = registry.m_123009_(this.f_57015_);
                    Optional<Block> optional1 = registry.m_123009_(this.f_302609_);
                    if (optional.isPresent() && optional1.isPresent()) {
                        p_222539_.m_46597_(blockpos, optional.get().m_49966_());
                        p_222539_.m_46597_(p_222540_, (BlockState)optional1.get().m_49966_().m_61124_(HorizontalDirectionalBlock.f_54117_, direction));
                    }
                }
            }
            ForgeHooks.onCropsGrowPost((Level)p_222539_, (BlockPos)p_222540_, (BlockState)p_222538_);
        }
    }

    @Override
    public ItemStack m_7397_(LevelReader p_312829_, BlockPos p_57027_, BlockState p_57028_) {
        return new ItemStack((ItemLike)DataFixUtils.orElse(p_312829_.m_9598_().m_175515_(Registries.f_256913_).m_123009_(this.f_302863_), (Object)this));
    }

    @Override
    public boolean m_7370_(LevelReader p_255699_, BlockPos p_57031_, BlockState p_57032_) {
        return p_57032_.m_61143_(f_57013_) != 7;
    }

    @Override
    public boolean m_214167_(Level p_222533_, RandomSource p_222534_, BlockPos p_222535_, BlockState p_222536_) {
        return true;
    }

    @Override
    public void m_214148_(ServerLevel p_222528_, RandomSource p_222529_, BlockPos p_222530_, BlockState p_222531_) {
        int i = Math.min(7, p_222531_.m_61143_(f_57013_) + Mth.m_216271_(p_222528_.f_46441_, 2, 5));
        BlockState blockstate = (BlockState)p_222531_.m_61124_(f_57013_, i);
        p_222528_.m_7731_(p_222530_, blockstate, 2);
        if (i == 7) {
            blockstate.m_222972_(p_222528_, p_222530_, p_222528_.f_46441_);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57040_) {
        p_57040_.m_61104_(f_57013_);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }
}

