/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public final class TrialSpawner {
    public static final int f_302637_ = 40;
    private static final int f_302891_ = 47;
    private static final int f_303092_ = Mth.m_144944_(47);
    private static final float f_302617_ = 0.02f;
    private final TrialSpawnerConfig f_302564_;
    private final TrialSpawnerData f_302910_;
    private final StateAccessor f_302785_;
    private PlayerDetector f_302944_;
    private boolean f_302722_;

    public Codec<TrialSpawner> m_307687_() {
        return RecordCodecBuilder.create(p_310329_ -> p_310329_.group((App)TrialSpawnerConfig.f_303386_.forGetter(TrialSpawner::m_306177_), (App)TrialSpawnerData.f_302600_.forGetter(TrialSpawner::m_305472_)).apply((Applicative)p_310329_, (p_312762_, p_311305_) -> new TrialSpawner((TrialSpawnerConfig)p_312762_, (TrialSpawnerData)p_311305_, this.f_302785_, this.f_302944_)));
    }

    public TrialSpawner(StateAccessor p_310539_, PlayerDetector p_312974_) {
        this(TrialSpawnerConfig.f_303284_, new TrialSpawnerData(), p_310539_, p_312974_);
    }

    public TrialSpawner(TrialSpawnerConfig p_310434_, TrialSpawnerData p_311518_, StateAccessor p_310216_, PlayerDetector p_309626_) {
        this.f_302564_ = p_310434_;
        this.f_302910_ = p_311518_;
        this.f_302910_.m_305185_(p_310434_);
        this.f_302785_ = p_310216_;
        this.f_302944_ = p_309626_;
    }

    public TrialSpawnerConfig m_306177_() {
        return this.f_302564_;
    }

    public TrialSpawnerData m_305472_() {
        return this.f_302910_;
    }

    public TrialSpawnerState m_305684_() {
        return this.f_302785_.m_306453_();
    }

    public void m_304838_(Level p_310153_, TrialSpawnerState p_312484_) {
        this.f_302785_.m_305970_(p_310153_, p_312484_);
    }

    public void m_306727_() {
        this.f_302785_.m_306374_();
    }

    public PlayerDetector m_305791_() {
        return this.f_302944_;
    }

    public boolean m_305592_(Level p_312209_) {
        if (this.f_302722_) {
            return true;
        }
        if (p_312209_.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        return p_312209_.m_46469_().m_46207_(GameRules.f_46134_);
    }

    public Optional<UUID> m_305361_(ServerLevel p_312690_, BlockPos p_313108_) {
        double $$10;
        RandomSource $$2 = p_312690_.m_213780_();
        SpawnData $$3 = this.f_302910_.m_306716_(this, p_312690_.m_213780_());
        CompoundTag $$4 = $$3.f_186561_();
        ListTag $$5 = $$4.m_128437_("Pos", 6);
        Optional<EntityType<?>> $$6 = EntityType.m_20637_($$4);
        if ($$6.isEmpty()) {
            return Optional.empty();
        }
        int $$7 = $$5.size();
        double $$8 = $$7 >= 1 ? $$5.m_128772_(0) : (double)p_313108_.m_123341_() + ($$2.m_188500_() - $$2.m_188500_()) * (double)this.f_302564_.f_302636_() + 0.5;
        double $$9 = $$7 >= 2 ? $$5.m_128772_(1) : (double)(p_313108_.m_123342_() + $$2.m_188503_(3) - 1);
        double d = $$10 = $$7 >= 3 ? $$5.m_128772_(2) : (double)p_313108_.m_123343_() + ($$2.m_188500_() - $$2.m_188500_()) * (double)this.f_302564_.f_302636_() + 0.5;
        if (!p_312690_.m_45772_($$6.get().m_20585_($$8, $$9, $$10))) {
            return Optional.empty();
        }
        Vec3 $$11 = new Vec3($$8, $$9, $$10);
        if (!TrialSpawner.m_306844_(p_312690_, p_313108_.m_252807_(), $$11)) {
            return Optional.empty();
        }
        BlockPos $$12 = BlockPos.m_274446_($$11);
        if (!SpawnPlacements.m_217074_($$6.get(), p_312690_, MobSpawnType.TRIAL_SPAWNER, $$12, p_312690_.m_213780_())) {
            return Optional.empty();
        }
        Entity $$13 = EntityType.m_20645_($$4, p_312690_, p_312166_ -> {
            p_312166_.m_7678_($$8, $$9, $$10, $$2.m_188501_() * 360.0f, 0.0f);
            return p_312166_;
        });
        if ($$13 == null) {
            return Optional.empty();
        }
        if ($$13 instanceof Mob) {
            Mob $$14 = (Mob)$$13;
            if (!$$14.m_6914_(p_312690_)) {
                return Optional.empty();
            }
            if ($$3.m_186567_().m_128440_() == 1 && $$3.m_186567_().m_128425_("id", 8)) {
                $$14.m_6518_(p_312690_, p_312690_.m_6436_($$14.m_20183_()), MobSpawnType.TRIAL_SPAWNER, null, null);
                $$14.m_21530_();
            }
        }
        if (!p_312690_.m_8860_($$13)) {
            return Optional.empty();
        }
        p_312690_.m_46796_(3011, p_313108_, 0);
        p_312690_.m_46796_(3012, $$12, 0);
        p_312690_.m_142346_($$13, GameEvent.f_157810_, $$12);
        return Optional.of($$13.m_20148_());
    }

    public void m_306218_(ServerLevel p_310080_, BlockPos p_311547_, ResourceLocation p_311861_) {
        LootParams $$4;
        LootTable $$3 = p_310080_.m_7654_().m_278653_().m_278676_(p_311861_);
        ObjectArrayList<ItemStack> $$5 = $$3.m_287195_($$4 = new LootParams.Builder(p_310080_).m_287235_(LootContextParamSets.f_81410_));
        if (!$$5.isEmpty()) {
            for (ItemStack $$6 : $$5) {
                DefaultDispenseItemBehavior.m_123378_(p_310080_, $$6, 2, Direction.UP, Vec3.m_82539_(p_311547_).m_231075_(Direction.UP, 1.2));
            }
            p_310080_.m_46796_(3014, p_311547_, 0);
        }
    }

    public void m_304902_(Level p_309627_, BlockPos p_311485_) {
        RandomSource $$4;
        if (!this.m_305592_(p_309627_)) {
            this.f_302910_.f_303293_ = this.f_302910_.f_302632_;
            return;
        }
        TrialSpawnerState $$2 = this.m_305684_();
        $$2.m_306816_(p_309627_, p_311485_);
        if ($$2.m_307384_()) {
            double $$3 = Math.max(0L, this.f_302910_.f_302458_ - p_309627_.m_46467_());
            this.f_302910_.f_303293_ = this.f_302910_.f_302632_;
            this.f_302910_.f_302632_ = (this.f_302910_.f_302632_ + $$2.m_305120_() / ($$3 + 200.0)) % 360.0;
        }
        if ($$2.m_306216_() && ($$4 = p_309627_.m_213780_()).m_188501_() <= 0.02f) {
            p_309627_.m_245747_(p_311485_, SoundEvents.f_302711_, SoundSource.BLOCKS, $$4.m_188501_() * 0.25f + 0.75f, $$4.m_188501_() + 0.5f, false);
        }
    }

    public void m_306335_(ServerLevel p_310996_, BlockPos p_312836_) {
        TrialSpawnerState $$3;
        TrialSpawnerState $$2 = this.m_305684_();
        if (!this.m_305592_(p_310996_)) {
            if ($$2.m_306216_()) {
                this.f_302910_.m_305301_();
                this.m_304838_(p_310996_, TrialSpawnerState.INACTIVE);
            }
            return;
        }
        if (this.f_302910_.f_302440_.removeIf(p_309715_ -> TrialSpawner.m_306734_(p_310996_, p_312836_, p_309715_))) {
            this.f_302910_.f_302458_ = p_310996_.m_46467_() + (long)this.f_302564_.f_303452_();
        }
        if (($$3 = $$2.m_308008_(p_312836_, this, p_310996_)) != $$2) {
            this.m_304838_(p_310996_, $$3);
        }
    }

    private static boolean m_306734_(ServerLevel p_312275_, BlockPos p_310158_, UUID p_312011_) {
        Entity $$3 = p_312275_.m_8791_(p_312011_);
        return $$3 == null || !$$3.m_6084_() || !((Object)$$3.m_9236_().m_46472_()).equals(p_312275_.m_46472_()) || $$3.m_20183_().m_123331_(p_310158_) > (double)f_303092_;
    }

    private static boolean m_306844_(Level p_311873_, Vec3 p_311845_, Vec3 p_312229_) {
        BlockHitResult $$3 = p_311873_.m_45547_(new ClipContext(p_312229_, p_311845_, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.m_82749_()));
        return $$3.m_82425_().equals(BlockPos.m_274446_(p_311845_)) || $$3.m_6662_() == HitResult.Type.MISS;
    }

    public static void m_307155_(Level p_312837_, BlockPos p_311261_, RandomSource p_312356_) {
        for (int $$3 = 0; $$3 < 20; ++$$3) {
            double $$4 = (double)p_311261_.m_123341_() + 0.5 + (p_312356_.m_188500_() - 0.5) * 2.0;
            double $$5 = (double)p_311261_.m_123342_() + 0.5 + (p_312356_.m_188500_() - 0.5) * 2.0;
            double $$6 = (double)p_311261_.m_123343_() + 0.5 + (p_312356_.m_188500_() - 0.5) * 2.0;
            p_312837_.m_7106_(ParticleTypes.f_123762_, $$4, $$5, $$6, 0.0, 0.0, 0.0);
            p_312837_.m_7106_(ParticleTypes.f_123744_, $$4, $$5, $$6, 0.0, 0.0, 0.0);
        }
    }

    public static void m_306813_(Level p_309415_, BlockPos p_309941_, RandomSource p_310263_, int p_310988_) {
        for (int $$4 = 0; $$4 < 30 + Math.min(p_310988_, 10) * 5; ++$$4) {
            double $$5 = (double)(2.0f * p_310263_.m_188501_() - 1.0f) * 0.65;
            double $$6 = (double)(2.0f * p_310263_.m_188501_() - 1.0f) * 0.65;
            double $$7 = (double)p_309941_.m_123341_() + 0.5 + $$5;
            double $$8 = (double)p_309941_.m_123342_() + 0.1 + (double)p_310263_.m_188501_() * 0.8;
            double $$9 = (double)p_309941_.m_123343_() + 0.5 + $$6;
            p_309415_.m_7106_(ParticleTypes.f_302628_, $$7, $$8, $$9, 0.0, 0.0, 0.0);
        }
    }

    public static void m_306726_(Level p_311170_, BlockPos p_309958_, RandomSource p_309409_) {
        for (int $$3 = 0; $$3 < 20; ++$$3) {
            double $$4 = (double)p_309958_.m_123341_() + 0.4 + p_309409_.m_188500_() * 0.2;
            double $$5 = (double)p_309958_.m_123342_() + 0.4 + p_309409_.m_188500_() * 0.2;
            double $$6 = (double)p_309958_.m_123343_() + 0.4 + p_309409_.m_188500_() * 0.2;
            double $$7 = p_309409_.m_188583_() * 0.02;
            double $$8 = p_309409_.m_188583_() * 0.02;
            double $$9 = p_309409_.m_188583_() * 0.02;
            p_311170_.m_7106_(ParticleTypes.f_175834_, $$4, $$5, $$6, $$7, $$8, $$9 * 0.25);
            p_311170_.m_7106_(ParticleTypes.f_123762_, $$4, $$5, $$6, $$7, $$8, $$9);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void m_305658_(PlayerDetector p_311472_) {
        this.f_302944_ = p_311472_;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void m_306621_() {
        this.f_302722_ = true;
    }

    public static interface StateAccessor {
        public void m_305970_(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState m_306453_();

        public void m_306374_();
    }
}

