/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;

public class TrialSpawnerData {
    public static final String f_302545_ = "spawn_data";
    private static final String f_303495_ = "next_mob_spawns_at";
    public static MapCodec<TrialSpawnerData> f_302600_ = RecordCodecBuilder.mapCodec(p_313188_ -> p_313188_.group((App)UUIDUtil.f_302298_.optionalFieldOf("registered_players", (Object)Sets.newHashSet()).forGetter(p_309580_ -> p_309580_.f_303462_), (App)UUIDUtil.f_302298_.optionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(p_311034_ -> p_311034_.f_302440_), (App)Codec.LONG.optionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(p_309685_ -> p_309685_.f_303712_), (App)Codec.LONG.optionalFieldOf(f_303495_, (Object)0L).forGetter(p_310876_ -> p_310876_.f_302458_), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("total_mobs_spawned", (Object)0).forGetter(p_309745_ -> p_309745_.f_302930_), (App)SpawnData.f_186559_.optionalFieldOf(f_302545_).forGetter(p_312904_ -> p_312904_.f_303191_), (App)ResourceLocation.f_135803_.optionalFieldOf("ejecting_loot_table").forGetter(p_310765_ -> p_310765_.f_303012_)).apply((Applicative)p_313188_, TrialSpawnerData::new));
    protected final Set<UUID> f_303462_ = new HashSet<UUID>();
    protected final Set<UUID> f_302440_ = new HashSet<UUID>();
    protected long f_303712_;
    protected long f_302458_;
    protected int f_302930_;
    protected Optional<SpawnData> f_303191_;
    protected Optional<ResourceLocation> f_303012_;
    protected SimpleWeightedRandomList<SpawnData> f_302396_;
    @Nullable
    protected Entity f_302195_;
    protected double f_302632_;
    protected double f_303293_;

    public TrialSpawnerData() {
        this(Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, Optional.empty(), Optional.empty());
    }

    public TrialSpawnerData(Set<UUID> p_312543_, Set<UUID> p_311274_, long p_312908_, long p_311373_, int p_311452_, Optional<SpawnData> p_311258_, Optional<ResourceLocation> p_312612_) {
        this.f_303462_.addAll(p_312543_);
        this.f_302440_.addAll(p_311274_);
        this.f_303712_ = p_312908_;
        this.f_302458_ = p_311373_;
        this.f_302930_ = p_311452_;
        this.f_303191_ = p_311258_;
        this.f_303012_ = p_312612_;
    }

    public void m_305185_(TrialSpawnerConfig p_311202_) {
        SimpleWeightedRandomList<SpawnData> $$1 = p_311202_.f_303733_();
        this.f_302396_ = $$1.m_146337_() ? SimpleWeightedRandomList.m_185862_(this.f_303191_.orElseGet(SpawnData::new)) : $$1;
    }

    public void m_305301_() {
        this.f_303462_.clear();
        this.f_302930_ = 0;
        this.f_302458_ = 0L;
        this.f_303712_ = 0L;
        this.f_302440_.clear();
    }

    public boolean m_306286_() {
        boolean $$0 = this.f_303191_.isPresent() && this.f_303191_.get().m_186567_().m_128425_("id", 8);
        return $$0 || !this.f_302396_.m_146337_();
    }

    public boolean m_305025_(TrialSpawnerConfig p_310871_, int p_313160_) {
        return this.f_302930_ >= p_310871_.m_306590_(p_313160_);
    }

    public boolean m_307352_() {
        return this.f_302440_.isEmpty();
    }

    public boolean m_305681_(ServerLevel p_312376_, TrialSpawnerConfig p_313089_, int p_311969_) {
        return p_312376_.m_46467_() >= this.f_302458_ && this.f_302440_.size() < p_313089_.m_306918_(p_311969_);
    }

    public int m_305480_(BlockPos p_310055_) {
        if (this.f_303462_.isEmpty()) {
            Util.m_143785_("Trial Spawner at " + p_310055_ + " has no detected players");
        }
        return Math.max(0, this.f_303462_.size() - 1);
    }

    public void m_304942_(ServerLevel p_313049_, BlockPos p_310981_, PlayerDetector p_312393_, int p_310864_) {
        List<UUID> $$4 = p_312393_.m_305839_(p_313049_, p_310981_, p_310864_);
        boolean $$5 = this.f_303462_.addAll($$4);
        if ($$5) {
            this.f_302458_ = Math.max(p_313049_.m_46467_() + 40L, this.f_302458_);
            p_313049_.m_46796_(3013, p_310981_, this.f_303462_.size());
        }
    }

    public boolean m_305761_(ServerLevel p_311936_, TrialSpawnerConfig p_312846_, float p_312381_) {
        long $$3 = this.f_303712_ - (long)p_312846_.f_302361_();
        return (float)p_311936_.m_46467_() >= (float)$$3 + p_312381_;
    }

    public boolean m_305594_(ServerLevel p_309478_, TrialSpawnerConfig p_310848_, float p_310189_) {
        long $$3 = this.f_303712_ - (long)p_310848_.f_302361_();
        return (float)(p_309478_.m_46467_() - $$3) % p_310189_ == 0.0f;
    }

    public boolean m_305171_(ServerLevel p_312277_) {
        return p_312277_.m_46467_() >= this.f_303712_;
    }

    public void m_307184_(TrialSpawner p_311233_, RandomSource p_312395_, EntityType<?> p_311226_) {
        this.m_306716_(p_311233_, p_312395_).m_186567_().m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(p_311226_).toString());
    }

    protected SpawnData m_306716_(TrialSpawner p_311810_, RandomSource p_311692_) {
        if (this.f_303191_.isPresent()) {
            return this.f_303191_.get();
        }
        this.f_303191_ = Optional.of(this.f_302396_.m_216829_(p_311692_).map(WeightedEntry.Wrapper::m_146310_).orElseGet(SpawnData::new));
        p_311810_.m_306727_();
        return this.f_303191_.get();
    }

    @Nullable
    public Entity m_307031_(TrialSpawner p_310895_, Level p_310374_, TrialSpawnerState p_310556_) {
        CompoundTag $$3;
        if (!p_310895_.m_305592_(p_310374_) || !p_310556_.m_307384_()) {
            return null;
        }
        if (this.f_302195_ == null && ($$3 = this.m_306716_(p_310895_, p_310374_.m_213780_()).m_186567_()).m_128425_("id", 8)) {
            this.f_302195_ = EntityType.m_20645_($$3, p_310374_, Function.identity());
        }
        return this.f_302195_;
    }

    public CompoundTag m_307504_(TrialSpawnerState p_310015_) {
        CompoundTag $$1 = new CompoundTag();
        if (p_310015_ == TrialSpawnerState.ACTIVE) {
            $$1.m_128356_(f_303495_, this.f_302458_);
        }
        this.f_303191_.ifPresent(p_312008_ -> $$1.m_128365_(f_302545_, (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, p_312008_).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"))));
        return $$1;
    }

    public double m_306486_() {
        return this.f_302632_;
    }

    public double m_305098_() {
        return this.f_303293_;
    }
}

