/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.grower;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;

public final class TreeGrower {
    private static final Map<String, TreeGrower> f_302769_ = new Object2ObjectArrayMap();
    public static final Codec<TreeGrower> f_302786_ = ExtraCodecs.m_184405_(p_310196_ -> p_310196_.f_303132_, f_302769_::get);
    public static final TreeGrower f_303425_ = new TreeGrower("oak", 0.1f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.f_195123_), Optional.of(TreeFeatures.f_195130_), Optional.of(TreeFeatures.f_195142_), Optional.of(TreeFeatures.f_195111_));
    public static final TreeGrower f_302563_ = new TreeGrower("spruce", 0.5f, Optional.of(TreeFeatures.f_195133_), Optional.of(TreeFeatures.f_195134_), Optional.of(TreeFeatures.f_195127_), Optional.empty(), Optional.empty(), Optional.empty());
    public static final TreeGrower f_302923_ = new TreeGrower("mangrove", 0.85f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.f_236762_), Optional.of(TreeFeatures.f_236763_), Optional.empty(), Optional.empty());
    public static final TreeGrower f_303862_ = new TreeGrower("azalea", Optional.empty(), Optional.of(TreeFeatures.f_195139_), Optional.empty());
    public static final TreeGrower f_303209_ = new TreeGrower("birch", Optional.empty(), Optional.of(TreeFeatures.f_195125_), Optional.of(TreeFeatures.f_195108_));
    public static final TreeGrower f_303040_ = new TreeGrower("jungle", Optional.of(TreeFeatures.f_195132_), Optional.of(TreeFeatures.f_195131_), Optional.empty());
    public static final TreeGrower f_303438_ = new TreeGrower("acacia", Optional.empty(), Optional.of(TreeFeatures.f_195126_), Optional.empty());
    public static final TreeGrower f_302972_ = new TreeGrower("cherry", Optional.empty(), Optional.of(TreeFeatures.f_271469_), Optional.of(TreeFeatures.f_271485_));
    public static final TreeGrower f_302400_ = new TreeGrower("dark_oak", Optional.of(TreeFeatures.f_195124_), Optional.empty(), Optional.empty());
    private final String f_303132_;
    private final float f_303193_;
    private final Optional<ResourceKey<ConfiguredFeature<?, ?>>> f_302394_;
    private final Optional<ResourceKey<ConfiguredFeature<?, ?>>> f_303060_;
    private final Optional<ResourceKey<ConfiguredFeature<?, ?>>> f_302290_;
    private final Optional<ResourceKey<ConfiguredFeature<?, ?>>> f_303523_;
    private final Optional<ResourceKey<ConfiguredFeature<?, ?>>> f_303258_;
    private final Optional<ResourceKey<ConfiguredFeature<?, ?>>> f_303546_;

    public TreeGrower(String p_311110_, Optional<ResourceKey<ConfiguredFeature<?, ?>>> p_309803_, Optional<ResourceKey<ConfiguredFeature<?, ?>>> p_311829_, Optional<ResourceKey<ConfiguredFeature<?, ?>>> p_310077_) {
        this(p_311110_, 0.0f, p_309803_, Optional.empty(), p_311829_, Optional.empty(), p_310077_, Optional.empty());
    }

    public TreeGrower(String p_310538_, float p_312608_, Optional<ResourceKey<ConfiguredFeature<?, ?>>> p_311356_, Optional<ResourceKey<ConfiguredFeature<?, ?>>> p_309855_, Optional<ResourceKey<ConfiguredFeature<?, ?>>> p_312520_, Optional<ResourceKey<ConfiguredFeature<?, ?>>> p_310394_, Optional<ResourceKey<ConfiguredFeature<?, ?>>> p_309623_, Optional<ResourceKey<ConfiguredFeature<?, ?>>> p_310708_) {
        this.f_303132_ = p_310538_;
        this.f_303193_ = p_312608_;
        this.f_302394_ = p_311356_;
        this.f_303060_ = p_309855_;
        this.f_302290_ = p_312520_;
        this.f_303523_ = p_310394_;
        this.f_303258_ = p_309623_;
        this.f_303546_ = p_310708_;
        f_302769_.put(p_310538_, this);
    }

    @Nullable
    private ResourceKey<ConfiguredFeature<?, ?>> m_307922_(RandomSource p_312729_, boolean p_311061_) {
        if (p_312729_.m_188501_() < this.f_303193_) {
            if (p_311061_ && this.f_303546_.isPresent()) {
                return this.f_303546_.get();
            }
            if (this.f_303523_.isPresent()) {
                return this.f_303523_.get();
            }
        }
        return p_311061_ && this.f_303258_.isPresent() ? this.f_303258_.get() : this.f_302290_.orElse(null);
    }

    @Nullable
    private ResourceKey<ConfiguredFeature<?, ?>> m_304937_(RandomSource p_309400_) {
        return this.f_303060_.isPresent() && p_309400_.m_188501_() < this.f_303193_ ? this.f_303060_.get() : this.f_302394_.orElse(null);
    }

    public boolean m_307294_(ServerLevel p_309830_, ChunkGenerator p_311976_, BlockPos p_310327_, BlockState p_312382_, RandomSource p_309951_) {
        ResourceKey<ConfiguredFeature<?, ?>> resourcekey1;
        ResourceKey<ConfiguredFeature<?, ?>> resourcekey = this.m_304937_(p_309951_);
        if (resourcekey != null) {
            Holder holder = p_309830_.m_9598_().m_175515_(Registries.f_256911_).m_203636_(resourcekey).orElse(null);
            SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)p_309830_, (RandomSource)p_309951_, (BlockPos)p_310327_, (Holder)holder);
            holder = event.getFeature();
            if (event.getResult() == Event.Result.DENY) {
                return false;
            }
            if (holder != null) {
                for (int i = 0; i >= -1; --i) {
                    for (int j = 0; j >= -1; --j) {
                        if (!TreeGrower.m_305963_(p_312382_, p_309830_, p_310327_, i, j)) continue;
                        ConfiguredFeature configuredfeature = (ConfiguredFeature)holder.m_203334_();
                        BlockState blockstate = Blocks.f_50016_.m_49966_();
                        p_309830_.m_7731_(p_310327_.m_7918_(i, 0, j), blockstate, 4);
                        p_309830_.m_7731_(p_310327_.m_7918_(i + 1, 0, j), blockstate, 4);
                        p_309830_.m_7731_(p_310327_.m_7918_(i, 0, j + 1), blockstate, 4);
                        p_309830_.m_7731_(p_310327_.m_7918_(i + 1, 0, j + 1), blockstate, 4);
                        if (configuredfeature.m_224953_(p_309830_, p_311976_, p_309951_, p_310327_.m_7918_(i, 0, j))) {
                            return true;
                        }
                        p_309830_.m_7731_(p_310327_.m_7918_(i, 0, j), p_312382_, 4);
                        p_309830_.m_7731_(p_310327_.m_7918_(i + 1, 0, j), p_312382_, 4);
                        p_309830_.m_7731_(p_310327_.m_7918_(i, 0, j + 1), p_312382_, 4);
                        p_309830_.m_7731_(p_310327_.m_7918_(i + 1, 0, j + 1), p_312382_, 4);
                        return false;
                    }
                }
            }
        }
        if ((resourcekey1 = this.m_307922_(p_309951_, this.m_306742_(p_309830_, p_310327_))) == null) {
            return false;
        }
        Holder holder1 = p_309830_.m_9598_().m_175515_(Registries.f_256911_).m_203636_(resourcekey1).orElse(null);
        if (holder1 == null) {
            return false;
        }
        ConfiguredFeature configuredfeature1 = (ConfiguredFeature)holder1.m_203334_();
        BlockState blockstate1 = p_309830_.m_6425_(p_310327_).m_76188_();
        p_309830_.m_7731_(p_310327_, blockstate1, 4);
        if (configuredfeature1.m_224953_(p_309830_, p_311976_, p_309951_, p_310327_)) {
            if (p_309830_.m_8055_(p_310327_) == blockstate1) {
                p_309830_.m_7260_(p_310327_, p_312382_, blockstate1, 2);
            }
            return true;
        }
        p_309830_.m_7731_(p_310327_, p_312382_, 4);
        return false;
    }

    private static boolean m_305963_(BlockState p_310256_, BlockGetter p_311754_, BlockPos p_312442_, int p_310725_, int p_310118_) {
        Block block = p_310256_.m_60734_();
        return p_311754_.m_8055_(p_312442_.m_7918_(p_310725_, 0, p_310118_)).m_60713_(block) && p_311754_.m_8055_(p_312442_.m_7918_(p_310725_ + 1, 0, p_310118_)).m_60713_(block) && p_311754_.m_8055_(p_312442_.m_7918_(p_310725_, 0, p_310118_ + 1)).m_60713_(block) && p_311754_.m_8055_(p_312442_.m_7918_(p_310725_ + 1, 0, p_310118_ + 1)).m_60713_(block);
    }

    private boolean m_306742_(LevelAccessor p_312531_, BlockPos p_312326_) {
        for (BlockPos blockpos : BlockPos.MutableBlockPos.m_121940_(p_312326_.m_7495_().m_122013_(2).m_122025_(2), p_312326_.m_7494_().m_122020_(2).m_122030_(2))) {
            if (!p_312531_.m_8055_(blockpos).m_204336_(BlockTags.f_13041_)) continue;
            return true;
        }
        return false;
    }
}

