/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class JigsawPlacement {
    static final Logger f_210265_ = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> m_227238_(Structure.GenerationContext p_227239_, Holder<StructureTemplatePool> p_227240_, Optional<ResourceLocation> p_227241_, int p_227242_, BlockPos p_227243_, boolean p_227244_, Optional<Heightmap.Types> p_227245_, int p_227246_, PoolAliasLookup p_312146_) {
        int $$29;
        BlockPos $$21;
        RegistryAccess $$9 = p_227239_.f_226621_();
        ChunkGenerator $$10 = p_227239_.f_226622_();
        StructureTemplateManager $$11 = p_227239_.f_226625_();
        LevelHeightAccessor $$12 = p_227239_.f_226629_();
        WorldgenRandom $$13 = p_227239_.f_226626_();
        Registry<StructureTemplatePool> $$14 = $$9.m_175515_(Registries.f_256948_);
        Rotation $$15 = Rotation.m_221990_($$13);
        StructureTemplatePool $$16 = p_227240_.m_203543_().flatMap(p_309329_ -> $$14.m_123009_(p_312146_.m_307301_((ResourceKey<StructureTemplatePool>)p_309329_))).orElse(p_227240_.m_203334_());
        StructurePoolElement $$17 = $$16.m_227355_($$13);
        if ($$17 == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (p_227241_.isPresent()) {
            ResourceLocation $$18 = p_227241_.get();
            Optional<BlockPos> $$19 = JigsawPlacement.m_227247_($$17, $$18, p_227243_, $$15, $$11, $$13);
            if ($$19.isEmpty()) {
                f_210265_.error("No starting jigsaw {} found in start pool {}", (Object)$$18, (Object)p_227240_.m_203543_().map(p_248484_ -> p_248484_.m_135782_().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            BlockPos $$20 = $$19.get();
        } else {
            $$21 = p_227243_;
        }
        BlockPos $$22 = $$21.m_121996_(p_227243_);
        BlockPos $$23 = p_227243_.m_121996_($$22);
        PoolElementStructurePiece $$24 = new PoolElementStructurePiece($$11, $$17, $$23, $$17.m_210540_(), $$15, $$17.m_214015_($$11, $$23, $$15));
        BoundingBox $$25 = $$24.m_73547_();
        int $$26 = ($$25.m_162399_() + $$25.m_162395_()) / 2;
        int $$27 = ($$25.m_162401_() + $$25.m_162398_()) / 2;
        if (p_227245_.isPresent()) {
            int $$28 = p_227243_.m_123342_() + $$10.m_223221_($$26, $$27, p_227245_.get(), $$12, p_227239_.f_226624_());
        } else {
            $$29 = $$23.m_123342_();
        }
        int $$30 = $$25.m_162396_() + $$24.m_72647_();
        $$24.m_6324_(0, $$29 - $$30, 0);
        int $$31 = $$29 + $$22.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos($$26, $$31, $$27), p_309345_ -> {
            ArrayList $$16 = Lists.newArrayList();
            $$16.add($$24);
            if (p_227242_ <= 0) {
                return;
            }
            AABB $$17 = new AABB($$26 - p_227246_, $$31 - p_227246_, $$27 - p_227246_, $$26 + p_227246_ + 1, $$31 + p_227246_ + 1, $$27 + p_227246_ + 1);
            VoxelShape $$18 = Shapes.m_83113_(Shapes.m_83064_($$17), Shapes.m_83064_(AABB.m_82321_($$25)), BooleanOp.f_82685_);
            JigsawPlacement.m_227210_(p_227239_.f_226624_(), p_227242_, p_227244_, $$10, $$11, $$12, $$13, $$14, $$24, $$16, $$18, p_312146_);
            $$16.forEach(p_309345_::m_142679_);
        }));
    }

    private static Optional<BlockPos> m_227247_(StructurePoolElement p_227248_, ResourceLocation p_227249_, BlockPos p_227250_, Rotation p_227251_, StructureTemplateManager p_227252_, WorldgenRandom p_227253_) {
        List<StructureTemplate.StructureBlockInfo> $$6 = p_227248_.m_213638_(p_227252_, p_227250_, p_227251_, p_227253_);
        Optional<BlockPos> $$7 = Optional.empty();
        for (StructureTemplate.StructureBlockInfo $$8 : $$6) {
            ResourceLocation $$9 = ResourceLocation.m_135820_(Objects.requireNonNull($$8.f_74677_(), () -> $$8 + " nbt was null").m_128461_("name"));
            if (!p_227249_.equals($$9)) continue;
            $$7 = Optional.of($$8.f_74675_());
            break;
        }
        return $$7;
    }

    private static void m_227210_(RandomState p_227211_, int p_227212_, boolean p_227213_, ChunkGenerator p_227214_, StructureTemplateManager p_227215_, LevelHeightAccessor p_227216_, RandomSource p_227217_, Registry<StructureTemplatePool> p_227218_, PoolElementStructurePiece p_227219_, List<PoolElementStructurePiece> p_227220_, VoxelShape p_227221_, PoolAliasLookup p_312553_) {
        Placer $$12 = new Placer(p_227218_, p_227212_, p_227214_, p_227215_, p_227220_, p_227217_);
        $$12.m_227264_(p_227219_, (MutableObject<VoxelShape>)new MutableObject((Object)p_227221_), 0, p_227213_, p_227216_, p_227211_, p_312553_);
        while ($$12.f_210321_.hasNext()) {
            PieceState $$13 = (PieceState)$$12.f_210321_.next();
            $$12.m_227264_($$13.f_210307_, $$13.f_210308_, $$13.f_210309_, p_227213_, p_227216_, p_227211_, p_312553_);
        }
    }

    public static boolean m_227203_(ServerLevel p_227204_, Holder<StructureTemplatePool> p_227205_, ResourceLocation p_227206_, int p_227207_, BlockPos p_227208_, boolean p_227209_) {
        ChunkGenerator $$6 = p_227204_.m_7726_().m_8481_();
        StructureTemplateManager $$7 = p_227204_.m_215082_();
        StructureManager $$8 = p_227204_.m_215010_();
        RandomSource $$9 = p_227204_.m_213780_();
        Structure.GenerationContext $$10 = new Structure.GenerationContext(p_227204_.m_9598_(), $$6, $$6.m_62218_(), p_227204_.m_7726_().m_214994_(), $$7, p_227204_.m_7328_(), new ChunkPos(p_227208_), p_227204_, p_227255_ -> true);
        Optional<Structure.GenerationStub> $$11 = JigsawPlacement.m_227238_($$10, p_227205_, Optional.of(p_227206_), p_227207_, p_227208_, false, Optional.empty(), 128, PoolAliasLookup.f_303598_);
        if ($$11.isPresent()) {
            StructurePiecesBuilder $$12 = $$11.get().m_226677_();
            for (StructurePiece $$13 : $$12.m_192780_().f_192741_()) {
                if (!($$13 instanceof PoolElementStructurePiece)) continue;
                PoolElementStructurePiece $$14 = (PoolElementStructurePiece)$$13;
                $$14.m_226509_(p_227204_, $$8, $$6, $$9, BoundingBox.m_71044_(), p_227208_, p_227209_);
            }
            return true;
        }
        return false;
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> f_210314_;
        private final int f_210315_;
        private final ChunkGenerator f_210317_;
        private final StructureTemplateManager f_227256_;
        private final List<? super PoolElementStructurePiece> f_210319_;
        private final RandomSource f_210320_;
        final SequencedPriorityIterator<PieceState> f_210321_ = new SequencedPriorityIterator();

        Placer(Registry<StructureTemplatePool> p_227258_, int p_227259_, ChunkGenerator p_227260_, StructureTemplateManager p_227261_, List<? super PoolElementStructurePiece> p_227262_, RandomSource p_227263_) {
            this.f_210314_ = p_227258_;
            this.f_210315_ = p_227259_;
            this.f_210317_ = p_227260_;
            this.f_227256_ = p_227261_;
            this.f_210319_ = p_227262_;
            this.f_210320_ = p_227263_;
        }

        void m_227264_(PoolElementStructurePiece p_227265_, MutableObject<VoxelShape> p_227266_, int p_227267_, boolean p_227268_, LevelHeightAccessor p_227269_, RandomState p_227270_, PoolAliasLookup p_311045_) {
            StructurePoolElement $$7 = p_227265_.m_209918_();
            BlockPos $$8 = p_227265_.m_72646_();
            Rotation $$9 = p_227265_.m_6830_();
            StructureTemplatePool.Projection $$10 = $$7.m_210539_();
            boolean $$11 = $$10 == StructureTemplatePool.Projection.RIGID;
            MutableObject $$12 = new MutableObject();
            BoundingBox $$13 = p_227265_.m_73547_();
            int $$14 = $$13.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo $$15 : $$7.m_213638_(this.f_227256_, $$8, $$9, this.f_210320_)) {
                StructurePoolElement $$30;
                MutableObject<VoxelShape> $$27;
                Direction $$16 = JigsawBlock.m_54250_($$15.f_74676_());
                BlockPos $$17 = $$15.f_74675_();
                BlockPos $$18 = $$17.m_121945_($$16);
                int $$19 = $$17.m_123342_() - $$14;
                int $$20 = -1;
                ResourceKey<StructureTemplatePool> $$21 = Placer.m_306140_($$15, p_311045_);
                Optional<Holder.Reference<StructureTemplatePool>> $$22 = this.f_210314_.m_203636_($$21);
                if ($$22.isEmpty()) {
                    f_210265_.warn("Empty or non-existent pool: {}", (Object)$$21.m_135782_());
                    continue;
                }
                Holder $$23 = $$22.get();
                if (((StructureTemplatePool)$$23.m_203334_()).m_210590_() == 0 && !$$23.m_203565_(Pools.f_127186_)) {
                    f_210265_.warn("Empty or non-existent pool: {}", (Object)$$21.m_135782_());
                    continue;
                }
                Holder<StructureTemplatePool> $$24 = ((StructureTemplatePool)$$23.m_203334_()).m_254935_();
                if ($$24.m_203334_().m_210590_() == 0 && !$$24.m_203565_(Pools.f_127186_)) {
                    f_210265_.warn("Empty or non-existent fallback pool: {}", (Object)$$24.m_203543_().map(p_255599_ -> p_255599_.m_135782_().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean $$25 = $$13.m_71051_($$18);
                if ($$25) {
                    MutableObject $$26 = $$12;
                    if ($$12.getValue() == null) {
                        $$12.setValue((Object)Shapes.m_83064_(AABB.m_82321_($$13)));
                    }
                } else {
                    $$27 = p_227266_;
                }
                ArrayList $$28 = Lists.newArrayList();
                if (p_227267_ != this.f_210315_) {
                    $$28.addAll(((StructureTemplatePool)$$23.m_203334_()).m_227362_(this.f_210320_));
                }
                $$28.addAll($$24.m_203334_().m_227362_(this.f_210320_));
                int $$29 = $$15.f_74677_() != null ? $$15.f_74677_().m_128451_("placement_priority") : 0;
                Iterator iterator = $$28.iterator();
                while (iterator.hasNext() && ($$30 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_210175_) {
                    for (Rotation $$31 : Rotation.m_221992_(this.f_210320_)) {
                        int $$35;
                        List<StructureTemplate.StructureBlockInfo> $$32 = $$30.m_213638_(this.f_227256_, BlockPos.f_121853_, $$31, this.f_210320_);
                        BoundingBox $$33 = $$30.m_214015_(this.f_227256_, BlockPos.f_121853_, $$31);
                        if (!p_227268_ || $$33.m_71057_() > 16) {
                            boolean $$34 = false;
                        } else {
                            $$35 = $$32.stream().mapToInt(p_255598_ -> {
                                if (!$$33.m_71051_(p_255598_.f_74675_().m_121945_(JigsawBlock.m_54250_(p_255598_.f_74676_())))) {
                                    return 0;
                                }
                                ResourceKey<StructureTemplatePool> $$3 = Placer.m_306140_(p_255598_, p_311045_);
                                Optional<Holder.Reference<StructureTemplatePool>> $$4 = this.f_210314_.m_203636_($$3);
                                Optional<Holder> $$5 = $$4.map(p_255600_ -> ((StructureTemplatePool)p_255600_.m_203334_()).m_254935_());
                                int $$6 = $$4.map(p_255596_ -> ((StructureTemplatePool)p_255596_.m_203334_()).m_227357_(this.f_227256_)).orElse(0);
                                int $$7 = $$5.map(p_255601_ -> ((StructureTemplatePool)p_255601_.m_203334_()).m_227357_(this.f_227256_)).orElse(0);
                                return Math.max($$6, $$7);
                            }).max().orElse(0);
                        }
                        for (StructureTemplate.StructureBlockInfo $$36 : $$32) {
                            int $$57;
                            int $$53;
                            int $$46;
                            if (!JigsawBlock.m_54245_($$15, $$36)) continue;
                            BlockPos $$37 = $$36.f_74675_();
                            BlockPos $$38 = $$18.m_121996_($$37);
                            BoundingBox $$39 = $$30.m_214015_(this.f_227256_, $$38, $$31);
                            int $$40 = $$39.m_162396_();
                            StructureTemplatePool.Projection $$41 = $$30.m_210539_();
                            boolean $$42 = $$41 == StructureTemplatePool.Projection.RIGID;
                            int $$43 = $$37.m_123342_();
                            int $$44 = $$19 - $$43 + JigsawBlock.m_54250_($$15.f_74676_()).m_122430_();
                            if ($$11 && $$42) {
                                int $$45 = $$14 + $$44;
                            } else {
                                if ($$20 == -1) {
                                    $$20 = this.f_210317_.m_223221_($$17.m_123341_(), $$17.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_227269_, p_227270_);
                                }
                                $$46 = $$20 - $$43;
                            }
                            int $$47 = $$46 - $$40;
                            BoundingBox $$48 = $$39.m_71045_(0, $$47, 0);
                            BlockPos $$49 = $$38.m_7918_(0, $$47, 0);
                            if ($$35 > 0) {
                                int $$50 = Math.max($$35 + 1, $$48.m_162400_() - $$48.m_162396_());
                                $$48.m_162371_(new BlockPos($$48.m_162395_(), $$48.m_162396_() + $$50, $$48.m_162398_()));
                            }
                            if (Shapes.m_83157_((VoxelShape)$$27.getValue(), Shapes.m_83064_(AABB.m_82321_($$48).m_82406_(0.25)), BooleanOp.f_82683_)) continue;
                            $$27.setValue((Object)Shapes.m_83148_((VoxelShape)$$27.getValue(), Shapes.m_83064_(AABB.m_82321_($$48)), BooleanOp.f_82685_));
                            int $$51 = p_227265_.m_72647_();
                            if ($$42) {
                                int $$52 = $$51 - $$44;
                            } else {
                                $$53 = $$30.m_210540_();
                            }
                            PoolElementStructurePiece $$54 = new PoolElementStructurePiece(this.f_227256_, $$30, $$49, $$53, $$31, $$48);
                            if ($$11) {
                                int $$55 = $$14 + $$19;
                            } else if ($$42) {
                                int $$56 = $$46 + $$43;
                            } else {
                                if ($$20 == -1) {
                                    $$20 = this.f_210317_.m_223221_($$17.m_123341_(), $$17.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, p_227269_, p_227270_);
                                }
                                $$57 = $$20 + $$44 / 2;
                            }
                            p_227265_.m_209916_(new JigsawJunction($$18.m_123341_(), (int)($$57 - $$19 + $$51), $$18.m_123343_(), $$44, $$41));
                            $$54.m_209916_(new JigsawJunction($$17.m_123341_(), $$57 - $$43 + $$53, $$17.m_123343_(), -$$44, $$10));
                            this.f_210319_.add($$54);
                            if (p_227267_ + 1 > this.f_210315_) continue block0;
                            PieceState $$58 = new PieceState($$54, $$27, p_227267_ + 1);
                            this.f_210321_.m_307049_($$58, $$29);
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> m_306140_(StructureTemplate.StructureBlockInfo p_309775_, PoolAliasLookup p_310642_) {
            CompoundTag $$2 = Objects.requireNonNull(p_309775_.f_74677_(), () -> p_309775_ + " nbt was null");
            ResourceKey<StructureTemplatePool> $$3 = Pools.m_254871_($$2.m_128461_("pool"));
            return p_310642_.m_307301_($$3);
        }
    }

    record PieceState(PoolElementStructurePiece f_210307_, MutableObject<VoxelShape> f_210308_, int f_210309_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PieceState.class, "piece;free;depth", "f_210307_", "f_210308_", "f_210309_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PieceState.class, "piece;free;depth", "f_210307_", "f_210308_", "f_210309_"}, this);
        }

        @Override
        public final boolean equals(Object p_311397_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PieceState.class, "piece;free;depth", "f_210307_", "f_210308_", "f_210309_"}, this, p_311397_);
        }
    }
}

