/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger f_78191_ = LogUtils.getLogger();
    static final DateTimeFormatter f_78192_ = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final String f_202311_ = "Data";
    private static final PathMatcher f_289833_ = p_296993_ -> false;
    public static final String f_289824_ = "allowed_symlinks.txt";
    private static final int f_302867_ = 0x6400000;
    private final Path f_78194_;
    private final Path f_78195_;
    final DataFixer f_78196_;
    private final DirectoryValidator f_289816_;

    public LevelStorageSource(Path p_289985_, Path p_289978_, DirectoryValidator p_289922_, DataFixer p_289940_) {
        this.f_78196_ = p_289940_;
        try {
            FileUtil.m_257659_(p_289985_);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
        this.f_78194_ = p_289985_;
        this.f_78195_ = p_289978_;
        this.f_289816_ = p_289922_;
    }

    public static DirectoryValidator m_289881_(Path p_289968_) {
        if (Files.exists(p_289968_, new LinkOption[0])) {
            DirectoryValidator directoryValidator;
            block9: {
                BufferedReader bufferedreader = Files.newBufferedReader(p_289968_);
                try {
                    directoryValidator = new DirectoryValidator(PathAllowList.m_289888_(bufferedreader));
                    if (bufferedreader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedreader != null) {
                            try {
                                bufferedreader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        f_78191_.error("Failed to parse {}, disallowing all symbolic links", (Object)f_289824_, (Object)exception);
                    }
                }
                bufferedreader.close();
            }
            return directoryValidator;
        }
        return new DirectoryValidator(f_289833_);
    }

    public static LevelStorageSource m_78242_(Path p_78243_) {
        DirectoryValidator directoryvalidator = LevelStorageSource.m_289881_(p_78243_.resolve(f_289824_));
        return new LevelStorageSource(p_78243_, p_78243_.resolve("../backups"), directoryvalidator, DataFixers.m_14512_());
    }

    public static WorldDataConfiguration m_245610_(Dynamic<?> p_250884_) {
        return WorldDataConfiguration.f_244621_.parse(p_250884_).resultOrPartial(arg_0 -> ((Logger)f_78191_).error(arg_0)).orElse(WorldDataConfiguration.f_244649_);
    }

    public static WorldLoader.PackConfig m_305246_(Dynamic<?> p_312675_, PackRepository p_309764_, boolean p_310223_) {
        return new WorldLoader.PackConfig(p_309764_, LevelStorageSource.m_245610_(p_312675_), p_310223_, false);
    }

    public static LevelDataAndDimensions m_306102_(Dynamic<?> p_311362_, WorldDataConfiguration p_311014_, Registry<LevelStem> p_311619_, RegistryAccess.Frozen p_313214_) {
        Dynamic<?> dynamic = LevelStorageSource.m_304791_(p_311362_, p_313214_);
        Dynamic dynamic1 = dynamic.get("WorldGenSettings").orElseEmptyMap();
        WorldGenSettings worldgensettings = (WorldGenSettings)WorldGenSettings.f_64600_.parse(dynamic1).getOrThrow(false, Util.m_137489_("WorldGenSettings: ", arg_0 -> ((Logger)f_78191_).error(arg_0)));
        LevelSettings levelsettings = LevelSettings.m_46924_(dynamic, p_311014_);
        WorldDimensions.Complete worlddimensions$complete = worldgensettings.f_64605_().m_245300_(p_311619_);
        Lifecycle lifecycle = worlddimensions$complete.m_245945_().add(p_313214_.m_211816_());
        PrimaryLevelData primaryleveldata = PrimaryLevelData.m_78530_(dynamic, levelsettings, worlddimensions$complete.f_244634_(), worldgensettings.f_243992_(), lifecycle);
        return new LevelDataAndDimensions(primaryleveldata, worlddimensions$complete);
    }

    private static <T> Dynamic<T> m_304791_(Dynamic<T> p_310020_, RegistryAccess.Frozen p_310921_) {
        RegistryOps registryops = RegistryOps.m_255058_(p_310020_.getOps(), p_310921_);
        return new Dynamic(registryops, p_310020_.getValue());
    }

    public String m_164909_() {
        return "Anvil";
    }

    public LevelCandidates m_230833_() throws LevelStorageException {
        LevelCandidates levelCandidates;
        block9: {
            if (!Files.isDirectory(this.f_78194_, new LinkOption[0])) {
                throw new LevelStorageException(Component.m_237115_("selectWorld.load_folder_access"));
            }
            Stream<Path> stream = Files.list(this.f_78194_);
            try {
                List<LevelDirectory> list = stream.filter(p_230839_ -> Files.isDirectory(p_230839_, new LinkOption[0])).map(LevelDirectory::new).filter(p_230835_ -> Files.isRegularFile(p_230835_.m_230858_(), new LinkOption[0]) || Files.isRegularFile(p_230835_.m_230859_(), new LinkOption[0])).toList();
                levelCandidates = new LevelCandidates(list);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioexception) {
                    throw new LevelStorageException(Component.m_237115_("selectWorld.load_folder_access"));
                }
            }
            stream.close();
        }
        return levelCandidates;
    }

    public CompletableFuture<List<LevelSummary>> m_230813_(LevelCandidates p_230814_) {
        ArrayList<CompletableFuture<LevelSummary>> list = new ArrayList<CompletableFuture<LevelSummary>>(p_230814_.f_230840_.size());
        for (LevelDirectory levelstoragesource$leveldirectory : p_230814_.f_230840_) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean flag;
                try {
                    flag = DirectoryLock.m_13642_(levelstoragesource$leveldirectory.f_230850_());
                }
                catch (Exception exception) {
                    f_78191_.warn("Failed to read {} lock", (Object)levelstoragesource$leveldirectory.f_230850_(), (Object)exception);
                    return null;
                }
                try {
                    return this.m_306052_(levelstoragesource$leveldirectory, flag);
                }
                catch (OutOfMemoryError outofmemoryerror1) {
                    MemoryReserve.m_182328_();
                    System.gc();
                    String s = "Ran out of memory trying to read summary of world folder \"" + levelstoragesource$leveldirectory.m_230853_() + "\"";
                    f_78191_.error(LogUtils.FATAL_MARKER, s);
                    OutOfMemoryError outofmemoryerror = new OutOfMemoryError("Ran out of memory reading level data");
                    outofmemoryerror.initCause(outofmemoryerror1);
                    CrashReport crashreport = CrashReport.m_127521_(outofmemoryerror, s);
                    CrashReportCategory crashreportcategory = crashreport.m_127514_("World details");
                    crashreportcategory.m_128159_("Folder Name", levelstoragesource$leveldirectory.m_230853_());
                    try {
                        long i = Files.size(levelstoragesource$leveldirectory.m_230858_());
                        crashreportcategory.m_128159_("level.dat size", i);
                    }
                    catch (IOException ioexception) {
                        crashreportcategory.m_128162_("level.dat size", ioexception);
                    }
                    throw new ReportedException(crashreport);
                }
            }, Util.m_183991_()));
        }
        return Util.m_214684_(list).thenApply(p_230832_ -> p_230832_.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int m_78265_() {
        return 19133;
    }

    static CompoundTag m_305304_(Path p_312857_) throws IOException {
        return NbtIo.m_128939_(p_312857_, NbtAccounter.m_301677_(0x6400000L));
    }

    static Dynamic<?> m_306158_(Path p_309458_, DataFixer p_312702_) throws IOException {
        CompoundTag compoundtag = LevelStorageSource.m_305304_(p_309458_);
        CompoundTag compoundtag1 = compoundtag.m_128469_(f_202311_);
        int i = NbtUtils.m_264487_(compoundtag1, -1);
        Dynamic dynamic = DataFixTypes.LEVEL.m_264140_(p_312702_, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundtag1), i);
        Dynamic dynamic1 = dynamic.get("Player").orElseEmptyMap();
        Dynamic dynamic2 = DataFixTypes.PLAYER.m_264140_(p_312702_, dynamic1, i);
        dynamic = dynamic.set("Player", dynamic2);
        Dynamic dynamic3 = dynamic.get("WorldGenSettings").orElseEmptyMap();
        Dynamic dynamic4 = DataFixTypes.WORLD_GEN_SETTINGS.m_264140_(p_312702_, dynamic3, i);
        return dynamic.set("WorldGenSettings", dynamic4);
    }

    private LevelSummary m_306052_(LevelDirectory p_313112_, boolean p_312081_) {
        Path path = p_313112_.m_230858_();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> list;
                if (Files.isSymbolicLink(path) && !(list = this.f_289816_.m_295373_(path)).isEmpty()) {
                    f_78191_.warn("{}", (Object)ContentValidationException.m_289907_(path, list));
                    return new LevelSummary.SymlinkLevelSummary(p_313112_.m_230853_(), p_313112_.m_230860_());
                }
                Tag tag = LevelStorageSource.m_230836_(path);
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundtag = (CompoundTag)tag;
                    CompoundTag compoundtag1 = compoundtag.m_128469_(f_202311_);
                    int i = NbtUtils.m_264487_(compoundtag1, -1);
                    Dynamic dynamic = DataFixTypes.LEVEL.m_264140_(this.f_78196_, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundtag1), i);
                    return this.m_306201_(dynamic, p_313112_, p_312081_);
                }
                f_78191_.warn("Invalid root tag in {}", (Object)path);
            }
            catch (Exception exception) {
                f_78191_.error("Exception reading {}", (Object)path, (Object)exception);
            }
        }
        return new LevelSummary.CorruptedLevelSummary(p_313112_.m_230853_(), p_313112_.m_230860_(), LevelStorageSource.m_307617_(p_313112_));
    }

    private static long m_307617_(LevelDirectory p_311230_) {
        Instant instant = LevelStorageSource.m_306357_(p_311230_.m_230858_());
        if (instant == null) {
            instant = LevelStorageSource.m_306357_(p_311230_.m_230859_());
        }
        return instant == null ? -1L : instant.toEpochMilli();
    }

    @Nullable
    static Instant m_306357_(Path p_313101_) {
        try {
            return Files.getLastModifiedTime(p_313101_, new LinkOption[0]).toInstant();
        }
        catch (IOException ioexception) {
            return null;
        }
    }

    LevelSummary m_306201_(Dynamic<?> p_310955_, LevelDirectory p_309842_, boolean p_310644_) {
        LevelVersion levelversion = LevelVersion.m_78390_(p_310955_);
        int i = levelversion.m_78389_();
        if (i != 19132 && i != 19133) {
            throw new NbtFormatException("Unknown data version: " + Integer.toHexString(i));
        }
        boolean flag = i != this.m_78265_();
        Path path = p_309842_.m_230860_();
        WorldDataConfiguration worlddataconfiguration = LevelStorageSource.m_245610_(p_310955_);
        LevelSettings levelsettings = LevelSettings.m_46924_(p_310955_, worlddataconfiguration);
        FeatureFlagSet featureflagset = LevelStorageSource.m_247076_(p_310955_);
        boolean flag1 = FeatureFlags.m_246811_(featureflagset);
        return new LevelSummary(levelsettings, levelversion, p_309842_.m_230853_(), flag, p_310644_, flag1, path);
    }

    private static FeatureFlagSet m_247076_(Dynamic<?> p_249466_) {
        Set<ResourceLocation> set = p_249466_.get("enabled_features").asStream().flatMap(p_248492_ -> p_248492_.asString().result().map(ResourceLocation::m_135820_).stream()).collect(Collectors.toSet());
        return FeatureFlags.f_244280_.m_247021_(set, p_248503_ -> {});
    }

    @Nullable
    private static Tag m_230836_(Path p_230837_) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector(f_202311_, CompoundTag.f_128326_, "Player"), new FieldSelector(f_202311_, CompoundTag.f_128326_, "WorldGenSettings"));
        NbtIo.m_202487_(p_230837_, skipfields, NbtAccounter.m_301677_(0x6400000L));
        return skipfields.m_197713_();
    }

    public boolean m_78240_(String p_78241_) {
        try {
            Path path = this.m_289874_(p_78241_);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean m_78255_(String p_78256_) {
        try {
            return Files.isDirectory(this.m_289874_(p_78256_), new LinkOption[0]);
        }
        catch (InvalidPathException invalidpathexception) {
            return false;
        }
    }

    public Path m_289874_(String p_289974_) {
        return this.f_78194_.resolve(p_289974_);
    }

    public Path m_78257_() {
        return this.f_78194_;
    }

    public Path m_78262_() {
        return this.f_78195_;
    }

    public LevelStorageAccess m_289864_(String p_289980_) throws IOException, ContentValidationException {
        Path path = this.m_289874_(p_289980_);
        List<ForbiddenSymlinkInfo> list = this.f_289816_.m_294444_(path, true);
        if (!list.isEmpty()) {
            throw new ContentValidationException(path, list);
        }
        return new LevelStorageAccess(p_289980_, path);
    }

    public LevelStorageAccess m_78260_(String p_78261_) throws IOException {
        Path path = this.m_289874_(p_78261_);
        return new LevelStorageAccess(p_78261_, path);
    }

    public DirectoryValidator m_289863_() {
        return this.f_289816_;
    }

    public record LevelCandidates(List<LevelDirectory> f_230840_) implements Iterable<LevelDirectory>
    {
        public boolean m_230843_() {
            return this.f_230840_.isEmpty();
        }

        @Override
        public Iterator<LevelDirectory> iterator() {
            return this.f_230840_.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this);
        }

        @Override
        public final boolean equals(Object p_230846_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this, p_230846_);
        }
    }

    public record LevelDirectory(Path f_230850_) {
        public String m_230853_() {
            return this.f_230850_.getFileName().toString();
        }

        public Path m_230858_() {
            return this.m_230854_(LevelResource.f_78178_);
        }

        public Path m_230859_() {
            return this.m_230854_(LevelResource.f_230800_);
        }

        public Path m_230856_(LocalDateTime p_230857_) {
            return this.f_230850_.resolve(LevelResource.f_78178_.m_78187_() + "_corrupted_" + p_230857_.format(f_78192_));
        }

        public Path m_305605_(LocalDateTime p_310027_) {
            return this.f_230850_.resolve(LevelResource.f_78178_.m_78187_() + "_raw_" + p_310027_.format(f_78192_));
        }

        public Path m_230860_() {
            return this.m_230854_(LevelResource.f_230801_);
        }

        public Path m_230861_() {
            return this.m_230854_(LevelResource.f_230802_);
        }

        public Path m_230854_(LevelResource p_230855_) {
            return this.f_230850_.resolve(p_230855_.m_78187_());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this);
        }

        @Override
        public final boolean equals(Object p_230863_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this, p_230863_);
        }
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock f_78270_;
        final LevelDirectory f_230867_;
        private final String f_78272_;
        private final Map<LevelResource, Path> f_78273_ = Maps.newHashMap();

        LevelStorageAccess(String p_289967_, Path p_289988_) throws IOException {
            this.f_78272_ = p_289967_;
            this.f_230867_ = new LevelDirectory(p_289988_);
            this.f_78270_ = DirectoryLock.m_13640_(p_289988_);
        }

        public void m_306156_() {
            try {
                this.close();
            }
            catch (IOException ioexception) {
                f_78191_.warn("Failed to unlock access to level {}", (Object)this.m_78277_(), (Object)ioexception);
            }
        }

        public LevelStorageSource m_295711_() {
            return LevelStorageSource.this;
        }

        public LevelDirectory m_306248_() {
            return this.f_230867_;
        }

        public String m_78277_() {
            return this.f_78272_;
        }

        public Path m_78283_(LevelResource p_78284_) {
            return this.f_78273_.computeIfAbsent(p_78284_, this.f_230867_::m_230854_);
        }

        public Path m_197394_(ResourceKey<Level> p_197395_) {
            return DimensionType.m_196975_(p_197395_, this.f_230867_.f_230850_());
        }

        private void m_78313_() {
            if (!this.f_78270_.m_13639_()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage m_78301_() {
            this.m_78313_();
            return new PlayerDataStorage(this, LevelStorageSource.this.f_78196_);
        }

        public LevelSummary m_78308_(Dynamic<?> p_310283_) {
            this.m_78313_();
            return LevelStorageSource.this.m_306201_(p_310283_, this.f_230867_, false);
        }

        public Dynamic<?> m_307464_() throws IOException {
            return this.m_246049_(false);
        }

        public Dynamic<?> m_305112_() throws IOException {
            return this.m_246049_(true);
        }

        public CompoundTag getDataTagRaw(boolean fallback) throws IOException {
            this.m_78313_();
            return LevelStorageSource.m_305304_(fallback ? this.f_230867_.m_230859_() : this.f_230867_.m_230858_());
        }

        private Dynamic<?> m_246049_(boolean p_310699_) throws IOException {
            this.m_78313_();
            return LevelStorageSource.m_306158_(p_310699_ ? this.f_230867_.m_230859_() : this.f_230867_.m_230858_(), LevelStorageSource.this.f_78196_);
        }

        public void m_78287_(RegistryAccess p_78288_, WorldData p_78289_) {
            this.m_78290_(p_78288_, p_78289_, null);
        }

        public void m_78290_(RegistryAccess p_78291_, WorldData p_78292_, @Nullable CompoundTag p_78293_) {
            CompoundTag compoundtag = p_78292_.m_6626_(p_78291_, p_78293_);
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.m_128365_(LevelStorageSource.f_202311_, compoundtag);
            ForgeHooks.writeAdditionalLevelSaveData((WorldData)p_78292_, (CompoundTag)compoundtag1);
            this.m_305059_(compoundtag1);
        }

        private void m_305059_(CompoundTag p_312575_) {
            Path path = this.f_230867_.f_230850_();
            try {
                Path path1 = Files.createTempFile(path, "level", ".dat", new FileAttribute[0]);
                NbtIo.m_128944_(p_312575_, path1);
                Path path2 = this.f_230867_.m_230859_();
                Path path3 = this.f_230867_.m_230858_();
                Util.m_137505_(path3, path1, path2);
            }
            catch (Exception exception) {
                f_78191_.error("Failed to save level {}", (Object)path, (Object)exception);
            }
        }

        public Optional<Path> m_182514_() {
            return !this.f_78270_.m_13639_() ? Optional.empty() : Optional.of(this.f_230867_.m_230860_());
        }

        public Path getWorldDir() {
            return LevelStorageSource.this.f_78194_;
        }

        public void m_78311_() throws IOException {
            this.m_78313_();
            final Path path = this.f_230867_.m_230861_();
            f_78191_.info("Deleting level {}", (Object)this.f_78272_);
            for (int i = 1; i <= 5; ++i) {
                f_78191_.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.f_230867_.f_230850_(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals(path)) {
                                f_78191_.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, @Nullable IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.f_230867_.f_230850_())) {
                                LevelStorageAccess.this.f_78270_.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i >= 5) {
                        throw ioexception;
                    }
                    f_78191_.warn("Failed to delete {}", (Object)this.f_230867_.f_230850_(), (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void m_78297_(String p_78298_) throws IOException {
            this.m_306294_(p_313219_ -> p_313219_.m_128359_("LevelName", p_78298_.trim()));
        }

        public void m_307222_(String p_309798_) throws IOException {
            this.m_306294_(p_312160_ -> {
                p_312160_.m_128359_("LevelName", p_309798_.trim());
                p_312160_.m_128473_("Player");
            });
        }

        private void m_306294_(Consumer<CompoundTag> p_310066_) throws IOException {
            this.m_78313_();
            CompoundTag compoundtag = LevelStorageSource.m_305304_(this.f_230867_.m_230858_());
            p_310066_.accept(compoundtag.m_128469_(LevelStorageSource.f_202311_));
            this.m_305059_(compoundtag);
        }

        public long m_78312_() throws IOException {
            this.m_78313_();
            String s = LocalDateTime.now().format(f_78192_) + "_" + this.f_78272_;
            Path path = LevelStorageSource.this.m_78262_();
            try {
                FileUtil.m_257659_(path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtil.m_133730_(path, s, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.f_78272_, new String[0]);
                Files.walkFileTree(this.f_230867_.f_230850_(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s1 = path2.resolve(LevelStorageAccess.this.f_230867_.f_230850_().relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s1);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        public boolean m_306456_() {
            return Files.exists(this.f_230867_.m_230858_(), new LinkOption[0]) || Files.exists(this.f_230867_.m_230859_(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.f_78270_.close();
        }

        public boolean m_305486_() {
            return Util.m_212224_(this.f_230867_.m_230858_(), this.f_230867_.m_230859_(), this.f_230867_.m_230856_(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant m_306206_(boolean p_311251_) {
            return LevelStorageSource.m_306357_(p_311251_ ? this.f_230867_.m_230859_() : this.f_230867_.m_230858_());
        }
    }
}

