/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class PlayerDataStorage {
    private static final Logger f_78426_ = LogUtils.getLogger();
    private final File f_78427_;
    protected final DataFixer f_78425_;

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess p_78430_, DataFixer p_78431_) {
        this.f_78425_ = p_78431_;
        this.f_78427_ = p_78430_.m_78283_(LevelResource.f_78176_).toFile();
        this.f_78427_.mkdirs();
    }

    public void m_78433_(Player p_78434_) {
        try {
            CompoundTag compoundtag = p_78434_.m_20240_(new CompoundTag());
            Path path = this.f_78427_.toPath();
            Path path1 = Files.createTempFile(path, p_78434_.m_20149_() + "-", ".dat", new FileAttribute[0]);
            NbtIo.m_128944_(compoundtag, path1);
            Path path2 = path.resolve(p_78434_.m_20149_() + ".dat");
            Path path3 = path.resolve(p_78434_.m_20149_() + ".dat_old");
            Util.m_137505_(path2, path1, path3);
            ForgeEventFactory.firePlayerSavingEvent((Player)p_78434_, (File)this.f_78427_, (String)p_78434_.m_20149_());
        }
        catch (Exception exception) {
            f_78426_.warn("Failed to save player data for {}", (Object)p_78434_.m_7755_().getString());
        }
    }

    @Nullable
    public CompoundTag m_78435_(Player p_78436_) {
        CompoundTag compoundtag = null;
        try {
            File file1 = new File(this.f_78427_, p_78436_.m_20149_() + ".dat");
            if (file1.exists() && file1.isFile()) {
                compoundtag = NbtIo.m_128939_(file1.toPath(), NbtAccounter.m_301669_());
            }
        }
        catch (Exception exception) {
            f_78426_.warn("Failed to load player data for {}", (Object)p_78436_.m_7755_().getString());
        }
        if (compoundtag != null) {
            int i = NbtUtils.m_264487_(compoundtag, -1);
            compoundtag = DataFixTypes.PLAYER.m_264218_(this.f_78425_, compoundtag, i);
            p_78436_.m_20258_(compoundtag);
        }
        ForgeEventFactory.firePlayerLoadingEvent((Player)p_78436_, (File)this.f_78427_, (String)p_78436_.m_20149_());
        return compoundtag;
    }

    public String[] m_78432_() {
        String[] astring = this.f_78427_.list();
        if (astring == null) {
            astring = new String[]{};
        }
        for (int i = 0; i < astring.length; ++i) {
            if (!astring[i].endsWith(".dat")) continue;
            astring[i] = astring[i].substring(0, astring[i].length() - 4);
        }
        return astring;
    }

    public File getPlayerDataFolder() {
        return this.f_78427_;
    }
}

