/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerScores;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class Scoreboard {
    public static final String f_303532_ = "#";
    private static final Logger f_199933_ = LogUtils.getLogger();
    private final Object2ObjectMap<String, Objective> f_83408_ = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Reference2ObjectMap<ObjectiveCriteria, List<Objective>> f_83409_ = new Reference2ObjectOpenHashMap();
    private final Map<String, PlayerScores> f_83410_ = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Map<DisplaySlot, Objective> f_83411_ = new EnumMap<DisplaySlot, Objective>(DisplaySlot.class);
    private final Object2ObjectMap<String, PlayerTeam> f_83412_ = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, PlayerTeam> f_83413_ = new Object2ObjectOpenHashMap();

    @Nullable
    public Objective m_83477_(@Nullable String p_83478_) {
        return (Objective)this.f_83408_.get((Object)p_83478_);
    }

    public Objective m_83436_(String p_83437_, ObjectiveCriteria p_83438_, Component p_83439_, ObjectiveCriteria.RenderType p_83440_, boolean p_311367_, @Nullable NumberFormat p_311959_) {
        if (this.f_83408_.containsKey((Object)p_83437_)) {
            throw new IllegalArgumentException("An objective with the name '" + p_83437_ + "' already exists!");
        }
        Objective $$6 = new Objective(this, p_83437_, p_83438_, p_83439_, p_83440_, p_311367_, p_311959_);
        ((List)this.f_83409_.computeIfAbsent((Object)p_83438_, p_310953_ -> Lists.newArrayList())).add($$6);
        this.f_83408_.put((Object)p_83437_, (Object)$$6);
        this.m_7092_($$6);
        return $$6;
    }

    public final void m_83427_(ObjectiveCriteria p_83428_, ScoreHolder p_310719_, Consumer<ScoreAccess> p_83430_) {
        ((List)this.f_83409_.getOrDefault((Object)p_83428_, Collections.emptyList())).forEach(p_309370_ -> p_83430_.accept(this.m_307672_(p_310719_, (Objective)p_309370_, true)));
    }

    private PlayerScores m_307682_(String p_311117_) {
        return this.f_83410_.computeIfAbsent(p_311117_, p_309376_ -> new PlayerScores());
    }

    public ScoreAccess m_83471_(ScoreHolder p_309688_, Objective p_83473_) {
        return this.m_307672_(p_309688_, p_83473_, false);
    }

    public ScoreAccess m_307672_(final ScoreHolder p_310827_, final Objective p_312875_, boolean p_310024_) {
        final boolean $$3 = p_310024_ || !p_312875_.m_83321_().m_83621_();
        PlayerScores $$4 = this.m_307682_(p_310827_.m_6302_());
        final MutableBoolean $$5 = new MutableBoolean();
        final Score $$6 = $$4.m_306863_(p_312875_, p_309375_ -> $$5.setTrue());
        return new ScoreAccess(){

            @Override
            public int m_306505_() {
                return $$6.m_305685_();
            }

            @Override
            public void m_305183_(int p_312858_) {
                Component $$2;
                if (!$$3) {
                    throw new IllegalStateException("Cannot modify read-only score");
                }
                boolean $$1 = $$5.isTrue();
                if (p_312875_.m_305930_() && ($$2 = p_310827_.m_5446_()) != null && !$$2.equals($$6.m_307077_())) {
                    $$6.m_306495_($$2);
                    $$1 = true;
                }
                if (p_312858_ != $$6.m_305685_()) {
                    $$6.m_307037_(p_312858_);
                    $$1 = true;
                }
                if ($$1) {
                    this.m_304734_();
                }
            }

            @Override
            @Nullable
            public Component m_305613_() {
                return $$6.m_307077_();
            }

            @Override
            public void m_306789_(@Nullable Component p_309551_) {
                if ($$5.isTrue() || !Objects.equals(p_309551_, $$6.m_307077_())) {
                    $$6.m_306495_(p_309551_);
                    this.m_304734_();
                }
            }

            @Override
            public void m_304839_(@Nullable NumberFormat p_312257_) {
                $$6.m_306820_(p_312257_);
                this.m_304734_();
            }

            @Override
            public boolean m_304717_() {
                return $$6.m_83407_();
            }

            @Override
            public void m_305539_() {
                this.m_305235_(false);
            }

            @Override
            public void m_305263_() {
                this.m_305235_(true);
            }

            private void m_305235_(boolean p_311228_) {
                $$6.m_83398_(p_311228_);
                if ($$5.isTrue()) {
                    this.m_304734_();
                }
                Scoreboard.this.m_304975_(p_310827_, p_312875_);
            }

            private void m_304734_() {
                Scoreboard.this.m_5734_(p_310827_, p_312875_, $$6);
                $$5.setFalse();
            }
        };
    }

    @Nullable
    public ReadOnlyScoreInfo m_305759_(ScoreHolder p_309394_, Objective p_310266_) {
        PlayerScores $$2 = this.f_83410_.get(p_309394_.m_6302_());
        if ($$2 != null) {
            return $$2.m_307163_(p_310266_);
        }
        return null;
    }

    public Collection<PlayerScoreEntry> m_306706_(Objective p_312530_) {
        ArrayList<PlayerScoreEntry> $$1 = new ArrayList<PlayerScoreEntry>();
        this.f_83410_.forEach((p_309362_, p_309363_) -> {
            Score $$4 = p_309363_.m_307163_(p_312530_);
            if ($$4 != null) {
                $$1.add(new PlayerScoreEntry((String)p_309362_, $$4.m_305685_(), $$4.m_307077_(), $$4.m_305750_()));
            }
        });
        return $$1;
    }

    public Collection<Objective> m_83466_() {
        return this.f_83408_.values();
    }

    public Collection<String> m_83474_() {
        return this.f_83408_.keySet();
    }

    public Collection<ScoreHolder> m_83482_() {
        return this.f_83410_.keySet().stream().map(ScoreHolder::m_306660_).toList();
    }

    public void m_307153_(ScoreHolder p_311535_) {
        PlayerScores $$1 = this.f_83410_.remove(p_311535_.m_6302_());
        if ($$1 != null) {
            this.m_7182_(p_311535_);
        }
    }

    public void m_305788_(ScoreHolder p_312886_, Objective p_311508_) {
        PlayerScores $$2 = this.f_83410_.get(p_312886_.m_6302_());
        if ($$2 != null) {
            boolean $$3 = $$2.m_305067_(p_311508_);
            if (!$$2.m_307156_()) {
                PlayerScores $$4 = this.f_83410_.remove(p_312886_.m_6302_());
                if ($$4 != null) {
                    this.m_7182_(p_312886_);
                }
            } else if ($$3) {
                this.m_5973_(p_312886_, p_311508_);
            }
        }
    }

    public Object2IntMap<Objective> m_307827_(ScoreHolder p_312742_) {
        PlayerScores $$1 = this.f_83410_.get(p_312742_.m_6302_());
        return $$1 != null ? $$1.m_306675_() : Object2IntMaps.emptyMap();
    }

    public void m_83502_(Objective p_83503_) {
        this.f_83408_.remove((Object)p_83503_.m_83320_());
        for (DisplaySlot $$1 : DisplaySlot.values()) {
            if (this.m_83416_($$1) != p_83503_) continue;
            this.m_7136_($$1, null);
        }
        List $$2 = (List)this.f_83409_.get((Object)p_83503_.m_83321_());
        if ($$2 != null) {
            $$2.remove(p_83503_);
        }
        for (PlayerScores $$3 : this.f_83410_.values()) {
            $$3.m_305067_(p_83503_);
        }
        this.m_7093_(p_83503_);
    }

    public void m_7136_(DisplaySlot p_297926_, @Nullable Objective p_83419_) {
        this.f_83411_.put(p_297926_, p_83419_);
    }

    @Nullable
    public Objective m_83416_(DisplaySlot p_297931_) {
        return this.f_83411_.get(p_297931_);
    }

    @Nullable
    public PlayerTeam m_83489_(String p_83490_) {
        return (PlayerTeam)this.f_83412_.get((Object)p_83490_);
    }

    public PlayerTeam m_83492_(String p_83493_) {
        PlayerTeam $$1 = this.m_83489_(p_83493_);
        if ($$1 != null) {
            f_199933_.warn("Requested creation of existing team '{}'", (Object)p_83493_);
            return $$1;
        }
        $$1 = new PlayerTeam(this, p_83493_);
        this.f_83412_.put((Object)p_83493_, (Object)$$1);
        this.m_7650_($$1);
        return $$1;
    }

    public void m_83475_(PlayerTeam p_83476_) {
        this.f_83412_.remove((Object)p_83476_.m_5758_());
        for (String $$1 : p_83476_.m_6809_()) {
            this.f_83413_.remove((Object)$$1);
        }
        this.m_7644_(p_83476_);
    }

    public boolean m_6546_(String p_83434_, PlayerTeam p_83435_) {
        if (this.m_83500_(p_83434_) != null) {
            this.m_83495_(p_83434_);
        }
        this.f_83413_.put((Object)p_83434_, (Object)p_83435_);
        return p_83435_.m_6809_().add(p_83434_);
    }

    public boolean m_83495_(String p_83496_) {
        PlayerTeam $$1 = this.m_83500_(p_83496_);
        if ($$1 != null) {
            this.m_6519_(p_83496_, $$1);
            return true;
        }
        return false;
    }

    public void m_6519_(String p_83464_, PlayerTeam p_83465_) {
        if (this.m_83500_(p_83464_) != p_83465_) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + p_83465_.m_5758_() + "'.");
        }
        this.f_83413_.remove((Object)p_83464_);
        p_83465_.m_6809_().remove(p_83464_);
    }

    public Collection<String> m_83488_() {
        return this.f_83412_.keySet();
    }

    public Collection<PlayerTeam> m_83491_() {
        return this.f_83412_.values();
    }

    @Nullable
    public PlayerTeam m_83500_(String p_83501_) {
        return (PlayerTeam)this.f_83413_.get((Object)p_83501_);
    }

    public void m_7092_(Objective p_83422_) {
    }

    public void m_7091_(Objective p_83455_) {
    }

    public void m_7093_(Objective p_83467_) {
    }

    protected void m_5734_(ScoreHolder p_312923_, Objective p_311972_, Score p_83424_) {
    }

    protected void m_304975_(ScoreHolder p_311114_, Objective p_309936_) {
    }

    public void m_7182_(ScoreHolder p_312272_) {
    }

    public void m_5973_(ScoreHolder p_311030_, Objective p_83433_) {
    }

    public void m_7650_(PlayerTeam p_83423_) {
    }

    public void m_7645_(PlayerTeam p_83456_) {
    }

    public void m_7644_(PlayerTeam p_83468_) {
    }

    public void m_83420_(Entity p_83421_) {
        if (p_83421_ instanceof Player || p_83421_.m_6084_()) {
            return;
        }
        this.m_307153_(p_83421_);
        this.m_83495_(p_83421_.m_6302_());
    }

    protected ListTag m_83497_() {
        ListTag $$0 = new ListTag();
        this.f_83410_.forEach((p_309372_, p_309373_) -> p_309373_.m_307678_().forEach((p_309366_, p_309367_) -> {
            CompoundTag $$4 = p_309367_.m_305101_();
            $$4.m_128359_("Name", (String)p_309372_);
            $$4.m_128359_("Objective", p_309366_.m_83320_());
            $$0.add($$4);
        }));
        return $$0;
    }

    protected void m_83445_(ListTag p_83446_) {
        for (int $$1 = 0; $$1 < p_83446_.size(); ++$$1) {
            CompoundTag $$2 = p_83446_.m_128728_($$1);
            Score $$3 = Score.m_306631_($$2);
            String $$4 = $$2.m_128461_("Name");
            String $$5 = $$2.m_128461_("Objective");
            Objective $$6 = this.m_83477_($$5);
            if ($$6 == null) {
                f_199933_.error("Unknown objective {} for name {}, ignoring", (Object)$$5, (Object)$$4);
                continue;
            }
            this.m_307682_($$4).m_305165_($$6, $$3);
        }
    }
}

