/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import com.google.common.base.Function;
import io.izzel.arclight.common.bridge.core.util.DamageSourceBridge;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.common.mod.util.DistValidate;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftMagicNumbers;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Item;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftEventFactory.class}, remap=false)
public abstract class CraftEventFactoryMixin {
    @Shadow
    private static EntityDamageEvent callEntityDamageEvent(Entity damager, Entity damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        return null;
    }

    @ModifyVariable(method={"handleEntityDamageEvent*"}, at=@At(value="HEAD"), index=1, argsOnly=true)
    private static net.minecraft.world.damagesource.DamageSource arclight$captureSource(net.minecraft.world.damagesource.DamageSource source, Entity entity) {
        Entity damageEventEntity = ArclightCaptures.getDamageEventEntity();
        BlockPos damageEventBlock = ArclightCaptures.getDamageEventBlock();
        if (damageEventEntity != null && ((DamageSourceBridge)source).bridge$getCausingEntity() == null && source.m_276093_(DamageTypes.f_268450_)) {
            source = ((DamageSourceBridge)source).bridge$customCausingEntity(damageEventEntity);
        }
        if (damageEventBlock != null && ((DamageSourceBridge)source).bridge$directBlock() == null && (source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268469_) || source.m_276093_(DamageTypes.f_268434_))) {
            source = ((DamageSourceBridge)source).bridge$directBlock(CraftBlock.at((LevelAccessor)entity.m_20193_(), damageEventBlock));
        }
        return source;
    }

    @Inject(method={"handleEntityDamageEvent*"}, cancellable=true, at={@At(value="NEW", target="java/lang/IllegalStateException")})
    private static void arclight$unhandledDamage(Entity entity, net.minecraft.world.damagesource.DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> modifierFunctions, boolean cancelled, CallbackInfoReturnable<EntityDamageEvent> cir) {
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(source);
        EntityDamageEvent event = CraftEventFactoryMixin.callEntityDamageEvent(((DamageSourceBridge)source).bridge$getCausingEntity(), entity, EntityDamageEvent.DamageCause.CUSTOM, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        cir.setReturnValue((Object)event);
    }

    @Overwrite
    public static boolean handleBlockSpreadEvent(LevelAccessor world, BlockPos source, BlockPos target, BlockState block, int flag) {
        if (!(world instanceof Level) || !DistValidate.isValid(world)) {
            world.m_7731_(target, block, flag);
            return true;
        }
        CraftBlockState state = CraftBlockStates.getBlockState(world, target, flag);
        state.setData(block);
        BlockSpreadEvent event = new BlockSpreadEvent(state.getBlock(), CraftBlock.at(world, source), state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    @Overwrite
    public static boolean handleBlockGrowEvent(Level world, BlockPos pos, BlockState newData, int flag) {
        if (!DistValidate.isValid((LevelAccessor)world)) {
            world.m_7731_(pos, newData, flag);
            return true;
        }
        Block block = world.bridge$getWorld().getBlockAt(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setData(newData);
        BlockGrowEvent event = new BlockGrowEvent(block, state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    @Overwrite
    public static boolean handleBlockFormEvent(Level world, BlockPos pos, BlockState block, int flag, @Nullable Entity entity) {
        if (!DistValidate.isValid((LevelAccessor)world)) {
            world.m_7731_(pos, block, flag);
            return true;
        }
        CraftBlockState blockState = CraftBlockStates.getBlockState((LevelAccessor)world, pos, flag);
        blockState.setData(block);
        BlockFormEvent event = entity == null ? new BlockFormEvent(blockState.getBlock(), blockState) : new EntityBlockFormEvent(entity.bridge$getBukkitEntity(), blockState.getBlock(), blockState);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            blockState.update(true);
        }
        return !event.isCancelled();
    }

    @Overwrite
    public static BlockFadeEvent callBlockFadeEvent(LevelAccessor world, BlockPos pos, BlockState newBlock) {
        if (!(world instanceof Level) || !DistValidate.isValid(world)) {
            return new BlockFadeEvent(CraftBlock.at(world, pos), CraftBlockStates.getBlockState(CraftMagicNumbers.getMaterial(newBlock.m_60734_()), null));
        }
        CraftBlockState state = CraftBlockStates.getBlockState(world, pos);
        state.setData(newBlock);
        BlockFadeEvent event = new BlockFadeEvent(state.getBlock(), state);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    @Overwrite
    public static BlockPhysicsEvent callBlockPhysicsEvent(LevelAccessor world, BlockPos blockposition) {
        CraftBlock block = CraftBlock.at(world, blockposition);
        BlockPhysicsEvent event = new BlockPhysicsEvent(block, block.getBlockData());
        if (world instanceof Level && DistValidate.isValid(world)) {
            Bukkit.getPluginManager().callEvent(event);
        }
        return event;
    }

    @Overwrite
    public static boolean callEntityChangeBlockEvent(Entity entity, BlockPos position, BlockState newBlock, boolean cancelled) {
        CraftBlock block = CraftBlock.at((LevelAccessor)entity.m_9236_(), position);
        EntityChangeBlockEvent event = new EntityChangeBlockEvent(entity.bridge$getBukkitEntity(), block, CraftBlockData.fromData(newBlock));
        event.setCancelled(cancelled);
        if (DistValidate.isValid((LevelAccessor)entity.m_9236_())) {
            Bukkit.getPluginManager().callEvent(event);
        }
        return !event.isCancelled();
    }

    @Overwrite
    public static BlockRedstoneEvent callRedstoneChange(Level world, BlockPos pos, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent(CraftBlock.at((LevelAccessor)world, pos), oldCurrent, newCurrent);
        if (DistValidate.isValid((LevelAccessor)world)) {
            Bukkit.getPluginManager().callEvent(event);
        }
        return event;
    }

    @Overwrite
    public static NotePlayEvent callNotePlayEvent(Level world, BlockPos pos, NoteBlockInstrument instrument, int note) {
        NotePlayEvent event = new NotePlayEvent(CraftBlock.at((LevelAccessor)world, pos), Instrument.getByType((byte)instrument.ordinal()), new Note(note));
        if (DistValidate.isValid((LevelAccessor)world)) {
            Bukkit.getPluginManager().callEvent(event);
        }
        return event;
    }

    @Inject(method={"callItemSpawnEvent"}, cancellable=true, at={@At(value="HEAD")})
    private static void arclight$noAirDrops(ItemEntity itemEntity, CallbackInfoReturnable<ItemSpawnEvent> cir) {
        if (itemEntity.m_32055_().m_41619_()) {
            Item entity = (Item)((Object)itemEntity.bridge$getBukkitEntity());
            ItemSpawnEvent event = new ItemSpawnEvent(entity);
            event.setCancelled(true);
            cir.setReturnValue((Object)event);
        }
    }
}

