/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import io.izzel.arclight.common.bridge.bukkit.CraftServerBridge;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.command.CraftCommandMap;
import org.bukkit.craftbukkit.v1_20_R3.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_20_R3.scheduler.CraftScheduler;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.scheduler.BukkitWorker;
import org.spigotmc.SpigotConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftServer.class}, remap=false)
public abstract class CraftServerMixin
implements CraftServerBridge {
    @Shadow
    @Final
    private CraftCommandMap commandMap;
    @Shadow
    @Final
    private SimplePluginManager pluginManager;
    @Shadow
    @Final
    private SimpleHelpMap helpMap;
    @Shadow
    @Final
    protected DedicatedServer console;
    @Shadow
    @Final
    @Mutable
    private String serverName;
    @Shadow
    @Final
    @Mutable
    protected DedicatedPlayerList playerList;
    @Shadow
    @Final
    private Map<String, World> worlds;
    @Shadow
    public int reloadCount;
    @Shadow
    private YamlConfiguration configuration;
    @Shadow
    private YamlConfiguration commandsConfiguration;
    @Shadow
    @Final
    private Logger logger;
    @Shadow
    private boolean overrideAllCommandBlockCommands;
    @Shadow
    public boolean ignoreVanillaPermissions;
    @Shadow
    @Final
    private String serverVersion;

    @Shadow
    protected abstract void enablePlugin(Plugin var1);

    @Shadow
    protected abstract void loadCustomPermissions();

    @Shadow
    protected abstract File getConfigFile();

    @Shadow
    protected abstract File getCommandsConfigFile();

    @Shadow
    public abstract void reloadData();

    @Shadow
    public abstract CraftScheduler getScheduler();

    @Shadow
    public abstract Logger getLogger();

    @Shadow
    public abstract void loadPlugins();

    @Shadow
    public abstract void enablePlugins(PluginLoadOrder var1);

    @Shadow
    public abstract PluginManager getPluginManager();

    @Accessor(value="logger")
    @Mutable
    public abstract void setLogger(Logger var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$setBrand(DedicatedServer console, PlayerList playerList, CallbackInfo ci) {
        this.serverName = "Arclight";
    }

    @Overwrite(remap=false)
    public String getName() {
        return "Arclight";
    }

    @Overwrite
    public String getVersion() {
        return System.getProperty("arclight.version") + " (MC: " + this.console.m_129786_() + ")";
    }

    @Override
    public void bridge$setPlayerList(PlayerList playerList) {
        this.playerList = (DedicatedPlayerList)playerList;
    }

    @Overwrite(remap=false)
    public ConsoleReader getReader() {
        return null;
    }

    @Inject(method={"dispatchCommand"}, remap=false, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lorg/spigotmc/AsyncCatcher;catchOp(Ljava/lang/String;)V")})
    private void arclight$returnIfFail(CommandSender sender, String commandLine, CallbackInfoReturnable<Boolean> cir) {
        if (commandLine == null) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public void bridge$removeWorld(ServerLevel world) {
        if (world == null) {
            return;
        }
        this.worlds.remove(world.bridge$getWorld().getName().toLowerCase(Locale.ROOT));
    }

    @Overwrite(remap=false)
    public void reload() {
        ++this.reloadCount;
        this.configuration = YamlConfiguration.loadConfiguration(this.getConfigFile());
        this.commandsConfiguration = YamlConfiguration.loadConfiguration(this.getCommandsConfigFile());
        try {
            this.playerList.m_11299_().m_11399_();
        }
        catch (IOException var12) {
            this.logger.log(Level.WARNING, "Failed to load banned-ips.json, " + var12.getMessage());
        }
        try {
            this.playerList.m_11295_().m_11399_();
        }
        catch (IOException var11) {
            this.logger.log(Level.WARNING, "Failed to load banned-players.json, " + var11.getMessage());
        }
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        this.reloadData();
        SpigotConfig.registerCommands();
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            this.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), "This plugin is not properly shutting down its async tasks when it is being reloaded.  This may cause conflicts with the newly loaded version of the plugin"));
        }
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.getPluginManager().callEvent(new ServerLoadEvent(ServerLoadEvent.LoadType.RELOAD));
    }
}

