/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.network;

import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.network.common.ServerCommonPacketListenerBridge;
import io.izzel.arclight.common.bridge.core.server.MinecraftServerBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import net.minecraft.ChatFormatting;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.StringUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R3.util.Waitable;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerCommonPacketListenerImpl.class})
public abstract class ServerCommonPacketListenerImplMixin
implements ServerCommonPacketListenerBridge {
    @Shadow
    @Final
    protected Connection f_291338_;
    @Shadow
    @Final
    protected MinecraftServer f_291389_;
    @Shadow
    @Final
    private static Logger f_291096_;
    protected ServerPlayer player;
    protected CraftServer cserver;
    public boolean processedDisconnect;
    private static final ResourceLocation CUSTOM_REGISTER;
    private static final ResourceLocation CUSTOM_UNREGISTER;

    @Shadow
    public abstract void m_7026_(Component var1);

    @Shadow
    public abstract void m_141995_(Packet<?> var1);

    @Shadow
    protected abstract boolean m_293330_();

    public CraftPlayer getCraftPlayer() {
        return this.player == null ? null : ((ServerPlayerEntityBridge)this.player).bridge$getBukkitEntity();
    }

    @Override
    public CraftServer bridge$getCraftServer() {
        return this.cserver;
    }

    @Override
    public CraftPlayer bridge$getCraftPlayer() {
        return this.getCraftPlayer();
    }

    @Override
    public ServerPlayer bridge$getPlayer() {
        return this.player;
    }

    @Override
    public void bridge$setPlayer(ServerPlayer player) {
        this.player = player;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(MinecraftServer p_299469_, Connection p_300872_, CommonListenerCookie p_300277_, CallbackInfo ci) {
        this.cserver = (CraftServer)Bukkit.getServer();
    }

    @ModifyConstant(method={"keepConnectionAlive"}, constant={@Constant(longValue=15000L)})
    private long arclight$incrKeepaliveTimeout(long l) {
        return 25000L;
    }

    @Override
    public boolean bridge$processedDisconnect() {
        return this.processedDisconnect;
    }

    public final boolean isDisconnected() {
        return !((ServerPlayerEntityBridge)this.player).bridge$isJoining() && !this.f_291338_.m_129536_();
    }

    @Override
    public boolean bridge$isDisconnected() {
        return this.isDisconnected();
    }

    @Overwrite
    public void m_294716_(Component textComponent) {
        this.bridge$disconnect(CraftChatMessage.fromComponent(textComponent));
    }

    public void disconnect(String s) {
        this.bridge$disconnect(s);
    }

    @Override
    public void bridge$disconnect(final String s) {
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable<Object> waitable = new Waitable<Object>(){

                @Override
                protected Object evaluate() {
                    ServerCommonPacketListenerImplMixin.this.bridge$disconnect(s);
                    return null;
                }
            };
            ((MinecraftServerBridge)this.f_291389_).bridge$queuedProcess(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        String leaveMessage = ChatFormatting.YELLOW + this.player.m_6302_() + " left the game.";
        PlayerKickEvent event = new PlayerKickEvent(this.getCraftPlayer(), s, leaveMessage);
        if (this.cserver.getServer().m_130010_()) {
            this.cserver.getPluginManager().callEvent(event);
        }
        if (event.isCancelled()) {
            return;
        }
        ArclightCaptures.captureQuitMessage(event.getLeaveMessage());
        Component textComponent = CraftChatMessage.fromString(event.getReason(), true)[0];
        this.f_291338_.m_243124_((Packet)new ClientboundDisconnectPacket(textComponent), PacketSendListener.m_243092_(() -> this.f_291338_.m_129507_(textComponent)));
        this.m_7026_(textComponent);
        this.f_291338_.m_129540_();
        this.f_291389_.m_18709_(() -> ((Connection)this.f_291338_).m_129541_());
    }

    @Inject(method={"onDisconnect"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$returnIfProcessed(Component reason, CallbackInfo ci) {
        if (this.processedDisconnect) {
            ci.cancel();
        } else {
            this.processedDisconnect = true;
        }
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$updateCompassTarget(Packet<?> packetIn, PacketSendListener futureListeners, CallbackInfo ci) {
        if (packetIn == null || this.processedDisconnect) {
            ci.cancel();
            return;
        }
        if (packetIn instanceof ClientboundSetDefaultSpawnPositionPacket) {
            ClientboundSetDefaultSpawnPositionPacket packet6 = (ClientboundSetDefaultSpawnPositionPacket)packetIn;
            ((ServerPlayerEntityBridge)this.player).bridge$setCompassTarget(new Location(this.getCraftPlayer().getWorld(), packet6.f_133111_.m_123341_(), packet6.f_133111_.m_123342_(), packet6.f_133111_.m_123343_()));
        }
    }

    @Inject(method={"handleResourcePackResponse"}, at={@At(value="RETURN")})
    private void arclight$handleResourcePackStatus(ServerboundResourcePackPacket packetIn, CallbackInfo ci) {
        this.cserver.getPluginManager().callEvent(new PlayerResourcePackStatusEvent(this.getCraftPlayer(), packetIn.f_302393_(), PlayerResourcePackStatusEvent.Status.values()[packetIn.f_290447_().ordinal()]));
    }

    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")})
    private void arclight$customPayload(ServerboundCustomPayloadPacket packet, CallbackInfo ci) {
        FriendlyByteBuf data = this.bridge$getDiscardedData(packet);
        if (data != null) {
            int readerIndex = data.readerIndex();
            byte[] buf = new byte[data.readableBytes()];
            data.readBytes(buf);
            data.readerIndex(readerIndex);
            ArclightServer.getMinecraftServer().m_201446_(() -> {
                if (((MinecraftServerBridge)ArclightServer.getMinecraftServer()).bridge$hasStopped() || this.bridge$processedDisconnect()) {
                    return;
                }
                if (this.f_291338_.m_129536_()) {
                    if (packet.f_291328_().m_292644_().equals((Object)CUSTOM_REGISTER)) {
                        try {
                            String channels = new String(buf, StandardCharsets.UTF_8);
                            for (String channel : channels.split("\u0000")) {
                                if (StringUtil.m_14408_((String)channel)) continue;
                                this.bridge$getCraftPlayer().addChannel(channel);
                            }
                        }
                        catch (Exception ex) {
                            f_291096_.error("Couldn't register custom payload", (Throwable)ex);
                            this.bridge$disconnect("Invalid payload REGISTER!");
                        }
                    } else if (packet.f_291328_().m_292644_().equals((Object)CUSTOM_UNREGISTER)) {
                        try {
                            String channels = new String(buf, StandardCharsets.UTF_8);
                            for (String channel : channels.split("\u0000")) {
                                if (StringUtil.m_14408_((String)channel)) continue;
                                this.bridge$getCraftPlayer().removeChannel(channel);
                            }
                        }
                        catch (Exception ex) {
                            f_291096_.error("Couldn't unregister custom payload", (Throwable)ex);
                            this.bridge$disconnect("Invalid payload UNREGISTER!");
                        }
                    } else {
                        try {
                            this.bridge$getCraftServer().getMessenger().dispatchIncomingMessage(((ServerPlayerEntityBridge)this.bridge$getPlayer()).bridge$getBukkitEntity(), packet.f_291328_().m_292644_().toString(), buf);
                        }
                        catch (Exception ex) {
                            f_291096_.error("Couldn't dispatch custom payload", (Throwable)ex);
                            this.bridge$disconnect("Invalid custom payload!");
                        }
                    }
                }
            });
        }
    }

    static {
        CUSTOM_REGISTER = new ResourceLocation("register");
        CUSTOM_UNREGISTER = new ResourceLocation("unregister");
    }
}

