/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.network;

import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UndashedUuid;
import io.izzel.arclight.common.bridge.core.network.NetworkManagerBridge;
import io.izzel.arclight.common.bridge.core.network.handshake.ServerHandshakeNetHandlerBridge;
import io.izzel.arclight.common.mod.util.VelocitySupport;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerHandshakePacketListenerImpl;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import org.apache.logging.log4j.LogManager;
import org.bukkit.Bukkit;
import org.spigotmc.SpigotConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ServerHandshakePacketListenerImpl.class})
public abstract class ServerHandshakeNetHandlerMixin
implements ServerHandshakeNetHandlerBridge {
    private static final Gson gson = new Gson();
    private static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    @Shadow
    @Final
    private Connection f_9966_;
    @Shadow
    @Final
    private MinecraftServer f_9965_;
    @Shadow
    @Final
    private static Component f_9964_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void m_7322_(ClientIntentionPacket packetIn) {
        if (!this.bridge$forge$handleSpecialLogin(packetIn)) {
            return;
        }
        ((NetworkManagerBridge)this.f_9966_).bridge$setHostname(packetIn.f_134721_() + ":" + packetIn.f_134722_());
        switch (packetIn.f_134723_()) {
            case LOGIN: {
                this.f_9966_.m_294993_(ClientIntent.LOGIN);
                try {
                    long currentTime = System.currentTimeMillis();
                    long connectionThrottle = Bukkit.getServer().getConnectionThrottle();
                    InetAddress address = ((InetSocketAddress)this.f_9966_.m_129523_()).getAddress();
                    HashMap<InetAddress, Long> hashMap = throttleTracker;
                    synchronized (hashMap) {
                        if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                            throttleTracker.put(address, currentTime);
                            MutableComponent component = Component.m_237113_((String)"Connection throttled! Please wait before reconnecting.");
                            this.f_9966_.m_129512_((Packet)new ClientboundLoginDisconnectPacket((Component)component));
                            this.f_9966_.m_129507_((Component)component);
                            return;
                        }
                        throttleTracker.put(address, currentTime);
                        if (++throttleCounter > 200) {
                            throttleCounter = 0;
                            throttleTracker.entrySet().removeIf(entry -> (Long)entry.getValue() > connectionThrottle);
                        }
                    }
                }
                catch (Throwable t) {
                    LogManager.getLogger().debug("Failed to check connection throttle", t);
                }
                if (packetIn.f_134720_() > SharedConstants.m_183709_().m_132495_()) {
                    MutableComponent component = Component.m_237115_((String)MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), SharedConstants.m_183709_().m_132493_()));
                    this.f_9966_.m_129512_((Packet)new ClientboundLoginDisconnectPacket((Component)component));
                    this.f_9966_.m_129507_((Component)component);
                    break;
                }
                if (packetIn.f_134720_() < SharedConstants.m_183709_().m_132495_()) {
                    MutableComponent component = Component.m_237115_((String)MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), SharedConstants.m_183709_().m_132493_()));
                    this.f_9966_.m_129512_((Packet)new ClientboundLoginDisconnectPacket((Component)component));
                    this.f_9966_.m_129507_((Component)component);
                    break;
                }
                this.f_9966_.m_129505_((PacketListener)new ServerLoginPacketListenerImpl(this.f_9965_, this.f_9966_));
                if (VelocitySupport.isEnabled()) break;
                String[] split = packetIn.f_134721_().split("\u0000");
                if (SpigotConfig.bungee) {
                    if (split.length != 3 && split.length != 4 || !HOST_PATTERN.matcher(split[1]).matches()) {
                        MutableComponent component = Component.m_237113_((String)"If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                        this.f_9966_.m_129512_((Packet)new ClientboundLoginDisconnectPacket((Component)component));
                        this.f_9966_.m_129507_((Component)component);
                        return;
                    }
                    ((NetworkManagerBridge)this.f_9966_).bridge$setHostname(split[0]);
                    this.f_9966_.f_129469_ = new InetSocketAddress(split[1], ((InetSocketAddress)this.f_9966_.m_129523_()).getPort());
                    ((NetworkManagerBridge)this.f_9966_).bridge$setSpoofedUUID(UndashedUuid.fromStringLenient((String)split[2]));
                    if (split.length != 4) break;
                    ((NetworkManagerBridge)this.f_9966_).bridge$setSpoofedProfile((Property[])gson.fromJson(split[3], Property[].class));
                    break;
                }
                if (split.length != 3 && split.length != 4 || !HOST_PATTERN.matcher(split[1]).matches()) break;
                MutableComponent component = Component.m_237113_((String)"Unknown data in login hostname, did you forget to enable BungeeCord in spigot.yml?");
                this.f_9966_.m_129512_((Packet)new ClientboundLoginDisconnectPacket((Component)component));
                this.f_9966_.m_129507_((Component)component);
                return;
            }
            case STATUS: {
                ServerStatus serverstatus = this.f_9965_.m_129928_();
                if (this.f_9965_.m_6373_() && serverstatus != null) {
                    this.f_9966_.m_294993_(ClientIntent.STATUS);
                    this.f_9966_.m_129505_((PacketListener)new ServerStatusPacketListenerImpl(serverstatus, this.f_9966_));
                    break;
                }
                this.f_9966_.m_129507_(f_9964_);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + packetIn.f_134723_());
            }
        }
    }
}

