/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import io.izzel.arclight.common.bridge.core.network.NetworkManagerBridge;
import io.izzel.arclight.common.bridge.core.network.common.ServerCommonPacketListenerBridge;
import io.izzel.arclight.common.bridge.core.network.login.ServerLoginNetHandlerBridge;
import io.izzel.arclight.common.bridge.core.server.MinecraftServerBridge;
import io.izzel.arclight.common.bridge.core.server.management.PlayerListBridge;
import io.izzel.arclight.common.mod.util.VelocitySupport;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ClientboundHelloPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.util.Waitable;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerLoginPacketListenerImpl.class})
public abstract class ServerLoginNetHandlerMixin
implements ServerLoginNetHandlerBridge {
    @Shadow
    private ServerLoginPacketListenerImpl.State f_10019_;
    @Shadow
    @Final
    private MinecraftServer f_10018_;
    @Shadow
    @Final
    public Connection f_10013_;
    @Shadow
    @Final
    private static AtomicInteger f_10014_;
    @Shadow
    @Final
    private static Logger f_10015_;
    @Shadow
    @Final
    private byte[] f_252396_;
    @Shadow
    @Nullable
    private String f_291165_;
    @Shadow
    @Nullable
    private GameProfile f_291112_;
    private static final Pattern PROP_PATTERN;
    private ServerPlayer player;
    @Unique
    protected int arclight$velocityLoginId = -1;

    @Shadow
    public abstract void m_10053_(Component var1);

    @Shadow
    public abstract String m_10056_();

    @Shadow
    abstract void m_294008_(GameProfile var1);

    @Shadow
    protected abstract boolean m_294137_(GameProfile var1);

    @Override
    public int bridge$getVelocityLoginId() {
        return this.arclight$velocityLoginId;
    }

    @Override
    public void bridge$disconnect(String s) {
        this.m_10053_((Component)Component.m_237113_((String)s));
    }

    public void disconnect(String s) {
        this.bridge$disconnect(s);
    }

    @Overwrite
    public void m_5990_(ServerboundHelloPacket packetIn) {
        Validate.validState((this.f_10019_ == ServerLoginPacketListenerImpl.State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)Player.m_305596_((String)packetIn.f_238040_()), (String)"Invalid characters in username", (Object[])new Object[0]);
        this.f_291165_ = packetIn.f_238040_();
        GameProfile gameprofile = this.f_10018_.m_236731_();
        if (gameprofile != null && this.f_291165_.equalsIgnoreCase(gameprofile.getName())) {
            this.m_294008_(gameprofile);
        } else if (this.f_10018_.m_129797_() && !this.f_10013_.m_129531_()) {
            this.f_10019_ = ServerLoginPacketListenerImpl.State.KEY;
            this.f_10013_.m_129512_((Packet)new ClientboundHelloPacket("", this.f_10018_.m_129790_().getPublic().getEncoded(), this.f_252396_));
        } else {
            if (VelocitySupport.isEnabled()) {
                this.arclight$velocityLoginId = ThreadLocalRandom.current().nextInt();
                ClientboundCustomQueryPacket packet = new ClientboundCustomQueryPacket(this.arclight$velocityLoginId, VelocitySupport.createPacket());
                this.f_10013_.m_129512_((Packet)packet);
                return;
            }
            Thread thread = this.bridge$newHandleThread("User Authenticator #" + f_10014_.incrementAndGet(), () -> {
                try {
                    GameProfile gameProfile = ServerLoginNetHandlerMixin.arclight$createOfflineProfile(this.f_10013_, this.f_291165_);
                    this.bridge$preLogin(gameProfile);
                }
                catch (Exception ex) {
                    this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.unverified_username"));
                    f_10015_.warn("Exception verifying {} ", (Object)this.f_291165_, (Object)ex);
                }
            });
            thread.start();
        }
    }

    private static GameProfile arclight$createOfflineProfile(Connection connection, String name) {
        UUID uuid = ((NetworkManagerBridge)connection).bridge$getSpoofedUUID() != null ? ((NetworkManagerBridge)connection).bridge$getSpoofedUUID() : UUIDUtil.m_235879_((String)name);
        GameProfile gameProfile = new GameProfile(uuid, name);
        if (((NetworkManagerBridge)connection).bridge$getSpoofedProfile() != null) {
            for (Property property : ((NetworkManagerBridge)connection).bridge$getSpoofedProfile()) {
                if (!PROP_PATTERN.matcher(property.name()).matches()) continue;
                gameProfile.getProperties().put((Object)property.name(), (Object)property);
            }
        }
        return gameProfile;
    }

    @Redirect(method={"verifyLoginAndFinishConnectionSetup"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"))
    private Component arclight$canLogin(PlayerList instance, SocketAddress socketAddress, GameProfile gameProfile) {
        this.player = ((PlayerListBridge)instance).bridge$canPlayerLogin(socketAddress, gameProfile, (ServerLoginPacketListenerImpl)this);
        return null;
    }

    @Inject(method={"verifyLoginAndFinishConnectionSetup"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;")})
    private void arclight$returnIfFail(GameProfile p_299507_, CallbackInfo ci) {
        if (this.player == null) {
            ci.cancel();
        }
    }

    @Redirect(method={"verifyLoginAndFinishConnectionSetup"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;disconnectAllPlayersWithProfile(Lcom/mojang/authlib/GameProfile;)Z"))
    private boolean arclight$skipKick(PlayerList instance, GameProfile gameProfile) {
        return this.m_294137_(Objects.requireNonNull(this.f_291112_));
    }

    @Inject(method={"handleLoginAcknowledgement"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/network/Connection;setListener(Lnet/minecraft/network/PacketListener;)V")})
    private void arclight$setPlayer(ServerboundLoginAcknowledgedPacket p_298815_, CallbackInfo ci, CommonListenerCookie cookie, ServerConfigurationPacketListenerImpl listener) {
        ((ServerCommonPacketListenerBridge)listener).bridge$setPlayer(this.player);
    }

    @Overwrite
    public void m_8072_(ServerboundKeyPacket packetIn) {
        String s;
        Validate.validState((this.f_10019_ == ServerLoginPacketListenerImpl.State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.f_10018_.m_129790_().getPrivate();
            if (!packetIn.m_253194_(this.f_252396_, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretKey = packetIn.m_134859_(privatekey);
            Cipher cipher = Crypt.m_13583_((int)2, (Key)secretKey);
            Cipher cipher1 = Crypt.m_13583_((int)1, (Key)secretKey);
            s = new BigInteger(Crypt.m_13590_((String)"", (PublicKey)this.f_10018_.m_129790_().getPublic(), (SecretKey)secretKey)).toString(16);
            this.f_10019_ = ServerLoginPacketListenerImpl.State.AUTHENTICATING;
            this.f_10013_.m_129495_(cipher, cipher1);
        }
        catch (CryptException cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        Thread thread = this.bridge$newHandleThread("User Authenticator #" + f_10014_.incrementAndGet(), () -> {
            String name = Objects.requireNonNull(this.f_291165_, "Player name not initialized");
            try {
                SocketAddress socketaddress = this.f_10013_.m_129523_();
                InetAddress address = this.f_10018_.m_129798_() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
                ProfileResult profileResult = this.f_10018_.m_129925_().hasJoinedServer(name, s, address);
                if (profileResult != null) {
                    GameProfile gameProfile = profileResult.profile();
                    if (!this.f_10013_.m_129536_()) {
                        return;
                    }
                    this.bridge$preLogin(gameProfile);
                } else if (this.f_10018_.m_129792_()) {
                    f_10015_.warn("Failed to verify username but will let them in anyway!");
                    this.m_294008_(ServerLoginNetHandlerMixin.arclight$createOfflineProfile(this.f_10013_, name));
                } else {
                    this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.unverified_username"));
                    f_10015_.error("Username '{}' tried to join with an invalid session", (Object)name);
                }
            }
            catch (AuthenticationException e) {
                if (this.f_10018_.m_129792_()) {
                    f_10015_.warn("Authentication servers are down but will let them in anyway!");
                    this.m_294008_(ServerLoginNetHandlerMixin.arclight$createOfflineProfile(this.f_10013_, name));
                } else {
                    this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.authservers_down"));
                    f_10015_.error("Couldn't verify username because servers are unavailable");
                }
            }
            catch (Exception e) {
                this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.unverified_username"));
                f_10015_.error("Exception verifying " + name, (Throwable)e);
            }
        });
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_10015_));
        thread.start();
    }

    @Override
    @Unique
    public void bridge$preLogin(GameProfile gameProfile) throws Exception {
        if (this.arclight$velocityLoginId == -1 && VelocitySupport.isEnabled()) {
            this.disconnect("This server requires you to connect with Velocity.");
            return;
        }
        String playerName = gameProfile.getName();
        InetAddress address = ((InetSocketAddress)this.f_10013_.m_129523_()).getAddress();
        UUID uniqueId = gameProfile.getId();
        final CraftServer craftServer = (CraftServer)Bukkit.getServer();
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
        craftServer.getPluginManager().callEvent(asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            class SyncPreLogin
            extends Waitable<PlayerPreLoginEvent.Result> {
                SyncPreLogin() {
                }

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    craftServer.getPluginManager().callEvent(event);
                    return event.getResult();
                }
            }
            SyncPreLogin waitable = new SyncPreLogin();
            ((MinecraftServerBridge)this.f_10018_).bridge$queuedProcess(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.disconnect(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.disconnect(asyncEvent.getKickMessage());
            return;
        }
        f_10015_.info("UUID of player {} is {}", (Object)gameProfile.getName(), (Object)gameProfile.getId());
        this.m_294008_(gameProfile);
    }

    @Inject(method={"handleCustomQueryPacket"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$modernForwardReply(ServerboundCustomQueryAnswerPacket packet, CallbackInfo ci) {
        if (VelocitySupport.isEnabled() && packet.f_290801_() == this.bridge$getVelocityLoginId()) {
            FriendlyByteBuf payload = this.bridge$getDiscardedQueryAnswerData(packet);
            if (payload == null) {
                this.bridge$disconnect("This server requires you to connect with Velocity.");
                ci.cancel();
                return;
            }
            FriendlyByteBuf buf = (FriendlyByteBuf)payload.m_236868_(r -> {
                int i = r.readableBytes();
                if (i >= 0 && i <= 0x100000) {
                    return new FriendlyByteBuf(r.readBytes(i));
                }
                throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
            });
            if (buf == null) {
                this.bridge$disconnect("This server requires you to connect with Velocity.");
                ci.cancel();
                return;
            }
            if (!VelocitySupport.checkIntegrity(buf)) {
                this.bridge$disconnect("Unable to verify player details");
                ci.cancel();
                return;
            }
            int version = buf.m_130242_();
            if (version > 4) {
                throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted upto 4");
            }
            SocketAddress listening = this.f_10013_.m_129523_();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            this.f_10013_.f_129469_ = new InetSocketAddress(VelocitySupport.readAddress(buf), port);
            this.f_291112_ = VelocitySupport.createProfile(buf);
            Util.m_183991_().execute(() -> {
                try {
                    this.bridge$preLogin(this.f_291112_);
                }
                catch (Exception ex) {
                    this.m_10053_((Component)Component.m_237115_((String)"multiplayer.disconnect.unverified_username"));
                    f_10015_.warn("Exception verifying {} ", (Object)this.f_291112_.getName(), (Object)ex);
                }
            });
            this.bridge$platform$onCustomQuery(packet);
            ci.cancel();
        }
    }

    static {
        PROP_PATTERN = Pattern.compile("\\w{0,16}");
    }
}

