/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.management;

import io.izzel.arclight.common.bridge.core.entity.player.PlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.server.management.PlayerInteractionManagerBridge;
import io.izzel.arclight.common.bridge.core.world.item.ItemStackBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.tools.product.Product3;
import io.izzel.tools.product.Product6;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class ServerPlayerGameModeMixin
implements PlayerInteractionManagerBridge {
    @Shadow
    protected ServerLevel f_9244_;
    @Shadow
    @Final
    protected ServerPlayer f_9245_;
    @Shadow
    private GameType f_9247_;
    @Shadow
    private int f_9250_;
    @Shadow
    private int f_9252_;
    @Shadow
    private boolean f_9249_;
    @Shadow
    private BlockPos f_9251_;
    @Shadow
    private int f_9256_;
    @Shadow
    private boolean f_9253_;
    @Shadow
    private BlockPos f_9254_;
    @Shadow
    private int f_9255_;
    public boolean interactResult = false;
    public boolean firedInteract = false;

    @Shadow
    public abstract boolean m_9295_();

    @Shadow
    public abstract void m_215116_(BlockPos var1, int var2, String var3);

    @Shadow
    protected abstract void m_215125_(BlockPos var1, boolean var2, int var3, String var4);

    @Inject(method={"changeGameModeForPlayer"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;setGameModeForPlayer(Lnet/minecraft/world/level/GameType;Lnet/minecraft/world/level/GameType;)V")})
    private void arclight$gameModeEvent(GameType gameType, CallbackInfoReturnable<Boolean> cir) {
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((org.bukkit.entity.Player)((ServerPlayerEntityBridge)this.f_9245_).bridge$getBukkitEntity(), GameMode.getByValue(gameType.m_46392_()));
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Overwrite
    public void m_214168_(BlockPos blockPos, ServerboundPlayerActionPacket.Action action, Direction direction, int i, int j) {
        if (!this.f_9244_.m_46805_(blockPos)) {
            return;
        }
        Product3<Boolean, Boolean, Boolean> forgeEvent = ((PlayerEntityBridge)this.f_9245_).bridge$platform$onLeftClickBlock(blockPos, direction, action);
        if (((Boolean)forgeEvent._1).booleanValue() || !this.m_9295_() && ((Boolean)forgeEvent._2).booleanValue()) {
            this.f_9244_.m_7260_(blockPos, this.f_9244_.m_8055_(blockPos), this.f_9244_.m_8055_(blockPos), 3);
            return;
        }
        if (this.f_9245_.m_146892_().m_82557_(Vec3.m_82512_((Vec3i)blockPos)) != 0.0 && !((PlayerEntityBridge)this.f_9245_).bridge$platform$canReach(blockPos, 1.5)) {
            this.m_215125_(blockPos, false, j, "too far");
        } else if (blockPos.m_123342_() >= i) {
            this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(blockPos, this.f_9244_.m_8055_(blockPos)));
            this.m_215125_(blockPos, false, j, "too high");
        } else if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (!this.f_9244_.m_7966_((Player)this.f_9245_, blockPos)) {
                CraftEventFactory.callPlayerInteractEvent((Player)this.f_9245_, Action.LEFT_CLICK_BLOCK, blockPos, direction, this.f_9245_.m_150109_().m_36056_(), InteractionHand.MAIN_HAND);
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(blockPos, this.f_9244_.m_8055_(blockPos)));
                this.m_215125_(blockPos, false, j, "may not interact");
                BlockEntity tileentity = this.f_9244_.m_7702_(blockPos);
                if (tileentity != null) {
                    this.f_9245_.f_8906_.m_141995_(tileentity.m_58483_());
                }
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((Player)this.f_9245_, Action.LEFT_CLICK_BLOCK, blockPos, direction, this.f_9245_.m_150109_().m_36056_(), InteractionHand.MAIN_HAND);
            if (event.isCancelled()) {
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, blockPos));
                BlockEntity tileentity2 = this.f_9244_.m_7702_(blockPos);
                if (tileentity2 != null) {
                    this.f_9245_.f_8906_.m_141995_(tileentity2.m_58483_());
                }
                return;
            }
            if (this.m_9295_()) {
                this.m_215116_(blockPos, j, "creative destroy");
                return;
            }
            if (this.f_9245_.m_21205_().m_150930_(Items.f_42751_) && ((DebugStickItem)Items.f_42751_).m_150802_((Player)this.f_9245_, this.f_9244_.m_8055_(blockPos), (LevelAccessor)this.f_9244_, blockPos, false, this.f_9245_.m_21205_())) {
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, blockPos));
                return;
            }
            if (this.f_9245_.m_36187_((Level)this.f_9244_, blockPos, this.f_9247_)) {
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(blockPos, this.f_9244_.m_8055_(blockPos)));
                this.m_215125_(blockPos, false, j, "block action restricted");
                return;
            }
            this.f_9250_ = this.f_9252_;
            float f = 1.0f;
            net.minecraft.world.level.block.state.BlockState iblockdata = this.f_9244_.m_8055_(blockPos);
            if (event.useInteractedBlock() == Event.Result.DENY) {
                net.minecraft.world.level.block.state.BlockState data = this.f_9244_.m_8055_(blockPos);
                if (data.m_60734_() instanceof DoorBlock) {
                    boolean bottom = data.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
                    this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, blockPos));
                    this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, bottom ? blockPos.m_7494_() : blockPos.m_7495_()));
                } else if (data.m_60734_() instanceof TrapDoorBlock) {
                    this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, blockPos));
                }
            } else if (!iblockdata.m_60795_()) {
                if (!((Boolean)forgeEvent._3).booleanValue()) {
                    iblockdata.m_60686_((Level)this.f_9244_, blockPos, (Player)this.f_9245_);
                }
                f = iblockdata.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.m_9236_(), blockPos);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f > 1.0f) {
                    this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, blockPos));
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.f_9245_, blockPos, this.f_9245_.m_150109_().m_36056_(), f >= 1.0f);
            if (blockEvent.isCancelled()) {
                this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, blockPos));
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f = 2.0f;
            }
            if (!iblockdata.m_60795_() && f >= 1.0f) {
                this.m_215116_(blockPos, j, "insta mine");
            } else {
                if (this.f_9249_) {
                    this.f_9245_.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(this.f_9251_, this.f_9244_.m_8055_(this.f_9251_)));
                    this.m_215125_(blockPos, false, j, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.f_9249_ = true;
                this.f_9251_ = blockPos;
                int state = (int)(f * 10.0f);
                this.f_9244_.m_6801_(this.f_9245_.m_19879_(), blockPos, state);
                this.m_215125_(blockPos, true, j, "actual start of destroying");
                CraftEventFactory.callBlockDamageAbortEvent(this.f_9245_, blockPos, this.f_9245_.m_150109_().m_36056_());
                this.f_9256_ = state;
            }
        } else if (action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (blockPos.equals((Object)this.f_9251_)) {
                int k = this.f_9252_ - this.f_9250_;
                net.minecraft.world.level.block.state.BlockState iblockdata = this.f_9244_.m_8055_(blockPos);
                if (!iblockdata.m_60795_()) {
                    float f2 = iblockdata.m_60625_((Player)this.f_9245_, (BlockGetter)this.f_9245_.m_9236_(), blockPos) * (float)(k + 1);
                    if (f2 >= 0.7f) {
                        this.f_9249_ = false;
                        this.f_9244_.m_6801_(this.f_9245_.m_19879_(), blockPos, -1);
                        this.m_215116_(blockPos, j, "destroyed");
                        return;
                    }
                    if (!this.f_9253_) {
                        this.f_9249_ = false;
                        this.f_9253_ = true;
                        this.f_9254_ = blockPos;
                        this.f_9255_ = this.f_9250_;
                    }
                }
            }
            this.m_215125_(blockPos, true, j, "stopped destroying");
        } else if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.f_9249_ = false;
            if (!Objects.equals(this.f_9251_, blockPos)) {
                ArclightServer.LOGGER.debug("Mismatch in destroy block pos: " + this.f_9251_ + " " + blockPos);
                this.f_9244_.m_6801_(this.f_9245_.m_19879_(), this.f_9251_, -1);
                this.m_215125_(blockPos, true, j, "aborted mismatched destroying");
            }
            this.f_9244_.m_6801_(this.f_9245_.m_19879_(), blockPos, -1);
            this.m_215125_(blockPos, true, j, "aborted destroying");
        }
    }

    @Inject(method={"destroyBlock"}, at={@At(value="RETURN")})
    public void arclight$resetBlockBreak(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ArclightCaptures.BlockBreakEventContext breakEventContext = ArclightCaptures.popPrimaryBlockBreakEvent();
        if (breakEventContext != null) {
            this.bridge$handleBlockDrop(breakEventContext, pos);
        }
    }

    @Inject(method={"tick", "destroyAndAck"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayerGameMode;destroyBlock(Lnet/minecraft/core/BlockPos;)Z")})
    public void arclight$clearCaptures(CallbackInfo ci) {
        ArclightCaptures.clearBlockBreakEventContexts();
    }

    @Override
    public void bridge$handleBlockDrop(ArclightCaptures.BlockBreakEventContext breakEventContext, BlockPos pos) {
        BlockBreakEvent breakEvent = breakEventContext.getEvent();
        ArrayList<ItemEntity> blockDrops = breakEventContext.getBlockDrops();
        BlockState state = breakEventContext.getBlockBreakPlayerState();
        if (blockDrops != null && (breakEvent == null || breakEvent.isDropItems())) {
            CraftBlock craftBlock = CraftBlock.at((LevelAccessor)this.f_9244_, pos);
            CraftEventFactory.handleBlockDropItemEvent(craftBlock, state, this.f_9245_, blockDrops);
        }
    }

    @Override
    public boolean bridge$isFiredInteract() {
        return this.firedInteract;
    }

    @Override
    public void bridge$setFiredInteract(boolean b) {
        this.firedInteract = b;
    }

    @Override
    public boolean bridge$getInteractResult() {
        return this.interactResult;
    }

    @Override
    public void bridge$setInteractResult(boolean b) {
        this.interactResult = b;
    }

    @Overwrite
    public InteractionResult m_7179_(ServerPlayer playerIn, Level worldIn, ItemStack stackIn, InteractionHand handIn, BlockHitResult blockRaytraceResultIn) {
        InteractionResult result;
        BlockPos blockpos = blockRaytraceResultIn.m_82425_();
        net.minecraft.world.level.block.state.BlockState blockstate = worldIn.m_8055_(blockpos);
        boolean cancelledBlock = false;
        if (!blockstate.m_60734_().m_245993_(worldIn.m_246046_())) {
            return InteractionResult.FAIL;
        }
        if (this.f_9247_ == GameType.SPECTATOR) {
            MenuProvider provider = blockstate.m_60750_(worldIn, blockpos);
            boolean bl = cancelledBlock = !(provider instanceof MenuProvider);
        }
        if (playerIn.m_36335_().m_41519_(stackIn.m_41720_())) {
            cancelledBlock = true;
        }
        PlayerInteractEvent bukkitEvent = CraftEventFactory.callPlayerInteractEvent((Player)playerIn, Action.RIGHT_CLICK_BLOCK, blockpos, blockRaytraceResultIn.m_82434_(), stackIn, cancelledBlock, handIn, blockRaytraceResultIn.m_82450_());
        this.bridge$setFiredInteract(true);
        this.bridge$setInteractResult(bukkitEvent.useItemInHand() == Event.Result.DENY);
        if (bukkitEvent.useInteractedBlock() == Event.Result.DENY) {
            if (blockstate.m_60734_() instanceof DoorBlock) {
                boolean bottom = blockstate.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
                playerIn.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, bottom ? blockpos.m_7494_() : blockpos.m_7495_()));
            } else if (blockstate.m_60734_() instanceof CakeBlock) {
                ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().sendHealthUpdate();
            } else if (stackIn.m_41720_() instanceof DoubleHighBlockItem) {
                playerIn.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, blockpos.m_121945_(blockRaytraceResultIn.m_82434_()).m_7494_()));
                playerIn.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)this.f_9244_, blockpos.m_7494_()));
            }
            ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().updateInventory();
            return bukkitEvent.useItemInHand() != Event.Result.ALLOW ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (this.f_9247_ == GameType.SPECTATOR) {
            MenuProvider inamedcontainerprovider = blockstate.m_60750_(worldIn, blockpos);
            if (inamedcontainerprovider != null) {
                playerIn.m_5893_(inamedcontainerprovider);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        Product6<Boolean, Boolean, Boolean, Boolean, Boolean, InteractionResult> event = ((PlayerEntityBridge)this.f_9245_).bridge$platform$onRightClickBlock(handIn, blockpos, blockRaytraceResultIn);
        if (((Boolean)event._1).booleanValue()) {
            return (InteractionResult)event._6;
        }
        UseOnContext itemusecontext = new UseOnContext((Player)playerIn, handIn, blockRaytraceResultIn);
        if (!((Boolean)event._3).booleanValue() && (result = ((ItemStackBridge)stackIn).bridge$forge$onItemUseFirst(itemusecontext)) != InteractionResult.PASS) {
            return result;
        }
        boolean flag = !playerIn.m_21205_().m_41619_() || !playerIn.m_21206_().m_41619_();
        boolean flag1 = playerIn.m_36341_() && flag && (!((ItemStackBridge)playerIn.m_21205_()).bridge$forge$doesSneakBypassUse((LevelReader)worldIn, blockpos, (Player)playerIn) || !((ItemStackBridge)playerIn.m_21206_()).bridge$forge$doesSneakBypassUse((LevelReader)worldIn, blockpos, (Player)playerIn));
        ItemStack itemstack = stackIn.m_41777_();
        InteractionResult resultType = InteractionResult.PASS;
        if ((((Boolean)event._4).booleanValue() || !((Boolean)event._5).booleanValue() && !flag1) && (resultType = blockstate.m_60664_(worldIn, (Player)playerIn, handIn, blockRaytraceResultIn)).m_19077_()) {
            CriteriaTriggers.f_10562_.m_285767_(playerIn, blockpos, itemstack);
            return resultType;
        }
        if (((Boolean)event._2).booleanValue() || !stackIn.m_41619_() && resultType != InteractionResult.SUCCESS && !this.bridge$getInteractResult()) {
            if (((Boolean)event._3).booleanValue()) {
                return InteractionResult.PASS;
            }
            if (this.m_9295_()) {
                int i = stackIn.m_41613_();
                resultType = stackIn.m_41661_(itemusecontext);
                stackIn.m_41764_(i);
            } else {
                resultType = stackIn.m_41661_(itemusecontext);
            }
            if (resultType.m_19077_()) {
                CriteriaTriggers.f_10562_.m_285767_(playerIn, blockpos, itemstack);
            }
            return resultType;
        }
        return resultType;
    }
}

