/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level;

import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.bridge.core.world.border.WorldBorderBridge;
import io.izzel.arclight.common.bridge.core.world.level.levelgen.ChunkGeneratorBridge;
import io.izzel.arclight.common.bridge.core.world.server.ServerChunkProviderBridge;
import io.izzel.arclight.common.bridge.core.world.server.ServerWorldBridge;
import io.izzel.arclight.common.mod.ArclightConstants;
import io.izzel.arclight.common.mod.mixins.annotation.CreateConstructor;
import io.izzel.arclight.common.mod.mixins.annotation.ShadowConstructor;
import io.izzel.arclight.common.mod.mixins.annotation.TransformAccess;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.server.world.WrappedWorlds;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_20_R3.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_20_R3.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.BiomeProvider;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelMixin
implements WorldBridge,
LevelAccessor,
LevelWriter {
    @Shadow
    @Final
    private WorldBorder f_46447_;
    @Shadow
    @Final
    public boolean f_46443_;
    protected CraftWorld world;
    public boolean pvpMode;
    public boolean keepSpawnInMemory = true;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public boolean populating;
    public org.bukkit.generator.ChunkGenerator generator;
    protected World.Environment environment;
    protected BiomeProvider biomeProvider;
    public SpigotWorldConfig spigotConfig;
    @TransformAccess(value=9)
    private static BlockPos lastPhysicsProblem;
    public boolean preventPoiUpdated = false;
    public Map<BlockPos, CapturedBlockState> capturedBlockStates = new LinkedHashMap<BlockPos, CapturedBlockState>();
    public Map<BlockPos, BlockEntity> capturedTileEntities = new HashMap<BlockPos, BlockEntity>();
    private transient Explosion.BlockInteraction arclight$blockInteractionOverride;

    @Shadow
    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return null;
    }

    @Shadow
    public abstract BlockState m_8055_(BlockPos var1);

    @Shadow
    public abstract WorldBorder m_6857_();

    @Shadow
    public abstract long m_46468_();

    @Shadow
    public abstract MinecraftServer m_7654_();

    @Shadow
    public abstract LevelData m_6106_();

    @Shadow
    public abstract ResourceKey<Level> m_46472_();

    @Shadow
    public abstract DimensionType m_6042_();

    @Shadow
    public abstract void m_6550_(BlockPos var1, BlockState var2, BlockState var3);

    @Shadow
    public abstract void m_7260_(BlockPos var1, BlockState var2, BlockState var3, int var4);

    @Shadow
    public abstract void m_46717_(BlockPos var1, Block var2);

    @Shadow
    public abstract void m_6559_(BlockPos var1, BlockState var2, BlockState var3);

    @Accessor(value="thread")
    public abstract Thread arclight$getMainThread();

    @ShadowConstructor
    public void arclight$constructor(WritableLevelData worldInfo, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionType, Supplier<ProfilerFiller> profiler, boolean isRemote, boolean isDebug, long seed, int maxNeighborUpdate) {
        throw new RuntimeException();
    }

    @CreateConstructor
    public void arclight$constructor(WritableLevelData worldInfo, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionType, Supplier<ProfilerFiller> profiler, boolean isRemote, boolean isDebug, long seed, int maxNeighborUpdate, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.arclight$constructor(worldInfo, dimension, registryAccess, dimensionType, profiler, isRemote, isDebug, seed, maxNeighborUpdate);
        this.generator = gen;
        this.environment = env;
        this.biomeProvider = biomeProvider;
        this.bridge$getWorld();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(WritableLevelData info, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimType, Supplier<ProfilerFiller> profiler, boolean isRemote, boolean isDebug, long seed, int maxNeighborUpdates, CallbackInfo ci) {
        ((WorldBorderBridge)this.f_46447_).bridge$setWorld((Level)this);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
        }
    }

    @Override
    public Map<BlockPos, CapturedBlockState> bridge$getCapturedBlockState() {
        return this.capturedBlockStates;
    }

    @Override
    public Map<BlockPos, BlockEntity> bridge$getCapturedBlockEntity() {
        return this.capturedTileEntities;
    }

    @Override
    public void bridge$setLastPhysicsProblem(BlockPos pos) {
        lastPhysicsProblem = pos;
    }

    @Override
    public Object2LongOpenHashMap<SpawnCategory> bridge$ticksPerSpawnCategory() {
        return this.ticksPerSpawnCategory;
    }

    public abstract ResourceKey<LevelStem> getTypeKey();

    @Override
    public ResourceKey<LevelStem> bridge$getTypeKey() {
        return this.getTypeKey();
    }

    @Override
    public SpigotWorldConfig bridge$spigotConfig() {
        return this.spigotConfig;
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void arclight$hooks(BlockPos pos, BlockState newState, int flags, CallbackInfoReturnable<Boolean> cir) {
        if (!this.processCaptures(pos, newState, flags)) {
            cir.setReturnValue((Object)false);
        }
    }

    private boolean processCaptures(BlockPos pos, BlockState newState, int flags) {
        Entity entityChangeBlock = ArclightCaptures.getEntityChangeBlock();
        if (entityChangeBlock != null) {
            return CraftEventFactory.callEntityChangeBlockEvent(entityChangeBlock, pos, newState);
        }
        return true;
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, require=0, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;updateNeighbourShapes(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;II)V")})
    private void arclight$callBlockPhysics(BlockPos pos, BlockState state, int i, int j, CallbackInfoReturnable<Boolean> cir) {
        try {
            if (this.world != null) {
                BlockPhysicsEvent event = new BlockPhysicsEvent(CraftBlock.at(this, pos), CraftBlockData.fromData(state));
                Bukkit.getPluginManager().callEvent(event);
                if (event.isCancelled()) {
                    cir.setReturnValue((Object)true);
                }
            }
        }
        catch (StackOverflowError e) {
            lastPhysicsProblem = pos;
        }
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, require=0, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;onBlockStateChange(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void arclight$preventPoiUpdate(BlockPos blockPos, BlockState blockState, int i, int j, CallbackInfoReturnable<Boolean> cir) {
        if (this.preventPoiUpdated) {
            cir.setReturnValue((Object)true);
        }
    }

    public void notifyAndUpdatePhysics(BlockPos pos, LevelChunk chunk, BlockState oldBlock, BlockState newBlock, BlockState actualBlock, int i, int j) {
        this.bridge$forge$notifyAndUpdatePhysics(pos, chunk, oldBlock, newBlock, i, j);
    }

    @Override
    public void bridge$forge$notifyAndUpdatePhysics(BlockPos pos, @Nullable LevelChunk levelchunk, BlockState oldBlock, BlockState newBlock, int j, int k) {
        Block block = newBlock.m_60734_();
        BlockState blockstate1 = this.m_8055_(pos);
        if (blockstate1 == newBlock) {
            if (oldBlock != blockstate1) {
                this.m_6550_(pos, oldBlock, blockstate1);
            }
            if ((j & 2) != 0 && (!this.f_46443_ || (j & 4) == 0) && (this.f_46443_ || levelchunk == null || levelchunk.m_287138_() != null && levelchunk.m_287138_().m_287205_(FullChunkStatus.BLOCK_TICKING))) {
                this.m_7260_(pos, oldBlock, newBlock, j);
            }
            if ((j & 1) != 0) {
                this.m_6289_(pos, oldBlock.m_60734_());
                if (!this.f_46443_ && newBlock.m_60807_()) {
                    this.m_46717_(pos, block);
                }
            }
            if ((j & 0x10) == 0 && k > 0) {
                int i = j & 0xFFFFFFDE;
                oldBlock.m_60762_((LevelAccessor)this, pos, i, k - 1);
                try {
                    if (this.world != null) {
                        BlockPhysicsEvent event = new BlockPhysicsEvent(CraftBlock.at(this, pos), CraftBlockData.fromData(newBlock));
                        Bukkit.getPluginManager().callEvent(event);
                        if (event.isCancelled()) {
                            return;
                        }
                    }
                }
                catch (StackOverflowError e) {
                    lastPhysicsProblem = pos;
                }
                newBlock.m_60705_((LevelAccessor)this, pos, i, k - 1);
                newBlock.m_60762_((LevelAccessor)this, pos, i, k - 1);
            }
            if (!this.preventPoiUpdated) {
                this.m_6559_(pos, oldBlock, blockstate1);
            }
        }
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public CraftWorld getWorld() {
        if (this.world == null) {
            Optional<Field> delegate = WrappedWorlds.getDelegate(this.getClass());
            if (delegate.isPresent()) {
                try {
                    return ((WorldBridge)delegate.get().get(this)).bridge$getWorld();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.environment == null) {
                this.environment = ArclightServer.getEnvironment(this.getTypeKey());
            }
            if (this.generator == null) {
                LevelMixin levelMixin;
                this.generator = this.getCraftServer().getGenerator(((ServerLevelData)this.m_6106_()).m_5462_());
                if (this.generator != null && (levelMixin = this) instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)levelMixin;
                    CraftWorldInfo worldInfo = new CraftWorldInfo((ServerLevelData)this.m_6106_(), ((ServerWorldBridge)((Object)this)).bridge$getConvertable(), this.environment, this.m_6042_());
                    if (this.biomeProvider == null && this.generator != null) {
                        this.biomeProvider = this.generator.getDefaultBiomeProvider(worldInfo);
                    }
                    ChunkGenerator generator = serverWorld.m_7726_().m_8481_();
                    if (this.biomeProvider != null) {
                        CustomWorldChunkManager biomeSource = new CustomWorldChunkManager(worldInfo, this.biomeProvider, (Registry<Biome>)serverWorld.m_9598_().m_175515_(Registries.f_256952_));
                        ((ChunkGeneratorBridge)generator).bridge$setBiomeSource(biomeSource);
                    }
                    CustomChunkGenerator gen = new CustomChunkGenerator(serverWorld, generator, this.generator);
                    ((ServerChunkProviderBridge)serverWorld.m_7726_()).bridge$setChunkGenerator(gen);
                }
            }
            this.world = new CraftWorld((ServerLevel)this, this.generator, this.biomeProvider, this.environment);
            this.getCraftServer().addWorld(this.world);
        }
        return this.world;
    }

    public BlockEntity getBlockEntity(BlockPos pos, boolean validate) {
        return this.m_7702_(pos);
    }

    @Override
    public BlockEntity bridge$getTileEntity(BlockPos pos, boolean validate) {
        return this.getBlockEntity(pos, validate);
    }

    @Override
    public CraftServer bridge$getServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public CraftWorld bridge$getWorld() {
        return this.getWorld();
    }

    @Override
    public boolean bridge$isPvpMode() {
        return this.pvpMode;
    }

    @Override
    public boolean bridge$isKeepSpawnInMemory() {
        return this.keepSpawnInMemory;
    }

    @Override
    public boolean bridge$isPopulating() {
        return this.populating;
    }

    @Override
    public void bridge$setPopulating(boolean populating) {
        this.populating = populating;
    }

    @Override
    public org.bukkit.generator.ChunkGenerator bridge$getGenerator() {
        return this.generator;
    }

    @Override
    public ServerLevel bridge$getMinecraftWorld() {
        return this.getWorld().getHandle();
    }

    @Override
    public boolean bridge$addEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (this.getWorld().getHandle() != this) {
            return ((WorldBridge)this.getWorld().getHandle()).bridge$addEntity(entity, reason);
        }
        this.bridge$pushAddEntityReason(reason);
        return this.m_7967_(entity);
    }

    @Override
    public void bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason reason) {
        if (this.getWorld().getHandle() != this) {
            ((WorldBridge)this.getWorld().getHandle()).bridge$pushAddEntityReason(reason);
        }
    }

    @Override
    public CreatureSpawnEvent.SpawnReason bridge$getAddEntityReason() {
        if (this.getWorld().getHandle() != this) {
            return ((WorldBridge)this.getWorld().getHandle()).bridge$getAddEntityReason();
        }
        return null;
    }

    @Override
    public boolean bridge$preventPoiUpdated() {
        return this.preventPoiUpdated;
    }

    @Override
    public void bridge$preventPoiUpdated(boolean b) {
        this.preventPoiUpdated = b;
    }

    @ModifyVariable(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;ZLnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/sounds/SoundEvent;)Lnet/minecraft/world/level/Explosion;"}, ordinal=0, at=@At(value="HEAD"), argsOnly=true)
    private Level.ExplosionInteraction arclight$standardExplodePre(Level.ExplosionInteraction interaction) {
        if (interaction == ArclightConstants.STANDARD) {
            this.arclight$blockInteractionOverride = Explosion.BlockInteraction.DESTROY;
            return Level.ExplosionInteraction.BLOCK;
        }
        return interaction;
    }

    @ModifyVariable(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;ZLnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/sounds/SoundEvent;)Lnet/minecraft/world/level/Explosion;"}, at=@At(value="LOAD", ordinal=0))
    private Explosion.BlockInteraction arclight$standardExplodePost(Explosion.BlockInteraction interaction) {
        try {
            if (this.arclight$blockInteractionOverride != null) {
                Explosion.BlockInteraction blockInteraction = this.arclight$blockInteractionOverride;
                return blockInteraction;
            }
            Explosion.BlockInteraction blockInteraction = interaction;
            return blockInteraction;
        }
        finally {
            this.arclight$blockInteractionOverride = null;
        }
    }
}

