/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level.block.entity;

import io.izzel.arclight.api.ArclightPlatform;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.network.play.ServerPlayNetHandlerBridge;
import io.izzel.arclight.common.bridge.core.tileentity.EndGatewayBlockEntityBridge;
import io.izzel.arclight.common.mixin.core.world.level.block.entity.BlockEntityMixin;
import io.izzel.arclight.common.mod.mixins.annotation.OnlyInPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TheEndGatewayBlockEntity.class})
public abstract class EndGatewayBlockEntityMixin
extends BlockEntityMixin
implements EndGatewayBlockEntityBridge {
    @Shadow
    private static void m_155849_(Level p_155850_, BlockPos p_155851_, BlockState p_155852_, TheEndGatewayBlockEntity p_155853_) {
    }

    @Inject(method={"teleportEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPortalCooldown()V")})
    private static void arclight$teleportCause(Level level, BlockPos pos, BlockState state, Entity entityIn, TheEndGatewayBlockEntity entity, CallbackInfo ci) {
        entityIn.bridge().bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.HIT);
    }

    @Override
    public void bridge$playerTeleportEvent(Level level, BlockPos pos, BlockState state, Entity entityIn, BlockPos dest) {
        CraftPlayer player = ((ServerPlayerEntityBridge)entityIn).bridge$getBukkitEntity();
        Location location = new Location(level.bridge$getWorld(), (double)dest.m_123341_() + 0.5, (double)dest.m_123342_() + 0.5, (double)dest.m_123343_() + 0.5);
        location.setPitch(player.getLocation().getPitch());
        location.setYaw(player.getLocation().getYaw());
        PlayerTeleportEvent event = new PlayerTeleportEvent(player, player.getLocation(), location, PlayerTeleportEvent.TeleportCause.END_GATEWAY);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        entityIn.m_20091_();
        ((ServerPlayNetHandlerBridge)((ServerPlayer)entityIn).f_8906_).bridge$teleport(event.getTo());
        EndGatewayBlockEntityMixin.m_155849_(level, pos, state, (TheEndGatewayBlockEntity)this);
    }

    @Mixin(value={TheEndGatewayBlockEntity.class})
    @OnlyInPlatform(value={ArclightPlatform.FORGE, ArclightPlatform.NEOFORGE})
    public static class ForgeLike {
        @Inject(method={"teleportEntity"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPortalCooldown()V")})
        private static void arclight$portal(Level level, BlockPos pos, BlockState state, Entity entityIn, TheEndGatewayBlockEntity entity, CallbackInfo ci, ServerLevel serverLevel, BlockPos dest) {
            if (entityIn instanceof ServerPlayer) {
                ((EndGatewayBlockEntityBridge)entity).bridge$playerTeleportEvent(level, pos, state, entityIn, dest);
                ci.cancel();
            }
        }
    }

    @Mixin(value={TheEndGatewayBlockEntity.class})
    @OnlyInPlatform(value={ArclightPlatform.FABRIC, ArclightPlatform.VANILLA})
    public static class VanillaLike {
        @Inject(method={"teleportEntity"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPortalCooldown()V")})
        private static void arclight$portal(Level level, BlockPos pos, BlockState state, Entity entityIn, TheEndGatewayBlockEntity entity, CallbackInfo ci, BlockPos dest) {
            if (entityIn instanceof ServerPlayer) {
                ((EndGatewayBlockEntityBridge)entity).bridge$playerTeleportEvent(level, pos, state, entityIn, dest);
                ci.cancel();
            }
        }
    }
}

