/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level.entity;

import io.izzel.arclight.common.bridge.core.entity.EntityBridge;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PersistentEntitySectionManager.class})
public abstract class PersistentEntitySectionManagerMixin<T extends EntityAccess> {
    @Shadow
    @Final
    private EntityPersistentStorage<T> f_157493_;
    @Shadow
    @Final
    EntitySectionStorage<T> f_157495_;
    @Shadow
    @Final
    private Long2ObjectMap<PersistentEntitySectionManager.ChunkLoadStatus> f_157498_;
    @Unique
    private boolean arclight$fireEvent = false;

    @Shadow
    public abstract void close() throws IOException;

    public void close(boolean save) throws IOException {
        if (save) {
            this.close();
        } else {
            this.f_157493_.close();
        }
    }

    public List<Entity> getEntities(ChunkPos chunkCoordIntPair) {
        return this.f_157495_.m_156888_(chunkCoordIntPair.m_45588_()).flatMap(EntitySection::m_156845_).map(o -> (Entity)o).collect(Collectors.toList());
    }

    public boolean isPending(long cord) {
        return this.f_157498_.get(cord) == PersistentEntitySectionManager.ChunkLoadStatus.PENDING;
    }

    @Inject(method={"storeChunkSections"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityPersistentStorage;storeEntities(Lnet/minecraft/world/level/entity/ChunkEntities;)V")})
    private void arclight$fireUnload(long pos, Consumer<T> consumer, CallbackInfoReturnable<Boolean> cir, @Coerce Object status, List<T> list) {
        if (this.arclight$fireEvent) {
            CraftEventFactory.callEntitiesUnloadEvent((Level)((EntityStorage)this.f_157493_).f_156538_, new ChunkPos(pos), list.stream().map(entity -> (Entity)entity).collect(Collectors.toList()));
        }
    }

    @Inject(method={"storeChunkSections"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityPersistentStorage;storeEntities(Lnet/minecraft/world/level/entity/ChunkEntities;)V")})
    private void arclight$resetFlag(long pos, Consumer<T> consumer, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$fireEvent = false;
    }

    @Inject(method={"processChunkUnload"}, at={@At(value="HEAD")})
    private void arclight$fireEvent(long pChunkPosValue, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$fireEvent = true;
    }

    @Inject(method={"processPendingLoads"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", shift=At.Shift.AFTER, remap=false, target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;put(JLjava/lang/Object;)Ljava/lang/Object;")})
    private void arclight$fireLoad(CallbackInfo ci, ChunkEntities<T> chunkEntities) {
        List<Entity> entities = this.getEntities(chunkEntities.m_156791_());
        CraftEventFactory.callEntitiesLoadEvent((Level)((EntityStorage)this.f_157493_).f_156538_, chunkEntities.m_156791_(), entities);
    }

    @Inject(method={"unloadEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityAccess;setRemoved(Lnet/minecraft/world/entity/Entity$RemovalReason;)V")})
    private void arclight$unloadCause(EntityAccess entityAccess, CallbackInfo ci) {
        if (entityAccess instanceof EntityBridge) {
            EntityBridge bridge = (EntityBridge)entityAccess;
            bridge.bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.UNLOAD);
        }
    }
}

