/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level.levelgen.structure;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R3.util.TransformerGeneratorAccess;
import org.bukkit.entity.EntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={StructurePiece.class})
public class StructurePieceMixin {
    @Inject(method={"placeBlock"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/WorldGenLevel;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z")})
    private void arclight$useTransformer(WorldGenLevel level, BlockState p_73436_, int p_73437_, int p_73438_, int p_73439_, BoundingBox p_73440_, CallbackInfo ci, BlockPos pos) {
        if (level instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerGeneratorAccess = (TransformerGeneratorAccess)level;
            transformerGeneratorAccess.setCraftBlock(pos, (CraftBlockState)CraftBlockStates.getBlockState(pos, p_73436_, null), 2);
            ci.cancel();
        }
    }

    @Unique
    protected boolean placeCraftBlockEntity(ServerLevelAccessor worldAccess, BlockPos position, CraftBlockEntityState<?> craftBlockEntityState, int i) {
        if (worldAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
            return transformerAccess.setCraftBlock(position, craftBlockEntityState, i);
        }
        boolean result = worldAccess.m_7731_(position, craftBlockEntityState.getHandle(), i);
        BlockEntity tileEntity = worldAccess.m_7702_(position);
        if (tileEntity != null) {
            tileEntity.m_142466_(craftBlockEntityState.getSnapshotNBT());
        }
        return result;
    }

    @Unique
    protected void placeCraftSpawner(ServerLevelAccessor worldAccess, BlockPos position, EntityType entityType, int i) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)CraftBlockStates.getBlockState(position, Blocks.f_50085_.m_49966_(), null);
        spawner.setSpawnedType(entityType);
        this.placeCraftBlockEntity(worldAccess, position, spawner, i);
    }

    @Unique
    protected void setCraftLootTable(ServerLevelAccessor worldAccess, BlockPos position, RandomSource randomSource, ResourceLocation loottableKey) {
        BlockEntity tileEntity = worldAccess.m_7702_(position);
        if (tileEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity tileEntityLootable = (RandomizableContainerBlockEntity)tileEntity;
            tileEntityLootable.m_307796_(loottableKey, randomSource.m_188505_());
            if (worldAccess instanceof TransformerGeneratorAccess) {
                TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
                transformerAccess.setCraftBlock(position, (CraftBlockState)CraftBlockStates.getBlockState(position, tileEntity.m_58900_(), tileEntityLootable.m_187480_()), 3);
            }
        }
    }
}

